package sims2;



import javax.microedition.lcdui.*;



import java.io.DataInputStream;





public class PNG_funcs

{

    

	//used by the image cacher

	public static class CachedImage{

		public CachedImage(){

			sprName = "";

			nPriority = 0;

			nHash = 0;

			Img = null;

		}

		

		

		public String sprName;

		public int nHash;

		public int nPriority;

		public Image Img; 

	}

	

	//#ifdef SMALL_CACHE

//# 	public final static int ImageCacheSize = 6;

	//#else

	public final static int ImageCacheSize = 10;

	//#endif

	

	

	static private CachedImage imgCache[] = new CachedImage[ImageCacheSize];

	

	static private int num_cached = 0;

	

	public static void clearCache(){

		//forces all images to be reloaded on phones with low memory

		//#ifdef CLEAR_CACHE

		//#ifdef DEBUG

//# 		Runtime r = Runtime.getRuntime();

//# 		long mem = r.freeMemory();

		//#endif

//# 		imgCache = new CachedImage[ImageCacheSize];

//# 		num_cached = 0;

//# 		System.gc();

		//#ifdef DEBUG

//# 		System.out.println("Cleared image cache, freed "+((mem - r.freeMemory())/1000)+" kbs");

		//#endif

		//#endif

	}

    

    public static int getPNGLength( DataInputStream aInput )

    {

    	int iLoop = 0;

    	try{

	    	while(aInput.read() != -1)

	    	{

	    		iLoop++;

	    	}

    	}

    	catch(Exception e){}

    	return iLoop;

    }

    

    

    

    public static int getPNGChunkDataLength(String sChunk, byte[] ayPNGData)

    {

    	int iDataLength = 0;

    	try{

	    	int iOffset = getPNGOffset(sChunk, ayPNGData);

	    	

	    	if(iOffset == -1 || iOffset < 8)

	    	{

	    		return -1;

	    	}

	    	

	    	

	    	iDataLength |= ayPNGData[iOffset - 8] << 24;

	    	iDataLength |= ayPNGData[iOffset - 7] << 16;

	    	iDataLength |= ayPNGData[iOffset - 6] << 8;

	    	iDataLength |= ayPNGData[iOffset - 5];

    	}catch( Exception e ){

    			//#ifdef DEBUG

//#     		System.out.println( e.getMessage()  );

    		//#endif

    	}



    	return iDataLength;

    }

    

    

    public static int getPNGOffset(String sChunk, byte[] ayPNGData)

    {

    	int iOffset = -1;

    	int iThisByte = 0;

    	int iLoop = 0;

    	int iSuccessPasses = 0;

    	

    	// Find the chunk

    	while(iOffset == -1)

    	{

    		// Read the current byte

    		iThisByte = (int) ayPNGData[iLoop];

    		

    		/*/ Is this the end of the file

    		if(iThisByte == -1)

    		{

    			////#ifdef DEBUG_PALETTE

    			System.out.println( "End of file.\n\tTrying to read chunk " + sChunk + "\n\tLoop:\t" + iLoop);

    			////#endif

    			return -1;

    		}//*/

    		

    		

    		

    		if(iThisByte == (int) sChunk.charAt(iSuccessPasses))

			{

    			iSuccessPasses++;

			}

    		else

    		{

				iSuccessPasses = 0;

    		}

    		

    		if(iSuccessPasses == 4)

    		{

    			iOffset = iLoop +1;

    			//#ifdef PNG_DEBUG

//#     			System.out.println( "\t" + sChunk + " data starts at " + iOffset );

    			//#endif

    		}

    		

    		iLoop++;

    	}

    	

    	return iOffset;

    }

    

    



      public static Image generateImage( String sFileName )

      {



      	      	

  			//search the cache first and formost

  			for( int i = 0; i < num_cached; i++ ){

  				if( imgCache[i].sprName.compareTo(sFileName) == 0 ){

  					

  					//match, send it out

  					//imgCache[i].nPriority++;

  					//System.out.println( "Retrieving cached image :" + imgCache[i].sprName );

  					return imgCache[i].Img;

  				}

  			}



  			  		

    		// Create an image from modified bytes

    		try{

    			

	    		//System.out.println("Creating new file "+sFileName+" w/o pal swap");

                if (sFileName != null && sFileName.charAt(0) != '/') {

                    sFileName = "/" + sFileName;

                }

    			Image imgTmp = Image.createImage("/sims2" + sFileName);

    			



    			

    			//if there is room in the array add it

    			if( num_cached < imgCache.length ){

  		    		imgCache[num_cached] = new CachedImage();

    				imgCache[num_cached].sprName = sFileName; 

					imgCache[num_cached].nHash = 0;

					imgCache[num_cached].Img = imgTmp;

					imgCache[num_cached].nPriority = num_cached+1;

  					//System.out.println( "Adding cached image :" + imgCache[num_cached].sprName );

					num_cached++;

    			}else{

    				//decrement all priorities

    				for( int i = 0; i < imgCache.length; i++ ){

    					imgCache[i].nPriority--;

    				}

    				//find the entry with priority 0

    				int index = 0;

    				for( index = 0; index < imgCache.length; index++ ){

    					if( imgCache[index].nPriority == 0 ){

    						break;

    					}

    				}

    				

    				//System.out.println( "Attempting to place image in index : "+index );

    				//replace this image with the new one

    				imgCache[index].sprName = sFileName; 

					imgCache[index].nHash = 0;

					imgCache[index].Img = imgTmp;

					imgCache[index].nPriority = ImageCacheSize;

  					//System.out.println( "Cleared: "+index+" add cached image :" + imgCache[num_cached-1].sprName );

    				

    			}





    			System.gc();

    			return imgTmp;

    		}

    		catch(Exception e)

			{

				//#ifdef DEBUG 

//#     			e.printStackTrace();

//#     			System.out.println("Failure compiling image from " + sFileName);

//#     			System.out.println();

    			//#endif

    			return null;

    		}

      }

    

    



      public static Image generateImage( int hash, byte [] data, int dataPos, int imageSize )

      {



      	      	

  			//search the cache first and formost

  			for( int i = 0; i < num_cached; i++ ){

  				if( imgCache[i].nHash != 0 && imgCache[i].nHash == hash ){

  					

  					//match, send it out

  					//imgCache[i].nPriority++;

  					//System.out.println( "Retrieving cached image :" + imgCache[i].sprName );

  					return imgCache[i].Img;

  				}

  			}



  			  		

    		// Create an image from modified bytes

    		try{





    			Image imgTmp = Image.createImage(data, dataPos, imageSize);

    			

    			//if there is room in the array add it

    			if( num_cached < imgCache.length ){

  		    		imgCache[num_cached] = new CachedImage();

    				imgCache[num_cached].sprName = ""; 

					imgCache[num_cached].nHash = hash;

					imgCache[num_cached].Img = imgTmp;

					imgCache[num_cached].nPriority = num_cached+1;

  					//System.out.println( "Adding cached image :" + imgCache[num_cached].sprName );

					num_cached++;

    			}else{

    				//decrement all priorities

    				for( int i = 0; i < imgCache.length; i++ ){

    					imgCache[i].nPriority--;

    				}

    				//find the entry with priority 0

    				int index = 0;

    				for( index = 0; index < imgCache.length; index++ ){

    					if( imgCache[index].nPriority == 0 ){

    						break;

    					}

    				}

    				

    				//System.out.println( "Attempting to place image in index : "+index );

    				//replace this image with the new one

    				imgCache[index].sprName = ""; 

					imgCache[index].nHash = 0;

					imgCache[index].Img = imgTmp;

					imgCache[index].nPriority = ImageCacheSize;

  					//System.out.println( "Cleared: "+index+" add cached image :" + imgCache[num_cached-1].sprName );

    				

    			}





    			System.gc();

    			return imgTmp;

    		}

    		catch(Exception e)

			{

				//#ifdef DEBUG 

//#     			e.printStackTrace();

//#     			System.out.println("Failure compiling image from " + hash);

    			//#endif

    			return null;

    		}

      }

      

      

          

    

    public static int crc32(byte[] aData, int aStart, int aLength)

    {

        int temp1 = 0;

		int temp2 = 0;

        int i = aStart;



        int crc = 0xFFFFFFFF;



        while (aLength-- != 0)

        {

            temp1 = crc >>> 8;

            try{

            temp2 = mCrcTable[(crc ^ aData[i++]) & 0xFF];

            }catch(Exception e){

            	//#ifdef DEBUG 

//#             	System.out.println("CRC Table out of bounds");

            	 //#endif

            }

            crc = temp1 ^ temp2;

        }



        return crc ^ 0xFFFFFFFF;

    }

    

    

    

    // The CRC table.

    private static int[] mCrcTable = new int[256];

    static

    {

        initCrcTable();

    }

    

    

    





    // The CRC polynomial.

    private final static int CRC32_POLYNOMIAL = 0xEDB88320;

    // Init the crc table.

    private static void initCrcTable()

    {

        int i, j;

        int crc;



        for (i = 0; i < 256; i++)

        {

            crc = i;



            for (j = 8; j > 0; j--)

            {

                if ((crc & 1) == 1)

                {

                    crc = (crc >>> 1) ^ CRC32_POLYNOMIAL;

                }

                else

                {

                    crc >>>= 1;

                }

            }



            mCrcTable[i] = crc;

        }

    }

    

    

}

