package sims2;



/* Copyright Ideaworks3D Ltd. 2005 */

/*

 * Created on Mar 9, 2005

 */











/**

 * SKU specific constants only

 */

public final class SKUConsts

{	

	/** True if we shouldn't use the mirroring flags due to memory leak issues on Series60 phones */

	public static boolean FLIPPING_MEMORY_LEAKS = true;

	

	/** Set to true if we want to memory cache all guid accesses */

	public static final boolean CACHE_ALL_STREAMED_DATA = true;

	

	/** Set to true if we want to memory cache all guid accesses */

	public static final boolean LOADING_SCREEN_IN_BUY_UPGRADE = true;

	

	//#ifdef LARGE

	/** Width of the screen in pixels */

	public static final int SCREEN_WIDTH = 240;

	/** Half width of the screen in pixels */

	public static final int SCREEN_HALF_WIDTH = SCREEN_WIDTH / 2;

	/** Height of the screen in pixels */

	public static final int SCREEN_HEIGHT = 320;

	/** Half height of the screen in pixels */

	public static final int SCREEN_HALF_HEIGHT = SCREEN_HEIGHT / 2;

	//#else

//# 	/** Width of the screen in pixels */

//# 	public static final int SCREEN_WIDTH = 176;

//# 	/** Half width of the screen in pixels */

//# 	public static final int SCREEN_HALF_WIDTH = SCREEN_WIDTH / 2;

//# 	/** Height of the screen in pixels */

//# 	public static final int SCREEN_HEIGHT = 208;

//# 	/** Half height of the screen in pixels */

//# 	public static final int SCREEN_HALF_HEIGHT = SCREEN_HEIGHT / 2;

	//#endif

	

	/** Width of the isometric view */

	public static final int ISO_VIEW_WIDTH = SCREEN_WIDTH;

	/** Half width of the isometric view */

	public static final int ISO_VIEW_HALF_WIDTH = ISO_VIEW_WIDTH / 2;

	/** Height of the isometric view */

	public static final int ISO_VIEW_HEIGHT = SCREEN_HEIGHT;

	/** Half height of the isometric view */

	public static final int ISO_VIEW_HALF_HEIGHT = ISO_VIEW_HEIGHT  / 2;

	/** Placement of isometric view */

	public static final int ISO_VIEW_X_POS = 0;

	/** Placement of isometric view */

	public static final int ISO_VIEW_Y_POS = 0;

	

	/** Width of one tile in pixels */

	public static final int TILE_WIDTH = 32;

	/** Half width of one tile in pixels */

	public static final int TILE_HALF_WIDTH = TILE_WIDTH / 2;

	/** Height of one tile in pixels */

	public static final int TILE_HEIGHT = 16;

	/** Half height of one tile in pixels */

	public static final int TILE_HALF_HEIGHT = TILE_HEIGHT / 2;

	

	/** Length of tile edge in fixed point */

	public static final int TILE_EDGE_LENGTH_FP = (int)(TILE_WIDTH * 0.7071067 * Utility.FIXED_ONE);

	

	/** Half length of tile edge in fixed point */

	public static final int HALF_TILE_EDGE_LENGTH_FP = TILE_EDGE_LENGTH_FP / 2;

	

	/** Maximum tiles that may span the screen */

	public static final int MAX_SCREEN_TILES_ACROSS =

		(SCREEN_WIDTH / TILE_HALF_WIDTH);

	

	/** Maximum tiles that may span the screen */

	public static final int MAX_SCREEN_TILES_DOWN =

		(SCREEN_HEIGHT / TILE_HEIGHT)

		+ (((SCREEN_HEIGHT % TILE_HEIGHT) != 0) ? 1 : 0)

		+ 1;

	

}

