package sims2;



/* Copyright Ideaworks3D Ltd. 2005 */

/*

 * Search.java

 */

 







import java.util.Enumeration;

import java.util.Hashtable;

import java.util.Vector;



//import com.ideaworks3d.debug.Debug;



 

/**

 * Performs an AStar search when constructed.

 * Can then be used to return useful information about the path.

 */

public class Search

{

	/** 

	 * Performs the AStar search and saves results.

	 * 

	 * @param	start		Start node in search

	 * @param	end			End node in search

	 * @param 	nodeLimit	The maximum number of nodes for the search

	 */

	public Search(Node start, Node end, int nodeLimit)

	{

		// Sanity checks.

		//Debug.debugAssert(start != null);

		//Debug.debugAssert(end != null);

		

		// Assignments.

		m_NodeLimit = nodeLimit;

		

		m_StartNode = start;

//		m_EndNode = end;

		

		// Create PortalNodes to find the sector path.

		// To avoid calculating the sector path from every

		// portal within the current sector we create a portal here.

		Node startPortal = Node.CreatePortalNode(null, Node.PORTAL_START_ID, start.getX(), start.getY());

		Node endPortal = Node.CreatePortalNode(null, Node.PORTAL_END_ID, end.getX(), end.getY());

		

		// Run complete sector A* path finding.

		Node endPathNode = GetSectorPath(startPortal, endPortal);

		

		// Place nodes in appearance order within sectorPath

		sectorPath = getAncestryChain(endPathNode);

		

		// print out sector path

//		if (Debug.ENABLED)

//		{

//			if(sectorPath != null)

//			{

//				//Debug.println("Sector path length is " + sectorPath.length, //Debug.CHAN_PATHFINDING);

//			}

//		}

		

		

		// Set the index.

		sectorIndex = 0;

		

		// Set the local index

		localNode = Integer.MAX_VALUE;

		moreSectors = true;

		PopSector(m_StartNode);		

		

		// 

		localNode = 0;

		PopNextStep();

	}

	

	/**

	 * @return	True if the search found a path, false otherwise

	 */

	public boolean hasPath()

	{

		return (localPath != null) && (localNode < localPath.length);

	}

	

	/**

	 * Preview the next step in the local path.

	 * 

	 * @return	The next Node

	 */

	public Node PeekNextStep()

	{	

		if (!hasPath())

			return null;

		else

			return getPathNode(localNode);

	}

	

	/**

	 * Pop the next step in the calculated path.

	 * This moves on to the next sector if necessary.

	 * 

	 * @return	The next Node

	 */

	public Node PopNextStep()

	{

		if(localPath != null)

		{

			//Debug.println("pop node from " + (localNode) +" to " + (localNode + 1) + "(of " + localPath.length + ")", //Debug.CHAN_PATHFINDING);

		}

		

		Node result = PeekNextStep();

		localNode++;

		

		// Pop next sector if necessary

		if (hasPath() && moreSectors)

		{

			PopSector(getPathNode(localPath.length - 1));			

		}

		

		return result;

	}

	

	/**

	 * Move on to the next sector from this node.

	 * 

	 * @param curNode	Node from which to search

	 * @return			Are more sectors?

	 */

	public boolean PopSector(Node curNode)

	{

		

		//Debug.println("pop start " + moreSectors, //Debug.CHAN_PATHFINDING);

		moreSectors = moreSectors && FindLocalPath(curNode);

		//Debug.println("pop end " + moreSectors, //Debug.CHAN_PATHFINDING);

		return moreSectors;

	}

	

	/** 

	 * Performs a local AStar search and saves results 

	 *

	 * @param	start	Start node in search.

	 */

	private boolean FindLocalPath(Node start)

	{

		// Only a path if start and end are non-null

		if( start != null &&

			sectorPath != null &&

			(++sectorIndex < sectorPath.length) )

		{

			// Choose the next portal node to aim for //



			// Get the next sector node.

			Node portalNode = (Node) sectorPath[sectorIndex];

			// Create a board node at this location.

			int[] p = portalNode.PortalGetPortalLocation();

			Node end = Node.CreateBoardNode(null, p[0], p[1], false, 1, 0);

			

			// Run complete local A* path finding.

			boolean isLastSector = (sectorIndex == sectorPath.length-1);

			Node endPathNode = getPath(start, end, isLastSector);

			

			// Place nodes in appearance order within sectorPath

			localPath = getAncestryChain(endPathNode);

			

			if(localPath == null)

			{

				if(!isLastSector)

				{

					// There is at least one more node.

					// Attempt to skip this node.

					return FindLocalPath(start);

				}

				else

				{

					// This is the last node.

					// Try another location.

					int[] p2 = House.s_LotSingleton.FindNearestEmptyCell(p[0], p[1], null);

					

					end = Node.CreateBoardNode(null, p2[0], p2[1], false, 1, 0);

					

					// Run complete local A* path finding.

					endPathNode = getPath(start, end, isLastSector);

					

					// Place nodes in appearance order within sectorPath

					localPath = getAncestryChain(endPathNode);

					

					// Failed to find alternative.

					if(localPath == null)

						return false;

				}

			}

			

			return true;

		}

		return false;

	}

	

	/**

	 * Determine which node in an enumeration has the lowest fitness

	 *

	 * @param	allNodes	Enumeration to search

	 * @param	endNode		Node we are finding a path to (used to evaluate fitness)

	 * @return	Most fit node

	 */

	private Node findMostFitNode(Enumeration allNodes, Node endNode)

	{

		Node curNode;

		Node mostFitNode = null;	

		int curFitness;

		int lowestFitness = Node.INFINITE_COST;

			

		// Find node on openList with lowest fitness

		while (allNodes.hasMoreElements())

		{

			curNode = (Node)allNodes.nextElement();

			curFitness = curNode.getFitness(endNode);

			

			if (curFitness <= lowestFitness)

			{

				lowestFitness = curFitness;

				mostFitNode = curNode;

			}

		}

				

		return mostFitNode;

	}

	

	/**

	 * Takes a pointer to an end node of a path and returns an ancestry chain

	 * in an array, starting with the eldest parent and ending with the given node.

	 *

	 * @param	end	Last node in ancestry chain

	 * @return	Ancestry chain of nodes, or null if null provided as end node

	 */

	private Node[] getAncestryChain(Node end)

	{

		Node[] ancestryArray;

		java.util.Vector ancestryVector;

	

		// Process into a vector

		ancestryVector = new java.util.Vector();

		while (end != null)

		{

			ancestryVector.insertElementAt(end, 0);

			end = end.getParent();

		}

		

		// Copy into array or return null if there are no elements

		if (ancestryVector.size() > 0)

		{

			ancestryArray = new Node[ancestryVector.size()];

			ancestryVector.copyInto(ancestryArray);

		}

		else

		{

			ancestryArray = null;

		}

	

		return ancestryArray;

	}

	

	/**

	 * Determines the number of nodes in the path (including the start and end nodes)

	 *

	 * @return	The number of nodes in the path found or 0 if no path found

	 */

	/*private int getNumPathNodes()

	{

		if (hasPath())

			return localPath.length;

		else

			return 0;

	}*/

	

	/**

	 * Calculates the shortest path from start to end

	 *

	 * @param	start	Node to begin search at (non null)

	 * @param	end		Node to end search at (non null)

	 * @return			Final node in path with parents leading back to start, or null if no path

	 */

	 private Node getPath(Node start, Node end, boolean exactLocation)

	{

	 	//Debug.debugAssert(start != null);

	 	//Debug.debugAssert(end != null);

	 	

		Hashtable openList;		// Non-explored nodes

		Hashtable closedList;	// Explored nodes



		Node current;				// Current node being explored

		Node[] children;		// Children of the current node

		int curChild;				// Used to iterate through children on current node 

	

		// Create open list and closed lists.  Add start node to open list.

		openList = new Hashtable();

		openList.put(new Integer(start.hashCode()), start);

		closedList = new Hashtable();

		

		Vector endNodes = null;

		if(exactLocation)

		{

			// Only add the end node.

			endNodes = new Vector();

			endNodes.addElement(end);

		}

		else

		{

			// Get all equivalent nodes.

			endNodes = end.getEquivalentNodes();

		}

	

		// While there are items on the open list, we may yet find a valid path!

		while ((openList.size() > 0) && (closedList.size() < m_NodeLimit))

		{

			// Find node on openList with lowest fitness

			// This is where we specify the heuristic destination

			current = findMostFitNode(openList.elements(), end);

			

			// Continuous feedback loop.

			// Update the end node based on the 

			// optimum node for reaching it.

			for(int i = 0; i < endNodes.size(); ++i)

			{

				Node node = (Node) endNodes.elementAt(i);

				// If this is closer than end then update end.

				if( current.calculateHeuristicTo(node) < 

					current.calculateHeuristicTo(end) )

					end = node;

			}

						

			// If this node is the end node then we have found the path -- return it 

			if (current.equals(end))

			{

				//Debug.println((closedList.size() + 1) + " nodes visited", //Debug.CHAN_PATHFINDING);

				return current;

			}

			

			// Remove this from the openList and add to closed list

			openList.remove(new Integer(current.hashCode()));

			closedList.put(new Integer(current.hashCode()), current);

			

			// Create and process node children

			children = current.createSuccessors(start, end, hasPreferredDirection, preferredDirectionX, preferredDirectionY);

			for (curChild = 0; curChild < children.length; curChild++)

			{

				// Only bother if child is reachable from parent

				// Use heuristic end point.

				if (children[curChild].getFitness(end) != Node.INFINITE_COST)

				{

					// Check whether the child is in the open or closed lists

					Integer hashValue = new Integer(children[curChild].hashCode());

					boolean isOnOpenList = openList.containsKey(hashValue);

					boolean isOnClosedList = !isOnOpenList && closedList.containsKey(hashValue);

					

					// If the child is already on a list

					if (isOnOpenList || isOnClosedList)

					{

						// Check whether the fitness of the new node is less than the fitness of the existing one

						Node existingNode = (Node)(isOnOpenList ? openList : closedList).get(hashValue);

						boolean betterFitness = existingNode.getFitness(end) > children[curChild].getFitness(end);

						

						// If so then steal the old node to the new path.

						// (old parent won't mind because we never traverse down the list)

						if (betterFitness)

						{

							current.addChild(existingNode, hasPreferredDirection, preferredDirectionX, preferredDirectionY);

						}

					}

					else	// Else add to open list as child of current node

					{

						openList.put(hashValue, children[curChild]);

						current.addChild(children[curChild], hasPreferredDirection, preferredDirectionX, preferredDirectionY);

					}

				}

			}

		}

	

		// No path found, return null

		//Debug.println(closedList.size() + " nodes visited", //Debug.CHAN_PATHFINDING);

		return null;

	}

	

	/**

	 * @param		index	The index of the node in the path nodes to return

	 * @return	the given particular node in the path or null if not found

	 */

	private Node getPathNode(int index)

	{

		if ((index >= 0) && (index < localPath.length))

			return localPath[index];

		else

			return null;

	}

		

	/**

	 * Find the path between the sectors using the portals.

	 * 

	 * @param start		start node within one sector

	 * @param end		end node within another sector

	 * @return			portal nodes to follow

	 */

	private Node GetSectorPath(Node start, Node end)

	{

		Node path = getPath(start, end, true);

		

//		if (Debug.ENABLED)

//		{

//			// Process into a vector

//			//Debug.println("sectors:", //Debug.CHAN_PATHFINDING);

//			Node endP = path;

//			while (endP != null)

//			{

//				//Debug.println(String.valueOf(((Node)endP).PortalGetId()), //Debug.CHAN_PATHFINDING);

//				endP = endP.getParent();

//			}

//		}

		

		return path;

	}

	

 	/** Maximum number of nodes to search */

 	final int m_NodeLimit;

	

	/** Position on the path */

	private int localNode;

 	

	/** The ancestry chain of the local path found */

	private Node[] localPath;

	

	/** End node */

//	private Node m_EndNode;

	

	/** Start node */

	private Node m_StartNode;



	/** Are there more sectors from the current position? */

	private boolean moreSectors;

	

	/** The index into the sectorPath */

	private int sectorIndex;

	

	/** The ancestry chain of the sector path found */

	private Node[] sectorPath;

	

	private boolean	hasPreferredDirection;

	private int		preferredDirectionX;

	private int		preferredDirectionY;

}

