package sims2;



/* Copyright Ideaworks3D Ltd. 2005 */







import java.util.Enumeration;

import java.util.Vector;



import javax.microedition.lcdui.Graphics;

import javax.microedition.lcdui.Image;





//import com.ideaworks3d.debug.Debug;



//import SimsCanvas;



/**

 * @author benw, jimv

 *

 * TODO To change the template for this generated type comment go to

 * Window - Preferences - Java - Code Style - Code Templates

 */

public final class SimObject extends EdithObject

{		

	private static Image	m_SkillsIcon;



	private static Image	m_PlumbBob;



	private static Image	m_NeedIconsMinus;



	private static Image	m_NeedIconsPlus;

	

	private static Image[]	m_GainImages;

	

	public static void LoadStaticImages()

	{

		m_SkillsIcon = Utility.loadImage("thoughts/Thought_Skills_Strip", true);

		m_PlumbBob = Utility.loadImage("plumb_bob", true);

		m_NeedIconsMinus = Utility.loadImage("needs_icons/NeedsIcons_minus_Strip", true);

		m_NeedIconsPlus = Utility.loadImage("needs_icons/NeedsIcons_plus_Strip", true);

		m_GainImages = new Image[2];

		m_GainImages[0] = Utility.loadImage("thoughts/DoublePlus", true);

		m_GainImages[1] = Utility.loadImage("thoughts/DoubleMinus", true);

	}



	public SimObject(int guId, int m_Appearance, boolean is_player, int stringId)

	{

		super(guId, m_Appearance, 0, 0, true, stringId);

		

		m_CurrentAction = ACTION_INVALID;

		

		m_ActionQueue = new Vector();



		m_IsPlayer = is_player;



		if (m_IsPlayer)

		{

			//Debug.println("new SimObject (player): " + m_name, //Debug.CHAN_SIM_OBJECT);

		}

		else

		{

			//Debug.println("new SimObject: " + m_name, //Debug.CHAN_SIM_OBJECT);

		}

		

		// No thought to begin with

		m_effectTime = (long)THOUGHT_DURATION;

//		this.m_modifierY = 5;

		m_progressIntoNextTileFp = 0;

		

		// Initialise to stand animation

		ControlAnimation(ANIM_ID_STAND, true, AnimationEffect.NONE);

		

	} // end Sim constructor

		

	/**

	 * Calculate position offset into next tile for character.

	 * We offset the character from the current tile until it reaches the next

	 * at which point we reduce the offset to zero and snap to the next tile.

	 * 

	 * @return	2d array containing x and y offsets

	 */

	public final int[] GetDrawOffset()

	{

		int dX = 0;	// X offset

		int dY = 0;	// Y offset

		

		//	 Alter position with progress into next tile

		if (m_progressIntoNextTileFp != 0)

		{

			// Determine tile offset

//START:how can this work#

			switch (GetFacing())

			{

			case Facing.NE:

				dX = 1;

				dY = -1;

				break;

				

			case Facing.NW:

				dX = -1;

				dY = -1;

				break;

				

			case Facing.SE:

				dX = 1;

				dY = 1;

				break;

				

			case Facing.SW:

				dX = -1;

				dY = 1;

				break;

			}			

//END			



			// Multiply through by tile width and height

			dX = (dX * SKUConsts.TILE_HALF_WIDTH * m_progressIntoNextTileFp) >> Utility.FIXED_POS;

			dY = (dY * SKUConsts.TILE_HALF_HEIGHT * m_progressIntoNextTileFp) >> Utility.FIXED_POS;

		}

		

		// Add half tile height to y, since Sim is anchored to centre of tile

		// (not the top as all objects are)

		dY += SKUConsts.TILE_HALF_HEIGHT;

		////Debug.println("DrawOffset: " + dY + " " + dX, //Debug.CHAN_TEMP_SET_ME);

		

//START:IGNORE:return value#

		return new int[] { dX, dY };

//END

	

	} // end GetDrawOffset

	

	/**

	 * Adds the social frame to the Sim for accessing later

	 * 

	 * @param label

	 */

	public void AddSocialFrame(String label)

	{

		throw new Error("depracated routine");

	} // end AddSocialFrame

	

	/**

	 * Gets the image for the socials screen

	 * 

	 * @param label

	 * @return

	 */

	public Image GetSocialImage(String label)

	{

		throw new Error("depracated routine");

	} // end GetSocialImage

			

	private int GetNextAction()

	{

		int action = ACTION_INVALID;

		

		if(!m_ActionQueue.isEmpty())

		{

			// Get the vector.

			Enumeration params = ((Vector) m_ActionQueue.elementAt(0)).elements();

			m_ActionQueue.removeElementAt(0);

			

			action = ((Integer)params.nextElement()).intValue();

//START:getnextaction#

			switch(action)

			{

			case ACTION_INVALID:

				//Debug.debugAssert(false);

				break;

				

			case ACTION_ROUTE_TO_LOCATION:

				m_WorldX = ((Integer)params.nextElement()).intValue();

				m_WorldY = ((Integer)params.nextElement()).intValue();

				break;

				

			case ACTION_ROUTE_TO_OBJECT:

				m_TargetObject = (EdithObject)params.nextElement();

				break;

				

			case ACTION_TURN_TO_OBJECT:

				m_TargetObject = (EdithObject)params.nextElement();

				m_FaceObject = ((Boolean)params.nextElement()).booleanValue();

				break;

				

			case ACTION_SET_FACING:

				m_TargetOrientation = ((Integer)params.nextElement()).intValue();

				break;

			}

//END

		}

		

		return action;

	}

	

	/**

	 * Main tick function for Sim objects (overrides the EdithObject one)

	 * @param int time - time elapsed in milliseconds since last time this function was run

	 */

	public void Tick(int millis)

	{	

		

		// Process the current action.

//START:tick#

		switch(m_CurrentAction)

		{

		case ACTION_INVALID:

			// Get the next action from the queue.

			m_CurrentAction = GetNextAction();

			break;

			

		case ACTION_ROUTE_TO_LOCATION:

			UpdateWorldPosRouteProcessing(m_WorldX, m_WorldY);

			break;

			

		case ACTION_ROUTE_TO_OBJECT:

			RouteToRoutingSlot(m_TargetObject);

			break;

			

		case ACTION_TURN_TO_OBJECT:			

			TurnTowards(m_TargetObject, !m_FaceObject, false);

			break;

			

		case ACTION_SET_FACING:

			if (!GetFacing(this, m_TargetOrientation))

			{

				m_CurrentAction = ACTION_INVALID;

			}

			break;

			

		case ACTION_USE_OBJECT:

			// Placeholder only.

			m_CurrentAction = ACTION_INVALID;

			break;

			

		case ACTION_SOCIALIZE:

			SimsApp.s_MIDlet.InitSocialRootMenu(true);

			m_CurrentAction = ACTION_INVALID;

			break;

			

		case ACTION_NPC_LEAVE:

			ClearActions();

			SimsApp.s_MIDlet.RemoveNPCFromMap(m_GuId - WorldData.NPC_ID_START_OFFSET);

			break;

		}

//END		

		// Attach progress into next tile to effect progress if walking

		if (m_IsWalking)

		{

			if (m_DirectControl && IsEffectDue(WALK_DELAY))

			{

				m_progressIntoNextTileFp = 0;

				House.s_LotSingleton.MoveObject(this, GetXPos(), GetYPos(), false);

				//Debug.println("move walk: " + m_newX + " " + m_newY, //Debug.CHAN_SIM_OBJECT);

				SetXPos(m_newX);

				SetYPos(m_newY);

				ResetEffect();

				if (m_StopOnNextTile)

					StopWalking();

			}

			else

			{

				if (m_DirectControl)

				{

					//Debug.println("walk ...", //Debug.CHAN_SIM_OBJECT);

				}

				int progress = GetEffectProgress(WALK_DELAY);

				m_progressIntoNextTileFp = progress;

			}

		}

		

		super.Tick(millis);



	} // end Tick



	private void StopWalking()

	{

		//Debug.println("stop walking", //Debug.CHAN_SIM_OBJECT);

//		ResetStaticVarFlag(EdithObject.STATIC_VAR_FLAG_WALKING);

		ControlAnimation(ANIM_ID_STAND, true, AnimationEffect.NONE);

		ResetEffect();

		m_IsWalking = false;

		m_StopOnNextTile = false;

		m_DirectControl = false;

	}



	/**

	 * Draws the Sim effect icons

	 * 

	 * @param x x

	 * @param y y

	 * @param g given Graphics where to paint the character

	 */

	public void DrawSimEffects(int x, int y, Graphics g)

	{

//		Image frameImage;	// Current animation m_CurFrame

		int xOffset;		// X offset to draw bubble at

		int yOffset;		// Y offset to draw bubble at



		if(IsPlayer())

		{

			// Use the walk offsets.

//			START:IGNORE:CentreOnObject#

			int[] pos = GetDrawOffset();

//			int[] pos = House.s_LotSingleton.GetItemScreenPos(this);

//END

			pos[0] += x;

			pos[1] += y-75;

			

			DrawPlumbBob(pos[0], pos[1], g);

		}

		

		// If a thought is being had

		if (m_effectTime < (long)THOUGHT_DURATION)

		{	

			// if it is the first time through, just add one and set the last millis 

			// (to avoid problems with screen changes)

			if (m_effectTime == 0)

			{

				m_effectTime++;

				m_effectMillisLastTick = System.currentTimeMillis();

			}

			else

			{

				// increase the time spent in thought

				m_effectTime += (System.currentTimeMillis() - m_effectMillisLastTick);

				m_effectMillisLastTick = System.currentTimeMillis();

			}



			// Determine offset of thought

			//			xOffset = m_modifierX + (m_CurAnim.GetWidth() / 2);

			//			yOffset = m_modifierY - m_CurAnim.GetHeight();

			xOffset = 0;

			yOffset = THOUGHT_Y_OFFSET;

			if (m_CurAnim != null)

			{

				xOffset += (m_CurAnim.GetWidth() / 2);

				yOffset -= m_CurAnim.GetHeight();

			}



			// Draw thought bubble or gain

			if (m_effectBubbleGainSkill!=0)

			{

				yOffset -= (m_effectTime / 100);

				if (m_effectBubbleGainSkill==1)

					DrawThoughtGain(x + xOffset + GAIN_THOUGHT_X_OFFSET, y + yOffset, g);

				else

				{

					if(m_effectBubbleGainSkill==2)

						DrawSkillIcon(x + xOffset, y + yOffset, g);

					else

						DrawThoughtFail(x + xOffset + GAIN_THOUGHT_X_OFFSET, y + yOffset, g);

				}

			}

		}



	} // end DrawSimEffects



	/**

	 * Instruct the Sim to have a gain thought.

	 * The thought will interrupt any current thought and

	 * last for a given amount of time before stopping.

	 * The thought will cause a gain to appear.

	 * 

	 * @param	type			Type of thought to have (pick from enumeration in this class)

	 * @param	strength	Strength of gain thought to have (pick from enumeration in this class)

	 */

	public final void HaveGainThought(final int type)

	{

		// Store type and set countdown to duration

		m_effectBubbleGainSkill = 1;

		m_effectType = type;

		m_effectTime = 0;

		

	} // end HaveGainThought

	

	public final void HaveFailThought(final int type)

	{

		// Store type and set countdown to duration

		m_effectBubbleGainSkill = 3;

		m_effectType = type;

		m_effectTime = 0;

		

	} // end HaveGainThought

	

	public final void HaveSkillThought(final int type)

	{

		// Store type and set countdown to duration

		m_effectBubbleGainSkill = 2;

		m_effectType = type;

		m_effectTime = 0;

		

	} // end HaveSkillThought

	

	/**

	 * Used to tell Sim when he is walking (since this is controlled via a primitive)

	 * 

	 * @param isWalking	True if walking, false if not

	 */

	public final void SetIsWalking(boolean isWalking)

	{

		m_IsWalking = isWalking;

	}

	

	public final boolean IsWalking()

	{

		return m_IsWalking;

	}

	

	public boolean IsBusy()

	{

		return (

			m_CurrentAction != ACTION_INVALID ||

			!m_ActionQueue.isEmpty() );

	}



	/**

	 * Update representation in renderer

	 */

	public void UpdateBillboards()

	{				

		// Do brunt of the work

		super.UpdateBillboards();

		

		// Add character specific offset

		int[] offset = GetDrawOffset();		

		m_Billboard.x += offset[0];

		m_Billboard.y += offset[1];

	}



	private void SetInitialisationFlag(int actionId)

	{

		m_ActionInitFlags |= 1 << actionId;

	}

	

	private void ResetInitialisationFlag(int actionId)

	{

		m_ActionInitFlags &= ~(1 << actionId);

	}

	

	private boolean CheckInitialisationFlag(int actionId)

	{

		return (m_ActionInitFlags & (1 << actionId)) != 0;

	}

	

	private void SetCurrentActionInitialised()

	{

		SetInitialisationFlag(m_CurrentAction);

	}

	

	private void ResetCurrentActionInitialised()

	{

		ResetInitialisationFlag(m_CurrentAction);

	}



	private boolean IsCurrentActionInitialised()

	{

		return CheckInitialisationFlag(m_CurrentAction);

	}

	

	/**

	 * Sets up the walk to action for the Sim

	 * 

	 * @param xPos

	 * @param yPos

	 */

	public void AddWalkToAction(int xPos, int yPos)

	{

		// Set up the routing.

		Vector params = new Vector();

		params.addElement(new Integer(ACTION_ROUTE_TO_LOCATION));

		params.addElement(new Integer(xPos));

		params.addElement(new Integer(yPos));

		

		m_ActionQueue.addElement(params);

	}

	

	/**

	 * Sets up the walk to action for the Sim

	 * 

	 * @param eObject		Object to walk to

	 */

	public boolean AddWalkToAction(EdithObject eObject)

	{

		// Set up the routing.

		Vector params = new Vector();

		params.addElement(new Integer(ACTION_ROUTE_TO_OBJECT));

		params.addElement(eObject);

		

		m_ActionQueue.addElement(params);

		

		return true;	

	} 

	

	/**

	 * Sets up the walk to action for the Sim

	 * 

	 * @param eObject		Object to walk to

	 */

	public boolean AddUseObjectAction(EdithObject eObject)

	{

		// Set up the routing.

		Vector params = new Vector();

		params.addElement(new Integer(ACTION_USE_OBJECT));

		params.addElement(eObject);

		

		m_ActionQueue.addElement(params);

		

		return true;	

	} 

	

	/**

	 * Sets up a generic action (doesn't need an object)

	 * 

	 * @param eObject		Object to walk to

	 */

	public boolean AddGenericAction(int actionId)

	{

		// Set up the routing.

		Vector params = new Vector();

		params.addElement(new Integer(actionId));

		

		m_ActionQueue.addElement(params);

		

		return true;



	} // end AddGenericAction

	

	/**

	 * Clear any pending actions

	 * 

	 */

	public void ClearActions()

	{

		m_ActionQueue.removeAllElements();

		

		ResetCurrentActionInitialised();

		m_CurrentAction = ACTION_INVALID;

		

		// Stop any current walk action

		if(IsWalking())

		{

			StopWalking();

			ClearPath();

			ResetStaticVarFlag(EdithObject.STATIC_VAR_FLAG_WALKING);				

		}		

	} // end ClearActions

	

	/**

	 * Sets up the walk to action for the Sim

	 * 

	 * @param eObject		Object to turn towards

	 */

	public boolean AddTurnTowardsAction(EdithObject eObject, boolean faceObject)

	{

		// Set up the routing.

		Vector params = new Vector();

		params.addElement(new Integer(ACTION_TURN_TO_OBJECT));

		params.addElement(eObject);

		params.addElement(new Boolean(faceObject));

		

		m_ActionQueue.addElement(params);

		

		return true;

	} 

	

	/**

	 * Sets up action to make Sim face a certain direction

	 * 

	 * @param facing

	 */

	public void AddSetFacingToAction(int facing)

	{

		// Set up the routing.

		Vector params = new Vector();

		params.addElement(new Integer(ACTION_SET_FACING));

		params.addElement(new Integer(facing));

		

		m_ActionQueue.addElement(params);

	}

	

	/**

	 * Turn this EdithObject to face another by a maximum of ninety degrees

	 * 

	 * @param Primitive primitive

	 * @param int targetX

	 * @param int targetY

	 * @return true if a turn was made, false if this EdithObject was already facing eObject

	 */

	private void TurnTowards(/*Primitive primitive,*/EdithObject eObject, boolean faceOpposite, boolean faceThisObject)

	{

		EdithObject targetObject = this;

		int 		containerSlot;

		

		if (faceThisObject)

		{

			// Swap target and source.

			targetObject = eObject;

			eObject = this;

			

			// TODO: HACK: Sims currently only have one container slot, and Sims currently can only change their facing....

			containerSlot = eObject.GetContainerThisObjectIsUsing(targetObject.m_InstanceId);

		}

		else

		{

			containerSlot = targetObject.m_staticScriptVars[StaticVariables.STAT_CURRENT_CONTAINER_SLOT];

		}

		

		// This will happen if we've not reached the object.

		// Just fail gracefully.

		boolean stillRotating = false;

		if(containerSlot != EdithObject.INVALID_SLOT_ID)

		{

//			Debug.assertPrintln( (containerSlot != EdithObject.INVALID_SLOT_ID),

//					"Invaled container Slot for targeted object(" + eObject +

//					") in TurnTowards primitive, container slot id: " + containerSlot);

			

			// get the x and y position of the container slot in use and use it for facing

//START:IGNORE:targetPosInt#

			int targetPosInt[] = eObject.GetContainerSlotOffset(containerSlot);

//END

			targetPosInt[0] += eObject.GetXPos();

			targetPosInt[1] += eObject.GetYPos();

			// get the facing

			stillRotating = GetFacing(targetObject, targetPosInt[0], targetPosInt[1], faceOpposite);

		}



		// If this call came to handle the turn towards primitive then

		// we may have to return a callback

		if (!stillRotating)

		{

			m_CurrentAction = ACTION_INVALID;

		}

		

	} // end TurnTowards

	

	/**

	 * Route an object to a object routing slot (a world position, tile based)

	 * 

	 * @param Primitive primitive

	 */

	private void RouteToRoutingSlot(EdithObject eObject)

	{

		EdithObject targetObject = this;

		boolean endPrimitive = false;

		

		// if the script has been cancelled, return false and set the character to stand

		if (eObject.CheckStaticVarFlag(EdithObject.STATIC_VAR_FLAG_CANCEL_SCRIPT) )

		{

			endPrimitive = true;

		}

		// otherwise process the primitive normally

		else

		{			

			// If this is the first call

			if ( !IsCurrentActionInitialised() )

			{			

				boolean blocked = false;

				

				// go through each container slot to see if it is available

				for (int i = 0; i < eObject.GetNumContainerSlots(); i++)

				{					

					// if the container slot is in use, then mark the object as blocked for now

					if (eObject.IsContainerSlotInUse(i, targetObject.m_InstanceId) )

					{

						blocked = true;

					}

					else

					{

						targetObject.m_staticScriptVars[StaticVariables.STAT_CURRENT_CONTAINER_SLOT] = i;

						

						// figure out the routing slot to go to for the container slot,

						//  and store it for use later, if there is none, mark the blocked flag as true

						if (!eObject.GetRoutingSlotToUse(targetObject))

						{

							blocked = true;

						}

						else

						{

							// Set walk animation (can only be done for SimObject, not an EdithObject)

							if (targetObject instanceof SimObject)

							{

								((SimObject)targetObject).ControlAnimation(SimObject.ANIM_ID_WALK, true, AnimationEffect.NONE);

								

								// Tell sim to attach position on tile to effect progress

								((SimObject)targetObject).SetIsWalking(true);

							}

							

							SetCurrentActionInitialised();

							targetObject.SetStaticVarFlag(EdithObject.STATIC_VAR_FLAG_WALKING);

							blocked = false;

							break;

						}

					}

				}

				

				if (blocked)

				{

					// If this is the player controlled sim then pop up dialog for the user.

//START:broken instance#

					if (targetObject instanceof SimObject && ((SimObject)targetObject).IsPlayer())

					{

						// Clear any action

						SimsApp.s_MIDlet.StopAction(true, false);

						

						// Show the dialog.

						Dialogue.SetStaticDialogue(new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.CAN_NOT_REACH) ), 2000);

					}

//END



					targetObject.m_staticScriptVars[StaticVariables.STAT_CURRENT_CONTAINER_SLOT] = EdithObject.INVALID_INSTANCE_ID;

					endPrimitive = true;

				}

			}

			

			if (!endPrimitive)

			{

				int routingSlot = targetObject.m_staticScriptVars[StaticVariables.STAT_CURRENT_ROUTING_SLOT];			

				//Debug.assertPrintln(routingSlot != EdithObject.INVALID_SLOT_ID,

				//				"Invalid routing slot on RouteToRoutingSlot()");				

//				Point2 targetPos = ScriptVM.GetScriptVM().m_worldBehaviors.GetRoutingSlot(eObject.m_guId, routingSlot);

//START:IGNORE:targetPosInt again#

				int targetPosInt[] = eObject.GetRoutingSlotOffset(routingSlot);

//END

				targetPosInt[0] += eObject.GetXPos();

				targetPosInt[1] += eObject.GetYPos();

				

				// if we are at the correct location

				if (targetObject.PositionEquals(targetPosInt[0], targetPosInt[1], 0) )

				{					

					// Get the container slot the target object was routing to

					int containerSlotToUse = targetObject.m_staticScriptVars[StaticVariables.STAT_CURRENT_CONTAINER_SLOT];

					

					// check to see if it is in use

					if (!eObject.IsContainerSlotInUse(containerSlotToUse, targetObject.m_InstanceId) )

					{

						eObject.m_containerSlots[containerSlotToUse] = targetObject.m_InstanceId;

						

						// set up the callback as we are done and made it to the point, so mark the callback boolean as true

						endPrimitive = true;

//						returnValue = true;

//START:debug print 1#

						//Debug.println("Object id " + targetObject.m_InstanceId + 

						//				" has arrived at routing slot " + routingSlot, //Debug.CHAN_ROUTING_OBJECT);

//END

						

						// For the moment just turn towards in this case.

//						turnTowards = true;

					}

					else

					{

						endPrimitive = true;

					}

				}

				else	// Still path finding to do

				{			

					if(!UpdateWorldPosRoute(/*primitive, */targetPosInt[0], targetPosInt[1]))

					{

						// Could not follow this path.

						//Debug.println("Unable to complete calculated path", //Debug.CHAN_REROUTING_OBJECT);

						//Debug.println("Routing object: " + targetObject.m_name, //Debug.CHAN_REROUTING_OBJECT);

						//Debug.println("Target object: " + eObject.m_name, //Debug.CHAN_REROUTING_OBJECT);

						

						// Remove cached path

						targetObject.ClearPath();

						

						// Stop walking.

						targetObject.ResetStaticVarFlag(EdithObject.STATIC_VAR_FLAG_WALKING);

						if (targetObject instanceof SimObject)

						{

							((SimObject)targetObject).ControlAnimation(SimObject.ANIM_ID_STAND, true, AnimationEffect.NONE);

						}

						

						// We failed to reach the destination.

						// If the target position is occupied then we should try another path.

						// Get the container slot the target object was routing to

						int containerSlotToUse = targetObject.m_staticScriptVars[StaticVariables.STAT_CURRENT_CONTAINER_SLOT];

						

						// check to see if it is not in use

						if (!eObject.IsContainerSlotInUse(containerSlotToUse, targetObject.m_InstanceId) )

							// Check to see if the routing slot is occupied.

							if(House.s_LotSingleton.IsSpaceOccupied(targetPosInt[0], targetPosInt[1]))

							{

								//Debug.println("Container slot not in use but routing slot occupied", //Debug.CHAN_REROUTING_OBJECT);

								//Debug.println("Unable to complete calculated path - rebooting...", //Debug.CHAN_REROUTING_OBJECT);

								// Our situation has changed.

								// We just need to reboot this primitive.

								ResetCurrentActionInitialised();

								return;

							}

						

						// check to see if it is in use

						if (eObject.IsContainerSlotInUse(containerSlotToUse, targetObject.m_InstanceId) )

						{

							//Debug.println("Container slot now in use", //Debug.CHAN_REROUTING_OBJECT);

							//Debug.println("Unable to complete calculated path - rebooting...", //Debug.CHAN_REROUTING_OBJECT);

							// Our situation has changed.

							// We just need to reboot this primitive.

							ResetCurrentActionInitialised();

							return;

						}

						

						// The routing failed and there is nothing using our

						// elected slot. It may be that we can't reach the free

						// slot. Here we need to do a test to see whether any of

						// the routing slots are accessible (using the

						// pathfinding).

						// If the pathfinding manages to find an acessible slot 

						// then we need to force the use of this slot.

						// Else fail gracefully.

						

						// Here we have almost reached the routing slot so we can

						// perform short tests of routing slot accessibility

						// to obtain a reachable container.

						

						//Debug.println("Failed to reach routing slot", //Debug.CHAN_REROUTING_OBJECT);

						//Debug.println("Searching for accessible slots...", //Debug.CHAN_REROUTING_OBJECT);

						// Get all of the routing slots.

						int numRoutingSlots = eObject.GetNumRoutingSlots();

						for(int i = 0; i < numRoutingSlots; ++i)

						{

							// Check that the container slot is not is use.

							int container = eObject.GetRoutingSlotContainer(i);

							if( !eObject.IsContainerSlotInUse(container, targetObject.m_InstanceId) )

							{

								// Check accessibility //

								

								// Set the target position.

//START:IGNORE:targetPosInt2#

								int targetPosInt2[] = eObject.GetRoutingSlotOffset(i);

//END

								targetPosInt2[0] += eObject.GetXPos();

								targetPosInt2[1] += eObject.GetYPos();



								targetObject.CalculateRoute(targetPosInt2[0], targetPosInt2[1]);

								if(targetObject.HasPath())

								{

									// If we're in the right sector this guarantees us a path.

									

									// Set these routing and container slots.

									targetObject.m_staticScriptVars[StaticVariables.STAT_CURRENT_ROUTING_SLOT] = i;

									targetObject.m_staticScriptVars[StaticVariables.STAT_CURRENT_CONTAINER_SLOT] = container;

									

									//Debug.println("Accessible routing slot found", //Debug.CHAN_REROUTING_OBJECT);

									//Debug.println("Routing slot number: " + i, //Debug.CHAN_REROUTING_OBJECT);

//START:debug print 2#

									//Debug.println("Location: " + targetPosInt2[0] + ", " + targetPosInt2[1], //Debug.CHAN_REROUTING_OBJECT);

//END

									

//									RouteToRoutingSlot(primitive);

									return;

								}

							}

						}

						

						//Debug.println("No routing slot found", //Debug.CHAN_REROUTING_OBJECT);



						if(true)

						{

							// Abandoning current task, so display a message

							//Debug.println("Unable to follow path", //Debug.CHAN_ROUTING_OBJECT);

							

							// If this is the player controlled sim then

							// pop up dialog for the user.

							if (targetObject instanceof SimObject)

							{

								SimObject sim = (SimObject) targetObject;

								if(sim.IsPlayer())

								{

									// Clear any action

									SimsApp.s_MIDlet.StopAction(true, false);

									

									// Show the dialog.

									Dialogue.SetStaticDialogue(new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.CAN_NOT_REACH) ), 2000);

								}

							}

							

//							returnValue = false;

							endPrimitive = true;

						}

					}

					else

					{

						// We're progressing along the path.

						// Set walk animation (can only be done for SimObject, not an EdithObject)

						if(!targetObject.CheckStaticVarFlag(EdithObject.STATIC_VAR_FLAG_WALKING))

						{

							if (targetObject instanceof SimObject)

							{

								((SimObject)targetObject).ControlAnimation(SimObject.ANIM_ID_WALK, true, AnimationEffect.NONE);

							}

							targetObject.SetStaticVarFlag(EdithObject.STATIC_VAR_FLAG_WALKING);

						}

					}

				}

			}

		}

		

		if (endPrimitive) 

		{

			// Remove cached path

			targetObject.ClearPath();

			

			// Set walk animation (can only be done for SimObject, not an EdithObject)

			if (targetObject instanceof SimObject)

			{

				((SimObject)targetObject).ControlAnimation(SimObject.ANIM_ID_STAND, true, AnimationEffect.NONE);

				

				// Tell sim to attach position on tile to effect progress

				((SimObject)targetObject).SetIsWalking(false);

			}

			// set up the callback as we are done and made it to the point, so mark the callback boolean as true

//			EndPrimitive(primitive, targetObject, true);

			ResetCurrentActionInitialised();

			m_CurrentAction = ACTION_INVALID;

			targetObject.ResetStaticVarFlag(EdithObject.STATIC_VAR_FLAG_WALKING);

			

//			if(turnTowards)

//				SetTurnTowardsAction(m_TargetObject);

		}

		

	} // end RouteToRoutingSlot

	

	/**

	 * Route an object to a world position (tile based)

	 * 

	 * @param Primitive primitive

	 * @param int targetX

	 * @param int targetY

	 */

	private void UpdateWorldPosRouteProcessing(/*Primitive primitive, */int targetX, int targetY/*, boolean useObjectStack*/)

	{

		EdithObject targetObject = this; //primitive.GetTargetEdithObject();

		

		int actualTargetX = targetX;

		int actualTargetY = targetY;

		

		{			

			// If this is the first call

			if(!IsCurrentActionInitialised())

			{

				// Set walk animation (can only be done for SimObject, not an EdithObject)

				if (targetObject instanceof SimObject)

				{

					((SimObject)targetObject).ControlAnimation(SimObject.ANIM_ID_WALK, true, AnimationEffect.NONE);

					

					// Tell sim to attach position on tile to effect progress

					((SimObject)targetObject).SetIsWalking(true);

				}

				

//				primitive.SetStatusFlag(Primitive.PRIM_BF_MASK_INITIALIZED);

				SetCurrentActionInitialised();

				targetObject.SetStaticVarFlag(EdithObject.STATIC_VAR_FLAG_WALKING);

			}

			

			// if we are at the correct location

			if (targetObject.PositionEquals(actualTargetX, actualTargetY, 0) )

			{			

				// Remove cached path

				targetObject.ClearPath();

				

				// Set walk animation (can only be done for SimObject, not an EdithObject)

				if (targetObject instanceof SimObject)

				{

					((SimObject)targetObject).ControlAnimation(SimObject.ANIM_ID_STAND, true, AnimationEffect.NONE);

					

					// Tell sim to attach position on tile to effect progress

					((SimObject)targetObject).SetIsWalking(false);

				}

				// set up the callback as we are done and made it to the point, so mark the callback boolean as true

//				EndPrimitive(primitive, targetObject, true);

				ResetCurrentActionInitialised();

				m_CurrentAction = ACTION_INVALID;

				targetObject.ResetStaticVarFlag(EdithObject.STATIC_VAR_FLAG_WALKING);

//START:debug print 3#

				//Debug.println("Object id " + targetObject.m_InstanceId + " has arrived.", //Debug.CHAN_ROUTING_OBJECT);

//END

			}

			else	// Still path finding to do

			{			

				if(!UpdateWorldPosRoute(/*primitive, */actualTargetX, actualTargetY))

				{

					// Remove cached path

					targetObject.ClearPath();

					

					// Abandoning current task, so display a message

					//Debug.println("Failed to reach target", //Debug.CHAN_ROUTING_OBJECT);

					

					// Set walk animation (can only be done for SimObject, not an EdithObject)

					if (targetObject instanceof SimObject)

					{

						((SimObject)targetObject).ControlAnimation(SimObject.ANIM_ID_STAND, true, AnimationEffect.NONE);

						

						// Tell sim to attach position on tile to effect progress

						((SimObject)targetObject).SetIsWalking(false);

					}

					// If this is the player controlled sim then

					// pop up dialog for the user.

					if (targetObject instanceof SimObject)

					{

						SimObject sim = (SimObject) targetObject;

						if(sim.IsPlayer())

							// Show the dialog.

							Dialogue.SetStaticDialogue(new Dialogue(SimsCanvas.s_Canvas.getStringById(StringId.CAN_NOT_REACH) ), 2000);

					}



					// Reached alternative destination.					

//					EndPrimitive(primitive, primitive.GetTargetEdithObject(), false);

					ResetCurrentActionInitialised();

					targetObject.ResetStaticVarFlag(EdithObject.STATIC_VAR_FLAG_WALKING);	

					

					// Quit trying unless it's an npc.

					if(!(targetObject instanceof SimObject))

						m_CurrentAction = ACTION_INVALID;

					if (targetObject instanceof SimObject)

					{

						SimObject sim = (SimObject) targetObject;

						if(sim.IsPlayer())

							m_CurrentAction = ACTION_INVALID;

					}

				}

			}

		}

		

	} // end RouteToWorldPos

	

	/**

	 *  Update an object's routing moving towards the specified position

	 * 

	 * @param Primitive primitive - primitive calling this method

	 * @param int targetX - world position X to move towards

	 * @param int targetX - world position Y to move towards

	 * @return		True if path proceeding okay, false if no path found

	 */

	private boolean UpdateWorldPosRoute(/*Primitive primitive, */int targetX, int targetY)

	{

		boolean failed;

		

		EdithObject targetObject = this; //primitive.GetTargetEdithObject();

		int 		oldX = targetObject.GetXPos();

		int 		oldY = targetObject.GetYPos();

	 

		// If we have no path, then calculate one

		// (we may have to do this more than once, since we don't always

		// route to the exact location on the first try)

		if (!targetObject.HasPath())

		{

			targetObject.CalculateRoute(targetX, targetY);

		}

		

		// If still no path then we have nowhere to go

		if (!targetObject.HasPath())

		{

			failed = true;

		}

		else

		{

			try

			{

				// Get next direction to move in

//START:IGNORE:nextDir#

				int nextDir[] = targetObject.GetNextRouteDirection();

//END

				

				// Turn character

				boolean isTurning = GetFacing(targetObject, 

								targetObject.GetXPos() + nextDir[0], 

								targetObject.GetYPos() + nextDir[1], false);

				

				// If turning

				if (isTurning)

				{

					// Reset animation effect (don't move across tiles whilst turning)

					targetObject.ResetEffect();

				}

				else	// No longer turning -- walking

				{

					// Check for action tick

					if (targetObject.IsEffectDue(SimObject.WALK_DELAY) )

					{

						targetObject.SetXPos(targetObject.GetXPos() + nextDir[0]);

						targetObject.SetYPos(targetObject.GetYPos() + nextDir[1]);

						

						House.s_LotSingleton.MoveObject(targetObject, oldX, oldY, false);

						targetObject.ResetEffect();

//START:debug print 4#

						//Debug.println("Routing object id " + targetObject.m_InstanceId + " to position: (" + targetObject.GetXPos() + ", " + targetObject.GetYPos() + ")", //Debug.CHAN_ROUTING_OBJECT);

//END

					}	

				}

				

				// All is good

				failed = false;

			}

			catch (Exception ex)

			{

				// Will throw if no next direction -- failed path find

				//Debug.println(ex.getMessage(), //Debug.CHAN_PATHFINDING);

				failed = true;

			}

		}



		return !failed;

		

	} // end UpdateWorldPosRoute	

	

	/**

	 * Turn this EdithObject to face another by a maximum of ninety degrees, 

	 * reverse the facing if needed.

	 * 

	 * @param Primitive primitive

	 * @param int targetX

	 * @param int targetY

	 * @param boolean faceOpposite

	 * @return true if a turn was made, false if this EdithObject was already facing eObject

	 */

	private boolean GetFacing(EdithObject targetObject, int targetX, int targetY, boolean faceOpposite)

	{

		int	destOrientation;

		int	dx = targetX - targetObject.GetXPos();

		int	dy = targetY - targetObject.GetYPos();

		

		// Determine which direction the object lies in

		if (dx > dy)

		{

			destOrientation = (dx > -dy) ?  Facing.SE : Facing.NE;

		}

		else

		{

			destOrientation = (dx > -dy) ?  Facing.SW : Facing.NW;

		}

		

		// reverse the direction if needed

		if (faceOpposite)

		{

			switch (destOrientation)

			{

			case Facing.NE:

				destOrientation = Facing.SW;

				break;

				

			case Facing.SE:

				destOrientation = Facing.NW;

				break;

				

			case Facing.SW:

				destOrientation = Facing.NE;

				break;

				

			case Facing.NW:

				destOrientation = Facing.SE;

				break;

			}

		}

		

		return GetFacing(targetObject, destOrientation);

		

	} // end GetFacing

	

	private boolean GetFacing(EdithObject targetObject, int destOrientation)

	{		

		// If we not facing the correct way, keep turning

		if (targetObject.GetFacing() != destOrientation)

		{

			// Rotate to target position

			// (makes assumptions about orientation values)

			if (((destOrientation - targetObject.GetFacing() + Facing.NUM_DIRECTIONS) % Facing.NUM_DIRECTIONS) == 1)

			{

				// Clockwise

				targetObject.SetFacing(targetObject.GetFacing() + 1);

			}

			else

			{

				// Anti-clockwise

				targetObject.SetFacing(targetObject.GetFacing() + (Facing.NUM_DIRECTIONS - 1));

			}

			

			//targetObject.SetFacing(targetObject.GetFacing() % Facing.NUM_DIRECTIONS);

			

			// Re-assess if we've finished rotating	

			return targetObject.GetFacing() != destOrientation;

		}

		

		return false;

	} // end GetFacing



	private final void DrawSkillIcon(int x, int y, final Graphics g)

	{

		int iconWidth = 32;

		int iconHeight = 19;

		

		// Set the rough position.

		x -= iconWidth/2;

		y -= iconHeight/2;

		

		// Store old clip area.

		int[] oldClip = Utility.GetClipArray(g);

		

		// Set clip area on graphics context.

		g.setClip(x, y, iconWidth, iconHeight);

		

		// Draw contents.

		g.drawImage(m_SkillsIcon, x, y - m_effectType*iconHeight, Graphics.TOP | Graphics.LEFT);

		

		// Restore old clip area.

		g.setClip(oldClip[0], oldClip[1], oldClip[2], oldClip[3]);

	}

	

	private final void DrawPlumbBob(int x, int y, final Graphics g)

	{

		int frames = SimsApp.s_MIDlet.m_SkillBarSpriteFrames;

		if(frames < 0)

			g.drawImage(m_PlumbBob, x, y, Graphics.TOP | Graphics.LEFT);

	}

	

	/**

	 * Draws a gain with required strength

	 * 

	 * @param x	X position at centre of gain

	 * @param y	Y position at bottom of gain

	 * @param g	Graphics context to draw to

	 */

	private final void DrawThoughtGain(int x, int y, final Graphics g)

	{

//		// Do the old routine.

//		if (m_effectType < GAIN_TYPE_OLD_END)

//		{

//			DrawThoughtGainOld(x, y, g);

//			return;

//		}

		

		// Use the new image strip.

		int iconWidth = 32;

		int iconHeight = 16;

		

		// Set the rough position.

		x -= iconWidth/2;

		y -= iconHeight/2;

		

		// Store old clip area.

		int[] oldClip = Utility.GetClipArray(g);

		

		// Set clip area on graphics context.

		g.setClip(x, y, iconWidth, iconHeight);

		

		// Draw contents.

		g.drawImage(m_NeedIconsPlus, x, y - m_effectType*iconHeight, Graphics.TOP | Graphics.LEFT);

		

		// Restore old clip area.

		g.setClip(oldClip[0], oldClip[1], oldClip[2], oldClip[3]);

	}

	

	/**

	 * Draws a fail with required strength

	 * 

	 * @param x	X position at centre of gain

	 * @param y	Y position at bottom of gain

	 * @param g	Graphics context to draw to

	 */

	private final void DrawThoughtFail(int x, int y, final Graphics g)

	{

//		// Do the old routine.

//		if (m_effectType < GAIN_TYPE_OLD_END)

//		{

//			DrawThoughtGainOld(x, y, g);

//			return;

//		}

		

		// Use the new image strip.

		int iconWidth = 32;

		int iconHeight = 16;

		

		// Set the rough position.

		x -= iconWidth/2;

		y -= iconHeight/2;

		

		// Store old clip area.

		int[] oldClip = Utility.GetClipArray(g);

		

		// Set clip area on graphics context.

		g.setClip(x, y, iconWidth, iconHeight);

		

		// Draw contents.

		g.drawImage(m_NeedIconsMinus, x, y - m_effectType*iconHeight, Graphics.TOP | Graphics.LEFT);

		

		// Restore old clip area.

		g.setClip(oldClip[0], oldClip[1], oldClip[2], oldClip[3]);

	}

	

//	private final void DrawThoughtGainOld(final int x, int y, final Graphics g)

//	{

//		// error checking

//		//Debug.assertPrintln(m_GainImages[m_effectType] != null, "invalid need gain image, Sim Object GUID: " + m_GuId);

//		

//		// Draw image

//		g.drawImage(m_GainImages[m_effectType], x, y, Graphics.TOP | Graphics.LEFT);

//		

//	} // end DrawThoughtGain

	

	public boolean IsPlayer()

	{

		return m_IsPlayer;

	}

	

	

	/** Name of file containing animations list */

	public static final String ANIMATIONS_LIST_FILE_NAME 	= "/anims.xml";

	

	/** The action tree used by the Sims to get to a point on the map using the stack for positioning */

	public static final int WALK_TO_TREE_ID					= 4110;

	public static final int WALK_TO_NEED_CHANGE_TREE_ID		= 4111;		// probably don't need this

	

	/** need defines */

	public static final int MAX_NEED_VALUE					= 16384;

	

	/** need defines */

	public static final int SKILL_STEPS						= 5;

	public static final int SKILL_STEP_VALUE				= MAX_NEED_VALUE/SKILL_STEPS;

	

	public static final int PLUMBOB_DECAY_RATE				= -820;

	public static final int SIMQ_INCREASE_RATE				= 410;

	

	/** Different types of gains to have */

	public static final int GAIN_TYPE_DOUBLE_PLUS 			= 0;

	public static final int GAIN_TYPE_DOUBLE_MINUS 			= 1;

	public static final int GAIN_TYPE_OLD_END				= 2;

	

	public static final int GAIN_TYPE_NEED_BLADDER 			= GAIN_TYPE_OLD_END;

	public static final int GAIN_TYPE_NEED_HUNGER 			= 3;

	public static final int GAIN_TYPE_NEED_ENVIRONMENT 		= 4;

	public static final int GAIN_TYPE_NEED_FUN 				= 5;

	public static final int GAIN_TYPE_NEED_HYGIENE 			= 6;

	public static final int GAIN_TYPE_NEED_SOCIAL 			= 7;

	public static final int GAIN_TYPE_NEED_COMFORT 			= 8;

	

	public static final int GAIN_NUMBER_OF_TYPES 			= 9;



	/** How long a thought lasts for (milliseconds) */

	public static final int THOUGHT_DURATION = 3000;

	

	/** X offset to draw thought contents at from bubble */

	public static final int BUBBLE_CONTENTS_OFFSET_X = -1;

	

	/** Y offset to draw thought contents at from bubble */

	public static final int BUBBLE_CONTENTS_OFFSET_Y = -1;

	

	public static final int GAIN_THOUGHT_X_OFFSET = -10;

	public static final int THOUGHT_Y_OFFSET = 5;

	

	/** How long it takes to walk from one square to another */

	public static final int WALK_DELAY = 500;

	

	public static final String[] orientationSuffixes = {"NW","NE","SE","SW"};

	

	// Enumerate all animations

	public static final int ANIM_ID_INVALID				= -1;

	public static final int ANIM_ID_SIT_DOWN			= 0;

	public static final int ANIM_ID_STAND_UP			= 1;

	public static final int ANIM_ID_SWITCH				= 2;

	public static final int ANIM_ID_WAVE				= 3;

	public static final int ANIM_ID_DANCE				= 4;

	public static final int ANIM_ID_WALK				= 5;

	public static final int ANIM_ID_STAND				= 6;

	public static final int ANIM_ID_IDLE				= 7;

//	private static final int ANIM_ID_ADMIRE				= 8;

	public static final int ANIM_ID_LAY_DOWN			= 9;

	public static final int ANIM_ID_LAY_DOWN_TO_STAND	= 10;

	public static final int LAST_ANIM_ID				= ANIM_ID_LAY_DOWN_TO_STAND;

	public static final int NUM_ANIM_IDS				= (LAST_ANIM_ID + 1);

	

	public static final int	ACTION_INVALID				= -1;

	public static final int	ACTION_ROUTE_TO_LOCATION	= 0;

	public static final int	ACTION_ROUTE_TO_OBJECT		= 1;

	public static final int	ACTION_TURN_TO_OBJECT		= 2;

	public static final int	ACTION_USE_OBJECT			= 3;

	public static final int	ACTION_SOCIALIZE			= 4;

	public static final int	ACTION_NPC_LEAVE			= 5;

	public static final int	ACTION_SET_FACING			= 6;

	

	

	/** private defines */	

//	private static final int	NUM_THOUGHT_TYPES 			= 16;

	

	/** public variables */

	public boolean          m_IsPlayer;

//	public boolean 			isMoving;

	public int 				socialStat;

	

	/** Store an Icons for main aspiration and astrological sign */

	public Image			m_AspirationIcon;

	public Image			m_AstrologicalIcon;

	public int				m_AspirationPointsReq;

	public String			m_AstrologicalSign;

	

	public static int		m_NeedsAverage;

	

	// Additional routing variables for 250K

	private int				m_CurrentAction;

	private int				m_ActionInitFlags;

	private int				m_WorldX;

	private int				m_WorldY;

	private int				m_TargetOrientation;

	private EdithObject		m_TargetObject;

	private Vector			m_ActionQueue;

	

	private boolean			m_FaceObject;

	private boolean			m_StopOnNextTile = false;

	private boolean			m_DirectControl = false;

	private byte	 		m_effectBubbleGainSkill;	/** Chooses whether the current effect is a bubble, gain or skill */

	private long 			m_effectTime;				/** Used to determine when an effect finishes */

	private long 			m_effectMillisLastTick;		/** The time stamp during the last tick of an effect */

	private int 			m_effectType;				/** Type of effect currently being had */

	private int 			m_progressIntoNextTileFp;	/** Fixed point representation of distance into the tile that we are facing */

//	private int				m_plumBob;					/** Aspiration Meter */	

	private int				m_newX;

	private int				m_newY;					



	private boolean 		m_IsWalking = false;		/** True if walking */

	

}

