package sims2;

//package root;

import java.io.DataInputStream;
import java.io.IOException;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.CommandListener;

//import com.ideaworks3d.debug.Debug;

public class SimsCanvas extends GameCanvas

//#ifdef SPRINT_DEBUG
//# implements CommandListener
//#endif
{
	/**
	 * Canvas constructor
	 *
	 */
	public SimsCanvas()
	{
		super(false);

		//#ifndef SPRINT_DEBUG
		setFullScreenMode(true);
		//#endif

		m_KeyStateHistory = new int[NUM_KEY_HISTORY_LVLS];


		//#ifdef LARGE_SCREEN
//# 		try{
//# 			bgImage = Image.createImage("/splashscreens/bg.png");
//# 		}catch(Exception e){
			//#ifdef DEBUG
//# 			e.printStackTrace();
			//#endif
//# 		}
		//#endif

		//#ifdef SPRINT_DEBUG
//# 		setCommandListener(this);
//# 		addCommand( c1 );
//# 		addCommand( c2 );
		//#endif


	} // end SimsCanvas constructor


	//This is only in the debug version to give soft key functionality to the emulator
	//Otherwise the normal keypresses work fine on the phones

	//#ifdef SPRINT_DEBUG
//# 	Command c2 = new  Command( "c2", Command.OK, 1  );
//# 	Command c1 = new  Command( "c1", Command.BACK, 0  );
//# 
//# 	public void commandAction(Command c, Displayable d){
//# 		if( c == c1 ){
//# 			keyPressed( -6 );
//# 			keyReleased( -6 );
//# 		}
//# 		if( c == c2 ){
//# 			keyPressed( -7 );
//# 			keyReleased( -7 );
//# 		}
//# 	}
	//#endif

	public void InitPanels()
	{
		// Load the panels.
		m_NeedsPanel = Utility.loadImage("panels/NeedsPanel_BG", true);
		m_SkillsPanel = Utility.loadImage("panels/SkillsPanel_BG", true);
		m_SoftkeyPanel = Utility.loadImage("panels/softkey_panel", true);

		// Load the bars strip.
		m_NeedsBars = Utility.loadImage("panels/Needs_bars_ALL", true);

		// Load the beads strip.
		m_SkillsBeads = Utility.loadImage("panels/Skills_Bead_all", true);

		// Load the gauge strip.
		m_SkillsGauge = Utility.loadImage("panels/Skill_Gauge_strip", true);

		// Load the phone strip.
		m_PhoneSprites = Utility.loadImage("in_game_menus/phone", true);

		// Set the variables.
		m_NeedPanelUp = true;
		need_pos = m_NeedsPanel.getHeight();
	}

	/**
	 * Clears the screen
	 * @param g Current graphics object
	 */
	public void clearScreen(Graphics g)
	{
		// TODO: Move this color to Colors.java as a define!
		g.setColor(0x9999cc);
		g.fillRect(0, 0, SKUConsts.SCREEN_WIDTH, SKUConsts.SCREEN_HEIGHT);

	} // end clearScreen

	/**
	 * Mark end of current key press cycle.
	 * Shuffles the next set of key presses in the history.
	 * Needed to be called once per game loop.
	 */
	public void updateKeyState(boolean blankCurrentState)
	{
		// Shuffle down one level
		for (int historyLevel = 0; historyLevel < (NUM_KEY_HISTORY_LVLS - 1); historyLevel++)
		{
			m_KeyStateHistory[historyLevel] = m_KeyStateHistory[historyLevel + 1];
		}

		if (blankCurrentState)
		{
			m_KeyStateHistory[NUM_KEY_HISTORY_LVLS - 1] = 0;
		}

		// Keep current level intact
		m_KeyPressedState = 0;
		m_KeyReleasedState = 0;

	} // end updateKeyState

	/**
	 * Checks the state of the given action from the history
	 * @param Game action to check for status (UP, DOWN, LEFT, RIGHT, GAME_A, GAME_B, ...)
	 * @return Either NONE, PRESSED, RELEASED or HELD
	 */
	public int getActionState(final int checkAction)
	{
		boolean currentState;
		boolean previousState;
		int result;

		/**
		 * Hack so that we don't loose UP/DOWN events that happen in the same
		 * frame.  This means that we can potentially loose RELEASE events.
		 * Anyone who needs RELEASE events rather than HELD status should would
		 * need to fix this.
		 */
		if ((m_KeyPressedState & m_KeyReleasedState & checkAction) != 0)
		{
			////Debug.println("key pressed and released in the same frame", //Debug.CHAN_CORE);
			return PRESSED;
		}

		// Get current state
		currentState = (m_KeyStateHistory[KEY_HISTORY_LVL_1] & checkAction) != 0;

		// Get previous state
		previousState = (m_KeyStateHistory[KEY_HISTORY_LVL_2] & checkAction) != 0;

		// Map to integer state
		if (previousState)
		{
			result = currentState ? HELD : RELEASED;
		}
		else	// !previousState
		{
			result = currentState ? PRESSED : NONE;
		}

		return result;

	} // end getActionState

	/**
	 * Map Canvas definition of action code to this Class' definition of action codes
	 */
	public int getGameAction(final int keyCode)
	{
		int actionCode;

		// it is possible that the key code needs to be defined to an action
		// so if the actionCode found was 0, try our other special key defines
		// TODO:  This is currently only set up for Nokia phones
//START:IGNORE:getGameAction#
		switch (keyCode)
		{
		case UP_BUTTON:
		case Canvas.KEY_NUM2:
			actionCode = UP;
			break;

		case DOWN_BUTTON:
		case Canvas.KEY_NUM8:
			actionCode = DOWN;
			break;

		case LEFT_BUTTON:
		case Canvas.KEY_NUM4:
			actionCode = LEFT;
			break;

		case RIGHT_BUTTON:
		case Canvas.KEY_NUM6:
			actionCode = RIGHT;
			break;

		case Canvas.KEY_NUM1:
			actionCode = GAME_A;
			break;

		case Canvas.KEY_NUM3:
			actionCode = GAME_B;
			break;

		case Canvas.KEY_NUM7:
			actionCode = GAME_C;
			break;

		case Canvas.KEY_NUM9:
			actionCode = GAME_D;
			break;

		case Canvas.KEY_NUM5:
			actionCode = FIRE;
			break;

		case ACCEPT_BUTTON:
			actionCode = ACCEPT;
			break;

		case BACK_BUTTON:
			actionCode = BACK;
			break;

		case Canvas.KEY_NUM0:
			actionCode = KEY_NUM0;
			break;

		case Canvas.KEY_POUND:
			actionCode = KEY_POUND;
			break;

		case Canvas.KEY_STAR:
			actionCode = KEY_STAR;
			break;

		default:
			// Not defined -- return 0
			actionCode = 0;
			break;
		}

		if (actionCode == 0)
		{
			// Get the actual pressed action code
			actionCode = super.getGameAction(keyCode);

			// Convert it to our idea of an action code
			switch (actionCode)
			{
			case Canvas.UP:
				actionCode = UP;
				break;

			case Canvas.DOWN:
				actionCode = DOWN;
				break;

			case Canvas.LEFT:
				actionCode = LEFT;
				break;

			case Canvas.RIGHT:
				actionCode = RIGHT;
				break;

			case Canvas.GAME_A:
				actionCode = GAME_A;
				break;

			case Canvas.GAME_B:
				actionCode = GAME_B;
				break;

			case Canvas.GAME_C:
				actionCode = GAME_C;
				break;

			case Canvas.GAME_D:
				actionCode = GAME_D;
				break;

			case Canvas.FIRE:
				actionCode = FIRE;
				break;

			default:
				// Not defined -- return 0
				actionCode = 0;
				break;
			}
		}
//END
		return actionCode;

	} // end getGameAction

	/**
	 * Gets whether the given key has been pressed or not in the last tick
	 *
	 * @param key
	 * @return
	 */
	public boolean getKeyPressed(int key)
	{
		return getActionState(key) == SimsCanvas.PRESSED;

	} // end getKeyPressed

	/**
	 * Loads the string table into memory
	 *
	 */
	public void loadStringTable()
	{
		String language = "";
/*		try
		{*/
			language = getLanguage();
			DataInputStream dis = null;
			try
			{
				dis = new DataInputStream(getClass().getResourceAsStream("/sims2" + "/" + language + "_s"));
				m_StringTable = new byte[dis.readShort()][];

				for(int i = 0; i < m_StringTable.length; i++)
				{
					m_StringTable[i] = dis.readUTF().getBytes();
				}

				dis.close();			}
			catch(Exception e)
			{
				System.out.println("Exception here :" + e);
			}

/*		}
		catch (IOException e)
		{
			if (GameDefines.DEBUG)
			{
				e.printStackTrace();
			}
		}*/

	} // end loadStringTable

    private static String lang;
    public static String sFreeTrial = null;
    
    public static void setLanguage(String lang) {
        SimsCanvas.lang = lang;
        
        if ("en".equals(lang)) {
            SimsCanvas.sFreeTrial = "FREE TRIAL";
        }
        else if ("fr".equals(lang)) {
            SimsCanvas.sFreeTrial = "D\u00c9MO GRATUITE";
        }
        else if ("it".equals(lang)) {
            SimsCanvas.sFreeTrial = "PROVA GRATUITA";
        }
        else if ("de".equals(lang)) {
            SimsCanvas.sFreeTrial = "FREIE TESTVERSION";
        }
        else if ("es".equals(lang)) {
            SimsCanvas.sFreeTrial = "DEMO GRATIS";
        }
    }
    
	/**
	* Gets the phone OS language or if the
	* language which is overridden using Force-Locale attribute
	*
	*/
	//public static String debugLanguage;
	public String getLanguage()
	{
        return SimsCanvas.lang;
        //
		//String lang = "en";
		//
		//try
		//{
		//	
		//	//String locale = System.getProperty("microedition.locale");
		//	//debugLanguage = new String(locale);
		//	String override = SimsApp.s_MIDlet.getAppProperty("Force-Locale");
		//	
	    //
		//	if ((override != null) && (override.length() > 1)) {
		//		lang = override;
		//	}
	    //
		//	/*if ((locale == null) || (locale.length() < 2)) {
		//		locale = "en";
		//	}*/
		//	lang = lang.substring(0,2);
		//	
		//}
		//catch( Exception e)
		//{
		//	lang = "en";
		//}
        //
		//return lang;

	}

	/**
	 * Gets the string from the string table using the given id
	 *
	 * @param id
	 * @return
	 */
	public String getStringById(int id)
	{
		String retVal = new String(m_StringTable[id]);
        if (id == StringId.TITLE_LEGAL_TEXT) {
            retVal = replace(retVal, "2006", "2007");
        }
        else if (id == StringId.ABOUT_EMAIL) {
            retVal = replace(retVal, "www.ea.com", "help@eamobile.com");
        }
        return retVal;

	} // end getStringById
    
    
    public static String replace(String str, String target, String replacement) {
        while (true) {
            int index = str.indexOf(target);
            if (index == -1) {
                return str;
            }
            
            str = str.substring(0, index) + replacement + str.substring(index + target.length());
        }
    }

	/**
	 * Paint method for drawing the canvas
	 *
	 */
//	//#ifdef LARGE_SCREEN
//	private Image bgImage = null;
//	//#endif

	//#ifdef LOADING_TEXT
	public String sLoading = null;
	//#endif
	//#ifdef DOUBLE_BUFFER
//# 	private Image backBuffer = null;
	//#endif

	public synchronized void paint(Graphics g)
	{
        g.setClip(0, 0, SKUConsts.SCREEN_WIDTH, SKUConsts.SCREEN_HEIGHT);

		//#ifdef DOUBLE_BUFFER
//# 		Graphics k = g;
//# 		if( backBuffer == null )
//# 			backBuffer = Image.createImage( getWidth(), getHeight() );
//# 		g = backBuffer.getGraphics();
		//#endif

		try
		{
//			//#ifdef LARGE_SCREEN
//			//put in a bg wallpaper
//			//This code isn't
//			if ( (SimsApp.s_MIDlet.m_CurrGameState == GameDefines.GAME_MODE_INITIALIZE_APP) ||
//					 (SimsApp.s_MIDlet.m_CurrGameState == GameDefines.GAME_MODE_LOGO_WAIT) )
//			{
//				g.setColor( 0xFFFFFF );
//				g.fillRect( 0, 0, getWidth(), getHeight() );
//			}else{
//				g.drawImage( bgImage, 0, 0, 0 );
//			}
//
//
//			//fill the rest of the space with a sort of soft bar
//			g.setColor( 0x54578E );
//			g.fillRect( 0, getHeight() - 10, getWidth(), 10 );
//
//			g.translate( (getWidth()- SKUConsts.SCREEN_WIDTH) / 2, (getHeight() - SKUConsts.SCREEN_HEIGHT) / 2 );
//			#elifdef LARGE
//			#else


			//#ifndef LARGE
//# 			//fill the rest of the space with a sort of soft bar
//# 			g.setColor( 0x54578E );
//# 			g.fillRect( 0, 208, getWidth(), getHeight() );
			//#endif

			if (m_IsInitialised)
			{
				// Since there is logic processing here it makes it impossible
				// to run the main loop and paint asynchronously.  This flag
				// prevents illegal processing and hence preserves stability.

				// This is currently essential to respect the input system since
				// input can only be read once per frame (by design).

				/* The logic has now been removed.
				 * Do not add any more logic to this function.
				 */

				// if the game mode isn't run or dialog, then draw the splash screen if there is one
				if ( (SimsApp.s_CurrBG != null) &&
					 (SimsApp.s_MIDlet.m_CurrGameState != GameDefines.GAME_MODE_RUN_GAME) &&
					 (SimsApp.s_MIDlet.m_CurrGameState != GameDefines.GAME_MODE_INITIALIZE_APP) &&
					 (SimsApp.s_MIDlet.m_CurrGameState != GameDefines.GAME_MODE_OBJECT_DIALOG) )
				{
					g.drawImage(SimsApp.s_CurrBG, 0, 0, (Graphics.TOP | Graphics.LEFT) );
				}

				switch (SimsApp.s_MIDlet.m_CurrGameState)
				{
				case GameDefines.GAME_MODE_SELECT_A_SIM:
					if (SimsApp.s_MIDlet.m_PlayerSim != null)
					{
						SimsApp.s_MIDlet.m_PlayerSim.DrawBillboard(g, GameDefines.SIM_SELECT_SPRITE_X_POS,
										GameDefines.SIM_SELECT_SPRITE_Y_POS);
					}

					g.drawImage(SimsApp.s_RoommateSpriteIcons[0], SimsApp.s_RoommateSpritePos[0][0],
									SimsApp.s_RoommateSpritePos[0][1], (Graphics.TOP | Graphics.LEFT) );

					g.drawImage(SimsApp.s_FriendshipSpriteIcons[0], SimsApp.s_FriendshipSpritePos[0][0],
									SimsApp.s_FriendshipSpritePos[0][1], (Graphics.TOP | Graphics.LEFT) );

					// fall through for the the dialog update
				case GameDefines.GAME_MODE_START_MENU:
				case GameDefines.GAME_MODE_INTRODUCTION:
				case GameDefines.GAME_MODE_DEMOOVER:
				//#ifdef ENABLE_VODAFONE_DEMO
 				case GameDefines.GAME_MODE_DEMO_SPLASH:
 				case GameDefines.GAME_MODE_VODAFONE_DEMOOVER:
 				case GameDefines.GAME_MODE_DEMO_PAUSE_MENU:
				//#endif
					Dialogue.PaintStaticDialogue(g);
					break;

				case GameDefines.GAME_MODE_SOCIAL_MENU:
				case GameDefines.GAME_MODE_CUTSCENE:
				case GameDefines.GAME_MODE_PAUSE_MENU:
					if (SimsApp.s_GeneralSpriteImage != null)
					{
						g.drawImage(SimsApp.s_GeneralSpriteImage, SimsApp.s_GeneralSpriteXPos,
										SimsApp.s_GeneralSpriteYPos, (Graphics.TOP | Graphics.LEFT) );
					}

					for (int i = 0; i < WorldData.NUM_NPCS; i++)
					{
						if (SimsApp.s_RoommateSpriteIcons[i] != null)
						{
							g.drawImage(SimsApp.s_RoommateSpriteIcons[i], SimsApp.s_RoommateSpritePos[i][0],
											SimsApp.s_RoommateSpritePos[i][1], (Graphics.TOP | Graphics.LEFT) );
						}

						if (SimsApp.s_FriendshipSpriteIcons[i] != null)
						{
							g.drawImage(SimsApp.s_FriendshipSpriteIcons[i], SimsApp.s_FriendshipSpritePos[i][0],
											SimsApp.s_FriendshipSpritePos[i][1], (Graphics.TOP | Graphics.LEFT) );
						}
					}

					if ( (SimsApp.s_MIDlet.m_CurrGameState == GameDefines.GAME_MODE_SOCIAL_MENU) ||
						 (SimsApp.s_MIDlet.m_CurrGameState == GameDefines.GAME_MODE_CUTSCENE) )
					{
						SimsApp.s_MIDlet.m_PlayerSim.DrawBillboard(g, GameDefines.PLAYER_SPRITE_X_OFFSET,
										GameDefines.SPRITE_Y_OFFSET);
						SimsApp.s_MIDlet.m_CurrentObject.DrawBillboard(g, GameDefines.NPC_SPRITE_X_OFFSET,
										GameDefines.SPRITE_Y_OFFSET);
					}

					Dialogue.PaintStaticDialogue(g);
					break;

				case GameDefines.GAME_MODE_RUN_GAME:
				case GameDefines.GAME_MODE_OBJECT_DIALOG:
					House.s_LotSingleton.Draw(g);

					// Draw the ui panels
					SimsCanvas.s_Canvas.DrawPanels(g);

					// Draw tool tip
					House.s_LotSingleton.DrawToolTip(g);

					Dialogue.PaintStaticDialogue(g);

					// draw the simolean display if it isn't flashing off
					if ( (SimsApp.s_MIDlet.m_GameFlags & GameDefines.GAME_FLAG_MASK_SHOW_SIMOLEANS) != 0)
					{
						Utility.PaintSimoleansValue(g, SimsApp.s_MIDlet.m_Simoleans,
										(SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET),
										GameDefines.SIMOLEANS_Y_OFFSET, Style.DIALOGUE_MAIN_TEXT_COLOR,
										(Graphics.BOTTOM | Graphics.RIGHT) );
					}

					break;

				case GameDefines.GAME_MODE_INVALID:
				case GameDefines.GAME_MODE_INITIALIZE_APP:
				case GameDefines.GAME_MODE_LOGO_WAIT:
				case GameDefines.GAME_MODE_INITIALIZE_START_MENU:
				case GameDefines.GAME_MODE_INITIALIZE_INTRODUCTION:
				case GameDefines.GAME_MODE_INITIALIZE_SELECT_A_SIM:
				case GameDefines.GAME_MODE_INITIALIZE_GAME:
				case GameDefines.GAME_MODE_PAUSE_APP:
				default:
					break;
				}

				// if the game is in a paused state, only draw the paused text
				if (SimsApp.s_MIDlet.m_CurrGameState == GameDefines.GAME_MODE_PAUSE_APP)
				{
					if (SimsApp.s_MIDlet.m_Dialogs[GameDefines.DIALOG_ID_RESERVED_0] != null)
					{
						SimsApp.s_MIDlet.m_Dialogs[GameDefines.DIALOG_ID_RESERVED_0].Paint(g);
					}

					if (SimsApp.s_MIDlet.m_Dialogs[GameDefines.DIALOG_ID_RESERVED_1] != null)
					{
						SimsApp.s_MIDlet.m_Dialogs[GameDefines.DIALOG_ID_RESERVED_1].Paint(g);
					}
				}
				else
				{
					for (int i = 0; i < GameDefines.NUM_DIALOG_IDS; i++)
					{
						if (SimsApp.s_MIDlet.m_Dialogs[i] != null)
						{
							SimsApp.s_MIDlet.m_Dialogs[i].Paint(g);
						}
					}
				}

				//#ifdef DEBUG
//# 				if (GameDefines.DEBUG_LOG)
//# 				{
//# 					//Debug.drawScreenLog(g, 0, 0, 176, 208);
//# 				}
				//#endif
			}
		}
		catch (Exception e)
		{
			if (GameDefines.DEBUG)
			{
				e.printStackTrace();
			}
		}
		g.translate( g.getTranslateX(), g.getTranslateY() );


		//#ifdef LOADING_TEXT
		//if( sLoading != null ){
		//	if( g.getFont() == null )
		//		g.setFont( Dialogue.FONT_PROP_MEDIUM );
		//	g.setColor( 0x8A94CA );
		//	g.drawString( sLoading, getWidth()/2, getHeight()/2, Graphics.TOP | Graphics.HCENTER );
		//}
		
		
	/*	if( g.getFont() == null ) 
		
			g.setFont( Dialogue.FONT_PROP_MEDIUM );
			g.setColor( 0x8A94CA );
			g.drawString( "WorldObjects: " + House.staticWorldObjects, getWidth()/2, getHeight()/2 + 30, Graphics.TOP | Graphics.HCENTER );
			g.drawString( "MapObjects: " + House.staticMapObjects, getWidth()/2, getHeight()/2 + 60, Graphics.TOP | Graphics.HCENTER );
			g.drawString( "tryedAdd: " + House.tryedAdd, getWidth()/2, getHeight()/2 + 90, Graphics.TOP | Graphics.HCENTER );
		*/
		//#endif


		//#ifdef MEM_MONITOR
//# 		g.setColor(0x000000);
//# 		Runtime runtime = Runtime.getRuntime();
//# 		g.setClip( 0, 0, getWidth(), getHeight() );
//# 		g.fillRect( 8, 25, Dialogue.FONT_PROP_SMALL.stringWidth("mem: "+(runtime.freeMemory()/1000)+"kb / "+(runtime.totalMemory()/1000)+"kb")+2, Dialogue.FONT_PROP_SMALL.getHeight()+2 );
//# 
//# 		g.setColor(0xFFFF00);
//# 		g.drawString("mem: "+(runtime.freeMemory()/1000)+"kb / "+(runtime.totalMemory()/1000)+"kb", 10, 27, g.TOP | g.LEFT );
		//#endif


		//flip buffers

		//#ifdef DOUBLE_BUFFER
//# 		g = k;
//# 		g.drawImage( backBuffer, 0, 0, 0 );
		//#endif

	} // end Paint

	/**
	 * Get and store any key presses
	 */
	protected void keyPressed(int keyCode)
	{
		//System.out.println("keyCode "+keyCode);

		//#ifdef NEXTEL_KEYS
//# 		if( keyCode == -20 )
//# 			keyCode = -6;
//# 		if( keyCode == -21 )
//# 			keyCode = -7;
//# 		if( keyCode == -23 )
//# 			keyCode = 53;
		//#endif


		int actionCode = getGameAction(keyCode);

		m_KeyPressedState |= actionCode;
		m_KeyStateHistory[KEY_HISTORY_LVL_0] |= actionCode;
		return;

	} // end keyPressed

	/**
	 * clear any key presses if they are released
	 */
	protected void keyReleased(int keyCode)
	{

		//#ifdef NEXTEL_KEYS
//# 		if( keyCode == -20 )
//# 			keyCode = -6;
//# 		if( keyCode == -21 )
//# 			keyCode = -7;
//# 		if( keyCode == -23 )
//# 			keyCode = 53;
		//#endif


		// Remove from current history
		////Debug.println("key released: " + keyCode + " [" + m_MillisThisSecond + "]", //Debug.CHAN_CORE);
		int actionCode = getGameAction(keyCode);

		m_KeyReleasedState |= actionCode;
		m_KeyStateHistory[KEY_HISTORY_LVL_0] &= ~actionCode;

	} // end keyReleased

	/**
	 *  Resumes after an interrupt
	 *
	 */
	protected void showNotify()
	{
	//	SimsApp.s_MIDlet.SetPausedState(false);
		SimsApp.s_MIDlet.bypassStartApp();
	} // end showNotify

	/**
	 *  Pauses for an interrupt
	 *
	 */
	public boolean bNoPause = false;
	protected void hideNotify()
	{
		updateKeyState(true);
	//	if( bNoPause != true ){
	//	if( SimsApp.s_MIDlet.m_CurrGameState != GameDefines.GAME_MODE_EXTERNAL )
	//		SimsApp.s_MIDlet.SetPausedState(true);
		//#ifdef ENABLE_GAMELOBBY
//# 		else
//# 			SimsApp.s_MIDlet.returnFromGamelobby();
		//#endif
	//	}else{
	//		bNoPause = false;
	//	}
		if( SimsApp.s_MIDlet.m_CurrGameState != GameDefines.GAME_MODE_EXTERNAL )
				SimsApp.s_MIDlet.SetPausedState(true);
	} // end hideNotify

	public void CyclePanels()
	{
		m_NeedPanelUp = !m_NeedPanelUp;
	}

	public void DrawPanels(Graphics g)
	{
		UpdatePositions();

		DrawSkillsBar(g);

		if(m_NeedPanelUp)
		{
			DrawNeedsPanel(g);
			DrawSkillsPanel(g);
		}
		else
		{
			DrawSkillsPanel(g);
			DrawNeedsPanel(g);
		}

		DrawSoftKeyPanel(g);
	}

	private void DrawNeedsPanel(Graphics g)
		{
			int offSet = SimsCanvas.s_Canvas.getHeight() - SKUConsts.SCREEN_HEIGHT;
			//#ifdef LARGE_SCREEN
//# 			offSet -= (getHeight() - SKUConsts.SCREEN_HEIGHT) / 2;
			//#endif
			if( offSet < 0 ) offSet = 0;

			int x = 0;
			int y = SKUConsts.SCREEN_HEIGHT+m_NeedsPanel.getHeight()-need_pos-m_SoftkeyPanel.getHeight() + offSet;

			g.drawImage(
				m_NeedsPanel,
				x,
				y,
				Graphics.BOTTOM | Graphics.LEFT );

			// Draw the needs bars in the appropriate locations.
			for(int i = SimAttributes.FIRST_NEED; i <= SimAttributes.LAST_NEED; ++i)
			{
				int need = SimsApp.s_MIDlet.GetNeedValue(i);
				// Round up!
				need = (need * 10 + SimAttributes.MAX_NEED_VALUE-1) / SimAttributes.MAX_NEED_VALUE;
				need--;

				if(need > 0 && need <= 10)
				{
					int iconWidth = 7;
					int iconHeight = 21;

					Image strip = m_NeedsBars;

					// Set the position.
					int X = x + m_NeedsBarPos[i][0];
					int Y = y - m_NeedsPanel.getHeight() + m_NeedsBarPos[i][1] - iconHeight;

					// Store old clip area.
					int[] oldClip = Utility.GetClipArray(g);

					// Set clip area on graphics context.
					g.setClip(X, Y, iconWidth, iconHeight);

					// Draw contents.
					g.drawImage(strip, X - need*iconWidth, Y, Graphics.TOP | Graphics.LEFT);

					// Restore old clip area.
					g.setClip(oldClip[0], oldClip[1], oldClip[2], oldClip[3]);

	//				g.drawImage(
	//					m_NeedsBars[need],
	//					x + m_NeedsBarPos[i][0],
	//					y - m_NeedsPanel.getHeight() + m_NeedsBarPos[i][1],
	//					Graphics.BOTTOM | Graphics.LEFT );
				}
			}
		}

	private void DrawSkillsBar(Graphics g)
		{
			int offSet = SimsCanvas.s_Canvas.getHeight() - SKUConsts.SCREEN_HEIGHT;
			//#ifdef LARGE_SCREEN
//# 			offSet -= (getHeight() - SKUConsts.SCREEN_HEIGHT) / 2;
			//#endif
			if( offSet < 0 ) offSet = 0;

			int frames = SimsApp.s_MIDlet.m_SkillBarSpriteFrames;
	//		int oldFrame = SimsApp.GetSimsApp().GetSkillBarSpriteFramesOld();

			SimObject player = SimsApp.s_MIDlet.m_PlayerSim;

			// Convert to world position
			int[] worldPos = Utility.GridToWorldCoords(player.GetXPos(), player.GetYPos());

			// Convert to screen position
			worldPos[0] -= House.s_LotSingleton.m_ScrollX;
			worldPos[1] -= House.s_LotSingleton.m_ScrollY;

			int[] pos = player.GetDrawOffset();

			int x = pos[0]+worldPos[0];
			int y = pos[1]+worldPos[1]-75 + offSet;

			if(frames >= 0)
			{
				// only draw the need bar if it is not empty
//				if (frames > 0)
				{
//					frames--;

					if(frames >= 0 && frames < 10)
					{
						int iconWidth = 4;
						int iconHeight = 11;

	//					y-=iconHeight;

						Image strip = m_SkillsGauge;

						// Store old clip area.
						int[] oldClip = Utility.GetClipArray(g);

						// Set clip area on graphics context.
						g.setClip(x, y, iconWidth, iconHeight);

						// Draw contents.
						g.drawImage(strip, x - frames*iconWidth, y, Graphics.TOP | Graphics.LEFT);

						// Restore old clip area.
						g.setClip(oldClip[0], oldClip[1], oldClip[2], oldClip[3]);

	//					g.drawImage(
	//						m_NeedsBars[frames],
	//						x,
	//						y,
	//						Graphics.BOTTOM | Graphics.LEFT );
					}
				}
			}
		}

	private void DrawSkillsPanel(Graphics g)
		{
			int offSet = SimsCanvas.s_Canvas.getHeight() - SKUConsts.SCREEN_HEIGHT;
			//#ifdef LARGE_SCREEN
//# 			offSet -= (getHeight() - SKUConsts.SCREEN_HEIGHT) / 2;
			//#endif
			if( offSet < 0 ) offSet = 0;

			int x = 0;
			int y = SKUConsts.SCREEN_HEIGHT+need_pos-m_SoftkeyPanel.getHeight() + offSet;

			g.drawImage(
				m_SkillsPanel,
				x,
				y,
				Graphics.BOTTOM | Graphics.LEFT );

			// Draw the skill bars in the appropriate locations.
			for(int i = SimAttributes.FIRST_SKILL; i <= SimAttributes.LAST_SKILL; ++i)
			{
				int skill = SimsApp.s_MIDlet.GetNumSkillPoints(i);
				skill--;

				if(skill >= 0 && skill < 5)
				{
					int iconWidth = 9;
					int iconHeight = 25;

					Image strip = m_SkillsBeads;

					// Set the position.
					int X = x + m_SkillsBarPos[i-SimAttributes.FIRST_SKILL][0];
					int Y = y - m_SkillsPanel.getHeight() + m_SkillsBarPos[i-SimAttributes.FIRST_SKILL][1] - iconHeight;

					// Store old clip area.
					int[] oldClip = Utility.GetClipArray(g);

					// Set clip area on graphics context.
					g.setClip(X, Y, iconWidth, iconHeight);

					// Draw contents.
					g.drawImage(strip, X - skill*iconWidth, Y, Graphics.TOP | Graphics.LEFT);

					// Restore old clip area.
					g.setClip(oldClip[0], oldClip[1], oldClip[2], oldClip[3]);

	//				g.drawImage(
	//					m_SkillsBars[skill],
	//					x + m_SkillsBarPos[i-SimAttributes.FIRST_SKILL][0],
	//					y - m_SkillsPanel.getHeight() + m_SkillsBarPos[i-SimAttributes.FIRST_SKILL][1],
	//					Graphics.BOTTOM | Graphics.LEFT );
				}
			}
		}

	private void DrawSoftKeyPanel(Graphics g)
	{

		int offSet = SimsCanvas.s_Canvas.getHeight() - SKUConsts.SCREEN_HEIGHT;
		//#ifdef LARGE_SCREEN
//# 		offSet -= (getHeight() - SKUConsts.SCREEN_HEIGHT) / 2;
		//#endif
		if( offSet < 0 ) offSet = 0;

		g.drawImage(
			m_SoftkeyPanel,
			0,
			SKUConsts.SCREEN_HEIGHT + offSet,
			Graphics.BOTTOM | Graphics.LEFT );

		// Add the phone sprite.
		int frame = SimsApp.s_MIDlet.m_PhoneSpriteFrame;

		// TODO: Remove magic numbers!
		int iconWidth = 18;
		int iconHeight = 10;

		int x = SKUConsts.SCREEN_WIDTH - iconWidth - 4;
		int y = SKUConsts.SCREEN_HEIGHT - iconHeight + offSet;

		Image strip = m_PhoneSprites;

		// Store old clip area.
		int[] oldClip = Utility.GetClipArray(g);

		// Set clip area on graphics context.

		

		// Draw contents.
		if (shell.Build.VODAFONE) {
			// "Menu" instead of phone icon
			//g.setClip(x-25, y - 4, 45, iconHeight+3);
			String text = SimsCanvas.s_Canvas.getStringById(StringId.DEMO_MENU);
            g.setFont(Dialogue.FONT_PROP_SMALL);
					
            g.setColor(Colors.BLACK);
            g.drawString(text, 
                    SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET + GameDefines.DROP_SHADOW_OFFSET, 
                    GameDefines.SOFT_KEY_TEXT_Y_OFFSET + GameDefines.DROP_SHADOW_OFFSET,
                    Graphics.TOP | Graphics.RIGHT);
            g.setColor(Colors.YELLOW);
            g.drawString(text, 
                    SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET, 
                    GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
                    Graphics.TOP | Graphics.RIGHT);            
    
            
            
			//if( g.getFont() == null )
			//	g.setFont( Dialogue.FONT_SYS_SMALL);
			//g.setColor( 0xFFFF00 );
			//g.drawString( s, (SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET), GameDefines.SOFT_KEY_TEXT_Y_OFFSET, Graphics.TOP | Graphics.RIGHT );
	      //
			//new Dialogue(s, false,
			//						(SKUConsts.ISO_VIEW_WIDTH - GameDefines.SOFT_KEY_TEXT_X_OFFSET), GameDefines.SOFT_KEY_TEXT_Y_OFFSET,
			//						Style.DIALOGUE_MAIN_TEXT_COLOR, (Graphics.TOP | Graphics.RIGHT) );
			//Dialogue.PaintStaticDialogue(g);
		}
		else {
			g.setClip(x, y - 4, iconWidth, iconHeight);
			g.drawImage(strip, x - frame*iconWidth, y - 4, Graphics.TOP | Graphics.LEFT);
		}

		// Restore old clip area.
		g.setClip(oldClip[0], oldClip[1], oldClip[2], oldClip[3]);
	}

	// Private functions //

	private void UpdatePositions()
	{
		if (m_NeedPanelUp)
		{
			need_pos++;
			need_pos++;
		}
		else
		{
			need_pos--;
			need_pos--;
		}

		if (need_pos < 0)
			need_pos = 0;
		if (need_pos > m_NeedsPanel.getHeight())
			need_pos = m_NeedsPanel.getHeight();
	}

	public static final int UP = (1 << 0);			/** Redefined from Canvas to be bitwise */
	public static final int DOWN = (1 << 1);		/** Redefined from Canvas to be bitwise */
	public static final int LEFT = (1 << 2);		/** Redefined from Canvas to be bitwise */
	public static final int RIGHT = (1 << 3);		/** Redefined from Canvas to be bitwise */
	public static final int GAME_A = (1 << 4);		/** Redefined from Canvas to be bitwise */
	public static final int GAME_B = (1 << 5);		/** Redefined from Canvas to be bitwise */
	public static final int GAME_C = (1 << 6);		/** Redefined from Canvas to be bitwise */
	public static final int GAME_D = (1 << 7);		/** Redefined from Canvas to be bitwise */
	public static final int FIRE = (1 << 8);		/** Redefined from Canvas to be bitwise */
	public static final int ACCEPT = (1 << 9);		/** Left soft key bit code */
	public static final int BACK = (1 << 10);		/** Right soft key bit code */
	public static final int KEY_NUM0 = (1 << 11);	/** Redefined from Canvas to be bitwise */
	public static final int KEY_POUND = (1 << 12);	/** Redefined from Canvas to be bitwise */
	public static final int KEY_STAR = (1 << 13);	/** Redefined from Canvas to be bitwise */
	public static final int ANY_KEY = 0xffff;		/** Redefined from Canvas to be bitwise */

	/**
	 * Status of an action when just released.
	 * this is currently depricated, use HELD to check for key press durations or
	 * fix the problem detailed in getActionState
	 */
	public static final int NONE    = (1 << 0);		/** Status of an action when not pressed, released or held */
	public static final int PRESSED = (1 << 1);		/** Status of an action when just pressed */
	public static final int HELD    = (1 << 3);		/** Status of an action when being held */

	private static final int RELEASED = (1 << 2);

	//vir - modified key declarations to be general
	// Phone special key defines
	private static final int ACCEPT_BUTTON	= -6;
	private static final int BACK_BUTTON	= -7;
	private static final int UP_BUTTON		= -1;
	private static final int DOWN_BUTTON	= -2;
	private static final int LEFT_BUTTON	= -3;
	private static final int RIGHT_BUTTON	= -4;

	private static final int KEY_HISTORY_LVL_2 = 0;	 	 /** Key state two updates ago */
	private static final int KEY_HISTORY_LVL_1 = 1;		 /** Key state two updates ago */
	private static final int KEY_HISTORY_LVL_0 = 2;		 /** Live key state */
	private static final int NUM_KEY_HISTORY_LVLS = 3;	 /** Key state levels to store */

	/*
	 * Public Static Vars
	 */
	/** Singleton instance */
	public static SimsCanvas	s_Canvas;

	/*
	 * Public Vars
	 */
	public boolean				m_IsInitialised;

	/*
	 * Tables
	 */
	private byte[][] 				m_StringTable;
	private static final int[][]	m_NeedsBarPos	=
	{
		{ 22, 28 },
		{ 52, 28 },
		{ 78, 28 },
		{ 106, 28 },
		{ 137, 28 },
		{ 166, 28 }
	};

	private static final int[][]	m_SkillsBarPos	=
	{
		{ 25, 28 },
		{ 58, 28 },
		{ 95, 28 },
		{ 130, 28 },
		{ 164, 28 }
	};

	/** History of key states */
//START:IGNORE:keyStateHistory#
	private int[] 	m_KeyStateHistory;
//END

	/*
	 * Private variables
	 */
	private boolean	m_NeedPanelUp;
	private Image	m_NeedsBars;
	private Image	m_NeedsPanel;
	private Image	m_PhoneSprites;
	private Image	m_SkillsBeads;
	private Image	m_SkillsGauge;
	private Image	m_SkillsPanel;
	private Image	m_SoftkeyPanel;
	private int		need_pos;
	private int 	m_KeyPressedState;
	private int 	m_KeyReleasedState;

}
