package sims2;

/* Copyright Ideaworks3D Ltd. 2005 */
//START:inclusive#
//END


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

//import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;


//import com.ideaworks3d.sims.ui.Dialogue;
//import com.ideaworks3d.debug.Debug;

/**
 * <p>to_be_removed: Utility</p>
 * <p>This class contains utility methods.</p>
 */
public class Utility
{	
	public static Image getDemoBackground() {
		try {
			return Image.createImage("/shell/voda.png");
		}
		catch (Exception ex) {
			return null;
		}
	}
	
	/**
	 * This method return an Image loading it from the "hard disk" of the mobile phone (from the standard directory) or, if the image was already loaded, it return an image took from an hashtable
	 * @param imageCode alphanumeric code for this image (filename)
	 * @param imagesHash where to store Image objects
	 * @return the requested Image
	 */
	public static Image loadImage(String imageCode, Hashtable imagesHash, boolean cacheImage)
	{
		// Check for leading slash
		//if (//Debug.ENABLED && imageCode.startsWith("/"))
		//{
			//Debug.println("loadImage is trying to load image code " + imageCode + ", but should not have leading slash", //Debug.CHAN_CORE);
			//Debug.debugAssert(false);
		//}
		
		//replace their image loading with my image cacheing system
		return PNG_funcs.generateImage( "/" + imageCode + ".png" );
		
//		if (imagesHash.containsKey(imageCode))
//		{ 
//			return (Image) imagesHash.get(imageCode);
//		}
//		else
//		{
//			try
//			{
//				Image temp_image = Image.createImage("/" + imageCode + ".png");
//				
//				if (cacheImage)
//				{
//					imagesHash.put(imageCode, temp_image);
//				}
//				
//				return (temp_image);
//			}
//			catch (IOException ex)
//			{
//				try
//				{
//					Image temp_image = Image.createImage("/" + imageCode + ".PNG");
//					
//					if (cacheImage)
//					{
//						imagesHash.put(imageCode, temp_image);
//					}
//					
//					return (temp_image);
//				}
//				catch (IOException exc)
//				{
//					//Debug.println("loadImage: error loading '" + imageCode + "' : " + exc);
//				}
//			}
//		}
//		return null;
	}

	/**
	 * This method return an Image loading it from the "hard disk" of the mobile phone (from the standard directory) or, if the image was already loaded, 
	 * it returns an image from the default hashtable
	 * @param imageCode alphanumeric code for this image (filename)
	 * @return the requested image
	 */
	/*public static Image loadImage(int uid)
	{
		return loadImage(uid, s_CachedImages);
	}*/	

	/**
	 * This method return an Image loading it from the "hard disk" of the mobile phone (from the standard directory) or, if the image was already loaded, it return an image took from an hashtable
	 * @param guid unique numeric code for this image (filename)
	 * @param imagesHash where to store Image objects
	 * @return the requested Image
	 */
	/*public static Image loadImage(int guid, Hashtable imagesHash)
	{
		if (s_CachedImages.containsKey( new Integer(guid)))
		{ 
			return (Image) s_CachedImages.get( new Integer(guid));
		}
		else
		{
			try
			{
				byte[] data = Utility.GetGlobalResource(guid);
				//Debug.println("Type: Image (splashscreen)", //Debug.CHAN_GLOBAL_RESOURCE);
				int dataPos = 0;
				
				// Read image
				int imageSize = Utility.ByteSerializeType(0, data, dataPos, 2, false);
				dataPos += 2;
				Image temp_image = Image.createImage(data, dataPos, imageSize);
				dataPos += imageSize;
				s_CachedImages.put(new Integer(guid), temp_image);
				//Debug.println("Dimensions: "+temp_image.getWidth()+" "+temp_image.getHeight(), //Debug.CHAN_GLOBAL_RESOURCE);
				return temp_image;
			}
			catch (Exception ex)
			{
				//Debug.println("loadImage: error loading '" + guid + "' : " + ex);
			}
		}
		return null;
	}*/	
	
	public static Image createImage(int paletteGuid, int guid, byte [] data, int dataPos, int imageSize, Hashtable imageStrips)
	{
		int hash = guid + (paletteGuid << 16);
		return PNG_funcs.generateImage( hash, data, dataPos, imageSize );
//		if (imageStrips.containsKey(new Integer(hash)))
//		{ 
//			return (Image) imageStrips.get(new Integer(hash));
//		}
//		else
//		{
//			try
//			{
//				Image temp_image = Image.createImage(data, dataPos, imageSize);
//				imageStrips.put(new Integer(hash), temp_image);
//				return temp_image;
//			}
//			catch (Exception ex)
//			{
//				// TODO: Something
//				//Debug.println("Error loading image: guid=" + guid + " size=" + data.length + ": " + ex.getMessage(),
//								//Debug.CHAN_CORE);
//				////Debug.assertPrintln(false, "oops");
//			}
//		}
//		return null;		
	}

	/**
	 * Create an alpha enabled image of one colour (0xAARRGGBB)
	 * @param colour
	 * @param width
	 * @param height
	 * @param alpha
	 * @return
	 */
	/*public static Image createImage(int colour, int width, int height, boolean alpha)
	{
		int[] argb = new int[width*height];
		
		for(int i=0; i<argb.length; ++i)
		{
			argb[i] = colour;
		}
		
		return Image.createRGBImage(argb, width, height, alpha);
		
	}*/
	
	/**
	 * Copies a source image onto a target, preserving transparency, but not! semi-transparency
	 * @param trgImg	target image
	 * @param srcImg	source image
	 * @param x			offset on target in x
	 * @param y			offset on target in y
	 * @param overlay	draw the source image in front
	 * @return
	 */
	/*public static Image drawImage(Image trgImg, Image srcImg, int x, int y, boolean overlay)
	{
		
		int[] srcARGB = new int[srcImg.getWidth()*srcImg.getHeight()];
		int[] trgARGB = new int[trgImg.getWidth()*trgImg.getHeight()];
		
		// Retrieve ARGB array (0xAARRGGBB) for target
		int trgScanLength = trgImg.getWidth();
		trgImg.getRGB(trgARGB, 0, trgScanLength, 0, 0, trgImg.getWidth(), trgImg.getHeight());
		
		// Retrieve ARGB array (0xAARRGGBB) for source
		int srcScanLength = srcImg.getWidth();
		srcImg.getRGB(srcARGB, 0, srcScanLength, 0, 0, srcImg.getWidth(), srcImg.getHeight());
		
		// calculate the area we are copying into
		int trgAreaX = trgImg.getWidth() - x;
		int trgAreaY = trgImg.getHeight() - y;
		
		// Make sure we don't try to copy from passed the src edges
		if(trgAreaX>srcImg.getWidth())
		{
			trgAreaX = srcImg.getWidth();
		}
		
		if(trgAreaY>srcImg.getHeight())
		{
			trgAreaY = srcImg.getHeight();
		}		
		
		int trgPixelX = x;
		int trgPixelY = y * trgScanLength;
		
		int srcPixelX = 0;
		int srcPixelY = 0;
		
		for(int i=0; i<trgAreaY; ++i)
		{ 
			for(int j=0 ; j<trgAreaX; ++j)
			{
				int colour;
				int trgColour;
				int alpha;
				
				// Sample source colour
				colour = srcARGB[(srcPixelY) + srcPixelX];
				alpha = colour & 0x11000000;
				
				// If we want to copy the source behind the target 
				if(!overlay)
				{
					trgColour = trgARGB[(trgPixelY) + trgPixelX];
					alpha = trgColour & 0x11000000;

				}
				
				// Copy pixels as necessary
				if(overlay && alpha != 0x00 || !overlay && alpha == 0x00)
				{
					trgARGB[(trgPixelY) + trgPixelX] = colour;
				}
				
				srcPixelX++;
				trgPixelX++;
			}
			
			trgPixelX = x;
			srcPixelX = 0;
			
			trgPixelY += trgScanLength;
			srcPixelY += srcScanLength;
		}

		return Image.createRGBImage(trgARGB, trgImg.getWidth(), trgImg.getHeight(), true);
	}*/
	
	public static Image createImage(int paletteGuid, int guid, byte [] data, int dataPos, int imageSize, boolean cacheImage)
	{
		// Cache the image if we use it again later
		if (cacheImage)
		{
			return createImage(paletteGuid, guid, data, dataPos, imageSize, s_CachedImages);
		}
		else
		{
			try
			{
				Image temp_image = Image.createImage(data, dataPos, imageSize);
				return temp_image;
			}
			catch (Exception ex)
			{
				//Debug.println("Error loading image: guid=" + guid + " size=" + data.length + ": " + ex.getMessage(),
								//Debug.CHAN_CORE);
			}
		
			return null;
		}
	}
	
	/** Wrapper for creating images */
	public static Image CreateImage(int width, int height)
	{
		return Image.createImage(width, height);
	}
	
	/*public static Animation getAnimation(int guid, int instanceId, byte[][] animData, int animId, int symmetry, Hashtable animations, int paletteGuId) // TODO: Remove and fix animation system
	{
		Integer key = new Integer( (animId*100000) + (instanceId*1000000) + (paletteGuId<<24) );
		if (animations.containsKey(key)) // TODO: HACK HACK HACK figure out a better way to hash guid and animid
		{ 
			Animation anim = (Animation) animations.get(key);
			anim.ResetAnimation();
			return anim;
		}
		else
		{
			try
			{
//				Animation temp_anim = new Animation(guid, instanceId, animData, animId, symmetry, paletteGuId);
				Animation temp_anim = new Animation(instanceId, animData, animId, symmetry, paletteGuId);
				animations.put(key, temp_anim);
//				return (Animation) animations.get(new AnimationPair(guid, animId));
				return temp_anim;
			}
			catch (Exception ex)
			{
				//Debug.println("Skipping removed animation "+animId, //Debug.CHAN_GLOBAL_RESOURCE);
			}
		}
		return null;		
	}*/

	public static Animation getAnimation(/*int guid, */int instanceId, byte[][] animData, int animId, int symmetry, int paletteGuId)
	{
//		return getAnimation(/*guid, */instanceId, animData, animId, symmetry, s_Animations, paletteGuId);
		
		try
		{
//				Animation temp_anim = new Animation(guid, instanceId, animData, animId, symmetry, paletteGuId);
			Animation temp_anim = new Animation(instanceId, animData, animId, symmetry, paletteGuId);
//				return (Animation) animations.get(new AnimationPair(guid, animId));
			return temp_anim;
		}
		catch (Exception ex)
		{
			//Debug.println("Skipping removed animation "+animId, //Debug.CHAN_GLOBAL_RESOURCE);
		}

		return null;
	}
	
	/**
	 * Creates a simple animation based on one sprite strip
	 * 
	 * @param guid				Guid of object that owns the animation
	 * @param instanceId		Instance id of object that owns the animation
	 * @param stripGuid			Value of image strip guid
	 * @param millisPerFrame	Milliseconds delay between the frames
	 * @param doesLoop			True to loop, false to not loop
	 * @return					Animation
	 */
	public static Animation GetAnimation(/*int guid, */int instanceId,
					ImageStrip strip, int millisPerFrame, 
					boolean doesLoop, int paletteGuId)
	{	
//		return new Animation(guid, instanceId, strip, millisPerFrame, doesLoop, paletteGuId);
		return new Animation(instanceId, strip, millisPerFrame, doesLoop, paletteGuId);
	}
	
	/**
	 * This method return an Image loading it from the "hard disk" of the mobile phone (from the standard directory) or, if the image was already loaded, 
	 * it returns an image from the default hashtable
	 * @param imageCode alphanumeric code for this image (filename)
	 * @return the requested image
	 */
	public static Image loadImage(String imageCode, boolean cacheImage)
	{
		return loadImage(imageCode, defaultImages, cacheImage);
	}

	/**
	 * This method return an Image loading it from the "hard disk" of the mobile phone (from the standard directory) or, if the image was already loaded, 
	 * it returns an image from the default hashtable
	 * @param imageCode alphanumeric code for this image (filename)
	 * @return the requested image
	 */
	/*public static Image loadImage(int uid)
	{
		return loadImage(uid, s_CachedImages);
	}*/
	
	/**
	 * Removes all images in default cache
	 */
	/*public static void emptyDefaultImageCache()
	{
		defaultImages.clear();
	}*/
	
	/**
	 * Returns true with a probability of prob
	 * 
	 * @param prob Percentage probability of success 0.0 = never, 1.0 = always (fixed point)
	 */
	public static boolean probability(int prob)
	{
		// Adjust prob to range -MAX_VALUE -> MAX_VALUE
		//    prob = (prob - 0.5f) * ((int)Integer.MAX_VALUE) * 2.0f;
		
		//return (prob > random.nextInt());
		
		int randomValue = Math.abs(m_Random.nextInt()) % FIXED_ONE;
		
		return (randomValue < prob);
	}

	/*public static String FixedToString(int fixed)
	{
//START:FixedToString#
		// This currently uses exactly 3 digits after the decimal point
		// (This is enough for the current 8 bits of fraction)
		String fractionString = "" + ((fixed & FIXED_FRAC_BITS) * 1000 / FIXED_ONE);
		fractionString = "000".substring(0, 3-fractionString.length()) + fractionString;
		return "" + (fixed >> FIXED_POS) + "." + fractionString;
//END
	}*/

	/**
	 * Generates a pseudo-random integer in range 0-maxRange.
	 * 
	 * @param maxRange
	 * @return
	 */
	public static int RandomRange(int maxRange)
	{
		int randInt = Math.abs(m_Random.nextInt() );

		// translate the results back by maxRange
		return (randInt % maxRange);

	} // end RandomRange
		
	/** Fully read a stream into a byte array
	 * 
	 * @param		is		Input stream to read from
	 * @return 	Data read from input stream
	 * @throws IOException if problems occur during read.
	 */
	public static byte[] readInputStreamFully(InputStream is) throws IOException
	{
		byte[] curBlockData = new byte[BLOCK_SIZE];
		int curBlockSize = BLOCK_SIZE;
		
//		// Uses streams (potentially slow and dangerous)
//		ByteArrayOutputStream output = new ByteArrayOutputStream();
//		
//		while (curBlockSize >= 0)
//		{
//			curBlockSize = is.read(curBlockData, 0, BLOCK_SIZE);
//			if (curBlockSize > 0)
//				output.write(curBlockData, 0, curBlockSize);
//		}
//		
//		byte[] byteData = output.toByteArray();
//		
//		output.close();
//		
//		return byteData;
		
		// Faster and doesn't require streams (potentially dangerous to have streams)
		Vector allBlocks = new Vector(100);
		int totalReadSize = 0;
		
		while (curBlockSize >= 0)
		{
			curBlockSize = is.read(curBlockData, 0, BLOCK_SIZE);
			if (curBlockSize > 0)
			{
				// Resize if less than block size
				if (curBlockSize < BLOCK_SIZE)
				{
					byte[] temp = new byte[curBlockSize];
					System.arraycopy(curBlockData, 0, temp, 0, curBlockSize);
					curBlockData = temp;
				}
				
				allBlocks.addElement(curBlockData);
				curBlockData = new byte[BLOCK_SIZE];
				totalReadSize += curBlockSize;							
			}
		}
		
		// Collate all blocks into one
		byte[] byteData = new byte[totalReadSize];
		int pos = totalReadSize;
		
		for (int curBlock = allBlocks.size() - 1; curBlock >= 0; curBlock--)
		{
//START:IGNORE:foo#
			curBlockData = (byte[])allBlocks.elementAt(curBlock);
//END
			curBlockSize = curBlockData.length;
			pos -= curBlockSize;
			System.arraycopy(curBlockData, 0, byteData, pos, curBlockSize);
		}
		
		return byteData;
	}
	
	/**
	 * Force the first letter of a String to a capital and the rest to
	 * lower case
	 * @param	input	Name to be capitalised
	 * @return	Properly capitalised string
	 */
	/*public static String nameCapitaliseString(String input)
	{
		String output = null;
		int inputLength;
		
		inputLength = (input != null) ? input.length() : 0;
		
		// Handle based on string length
		if (inputLength == 0)
		{
			output = "";
		}
		else 
		{
			// Convert first character to upper case
			output = input.substring(0, 1).toUpperCase();
			
			// Convert rest to lower case
			if (inputLength > 1)
				output += input.substring(1).toLowerCase();
		}
		
		return output;
	}*/
	
	/** Sets whether sound is enabled.
	 * By default we assume yes.
	 * Will not stop any playing sounds.
	 * @param enabled	True if sound should be enabled.
	 */
	/*public static void setSoundsEnabled(boolean enabled)
	{
		soundsEnabled = enabled;
	}*/
	
	/**
	 * Loads a sound and starts it playing
	 * @param soundCode		File name of sound to play (prepends "/" and appends ".png" to 
	 * 						form file name).
	 * @param isWavNotMidi	True if WAV format, false if MIDI format.
	 * @param numTimes		Number of times to play.  Use -1 for infinite looping.  Use
	 * 						0 just to load the sound and not play it.
	 */
	public static void playSound(int soundCode, boolean isWavNotMidi, int numTimes)
	{
		Midp2SoundEngine.getInstance().playSound( soundCode, numTimes );
		
////		if (MainMIDlet.GetInstance().CheckFlag(MainMIDlet.FLAG_SOUNDS_ENABLED))
////		{
//		System.out.println("playSound");
//			Player playSound = loadSound(soundCode, isWavNotMidi, defaultSounds);
//			if ((playSound != null) && playSound.getState() != Player.STARTED && (numTimes != 0))
//			{
//				// Quick hack.
//				if(s_DoPlaySounds)
//				{
//					System.out.println("playSound a");
//// This piece of code queues sounds in order to play all sounds requested					
//					if(numTimes == 1 && !isWavNotMidi)
//					{
//						System.out.println("playSound b");
//						// Only add a listener if this sound is to be played once only
////START:IGNORE:playerlistener#
//						PlayerListener listener = new PlayerListener(){
//														public void playerUpdate(Player player,
//										                         				String event,
//										                         				Object eventData)
//														{
//
//															System.out.println("playSound c");
//															if (event == PlayerListener.END_OF_MEDIA && !s_soundQueue.isEmpty())
//															{
//																int nextSound = ((Integer)s_soundQueue.firstElement()).intValue();
//																
//																// remove the first element
//																s_soundQueue.removeElementAt(0);
//																
//																// play the nex queued up element
//																playSound(nextSound, false, 1);
//															}
//														}
//													};
//									
//
//													System.out.println("playSound d");
//						playSound.addPlayerListener(listener);
////END
//						
//						// If there is a sound playing, add this one to the queue
//						// For now only queue up sounds that are requested to be played once and are not WAV
//						// limit the queue to 3 sounds
//						if(IsPlaying() && s_soundQueue.size() <= 3)
//						{
//							s_soundQueue.addElement(new Integer(soundCode));
//						}
//					}
//					else
//					{
//						// Nokia phones can only play one sound at a time.
//						// ...So kill all existing sounds.
//						Enumeration enumeration = defaultSounds.elements();
//						System.out.println("playSound e");
//						while(enumeration.hasMoreElements())
//						{
//							Player sound = (Player) enumeration.nextElement();
//							if(sound.getState() == Player.STARTED)
//								try { sound.stop(); } catch (MediaException e) {}
//						}
//					}
//
//					try 
//					{
//						playSound.setLoopCount(numTimes);
//						playSound.setMediaTime(0);
//						playSound.start();
//						
//					}
//					catch (MediaException e) {
//						//#ifdef DEBUG
//						e.printStackTrace();
//						//#endif
//					}
//				}
//			}
////		}
	}
	
	public static void stopAllSound()
	{
//		if(s_DoPlaySounds)
//		{
//			// Nokia phones can only play one sound at a time.
//			// Kill all existing sounds.
//			Enumeration enumeration = defaultSounds.elements();
//			while(enumeration.hasMoreElements())
//			{
//				Player sound = (Player) enumeration.nextElement();
//				if(sound.getState() == Player.STARTED)
//					try { sound.stop(); } catch (MediaException e) {}
//			}
//		}	
		Midp2SoundEngine.getInstance().stopSound();	
	}
	
	/**
	 * Stops a playing sound
	 * @param soundCode	File name of sound to stop (prepends "/" and appends ".png" to 
	 * 					form file name).
	 */
	public static void stopSound(int soundCode)
	{
		Midp2SoundEngine.getInstance().stopSound();
//		Player stopSound = (Player)defaultSounds.get(new Integer(soundCode));
//		if (stopSound != null)
//			try { stopSound.stop(); } catch (MediaException e) {}
	}

	/**
	 * See if any of the sounds are currently playing
	 * @return
	 */
	public static boolean IsPlaying()
	{
		Enumeration enumeration = defaultSounds.elements();
		while(enumeration.hasMoreElements())
		{
			Player sound = (Player) enumeration.nextElement();
			if(sound.getState() == Player.STARTED)
			{
				return true;
			}
		}
		
		return false;
	}
	
	/**
	 * See if were already playing a sound
	 * @param soundCode
	 * @return
	 */
	/*public static boolean IsPlaying(String soundCode)
	{
		Player sound = (Player)defaultSounds.get(soundCode);
		if (sound != null)
		{
			return sound.getState() == Player.STARTED;
		}
		
		return false;
	}*/
	
/*	public static long GetSoundTime(String soundCode)
	{
		Player sound = (Player)defaultSounds.get(soundCode);
		if (sound != null)
		{
			return sound.getMediaTime();
		}
		
		return -1;
	}
	
	public static void SetSoundTime(String soundCode, long time)
	{
		Player sound = (Player)defaultSounds.get(soundCode);
		if (sound != null)
		{
			try { sound.setMediaTime(time); } catch (MediaException e) {}
		}
	}
	
	public static void SetSoundLoopCount(String soundCode, int loop)
	{
		Player sound = (Player)defaultSounds.get(soundCode);
		if (sound != null)
		{
			sound.setLoopCount(loop);
		}
	}*/
	 
	/**
	 * Performs true modulus operation, where sign of result follows
	 * the sign of the divisor and not the divend.
	 * @param divend	Number to be divided.
	 * @param divisor	Number to divide by (must be positive).
	 * @return	Modulus value
	 */
	/*public static int Mod(int divend, int divisor)
	{
		// Calculate the remainder after division.
		int result = divend % divisor;
		
		// Reverse the sign by adding or subtracting the divisor if
		// the sign of the result does not match the sign of the
		// divisor.
		if (result > 0)
		{
			if (divisor < 0)
			{
				result -= divisor;
			}
		}
		else if (result < 0)
		{
			if (divisor > 0)
			{
				result += divisor;
			}
		}
		
		return result;
	}*/
	
	/**
	 * Map a value into range
	 * @param value
	 * @param minRangeIn
	 * @param maxRangeIn
	 * @param minRangeOut
	 * @param maxRangeOut
	 * @return
	 */
	/*public static int MapToRange(int value, int minRangeIn, int maxRangeIn, int minRangeOut, int maxRangeOut)
	{
		int rangeOut = maxRangeOut - minRangeOut;
		
		return (rangeOut - (rangeOut * (maxRangeIn - value)/maxRangeIn)) + minRangeOut;
		
	}*/ // end MapToRange
	
	/**
	 * Handles serialisation of primitive data types
	 * (serialisation meaning reading or writing)
	 * @param value					Value to be written (if reading then this is ignored)
	 * @param array					Byte array to be serialised to
	 * @param offset				Offset into byte array to serialise to
	 * @param valueLength			Length of value to input/output (1 for byte, 2 for short, 4 for int)
	 * @param isWritingNotReading	True if writing, false if reading.
	 * @return	Read value (returns written value if writing)
	 */
	public static int ByteSerializeType(int value, 
					byte[] array, int offset, int valueLength, 
					boolean isWritingNotReading)
	{
		// Do reading/writing
		try
		{
//START:byteserializetype#
			if (isWritingNotReading)
			{
				ByteArrayOutputStream byteOs = new ByteArrayOutputStream(valueLength);
				DataOutputStream dataOs = new DataOutputStream(byteOs);
				
				// Output depending on length
				if (valueLength == 1)
				{
					// Output as unsigned byte
					dataOs.write(value);
				}
				else if (valueLength == 2)
				{
					// Output as unsigned short
					dataOs.writeShort(value);
				}
				else
				{
					// Output as signed integer
					valueLength = 4;
					dataOs.writeInt(value);
				}
				
				// Copy into output byte array
				System.arraycopy(byteOs.toByteArray(), 0, array, offset, valueLength);

				try{
					dataOs.close();
				}catch(Exception e){
					//#ifdef DEBUG
//# 					e.printStackTrace();
					//#endif
				}
				try{
					byteOs.close();
				}catch(Exception e){
					//#ifdef DEBUG
//# 					e.printStackTrace();
					//#endif
				}
			}
			else	// Is reading
			{
				ByteArrayInputStream byteIs = new ByteArrayInputStream(array, offset, valueLength);
				DataInputStream dataIs = new DataInputStream(byteIs);
				
				// Input depending on length
				// Output depending on length
				if (valueLength == 1)
				{
					// Output as unsigned byte
					value = dataIs.readUnsignedByte();
				}
				else if (valueLength == 2)
				{
					// Output as unsigned short
					value = dataIs.readUnsignedShort();
				}
				else
				{
					// Output as signed integer
					valueLength = 4;
					value = dataIs.readInt();
				}

				try{
					dataIs.close();
				}catch(Exception e){
					//#ifdef DEBUG
//# 					e.printStackTrace();
					//#endif
				}
				try{
					byteIs.close();
				}catch(Exception e){
					//#ifdef DEBUG
//# 					e.printStackTrace();
					//#endif
				}
			}	// End if (isWritingNotReading)
//END
		}
		catch (IOException e)
		{
			//Debug.assertPrintln(false, "ByteSerializeType failed");
		}
		
		return value;
	}

	/**
	 * Render a frame of an image strip (anchored top left)
	 * @param context		Graphics context to render to
	 * @param strip			Image strip
	 * @param frameHeight	Height of one frame
	 * @param index			Frame number to draw
	 * @param xPos			X pos to draw on output
	 * @param yPos			Y pos to draw on output
	 * @param isMirrored	True if mirroring required, else false
	 */
	/*public static void ImageStripDraw(Graphics context, Image strip, 
					int frameHeight, int index, int xPos, int yPos,
					boolean isMirrored)
	{
		context.drawRegion(strip, 0, index * frameHeight, strip.getWidth(), frameHeight,
						isMirrored ? Sprite.TRANS_MIRROR : 0,
						xPos, yPos, Graphics.TOP | Graphics.LEFT);
		
//	MIDP 1.0 compatible (no mirroring)
//		// Store old clip
//		int[] oldClip = new int[]
//		{
//			context.getClipX(),
//			context.getClipY(),
//			context.getClipWidth(),
//			context.getClipHeight()
//		};
//
//		// Set clip to draw only image strip frame
//		context.setClip(xPos, yPos, strip.getWidth(), frameHeight);
//		
//		// Draw image strip
//		context.drawImage(strip, xPos, yPos - index * frameHeight, Graphics.TOP | Graphics.LEFT);
//		
//		// Restore old clip
//		context.setClip(oldClip[0], oldClip[1], oldClip[2], oldClip[3]);
	}*/
	
	/**
	 * Obtain a resource by name
	 * @param resourceName	Name of resource to open
	 * @return				InputStream from resource
	 */
	public static InputStream GetResourceAsStream(String resourceName)
	{
		////Debug.println("GetResourceAsStream: " + id, //Debug.CHAN_CORE);
		InputStream resourceStream = GetResourceAsStreamNonCompressed(resourceName);
		if (resourceStream != null)
		{
			resourceStream = DecompressStream(resourceStream);
			if (resourceStream == null) // Failed to decompress, so open it normally
				resourceStream = GetResourceAsStreamNonCompressed(resourceName);
		}
		return resourceStream;
	}
	
	/**
	 * Obtain a resource by name
	 * @param resourceName	Name of resource to open
	 * @return				InputStream from resource
	 */
	public static InputStream GetResourceAsStreamNonCompressed(String resourceName)
	{
        if (resourceName != null && resourceName.charAt(0) != '/') {
            resourceName = "/" + resourceName;
        }
        resourceName = "/sims2" + resourceName;         
//START:GetResourceAsStreamNonCompressed#
//		System.out.println(resourceName);
		return(new String(resourceName).getClass().getResourceAsStream(resourceName) );
//		return com.ideaworks3d.res.ResourceLoader.Peek().GetResourceAsStream(resourceName);
//END
	}
	
	/**
	 * Decompress a compressed stream. Warning: this returns null if the stream isn't compressed, and
	 *  will have already read 2 bytes from the stream passed in.
	 * @param compressedStream 	Stream containing potentially compressed data
	 * @return 					Decompressed stream, or null if stream wasn't compressed
	 */
	public static InputStream DecompressStream(InputStream compressedStream) 
	{	
        
		// Only attempt if marking is supported
		// (will have to find a different method otherwise!)
		// TODO: always place first two bytes in every file to avoid the need to mark/reset
		
		try
		{
			if (compressedStream.markSupported())
				compressedStream.mark(2);
			
			byte header0 = (byte) compressedStream.read();
			byte header1 = (byte) compressedStream.read();
			
			if (header0!=88 || header1<-16 || header1>-14)
			{
				// Unsupported header code - assume non-compressed file
				// (Note: this also catches the case where either of the above read call fails)
				if (compressedStream.markSupported())
				{
					compressedStream.reset();
					return compressedStream;
				}
				else
					return null;
			}
			
			//if (//Debug.ENABLED)
			//	//Debug.println("Loading compressed data type " + header1, //Debug.CHAN_GLOBAL_RESOURCE);
			
			if (header1==-16)
			{
				// No compression, just use the rest of the file
				return compressedStream; 
			}
			
			// Read target size from header
			int targetSize = compressedStream.read() << 16;
			targetSize += compressedStream.read() << 8;
			targetSize += compressedStream.read();
	
			byte[] output = new byte[targetSize];
			int bytesRead = 0;
	
			if (header1==-15)
			{	
				// PNG compressed - rebuild PNG, and decode from 32bit ARGB to index values
				
				// Load unchanging parts of PNG headers/footers
				// TODO: we should probably store this in RAM after loading it once, for efficiency.
//START:IGNORE:PNG arrays#
				byte pngFooter[] = new byte[0xc];
				byte pngHeader[] = new byte[0x10];
				byte pngPalette[] = new byte[0x30c];
//END
//				int pngSize = 0;
				
				InputStream pngData = Utility.GetResourceAsStreamNonCompressed("/compression/png.dat");
				pngData.read(pngHeader);
				pngData.read(pngPalette);
				pngData.read(pngFooter);
	
				// Start building PNG
//START:IGNORE:rebuiltPng#
				byte rebuiltPng[] = new byte[0x4800 + 0x345];
//END
				
				// Copy unchanging parts 
				System.arraycopy(pngHeader, 0, rebuiltPng, 0, 0x10);
				System.arraycopy(pngPalette, 0, rebuiltPng, 0x21, 0x30c);
				
				while(bytesRead < targetSize)
				{
					compressedStream.read(rebuiltPng, 0x10, 0x11);			// Header (body of IHDR info including CRC)
					compressedStream.read(rebuiltPng, 0x32d, 4);			// Image data length
					int length = ((rebuiltPng[0x330] & 0xff) << 0)
					           + ((rebuiltPng[0x32f] & 0xff) << 8)
					           + ((rebuiltPng[0x32e] & 0xff) << 16)
					           + ((rebuiltPng[0x32d] & 0xff) << 24);
					compressedStream.read(rebuiltPng, 0x331, length + 8);	// Image data
					System.arraycopy(pngFooter, 0, rebuiltPng, 0x339+length, 0xc);	// Footer
					
//START:pngStream#
					ByteArrayInputStream pngStream = new ByteArrayInputStream(rebuiltPng, 0, (0x339+0xc)+length);
//END
					
					Image a = Image.createImage(pngStream);
					int w = a.getWidth();
					int h = a.getHeight();
//START:IGNORE:rgb#
					int rgb[] = new int[w * h];
//END
					a.getRGB(rgb, 0, w, 0, 0, w, h);
					
					// Rebuild byte array from MSBs of RGB data
					int bytes = targetSize - bytesRead;
					if (bytes > rgb.length)
						bytes = rgb.length;
					for (int i=0; i<bytes; i++)
					{
						int x = rgb[i] & 0x00e0e0c0;
						output[i+bytesRead] = (byte) (x | (x>>10) | (x>>21));
					}
					bytesRead += bytes;
				}
			}
			else
			{
				// Masked format, each input clump represents 8 output bytes
				//  byte 0 = mask: 1s represent value 0x00 in output stream
				//  subsequent 0-8 bytes record the values of the non 0x00 bytes
				int mask = 1;
				int forceRepeat = 0;
				byte forceRepeatValue = (byte)0xff;
				while (bytesRead < targetSize)
				{
					if (mask==1)
						mask = compressedStream.read() | 0x100;
					
					if ((mask & 1) == 1)
					{
						// Not necessary to explicitly write 0 here - the ouput array will start at all 0 
						//output[bytesRead] = 0;
					}
					else 
					{
						if (forceRepeat > 0)
							forceRepeat--;
						else
						{
							byte inputByte = (byte)compressedStream.read();
							if (inputByte==0)
								forceRepeat = 1;
							else
								forceRepeatValue = inputByte;
						}
						output[bytesRead] = forceRepeatValue;
					}
						
					bytesRead++;
					mask >>= 1;
				}
			}
			return new ByteArrayInputStream(output);
		}
		catch(IOException e)
		{
			return null;
		}
	}

	/**
	 * Obtains a global resource
	 * 
	 * @param guid	Unique identifier for global resource
	 * @return		Block of data, or null if not found
	 * @throws		GenericException if data cannot be loaded from any resource
	 */
	public static byte[] GetGlobalResource(int guid) throws Exception
	{
		byte[] result = null;
		Integer guid_int = new Integer(guid); 
		
		// Attempt read from memory
		if (result == null)
		{
//START:IGNORE:result#
			result = (byte[])s_MemoryResources.get(guid_int);
//END
			
//			if (Debug.ENABLED && (result != null))
//			{
//				//Debug.println("Obtained guid from heap: " + guid, //Debug.CHAN_GLOBAL_RESOURCE);
//			}
		}
		
		// read data from auxilliary directory if it isn't cached already
		if (result == null)
		{
			try
			{
				String fileName = "/" + STAND_ALONE_JAR_GLOBAL_DATA_DIRECTORY + "/" + guid_int.toString();
//				String fileName = STAND_ALONE_JAR_GLOBAL_DATA_DIRECTORY + "/" + guid_int.toString();
				InputStream stream = GetResourceAsStream(fileName);	
				if (stream != null)
				{
					result = readInputStreamFully(stream);

//					if (//Debug.ENABLED && (result != null))
//					{
//						//Debug.println("Obtained guid from JAR: " + guid, //Debug.CHAN_GLOBAL_RESOURCE);
//						//Debug.println("Size: "+result.length+" Bytes", //Debug.CHAN_GLOBAL_RESOURCE);
//					}
//START:system error#
					if (LOG_JAR_USAGE)
						System.err.println(guid_int.toString());
//END
					stream.close();
				}
			}
			catch (IOException ex)
			{
				//Debug.println("IOException during GetResourceAsStream: " + ex.getMessage());
			}		
		}

		if (result == null)
		{
			throw new Exception("Failed to locate content: " + guid);
		}
		
		// If we are caching data to memory then write reference
		if (SKUConsts.CACHE_ALL_STREAMED_DATA)
		{
			s_MemoryResources.put(guid_int, result);
		}
		
		return result;
	}

	/*public static void StoreHeapResourceCache()
	{
		s_MemoryResources.clear();
	}*/

	/**
	 * Used to store a global resource to memory/clear it from memory
	 * @param guid	ID of resource to add/clear
	 * @param data	Null to clear the guid, else contains data to set
	 */
	/*public static void StoreGlobalResourceToMemory(int guid, byte[] data)
	{
		if (data != null)
		{
			// Add/set
			s_MemoryResources.put(new Integer(guid), data);
		}
		else
		{
			// Remove
			s_MemoryResources.remove(new Integer(guid));
		}
	}*/
	
	/**
	 * Load a string by guid from global resource
	 * @param guId
	 * @return string
	 */
	/*public static String LoadString(int guId)
	{
		//Debug.println("LoadString: " + guId, //Debug.CHAN_SCRIPT_VM);
		
		byte[] stringBinary = null;
		try
		{
			stringBinary = Utility.GetGlobalResource(guId);
			//Debug.println("Type: String", //Debug.CHAN_GLOBAL_RESOURCE);
		}
		catch (Exception ex)
		{
			//Debug.assertPrintln(false, "Error loading string: " + ex.getMessage());
			
			return null;
		}
		
		//return Utility.ReadStringFromUTF16(stringBinary, 0, stringBinary.length);
		return new String(stringBinary);
		
	}*/ // LoadString
		
	/**
	 * Load a string by guid from global resource
	 * @param guId
	 * @return string
	 */
	/*public static String LoadTokenizedString(int guId, String delimeter, int section)
	{
		String fullString = LoadString(guId);
		
		String token = null;
		
		int i = 0;
		int tokenStartIndex = 0;
		int tokenEndIndex = 0;
		
		boolean NoDelimFound = false;
		do
		{
			
			if((tokenEndIndex=fullString.indexOf(delimeter, tokenStartIndex)) <= tokenStartIndex)
			{
				tokenEndIndex = fullString.length();
				
				NoDelimFound = true;
			}
			
			token = fullString.substring(tokenStartIndex, tokenEndIndex);
		
			tokenStartIndex = tokenEndIndex + delimeter.length();
			
			++i;
		}
		while(i <= section && !NoDelimFound);
			
		//return Utility.ReadStringFromUTF16(stringBinary, 0, stringBinary.length);
		return token;
		
	}*/ // LoadString
	
	public static String GetExpandedTokenString(String [] strings)
	{
		String tokenizedString = strings[0];
		
		// move this to get string width function....
		StringBuffer fullString = new StringBuffer();
		
		for(int i = 0; i < tokenizedString.length(); ) 
		{
			char c = tokenizedString.charAt(i++);
			
			if (c == '~')
			{
				// subtract 48 here as it is the offset for numbers, 
				// the character following the ~ must be a number.
				fullString.append(strings[1 + strings[0].charAt(i++) - 48]);
			}
			else
			{
				fullString.append(c);
			}
		}
			
		return fullString.toString();
		
	} // GetExpandedTokenString
	
	/**
	 * Obtain a Guid that (probably) isn't used already
	 * This Guid must only be used temporarily.
	 * 
	 * @return	TEMPORARY guid
	 */
	/*public static int GetFakeGuid()
	{
		int result = s_NextFakeGuid;
		--s_NextFakeGuid;
		return result;
	}*/
	
	public static void loadAllSounds()
	{
		Midp2SoundEngine.getInstance().loadAllsounds();
		
		// The player initialisation below is too slow on device.
		// We keep the streams and create each player as required.
//		for(int i = 0; i < files.length; ++i)
//		{
//			try
//			{
//				String contentType = "audio/midi";
//				Player player;
//					player = Manager.createPlayer(files[i], contentType);
//				player.prefetch();
//				
//				// Adjust volume
//				VolumeControl vc = (VolumeControl)player.getControl("VolumeControl");
//				vc.setLevel(VOLUME_OF_SOUNDS);
//				
//				// Put in hash table and return
//				defaultSounds.put(new Integer(i), player);
//			}
//			catch (IOException e)
//			{
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//			catch (MediaException e)
//			{
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//		}
	}
	
	/**
	 * Read a chunk file containing global data and store in the cache.
	 * 
	 * @param chunkfile
	 */
	/*public static void readGlobalDataChunk(String chunkfile)
	{
		Vector files = new Vector();
		Vector data = new Vector();
		
		// Read the data.
		Utility.readChunkFile(chunkfile, files, data);
		
		// Put it in the cache.
		for(int i = 0; i < data.size(); ++i)
		{
			int guid = Integer.parseInt( (String)files.elementAt(i) );
			byte[] chunk = (byte[]) data.elementAt(i);
			s_MemoryResources.put(new Integer(guid), chunk);
		}
	}*/
	
	/**
	 * Chunk file reader.  
	 * This currently disgards the filenames.
	 * 
	 * @param chunkfile		The file to load
	 * @return				The resulting input streams
	 */
//	public static void readChunkFile(String chunkfile, Vector filenames, Vector data)
//	{
//		try
//		{
//			// Grab the file.
//			InputStream is = GetResourceAsStream(chunkfile);
//			DataInputStream dis = new DataInputStream(is);
//			
//			// Get the number of chunks.
//			int number = dis.readInt();
////			byte[][] array = new byte[number][];
//			
//			// Loop through the chunks.
//			for(int i = 0; i < number && dis.available() != 0; ++i)
//			{
//				// Filename.
//				StringBuffer file = new StringBuffer();
//				byte ch;
//				ch = dis.readByte();
//				while(ch != '\n')
//				{
//					file.append((char)ch);
//					// Read the next char.
//					ch = dis.readByte();
//				}
//				
//				// Add to the vector.
//				filenames.addElement(file.toString());
//				
//				// Length.
//				int length = dis.readInt();
//				
//				// Data.
//				byte[] chunk = new byte[length];
//				dis.read(chunk);
//				data.addElement(chunk);
//			}
//		}
//		catch (Exception e)
//		{
//			//Debug.println("Could not load sound files", //Debug.CHAN_CORE);
//		}
//	}
	
	/**
	 * Load a sound from cache
	 * @param soundCode			Name of sound to load (prepends "/" and appends ".png" to 
	 * 							form file name).
	 * @param soundsHash		Hashtable to cache in.
	 * @param	isWavNotMidi	Used to select between WAV and MIDI formats.
	 * @return					The Player object for the sound.
	 */
	private static Player loadSound(int soundCode, boolean isWavNotMidi, Hashtable soundsHash)
	{
		System.out.println("loadSound");
//		// If sound exists in cache
//		if (soundsHash.containsKey(new Integer(soundCode)))
//		{ 
//			return (Player)soundsHash.get(new Integer(soundCode));
//		}
//		else	// Sound does not exist in cache
//		{			
////			String filename = "/sound/" + Integer.toString(soundCode);//"/" + soundCode + (isWavNotMidi ? ".wav" : ".mid");
//			try
//			{
//				System.out.println("HERE 1");
//				// Load sound
//				InputStream is = new ByteArrayInputStream((byte[])soundData.elementAt(soundCode));
////				InputStream is = GetResourceAsStream(filename);
//				System.out.println("HERE 2");
//				String contentType = isWavNotMidi ? "audio/x-wav" : "audio/midi";
////START:createPlayer#
//				System.out.println("HERE 3");
//				Player player = Manager.createPlayer(is, contentType);
//				player.prefetch();
//				System.out.println("HERE 4");
//				
//				// Adjust volume
//				VolumeControl vc = (VolumeControl)player.getControl("VolumeControl");
//				vc.setLevel(VOLUME_OF_SOUNDS);
//				System.out.println("HERE 5");
//				
//				// Put in hash table and return
//				soundsHash.put(new Integer(soundCode), player);
//				System.out.println("HERE 6");
//				// Free the copy of the data stream.
//				soundData.setElementAt(null, soundCode);
//				System.out.println("HERE 7");
//				return player;
////END
//			}
//			catch (Exception e)
//			{
//				//Debug.println("Could not load sound " + soundCode +
//								e.getMessage() + " ; " + e.toString(), //Debug.CHAN_CORE);
//				
//			}
//		}
		return null;
	}
	
	/** 
	 * Validate the string used by a text field that should only contain integer data
	 * 
	 * @param value
	 * @return - sets the string to zero if it is invalid
	 */
	/*public static String ValidateIntegerTextField(String value)
	{
		String returnValue = value;
		
		try
		{
			Integer.parseInt(value);
		}
		catch (Exception e)
		{
			//Debug.println("Invalid Integer in text field: " + value, //Debug.CHAN_CORE);
			returnValue = "0";
		}
		
		return(returnValue);
		
	}*/ // end ValidateIntegerTextField
	
	/**
	 * Read a String from UTF-16 ascii data
	 * (works on phones that don't support UTF-16 encoding)
	 * 
	 * @param data		Byte data
	 * @param offset	Offset of start of data
	 * @param length	Length of data to use
	 * @return	String
	 */
	/*public static String ReadStringFromUTF16(byte[] data, int offset, int length)
	{		
		StringBuffer strBuf = new StringBuffer();
		int numChars = length >> 1;
		int pos = offset;
		
		while (numChars-- > 0)
		{
			char curChar = (char)((data[pos++] << 8) | (data[pos++] & 0xFF));
			strBuf.append(curChar);
		}
		
		return strBuf.toString();	
	}*/

	/**
	 * Breaks the string up across multiple lines if it is too long for the designated width
	 * 
	 * @param s
	 * @param separator
	 * @return
	 */
	public static Vector TokenizeString(String s, char separator)
	{
		Vector list = new Vector();
		StringBuffer tempString = new StringBuffer();
		
		for (int i = 0; i < s.length(); i++)
		{
			if (s.charAt(i) == '\\')
			{
				//Debug.println("format found slash");
				if (i < s.length() && s.charAt(i+1) == 'n')
				{
					String newString = tempString.toString();
					list.addElement(newString);
					tempString.delete(0, tempString.length());
					list.addElement(null);
					i++;
					continue;
				}
			}
			if (s.charAt(i) != separator) 
			{
				tempString.append(s.charAt(i));
			} 
			else 
			{
				tempString.append(s.charAt(i));
				String newString = tempString.toString();
				list.addElement(newString);
				tempString.delete(0, tempString.length());
			}
		}
		
		String newString = tempString.toString();
		list.addElement(newString);
		
		return list;
	} // end tokenizeString

	/**
	 * Formats the string to the given with by inserting newlines.
	 * 
	 * @param s the string to format
	 * @param width of the dialog.
	 * @return the new required height for the dialogue.
	 */
	/*public static Vector FormatString(String s, int width) 
	{
		Vector lines = new Vector();
		Font font = Dialogue.DIALOGUE_FONT;
		StringBuffer tempString = new StringBuffer("");
		
		if (font.stringWidth(s) < width) 
		{
			lines.addElement(s);
			return lines;
		}

		Vector words = TokenizeString(s, ' ');
		for (int i = 0; i < words.size(); i++) 
		{
			Object elem = words.elementAt(i);
			if (elem == null)
			{
				//Debug.println("newline at word " + i);
				String newString = tempString.toString();
				lines.addElement(newString);
				tempString.delete(0, tempString.length());
				continue;
			}

			String word = (String) elem;

			if (font.stringWidth(tempString.toString() + word) < width) 
			{
				tempString.append(word);
			} 
			else 
			{
				String newString = tempString.toString();
				lines.addElement(newString);
				tempString.delete(0, tempString.length());
				tempString.append(word);
			}
		}
		
		String newString = tempString.toString();
		lines.addElement(newString);
		return lines;
	}*/ // end formatString

	/**
	 * Convert a hex string to an int.
	 * We don't use Integer.parseInt(x, 16) because this does handle negatives.
	 * (i.e 0xffffffff).
	 */
	/*public static int hexToInt(String hex) throws NumberFormatException
    {
		int len = hex.length();
		if (len > 8)
			throw new NumberFormatException("string too long: " + len);

		int l = 0;
		for (int i = 0; i < len; i++)
		{
			l <<= 4;
			int c = Character.digit(hex.charAt(i), 16);
			if (c < 0)
				throw new NumberFormatException("invalid hex char: " + c);
			l |= c;
		}
		return l;
	}*/

	/*public static String toHexString(int num)
	{
		String hex_string = Integer.toHexString(num);
		if (hex_string.length() < 8)
		{
			StringBuffer buf = new StringBuffer(8);
			int pad = 8 - hex_string.length();
			for (int i = 0; i < pad; i++)
			{
				buf.append("0");
			}
			buf.append(hex_string);
			hex_string = buf.toString();
		}
		return hex_string;
	}*/
	
	public static void drawRegion(Graphics g, Image src, int x_src, int y_src, int width, int height, int xform, int x_dest, int y_dest, int where) 
	{
		if (SKUConsts.FLIPPING_MEMORY_LEAKS)
		{
			// Flipping is handled as a special case
			if (xform == Sprite.TRANS_MIRROR)
			{
				// Draw each column of the image back to front
				x_dest += width;
				for (int col = 0; col < width; col++)
				{
					x_dest--;
					/*g.setClip(x_dest,y_dest,1,height);
					g.drawImage(src, x_dest - x_src, y_dest - y_src, 0);
					g.setClip(0,0,240,297);*/
					g.drawRegion(src, x_src, y_src, 1, height, Sprite.TRANS_NONE, x_dest, y_dest, 0);
					x_src++;
				}
			}
			else
			{
				xform = Sprite.TRANS_NONE;
				/*g.setClip(x_dest,y_dest,width,height);
				g.drawImage(src, x_dest - x_src, y_dest - y_src, where);
				g.setClip(0,0,240,297);*/
				g.drawRegion(src, x_src, y_src, width, height, xform, x_dest, y_dest, where);
			}
		}
		else
		{
			g.drawRegion(src, x_src, y_src, width, height, xform, x_dest, y_dest, where);
			/*g.setClip(x_dest,y_dest,width,height);
			g.drawImage(src, x_dest - x_src, y_dest - y_src, where);
			g.setClip(0,0,240,297);*/
		}
		
		// JB: it's transformations that are the enemy, not drawRegion all together
//		int px = g.getClipX();
//		int py = g.getClipY();
//		int pw = g.getClipWidth();
//		int ph = g.getClipHeight();
//		int y_clip = y_dest;
//		int x_clip = x_dest;
//		/*
//		if ((where & Graphics.BOTTOM) != 0)
//		{
//		//height = -height;
//		y_clip = src.getHeight() - y_clip + height;
//		}
//		if ((where & Graphics.RIGHT) != 0)
//		{
//		//x_clip = src.getWidth() - x_clip + width;
//		}*/
//		// JoeB : don't know why these were commented, we only get 1/4 of the image if it's not here
//		if ((where & Graphics.VCENTER) != 0)
//		{
//		y_clip -= src.getHeight()/2;
//		}
//		if ((where & Graphics.HCENTER) != 0)
//		{
//		x_clip -= src.getWidth()/2;
//		}
//		
//		////Debug.println("drawRegion: clip:" + x_clip + " " + y_clip + " " + width + " " + height);
//		////Debug.println("drawRegion: draw to: " + x_dest + " " + " " + y_dest + " from: " + x_src + " " + y_src);
//		g.setClip(x_clip, y_clip, width, height);
//		Utility.DrawImage(g, src, x_dest-x_src, y_dest-y_src, where);
//		g.setClip(px, py, pw, ph);
	}
     
   /*public static String ReplaceStringArguments(String source, String[] arguments)
   {
   		StringBuffer out = new StringBuffer();
   		int i=0;
   		while (true)
   		{
   			int find = source.indexOf("%", i);
   			if (find==-1)
   			{
   				out.append(source.substring(i));
   				return out.toString();
   			}
   			out.append(source.substring(i,find));
   			out.append(arguments[source.charAt(find+1)-'1']);   			
   			i = find+2;
   		}
   }*/
   
   /**
    * Shift and pack an integer into a specific bit position.
    * An assert is thrown if the value is too large for the length, or on
    * overflow.
    * @param value value to pack
    * @param position bit number to contain value, 0 - 15
    * @param length number of bits to use
    * @return the packed int which can be or'ed with other packed ints
    */
   /*public static int packShortBits(int value, int position, int length)
   {
	   //Debug.assertPrintln(position + length <= 16,
						"can't pack bits into position " + position + 
						" and length " + length);
	   //Debug.assertPrintln(value < (1 << length), "value " + value + 
						" is too large for " + length + " bits");
	   return (value << position);
   }*/

   /**
    * Extract a packed value at a specific bit position from a double byte.
    * @param value packed double byte value
    * @param position bit number where value starts, 0-15
    * @param length number of bits
    * @return unpacked value
    */
   /*public static int unpackShortBits(int value, int position, int length)
   {
	   //Debug.assertPrintln(position + length <= 16,
						"can't pack bits into position " + position + 
						" and length " + length);
	   return (value >> position) & ((1 << length) - 1);
   }*/
   
	/** Wrapper for drawing images */
	public static void DrawImage(Graphics context, Image image, 
					int xPos, int yPos, int anchor)
	{	
		context.drawImage(image, xPos, yPos, anchor);
	}
	
	/**
	 * Utility method to get the clipping area of a graphics context to
	 * a 4 element array.
	 * 
	 * @param	gContext	Graphics context to grab clip coordinates from 
	 * @return	4 element array containing [x, y, width, height]
	 */
	public static int[] GetClipArray(Graphics gContext)
	{
		int[] clipArray = new int[4];
		
		clipArray[0] = gContext.getClipX();
		clipArray[1] = gContext.getClipY();
		clipArray[2] = gContext.getClipWidth();
		clipArray[3] = gContext.getClipHeight();
		
		return clipArray;
		
	} // end GetClipArray
	
	/**
	 * Convert world grid coords to world (pixel) coordinates
	 * 
	 * @param worldX	World grid position
	 * @param worldY	World grid position
	 * @return	Pixel position within world at centre of grid tile.
	 */
	public static int[] GridToWorldCoords(int gridX, int gridY)
	{
		// Call half grid routine, with double coords
		int[] result = HalfGridToWorldCoords(gridX * 2, gridY * 2);
		
		// Add 1/4 tile height to get to centre of cell
		result[1] += (SKUConsts.TILE_HALF_HEIGHT / 2);
		
		return result;
	}
	
	/**
	 * Convert world grid coords to world (pixel) coordinates
	 * 
	 * @param worldX	World grid position
	 * @param worldY	World grid position
	 * @return	Pixel position within world at centre of grid tile.
	 */
	public static int[] HalfGridToWorldCoords(int gridX, int gridY)
	{
		int worldX;	// Position in world coords
		int worldY;	// Position in world coords
		
		// Multiply by tile size to work in pixels rather than grid location
		gridX = (gridX * SKUConsts.HALF_TILE_EDGE_LENGTH_FP) >> Utility.FIXED_POS;
		gridY = (gridY * SKUConsts.HALF_TILE_EDGE_LENGTH_FP) >> Utility.FIXED_POS;
		
		// Negate direction of y, so that we can use standard rotation (assume y faces up screen)
		gridY = -gridY;
		
		// Rotate by 45 degrees anti-clockwise (rotate about z axis)
		worldX = ((gridX + gridY) * COSINE_OF_45_FP) >> Utility.FIXED_POS;
		worldY = ((-gridX + gridY) * COSINE_OF_45_FP) >> Utility.FIXED_POS;
		
		// We've worked in a coordinate system with Y facing up the screen.
		// Negate this so that we output in a format consistent with the game
		// engine (facing down the screen).
		worldY = -worldY;
		
		// Rotate view with respect to angle to ground.
		// Performed by dividing Y by two -- assumes angle to ground of view.
		worldY >>= 1;
		
		// Add 1/4 tile height, to place position at centre of tile
		worldY += (SKUConsts.TILE_HALF_HEIGHT / 2);
		
//START:result 1#
		return new int[] {worldX, worldY};
//END
	}

	/**
	 * Convert world (pixel) coords to world grid coordinates
	 * 
	 * @param worldX	Pixel position within world
	 * @param worldY	Pixel position within world
	 * @return	Grid coordinates.
	 */
	public static int[] WorldToGridCoords(int worldX, int worldY)
	{
		int[] result = WorldToHalfGridCoords(worldX, worldY);
		
		result[0] /= 2;
		result[1] /= 2;
		
		return result;
	}
	
	/**
	 * Convert world (pixel) coords to world grid coordinates
	 * 
	 * @param worldX	Pixel position within world
	 * @param worldY	Pixel position within world
	 * @return	Grid coordinates.
	 */
	public static int[] WorldToHalfGridCoords(int worldX, int worldY)
	{
		int gridX;	// Grid position
		int gridY;	// Grid position
		
		// Scale Y position by 2.  This effectively rotates the landscape into a
		// "birds-eye" view (angle of viewing is perpendicular to ground)
		// (note: makes assumption about angle of viewing!)
		worldY <<= 1;
		
		// Y faces down the screen.
		// Negate this so it faces up (so that we can use regular 2D transformations)
		worldY = -worldY;
		
		// Perform a rotation of 45 degrees, so that we are looking at the world
		// with x increasing to the right and y increasing upwards.
		gridX = ((worldX - worldY) * COSINE_OF_45_FP) >> Utility.FIXED_POS;
		gridY = ((worldX + worldY) * COSINE_OF_45_FP) >> Utility.FIXED_POS;
		
		// We've worked in a coordinate system with Y facing up the screen.
		// Negate this so that we output in a format consistent with the game
		// engine (facing down the screen).
		gridY = -gridY;
		
		// Shift into fixed point
		gridX <<= Utility.FIXED_POS;
		gridY <<= Utility.FIXED_POS;		
		
		// For negative values of X and Y, reduce by one tile size to read
		// as one value less.  Otherwise -TILE_WIDTH/2 will reduce to 0 and
		// not -1.
		if (gridX < 0) 
		{
			gridX -= SKUConsts.TILE_EDGE_LENGTH_FP;
		}
		if (gridY < 0) 
		{
			gridY -= SKUConsts.TILE_EDGE_LENGTH_FP;
		}
		
		// Divide through by tile size to get grid position
		gridX /= SKUConsts.HALF_TILE_EDGE_LENGTH_FP;
		gridY /= SKUConsts.HALF_TILE_EDGE_LENGTH_FP;
		
//START:result 2#
		return new int[] {gridX, gridY};
//END
	}
	
	/**
	 * In French, certain characters should never be wrapped when preceded by a space.
	 * This method replaces instances of spaces which occur before the certain characters
	 *  with a non-wrappable character.
	 * 
	 * @param	text			Text to process
	 * @param encodeNotDecode	Direction of processing
	 * @return	String that is encoded/decoded as specified
	 */
	public static String ProcessStringAgainstWrappingForFrench(String inText, boolean encodeNotDecode)	
	{
		// In French, these characters when preceded by a space are never wrapped
		final String FRENCH_SPACED_CHARACTERS = "!?;:";
		
		// Character occuring in decoded text
		final char DECODED_CHARACTER = ' ';
		
		// Character occuring in encoded text
		final char ENCODED_CHARACTER = '_';
		
		// Determine which characters we're replacing from/to
		final char FROM_CHAR = encodeNotDecode ? DECODED_CHARACTER : ENCODED_CHARACTER;
		final char TO_CHAR = encodeNotDecode ? ENCODED_CHARACTER : DECODED_CHARACTER;
		
		// Create a stringbuffer to hold processed text
		// Set the current position in the processed text to zero
		StringBuffer outText = new StringBuffer();
		int inPos = 0;
				
		// Keep going until the whole string is processed
		while (inPos < inText.length())
		{
			// Find first occurance of replaced character from current position
			int replPos = inText.indexOf(FROM_CHAR, inPos);
			
			// If there is an occurance of the replaced character that isn't at the end of the string
			if ((replPos != -1) && (replPos != inText.length() - 1))
			{				
				// If french replaced character occurs after this
				if (FRENCH_SPACED_CHARACTERS.indexOf(inText.charAt(replPos + 1)) != -1)
				{				
					// Append everything up to the replaced character
					outText.append(inText.substring(inPos, replPos));
					
					// Append replaced character
					outText.append(TO_CHAR);
					
					// Append character after replaced character
					outText.append(inText.charAt(replPos + 1));
					
					// Set current position just beyond character after replaced character
					inPos = replPos + 2;
				}
				else	// Else french replaced character doesn't occur after this
				{								
					// Copy text up to this point and move current position
					outText.append(inText.substring(inPos, replPos + 1));
					inPos = replPos + 1;
				}
			}
			else	// Else there isn't an occurance of the replaced character, or it's at the end of the string
			{							
				// Copy remaining text
				outText.append(inText.substring(inPos));
				
				// Move current position to end to exit on next loop
				inPos = inText.length();
			}
		}
		
		return outText.toString();
	}

	public static void PaintSimoleansValue(Graphics g, int value, int xPos, int yPos, int textColor, int anchor)
	{
		final int INNER_SPACING = 2;
		
		// load 4ever, but it's tiny
		if (s_SimoleansSymbol == null)
		{
			s_SimoleansSymbol = Utility.loadImage("in_game_menus/simolean", true);
			//Debug.assertPrintln(s_SimoleansSymbol != null, "Could not load simoleans symbol.");
		}
		
		// set up the font for the simoleans
		g.setFont(Dialogue.DIALOGUE_FONT);
		
		// Initial positioning
		String valueStr = String.valueOf(value); 
		int totalWidth = s_SimoleansSymbol.getWidth() + INNER_SPACING + g.getFont().stringWidth(valueStr);
		int totalHeight = Math.max(s_SimoleansSymbol.getHeight(), g.getFont().getHeight());
		
		int[] drawPos = Utility.AlterPositionForAnchor(new int[] {xPos, yPos}, anchor, totalWidth, totalHeight);
		
		// Draw simoleans symbol
		Utility.DrawImage(g, s_SimoleansSymbol, drawPos[0], drawPos[1] + g.getFont().getBaselinePosition(), Graphics.BOTTOM | Graphics.LEFT);
		drawPos[0] += INNER_SPACING + s_SimoleansSymbol.getWidth();
		
		// Draw value drop shadow		
		if (textColor != Colors.BLACK)
		{
			g.setColor(Colors.BLACK);
			g.drawString(valueStr, (drawPos[0] + GameDefines.DROP_SHADOW_OFFSET), 
						 (drawPos[1] + g.getFont().getBaselinePosition() + GameDefines.DROP_SHADOW_OFFSET), 
						 (Graphics.BASELINE | Graphics.LEFT) );
		}
		
		// now draw the string
		g.setColor(textColor);
		g.drawString(valueStr, drawPos[0], drawPos[1] + g.getFont().getBaselinePosition(), 
					 (Graphics.BASELINE | Graphics.LEFT) );
		
	} // end PaintSimoleansValue
	
	/**
	 * Applies an anchor to a position
	 * 
	 * @param pos		Position to manipulate
	 * @param anchor	Anchor to apply
	 * @param width		Width of object
	 * @param height	Height of object
	 * @return			New position
	 */
	private static int[] AlterPositionForAnchor(int[] pos, int anchor, int width, int height)
	{
		int[] newPos = new int[] { pos[0], pos[1] };
		
		if ((anchor & Graphics.HCENTER) != 0)
		{
			newPos[0] -= width >> 1;
		}
		else if ((anchor & Graphics.RIGHT) != 0)
		{
			newPos[0] -= width;
		}
		
		if ((anchor & Graphics.VCENTER) != 0)
		{
			newPos[1] -= height >> 1;
		}
		else if ((anchor & Graphics.BOTTOM) != 0)
		{
			newPos[1] -= height;
		}
		
		return newPos;
		
	} // end AlterPositionForAnchor
	
//	public static final int ONE_BYTE_ELEMENT = 1;
//	public static final int TWO_BYTE_ELEMENT = 2;
//	public static final int FOUR_BYTE_ELEMENT = 4;
	
//	public static final boolean USE_RMS = true;
	public static final boolean LOG_JAR_USAGE = false;

	/** Number of binary points used in a fixed point number */
	public static final int FIXED_POS = 8;
	
	/** Mask for fractional bits */
	public static final int FIXED_FRAC_BITS = ~(~0 << FIXED_POS);

	/** Fixed point representation of ONE */
	public static final int FIXED_ONE = 1 << FIXED_POS;
	
	/** Fixed point representation of HALF */
	public static final int FIXED_HALF = FIXED_ONE >> 1;
	
	/** And with a int-casted byte value to treat it as unsigned */
	public static final int UNSIGNED_BYTE_MASK = 0xFF;

	/** Cosine(45) degrees */
	public static final int COSINE_OF_45_FP = (int)(0.707106 * FIXED_ONE);
	
	// Sound identifiers
//	public static final int SOUND_GROW = 0;
//	public static final int SOUND_THEME = 1;
	
	// Encodings
//	public static final String ENCODING_UNICODE_BIG_ENDIAN_16	= "UTF-16BE";

	private static final int BLOCK_SIZE 					= 10240;
	private static final int DEFAULT_IMAGE_HASH_TABLE_SIZE 	= 20;
	private static final int DEFAULT_SOUND_HASH_TABLE_SIZE 	= 20;
	private static final int CACHED_IMAGE_HASH_TABLE_SIZE 	= 100;
//	private static final int CACHED_ANIMM_HASH_TABLE_SIZE 	= 50;
	
	private static final int VOLUME_OF_SOUNDS = 60;
	
	/** directory in jar containing all global data */
	private static final String STAND_ALONE_JAR_GLOBAL_DATA_DIRECTORY = "global_data";

	/*
	 * Public static variables
	 */
	public static Random m_Random = new Random();
	
	// Hack variable.
	// TODO Remove me.
	public static boolean s_DoPlaySounds = true;	
//	public static boolean s_SoundPlaying;
	
	private static Vector soundData;
	private static Vector soundFiles;
	private static Hashtable defaultImages = new Hashtable(DEFAULT_IMAGE_HASH_TABLE_SIZE);	// Hashtable to use for general images
	private static Hashtable defaultSounds = new Hashtable(DEFAULT_SOUND_HASH_TABLE_SIZE);	// Hashtable to use for general sounds
	private static Hashtable s_CachedImages = new Hashtable(CACHED_IMAGE_HASH_TABLE_SIZE);	// Hashtable to use for uid images and image strips
//	private static Hashtable s_Animations = new Hashtable(CACHED_ANIMM_HASH_TABLE_SIZE);	// Hashtable to use for uid images and image strips
	
	/** GUIDs loaded into memory */
	private static Hashtable s_MemoryResources = new Hashtable();
	
	private static Vector s_soundQueue = new Vector();
	
	/** Image of the simoleans symbol */
	private static Image s_SimoleansSymbol;
	
//	private static boolean soundsEnabled = true;
//	private static boolean m_MobileEdithEnabled = false;
	
	/** Last allocated fake GUID (debug purposes only) */
//	private static int s_NextFakeGuid = 0x7FFFFFFF;
	
}
