package tetris;



import javax.microedition.lcdui.Graphics;

import javax.microedition.lcdui.Image;

import java.io.DataInputStream;

import java.io.IOException;



public class blFont {



	public static final int LEFT = 0;

	public static final int CENTER = 1;

	public static final int RIGHT = 2;



	int sx,sy,kx,ky;

	int fc;

	Image img;



	public blFont(String font) {

		try {

			DataInputStream in = new DataInputStream(getClass().getResourceAsStream("/tetris" + font));

			if(((char)in.readUnsignedByte())!='F') {

				return;

			}

			if(((char)in.readUnsignedByte())!='1') {

				return;

			}

			fc=in.readByte();

			sx=in.readByte();

			sy=in.readByte();

			kx=in.readByte();

			ky=in.readByte();

			int pngsize=in.readShort();

			byte png[] = new byte[pngsize];

			for(int loaded=0; loaded<pngsize; ) {

				loaded+=in.read(png, loaded, pngsize-loaded);

			}

			img = Image.createImage(png, 0, pngsize);

			in.close();

		} catch(IOException e) {

		}

	}



	public void draw(Graphics g, String str, int x, int y, int just) {

		int cx = g.getClipX();

		int cy = g.getClipY();

		int cw = g.getClipWidth();

		int ch = g.getClipHeight();

		int l = str.length();



		switch(just) {

		case LEFT:

			break;

		case CENTER:

			x-=(kx*l)/2;

			break;

		case RIGHT:

			x-=kx*l;

			break;

		}



		for(int i=0;i<l;i++) {

			int c = str.charAt(i);

			if(c>=0x00bf) {

				c-=0x00bf-0x005b;

			}

			c-=fc;

			if(c>=0) {

				g.setClip(x, y, sx, sy);

				g.drawImage(img, x-(c*sx), y, Graphics.TOP|Graphics.LEFT);

			}

			x+=kx;

		}



		g.setClip(cx, cy, cw, ch);

	}



	public void drawChar(Graphics g, char c, int x, int y) {

		c-=fc;

		if(c<0) {

			return;

		}



		int cx = g.getClipX();

		int cy = g.getClipY();

		int cw = g.getClipWidth();

		int ch = g.getClipHeight();



		g.setClip(x, y, sx, sy);

		g.drawImage(img, x-(c*sx), y, Graphics.TOP|Graphics.LEFT);



		g.setClip(cx, cy, cw, ch);

	}



	public int getRealWidth() {

		return sx;

	}



	public int getRealHeight() {

		return sy;

	}



	public int getWidth() {

		return kx;

	}



	public int getHeight() {

		return ky;

	}

}

