package tetris;

//import com.sprintpcs.media.Clip;
//import com.sprintpcs.media.Player;
import java.util.Hashtable;
import java.io.IOException;
import javax.microedition.media.*;
import javax.microedition.media.control.*;


public class blSound {

	static Hashtable snds;

	static boolean mute;

	static Player curr;
	static PlayerListener pl;

	static class myPL implements PlayerListener {
		public void playerUpdate(Player player, String event, Object eventData) {
			//System.out.println("event = " + event);
			if (event == PlayerListener.END_OF_MEDIA) {
				player.deallocate();
				curr = null;

			//	tetris.debugSound = false;
			//	bluelava.update();
			}
		}
	}

	static boolean hasSound() {
		return true;
		//return false;
	}

	static void destroy() {
		if(snds!=null) {
			snds.clear();
			snds = null;
		}
	}

	static void load(String file, String type, int priority, int vibrate, String snd_id) throws IOException {
		if (pl == null) {
			pl = new myPL();
		}
		if (snds==null) {
			snds = new Hashtable();
		}
		if (snds.get(snd_id) != null) {
			return;
		}

		try {
			//System.out.println("Loading" +  "/" + file.substring(9));
			Player p = Manager.createPlayer(snds.getClass().getResourceAsStream("/tetris" + "/" + file.substring(9)), type);
			p.realize();
            try {
                VolumeControl control = (VolumeControl)p.getControl("VolumeControl");
                control.setLevel(100);
            }
            catch (Throwable t) {
            }
            
			p.addPlayerListener(pl);
			snds.put(snd_id, p);
		} catch (MediaException m) {
			throw new IOException(m.getMessage());
		}


		//System.out.println("Done loading sounds");
		/*
		// be sure that the storage has been created
		if(snds==null) {
			snds = new Hashtable();
		}
		// be certain that this is unique
		if(snds.get(snd_id)!=null) {
			return;
		}
		Clip c = new Clip(file,type,priority,vibrate);
		snds.put(snd_id,c);
		*/
	}

	static void unload(String snd_id) {
		/*
		Clip c = (Clip)snds.get(snd_id);
		if(c!=null) {
			snds.remove(c);
		}
		*/

		Player p = (Player) snds.get(snd_id);
		if (p != null) {
			p.close();
			snds.remove(p);
		}
	}

	static void play(String snd_id, int repeat) {

		//tetris.scol = false;


		if (!mute && (snds != null) ) {
			Player p = (Player) snds.get(snd_id);
			if (p != null) {
				//p.setLoopCount(repeat);

				int t = -100;
				//System.out.println("STATE = " + p.getState());

				if (p.getState() != p.STARTED) {

					try {
						t = (repeat < 0) ? repeat : repeat + 1;
						p.setLoopCount(t);
						//p.setLoopCount((repeat < 0) ? repeat : repeat + 1);
					}
					catch (Exception e) {
						//System.out.println(" exception : " + t);
					}
				}

				try {

					if (curr != null) {
						stop();
						//tetris.scol = true;
						//bluelava.update();
						//curr.deallocate();
					}

					//p.prefetch();
					p.start();
					curr = p;

					//tetris.debugSound = true;

				} catch (MediaException m) {
					//Log.print("PLAY : " + m.getMessage());
				}




			}

		}

		//System.out.println("I tried to play it...");

		/*
		if(!mute&&(snds!=null)) {
			Clip c = (Clip)snds.get(snd_id);
			if(c!=null) {
				Player.play(c,repeat);
			}
		}
		*/
	}

	static void stop() {
		//Player.stop();
		if (curr != null) {
			try {
				curr.stop();
				curr.deallocate();

				//curr = null;
				//tetris.scol = true;
				//bluelava.update();
			}
			catch (Exception e) {

			}
			curr = null;
		}
	}

	static void pause() {
		//Player.pause();
	}

	static void resume() {
		//Player.resume();
	}

	static void mute(boolean yesno) {
		mute=yesno;
		if(mute) {
		//	Player.stop();
			stop();
		}
	}

	static boolean isMute() {
		return mute;
	}
}
