package tetris;

/* bluelava.java - Nokia 3595 Version
 * Using FullCanvas to take advantage of the whole screen.
 * FullCanvas does not support addCommand or setCommandListener
 */

import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;
import java.util.TimerTask;
import java.util.Timer;
import java.util.Hashtable;
import java.util.Vector;
import java.util.NoSuchElementException;
import java.util.Enumeration;
import java.io.*;
import javax.microedition.rms.*;

//nokia specific
//import com.nokia.mid.ui.FullCanvas;

public class bluelava extends shell.core.GameMIDlet {


	static boolean	isDemo	= true;

	public static final int KEY_INVALID = 0;

	public static final int KEY_SOFTKEY1 = -6;
	public static final int KEY_SOFTKEY2 = -7;

	static final int FULLSCREEN_WIDTH   = 240;
	static final int FULLSCREEN_HEIGHT  = 320;

	static final int LEFTSOFT_X         = 2;
	static final int RIGHTSOFT_X        = FULLSCREEN_WIDTH - 3;
	static final int SOFTKEY_Y          = FULLSCREEN_HEIGHT - 15;


	/* Removed since Softkeys are not supported
	public static final int SOFTACTION_SWAP = 0;
	public static final int SOFTACTION_PUSH = 1;
	public static final int SOFTACTION_POP = 2;
	public static final int SOFTACTION_ONLY = 3;
	public static final int SOFTACTION_SELECT = 4;
	*/

	public static blGame game;

	public static bluelava midlet;
	public static bluelava inst;
	static handler hand;
	static Hashtable dids;
	static Vector dstack;
	static Vector softcmds;

	static Timer heart;
	static int heartRef;

	static Image bg;

//	static Command nocmds;
	boolean paused;
	boolean pausedBypauseApp;

	static int loading,load_size,load_x,load_y,load_inc;
	static boolean is_loading;

	static class heartTask extends TimerTask {

		public void run() {
			if(heartRef>0) {
				int s=dstack.size();
				for(int i=0;i<s;i++) {
					if(((blDest)(dstack.elementAt(i))).heartbeat()) {
						break;
					}
				}
			}
		}
	}

//static String dbString;

	static class handler extends Canvas { //FullCanvas  {
		//
		// implements CommandListener

		handler() {
			setFullScreenMode(true);
		}

		boolean all;

		protected void paint(Graphics g) {
			try {
				if(all) {
					all=false;
					int s=dstack.size();
					// scan the stack to find out who the "owner" of the screen is...
					int h;
					for(h=0;h<s-1;h++) {
						if(((blDest)(dstack.elementAt(h))).owns_bg) {
							break;
						}
					}
					// draw from the "owner" forward
					for(int i=h;i>=0;i--) {
						((blDest)(dstack.elementAt(i))).paint(g,true);
					}
				} else {
					blDest d=getActiveDest();
					if(d!=null) {
						d.paint(g,false);
					} else {
						g.drawImage(bluelava.bg,0,0,Graphics.TOP|Graphics.LEFT);
						paintLoading(g);
					}
				}
/*
				g.setClip(0,0,100,20);
				g.setColor(0);
				g.fillRect(0,0,100,20);
				g.setColor(0x00FF0044);
				g.drawString(dbString, 0, 0, Graphics.TOP | Graphics.LEFT);
*/

			} catch(Exception e) {
                                e.printStackTrace();
				return;
			}
		}



		protected void keyRepeated(int keyCode) {
			int k=decodeKey(keyCode);
			if(k!=KEY_INVALID) {
				int s=dstack.size();
				for(int i=0;i<s;i++) {
					if(((blDest)(dstack.elementAt(i))).keyRepeated(k)) {
						break;
					}
				}
			}
		}

		protected void keyPressed(int keyCode) {

			/*
			if (keyCode == KEY_POUND) {

		      Log.show(Display.getDisplay(bluelava.midlet)) ;

      		return;
			}
			*/


			int k=decodeKey(keyCode);
			if(k!=KEY_INVALID) {
				int s=dstack.size();
				for(int i=0;i<s;i++) {
					if(((blDest)(dstack.elementAt(i))).keyPressed(k)) {
						break;
					}
				}
			}
		}

		protected void keyReleased(int keyCode) {
			int k=decodeKey(keyCode);
			if(k!=KEY_INVALID) {
				int s=dstack.size();
				for(int i=0;i<s;i++) {
					if(((blDest)(dstack.elementAt(i))).keyReleased(k)) {
						break;
					}
				}
			}
		}

		protected void showNotify() {
			System.gc() ;
			if (!bluelava.inst.pausedBypauseApp) {
				bluelava.inst.resumeApp();
			}
		}

		protected void hideNotify() {
			System.gc() ;
			bluelava.inst.pauseApp_();
		}

/*
		public void commandAction(Command c, Displayable d) {
			softCmd sc=(softCmd)c;
			switch(sc.action) {
			case SOFTACTION_SWAP:
				swap(sc.d,null);
				break;
			case SOFTACTION_PUSH:
				push(sc.d,null);
				break;
			case SOFTACTION_POP:
				pop();
				break;
			case SOFTACTION_ONLY:
				only(sc.d,null);
				break;
			case SOFTACTION_SELECT:
				int s=dstack.size();
				for(int i=0;i<s;i++) {
					if(((blDest)(dstack.elementAt(i))).keyPressed(blDest.KEY_SELECT)) {
						break;
					}
				}
				break;
			}
		}
*/
	}

/* Removed since soft commands cannot be used with FullCanvas
	static class softCmd extends Command {
		public String d;
		public blDest owner;
		public int action;

		public softCmd(String label, String dest_id, int priority, int softaction, blDest owner) {
			super(label,Command.SCREEN,priority);
			d=dest_id;
			this.owner=owner;
			this.action=softaction;
		}
	}
*/

	public bluelava() {
		paused=false;
		midlet=this;
		inst=this;
		heartRef=0;
		dids= new Hashtable();
		dstack= new Vector();
		softcmds = new Vector();
		game = new blGame();
//		nocmds = new Command(" ",Command.SCREEN,1);

        //try {
		//	isDemo	= false;
		//} catch(Exception e) {
		//}

	}

	public void startApp() {
		pausedBypauseApp = false;
		if(paused) {
			resumeApp();
		} else {
			Display disp = getDisplay();
			hand = new handler();
			disp.setCurrent(hand);
			// hand.setCommandListener(hand);
			bg=Image.createImage(hand.getWidth(),hand.getHeight());
			// kickstart the app
			game.start();
		}
	}

	public void pauseApp() {
		System.gc();
		pausedBypauseApp = true;
	}

	protected void pauseApp_() {
		System.gc();
		if(paused) {
			return;
		}
		paused=true;
		try {
			blDest d=(blDest)dstack.firstElement();
			d.pause();
		} catch(NoSuchElementException e) {
		}
		blSound.pause();
	}

	void resumeApp() {
		System.gc();
		if(!paused) {
			return;
		}
		paused=false;
		try {
			blDest d=(blDest)dstack.firstElement();
			d.resume();
			updateAll();
		} catch(NoSuchElementException e) {
		}
		blSound.resume();
	}

	public void destroyApp(boolean unconditional) {
//		savePrefs();
		Display disp = getDisplay();
		disp.setCurrent(null);
		blSound.destroy();
	}

	public static blDest getActiveDest() {
		try {
			return (blDest)dstack.firstElement();
		} catch(NoSuchElementException e) {
		}
		return null;
	}

	public static boolean isActiveDest(String dest_id) {
		try {
		return dids.get(dest_id)==dstack.firstElement();
		} catch(NoSuchElementException e) {
		}
		return false;
	}

	public static void addDest(blDest dest, String dest_id) {
		dids.put(dest_id,dest);
		dest.setID(dest_id);
	}

	synchronized public static void push(String dest_id, Object obj) {
		blDest d;
		// deactivate() the active dest
		try {
			d=(blDest)dstack.firstElement();
			d.deactivating();
			// hideSoftCmds();
			d.deactivated();
		} catch(Exception e) {
                    e.printStackTrace();
		}
		// grab the new dest
		d=(blDest)dids.get(dest_id);
		if(d!=null) {
			// create() and activate() it
			d.create(obj);
			d.activating();
			dstack.insertElementAt(d,0);
			// showSoftCmds();
			if(d.owns_bg) {
				d.generateBG(bg.getGraphics(), hand.getWidth(), hand.getHeight());
			}
			d.activated();
			update();
		}
	}

	synchronized public static void pop() {
		blDest d;
		// deactivate() and destroy() the active dest
		try {
			d=(blDest)dstack.firstElement();
			d.deactivating();
			boolean was_owner=d.owns_bg;
			// deleteSoftCmds();
			dstack.removeElement(d);
			d.deactivated();
			d.destroy();
			System.gc();
			// activate() the new active dest
			d=(blDest)dstack.firstElement();
			d.activating();
			// showSoftCmds();
			// if this was an "owner", then find the next "owner" in the list and have it generate
			if(was_owner) {
				blDest od;
				int s=dstack.size();
				// scan the stack to find out who the "owner" of the screen is...
				for(int i=0;i<s;i++) {
					od=(blDest)(dstack.elementAt(i));
					if(od.owns_bg) {
						od.generateBG(bg.getGraphics(), hand.getWidth(), hand.getHeight());
						break;
					}
				}
			}
			d.activated();
			updateAll();
		} catch(Exception e) {
                    e.printStackTrace();
		}
	}

	synchronized public static void swap(String dest_id, Object obj) {
		blDest d;
		// deactivate() and destroy() the active dest
		try {
			d=(blDest)dstack.firstElement();
			d.deactivating();
			// deleteSoftCmds();
			dstack.removeElement(d);
			d.deactivated();
			d.destroy();
			System.gc();
		} catch(Exception e) {
                    e.printStackTrace();
                }
                
		// grab the new dest
		d=(blDest)dids.get(dest_id);
		if(d!=null) {
			// create() and activate() it
			d.create(obj);
			d.activating();
			dstack.insertElementAt(d,0);
			// showSoftCmds();
			if(d.owns_bg) {
				d.generateBG(bg.getGraphics(), hand.getWidth(), hand.getHeight());
			}
			d.activated();
			updateAll();
		}
	}

	synchronized public static void only(String dest_id, Object obj) {
		blDest d;
		// deactivate() and destroy() ALL dests
		try {
			while(dstack.size()>0) {
				d=(blDest)dstack.firstElement();
				d.deactivating();
				// deleteSoftCmds();
				dstack.removeElement(d);
				d.deactivated();
				d.destroy();
			}
			System.gc();
		} catch(Exception e) {
                    e.printStackTrace();
		}
		// grab the new dest
		d=(blDest)dids.get(dest_id);
		if(d!=null) {
			// create() and activate() it
			d.create(obj);
			d.activating();
			dstack.insertElementAt(d,0);
			// showSoftCmds();
			if(d.owns_bg) {
				d.generateBG(bg.getGraphics(), hand.getWidth(), hand.getHeight());
			}
			d.activated();
			updateAll();
		}
	}

	public static void enableHeart() {
		if(heartRef==0) {
			heart = new Timer();
			heart.schedule(new heartTask(),200,200);
		}
		heartRef++;
	}

	public static void disableHeart() {
		if(heartRef>0) {
			heartRef--;
			if(heartRef<=0) {
				heartRef = 0;
				heart.cancel();
				heart=null;
			}
		}
	}

	public static void exit() {
//		((bluelava)midlet).savePrefs();
		midlet.notifyDestroyed();
	}

	protected static int decodeKey(int keyCode) {
		switch(keyCode) {
		case KEY_SOFTKEY1:
			return blDest.KEY_LEFTSOFT;
		case KEY_SOFTKEY2:
			return blDest.KEY_RIGHTSOFT;
		case Canvas.KEY_NUM0:
			return blDest.KEY_0;
		case Canvas.KEY_NUM1:
			return blDest.KEY_1;
		case Canvas.KEY_NUM2:
			return blDest.KEY_2;
		case Canvas.KEY_NUM3:
			return blDest.KEY_3;
		case Canvas.KEY_NUM4:
			return blDest.KEY_4;
		case Canvas.KEY_NUM5:
			return blDest.KEY_5;
		case Canvas.KEY_NUM6:
			return blDest.KEY_6;
		case Canvas.KEY_NUM7:
			return blDest.KEY_7;
		case Canvas.KEY_NUM8:
			return blDest.KEY_8;
		case Canvas.KEY_NUM9:
			return blDest.KEY_9;
		case Canvas.KEY_STAR:
			return blDest.KEY_STAR;
		case Canvas.KEY_POUND:
			return blDest.KEY_POUND;
		}
		switch(hand.getGameAction(keyCode)) {
		case Canvas.UP:
			return blDest.KEY_UP;
		case Canvas.DOWN:
			return blDest.KEY_DOWN;
		case Canvas.LEFT:
			return blDest.KEY_LEFT;
		case Canvas.RIGHT:
			return blDest.KEY_RIGHT;
		case Canvas.FIRE:
			return blDest.KEY_FIRE;

		}
		return KEY_INVALID;
	}

	public static void update() {
		hand.repaint();
		hand.serviceRepaints();
	}

	public static void updateAll() {
		hand.all=true;
		update();
	}

	/*
	public static void addSoftCmd(String label, int priority, int action, String dest_id, String owner_id) {
		softCmd sc = new softCmd(label,dest_id,priority,action,(blDest)dids.get(owner_id));
//		hand.removeCommand(nocmds);
		hand.addCommand(sc);
		softcmds.addElement(sc);
	} */

	/*
	static void showSoftCmds() {
		blDest d=getActiveDest();
		softCmd sc;

//		hand.removeCommand(nocmds);
		for(Enumeration e=softcmds.elements();e.hasMoreElements();) {
			sc=(softCmd)e.nextElement();
			if(sc.owner==d) {
				hand.addCommand(sc);
			}
		}
	} */

	/*
	static void hideSoftCmds() {
		blDest d=getActiveDest();
		softCmd sc;
		for(Enumeration e=softcmds.elements();e.hasMoreElements();) {
			sc=(softCmd)e.nextElement();
			if(sc.owner==d) {
				hand.removeCommand(sc);
			}
		}
//		hand.addCommand(nocmds);
	} */

	/*
	static void deleteSoftCmds() {
		blDest d=getActiveDest();
		softCmd sc;
		for(int i=softcmds.size()-1;i>=0;i--) {
			sc=(softCmd)softcmds.elementAt(i);
			if(sc.owner==d) {
				hand.removeCommand(sc);
				softcmds.removeElement(sc);
			}
		}
//		hand.addCommand(nocmds);
	} */

	static int getWidth() {
		return hand.getWidth();
	}

	static int getHeight() {
		return hand.getHeight();
	}

	public static void loadPrefs() {
		try {
			RecordStore prefs = RecordStore.openRecordStore("prefs", true);
			byte[] data = prefs.getRecord(1);
			DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
			game.loadPrefs(dis);
			dis.close();
			prefs.closeRecordStore();
		} catch(Exception e) {
			game.resetAllPrefs();
		}
	}

	public static void savePrefs() {
		try {
			ByteArrayOutputStream bao = new ByteArrayOutputStream();
			DataOutputStream dos = new DataOutputStream(bao);
			game.savePrefs(dos);
			dos.close();
			byte[] data = bao.toByteArray();

			bao.close();
			RecordStore prefs = RecordStore.openRecordStore("prefs", true);
			try {
				prefs.setRecord(1,data,0,data.length);
			} catch(InvalidRecordIDException e) {
				prefs.addRecord(data,0,data.length);
			}
			/*
			if(prefs.getSize() > 40) {
				prefs.setRecord(1,data,0,data.length);
			} else {
				prefs.addRecord(data,0,data.length);
			}*/

			prefs.closeRecordStore();
		} catch(Exception e) {
		}
	}

	static public void startLoading() {
		loading=0;
		load_inc=1;
		int w=getWidth();
		load_size=(w-4)/8;
		load_x=(w-(load_size*8))/2;
		load_y=getHeight()-6;
		is_loading=true;
	}

	static public void stopLoading() {
		is_loading=false;
	}

	static public void updateLoading() {
		update();
		loading+=load_inc;
		if(loading>=8) {
			loading=6;
			load_inc=-1;
		}
		if(loading<0) {
			loading=1;
			load_inc=1;
		}
	}

	static public void paintLoading(Graphics g) {
		if(is_loading) {
			g.setColor(64,64,128);
			g.fillRect(load_x,load_y,load_size*8,3);
			g.setColor(192,192,255);
			g.fillRect(load_x+(loading*load_size),load_y,load_size,3);
		}
	}

	static public boolean canLaunchBrowser() {
		return true;
	}

	static public void launchBrowser(String url) {
		// *CHANGE* comment by grant
		// com.sprintpcs.util.System.setExitURI(url);
		// bluelava.exit()

		//try {
		//	bluelava.inst.platformRequest(url);//at&t
		//	bluelava.exit();
		//}
		//catch (javax.microedition.io.ConnectionNotFoundException c) {
		//	//bluelava.push("paused", null);
		//}
		//catch (Exception e) {
		//	//bluelava.push("exitconfirm", null);
		//	//System.out.println("Doesn't work");
		//}
	}
}
