package tetris;



import javax.microedition.lcdui.*;



public class tePiece {



	public static final int PIECE_STARTX = 4;  

	public static final int PIECE_STARTY = teWell.WELL_SKYLINE;



	public static final int PIECE_FACE_N = 0;

	public static final int PIECE_FACE_E = 1;

	public static final int PIECE_FACE_S = 2;

	public static final int PIECE_FACE_W = 3;



	int face;



	int x;

	int y;



	int ghostY;



	teTetri tetri;



	teWell well;

	

	tePiece(teTetri t, teWell w) {

		tetri = t;

		well = w;

		x = PIECE_STARTX;

		y = PIECE_STARTY;

		face = PIECE_FACE_N;

		recalcGhost();

	}



	public void paint(Graphics g, int wx, int wy, int minosize) {

		int px = wx+(x*minosize);

		int py = wy-(teWell.WELL_SKYLINE*minosize);

		if(tetris.ghost) {

			tetri.paintGhost(g, px, py+(ghostY*minosize), face);

		}

		tetri.paint(g, tetri.minoType, px, py+(y*minosize), face);

	}



	public void resetPosition() {

		x = PIECE_STARTX;

		y = PIECE_STARTY;

	}



	public boolean moveLeft() {

		if(isFree(-1, 0, face)) {

			x--;

			recalcGhost();

			return true;

		}

		return false;

	}



	public boolean moveRight() {

		if(isFree(1, 0, face)) {

			x++;

			recalcGhost();

			return true;

		}

		return false;

	}



	public boolean rotateCW() {

		return rotate((face>=tetri.maxFace)?PIECE_FACE_N:face+1);

	}



	public boolean rotateCCW() {

		return rotate((face<=PIECE_FACE_N)?tetri.maxFace:face-1);

	}



	public boolean rotate(int new_facing) {

		int nx,ny,s;

		int shsx,shsy;

		int dhsx,dhsy;

	

		for(s=0;s<teTetri.TETRI_MARKS;s++) {

			// calc the adjustment to the position caused by a rotation

			shsx=tetri.getMarkerX(s,face);

			shsy=tetri.getMarkerY(s,face);

			dhsx=tetri.getMarkerX(s,new_facing);

			dhsy=tetri.getMarkerY(s,new_facing);

			nx=shsx-dhsx;

			ny=shsy-dhsy;

			// validate this scheme

			if(isFree(nx,ny,new_facing)) {

				face=new_facing;

				x+=nx;

				y+=ny;

				recalcGhost();

				return true;

			}

		}

		return false;

	}



	public boolean fall(teStats stats, boolean softdrop) {

		// touchdown?

		if(!tetri.canFall(well, x, y, face)) {

			return false;

		}



		y++;

		if(softdrop) {

			stats.scored(1);

		}



		if(!tetri.canFall(well, x, y, face)) {

			return false;

		}



		return true;

	}



	public void hardDrop(teStats stats) {

		while(tetri.canFall(well, x, y, face)) {

			y++;

			stats.scored(2);

		}

	}



	public boolean lock() {

		return tetri.lock(well, x, y, face);

	}



	public boolean isFree(int xAdj, int yAdj, int facing) {

		int cx = x + xAdj;

		int cy = y + yAdj;



		if(facing==-1) {

			facing = face;

		}



		return tetri.isFree(well, cx, cy, facing);

	}



	public boolean canFall() {

		return tetri.canFall(well, x, y, face);

	}



	void recalcGhost() {

		ghostY = y;

		while(tetri.canFall(well, x, ghostY, face)) {

			ghostY++;

		}

	}

}

