package tetris;

import java.lang.Thread;
import java.lang.InterruptedException;

class teSim extends Thread {

	public boolean playing;
	boolean suicide;

	int paused;
	boolean wokenUp;

	boolean softDrop;
	boolean pausable; //for Nokia with fake soft keys

	public tePiece thePiece;
	public teWell theWell;
	public teNext nextQueue;
	public teStats theStats;

	tePhase phase;
	tePhaseGeneration genPhase;
	tePhaseFalling fallPhase;
	tePhaseLock lockPhase;
	tePhaseEliminate elimPhase;
	tePhaseEnd endPhase;

	tePhase phaseStack;

	boolean canHold;
	tePiece holdPiece;
	boolean holdDirty;

	static boolean movingLeft;
	static boolean movingRight;
	static boolean movingDown;
	boolean busy;

	long nodrift;

	public static boolean pushPauseAfterLoading = false ;
	int demoCount;

	abstract class tePhase {
		abstract public void init(teSim sim);
		abstract public void run(teSim sim);
	}

	class tePhaseGeneration extends tePhase {
		public void init(teSim sim) {

			 if(bluelava.isDemo && --demoCount<0) {
				//bluelava.push("demoover", null);
                bluelava.exit();
				sim.setPhase(sim.endPhase);
				return;
			}

//			sim.movingLeft=false;
//			sim.movingRight=false;
			sim.softDrop=false;
			sim.canHold = true;
			System.gc();
			sim.theStats.nextPiece();
			sim.theStats.processLevelUp(sim);
		}
		public void run(teSim sim) {
			sim.theWell.touch();
			bluelava.update();
			delay(500);
			// grab the next piece
			sim.thePiece = sim.nextQueue.pop(sim.theWell);
			// be sure that it's start location is free
			if(!sim.thePiece.isFree(0, 0, -1)) {
				// TOP OUT!
				sim.setPhase(sim.endPhase);
				return;
			}
			// start falling phase
			sim.setPhase(sim.fallPhase);
		}
	}

	class tePhaseFalling extends tePhase {

		long rate;

		public void init(teSim sim) {
			sim.softDrop = false;
			int lev = sim.theStats.level;
			if(lev>=15) {
				rate = 25;
			} else {
				if(lev<10) {
					rate = 1000-((lev-1)*100);
				} else {
					rate = 100-((lev-10)*15);
				}
			}
		}
		public void run(teSim sim) {
			boolean soft = sim.softDrop;
			long r = (soft)?25:rate;

			if(sim.delay(r)) {
				while(sim.busy){}
				if(sim.thePiece!=null) {
					busy=true;
					if(!sim.thePiece.fall(sim.theStats, soft)) {
						sim.setPhase(lockPhase);
					}
					busy=false;
				}
			}
		}
	}

	class tePhaseLock extends tePhase {
		public void init(teSim sim) {
		}
		public void run(teSim sim) {
			if(delay(500)) {
				if(sim.thePiece!=null&&!sim.busy) {
					busy=true;
					// verify that the piece should lock
					if(sim.thePiece.canFall()) {
						sim.setPhase(sim.fallPhase);
					} else {
						// lock the piece
						boolean lockout = sim.thePiece.lock();
						sim.thePiece = null;
                        sim.movingDown = false;
						if(lockout) {
							// we have been locked out, start the end phase
							sim.setPhase(sim.endPhase);
						} else {
							// start eliminate phase
							sim.setPhase(sim.elimPhase);
						}
					}
					busy=false;
				}
			} else {
				if(sim.thePiece!=null) {
					sim.theStats.scored(-1);
					if(sim.thePiece.canFall()) {
						sim.setPhase(sim.fallPhase);
					}
				}
			}
		}
	}

	class tePhaseEliminate extends tePhase {
		public void init(teSim sim) {
		}
		public void run(teSim sim) {
			int l = sim.theWell.needsCleaning();
			if(l<=0) {
				blSound.play("lock",0);
				sim.setPhase(sim.genPhase);
				return;
			}
			sim.theStats.clearedLines(l);
			// make white
			sim.theWell.setElimState(255);
			bluelava.update();
//			sim.delay(100);
			// make normal
			sim.theWell.setElimState(0);
			bluelava.update();
//			sim.delay(100);
			// make white
			sim.theWell.setElimState(255);
			bluelava.update();
//			sim.delay(100);
			// make 75%
			sim.theWell.setElimState(192);
			bluelava.update();
//			sim.delay(100);
			// make 50%
			sim.theWell.setElimState(128);
			bluelava.update();
//			sim.delay(100);
			// make 25%
			sim.theWell.setElimState(64);
			bluelava.update();
//			sim.delay(100);
			sim.theWell.setElimState(0);

			sim.theWell.eliminate();
			bluelava.update();
			sim.theStats.checkLevelUp(sim);
			sim.setPhase(sim.genPhase);
		}
	}

	class tePhaseEnd extends tePhase {
		public void init(teSim sim) {
			pausable = false;
			sim.theStats.pause();
		}
		public void run(teSim sim) {
            tetris.loaded = false;
            //Log.print("playing gameover sound") ;
			blSound.play("gameover",0);
			tePiece p = sim.thePiece;
			if(p!=null) {
				for(int i=0;i<15;i++) {
					sim.thePiece = p;
					bluelava.update();
					sim.delay(100);
					sim.thePiece = null;
					bluelava.update();
					sim.delay(100);
				}
			} else {
				sim.delay(3000);
			}
			if(bluelava.isActiveDest("tetris")) {
				sim.playing = false;
				if(bluelava.isDemo) {
                    if (shell.Build.VODAFONE) {
                        bluelava.push("demooverend", null);
                    }
                    else {
                        //bluelava.push("demoover", null);
                        bluelava.exit();
                    }
                    //bluelava.exit();
                }
				else {
					bluelava.swap("records",sim.theStats.pack());
                }
			}
		}
	}

	teSim() {
		thePiece = null;
		bluelava.updateLoading();
		theWell = new teWell();
		bluelava.updateLoading();
		nextQueue = new teNext();
		bluelava.updateLoading();
		theStats = new teStats();
		bluelava.updateLoading();

		phase = null;
		genPhase = new tePhaseGeneration();
		bluelava.updateLoading();
		fallPhase = new tePhaseFalling();
		bluelava.updateLoading();
		lockPhase = new tePhaseLock();
		bluelava.updateLoading();
		elimPhase = new tePhaseEliminate();
		bluelava.updateLoading();
		endPhase = new tePhaseEnd();
		bluelava.updateLoading();

		playing = true;
		paused = 0;

		movingLeft=false;
		movingRight=false;
		movingDown=false;
		busy=false;

		touchHold();
	}

	public void destroy() {
		suicide = true;
		playing = false;
		wakeUp();
	}

	public void run() {
		bluelava.updateLoading();
		nextQueue.init();
		bluelava.updateLoading();
		theStats.levelUp(this);
		bluelava.updateLoading();
		nodrift = System.currentTimeMillis();
		bluelava.updateLoading();

//		teSound.play(teSound.GAMESTART);
		theStats.resume();

		demoCount = 14;
		pausable = true;

		setPhase(genPhase);
		//bluelava.addSoftCmd("Pause",1,bluelava.SOFTACTION_PUSH,"paused","tetris");
		bluelava.stopLoading();
		blSound.play("gamestart",0);
		bluelava.update();
		theStats.reinit();
		theStats.resume();

		if(pushPauseAfterLoading){
			bluelava.push("paused",null);
			pushPauseAfterLoading=false ;
		}

//		theStats.score = (int)Runtime.getRuntime().freeMemory();
		while(playing) {
			if(theStats.tickle()) {
				phase=null;
				theStats.pause();
				bluelava.update();
				teGameStatPack sp=theStats.pack();
				blSound.play("tetrisx2",0);
				delay(3000);
				bluelava.swap("records",sp);
				break;
			}
			bluelava.update();
			if(phase!=null) {
				phase.run(this);
			}
		}
	}

	public void setPhase(tePhase newPhase) {
		phase = newPhase;
		phase.init(this);
	}

	public void moveLeft() {
		if(busy) {
			return;
		}
		if(phase==fallPhase) {
			busy=true;
			if(thePiece.moveLeft()) {
				bluelava.update();
			}
			busy=false;
			return;
		}
		if(phase==lockPhase) {
			busy=true;
			if(thePiece.moveLeft()) {
				wakeUp();
				bluelava.update();
			}
			busy=false;
			return;
		}
	}

	public void moveRight() {
		if(busy) {
			return;
		}
		if(phase==fallPhase) {
			busy=true;
			if(thePiece.moveRight()) {
				bluelava.update();
			}
			busy=false;
			return;
		}
		if(phase==lockPhase) {
			busy=true;
			if(thePiece.moveRight()) {
				wakeUp();
				bluelava.update();
			}
			busy=false;
			return;
		}
	}

	void moveDown() {
		if(busy) {
			return;
		}
		if(phase==fallPhase) {
			busy=true;
			if(thePiece.fall(theStats, true)) {
				//bluelava.update();
			}
            bluelava.update();
			busy=false;
			return;
		}
		if(phase==lockPhase) {
			busy=true;
			if(thePiece.fall(theStats, true)) {
				wakeUp();
				//bluelava.update();
			}
            bluelava.update();
			busy=false;
			return;
		}

	}


	public void rotateCW() {
		if(busy) {
			return;
		}
		if(phase==fallPhase) {
			busy=true;
			if(thePiece.rotateCW()) {
				bluelava.update();
			}
			busy=false;
			return;
		}
		if(phase==lockPhase) {
			busy=true;
			if(thePiece.rotateCW()) {
				wakeUp();
				bluelava.update();
			}
			busy=false;
			return;
		}
	}

	public void rotateCCW() {
		if(busy) {
			return;
		}
		if(phase==fallPhase) {
			busy=true;
			if(thePiece.rotateCCW()) {
				bluelava.update();
			}
			busy=false;
			return;
		}
		if(phase==lockPhase) {
			busy=true;
			if(thePiece.rotateCCW()) {
				wakeUp();
				bluelava.update();
			}
			busy=false;
			return;
		}
	}

	public void hardDrop() {
		if(busy) {
			return;
		}
		if((phase==fallPhase)||(phase==lockPhase)) {
			busy=true;
			thePiece.hardDrop(theStats);
			thePiece.lock();
			thePiece = null;
			setPhase(elimPhase);
			busy=false;
			wakeUp();
		}
	}

	public void softDropOn() {
		softDrop = true;
		if(phase==fallPhase) {
			wakeUp();
		}
	}

	public void softDropOff() {
		softDrop = false;
	}

	public void hold() {
		if(phase==fallPhase||phase==lockPhase) {
			if(canHold) {
				canHold = false;
				tePiece p = holdPiece;
				holdPiece = thePiece;
				holdPiece.face = tePiece.PIECE_FACE_N;
				if(p==null) {
					// grab a new piece
					thePiece = nextQueue.pop(theWell);
				} else {
					thePiece = p;
					thePiece.resetPosition();
				}
				thePiece.recalcGhost();
				wakeUp();
				// be sure that it's start location is free
				if(!thePiece.isFree(0, 0, -1)) {
					// TOP OUT!
					setPhase(endPhase);
					return;
				}
				// start falling phase
				setPhase(fallPhase);
				// dirty the hold
				touchHold();
			}
		}
	}

	synchronized boolean delay(long time) {
		long now = System.currentTimeMillis();
		if(time>0) {
			time-=now-nodrift;
			if(time<=0) {
				time=1;
			}
		}
		try {
			if(!suicide) {
				wait(time);
				nodrift = System.currentTimeMillis();
			} else {
				return false;
			}
			if(paused>0) {
				delay(0);
				bluelava.update();
				return delay(time);
			}
		} catch(InterruptedException e) {
		}
		if(wokenUp) {
			wokenUp = false;
			return false;
		}
		return true;
	}

	synchronized void wakeUp() {
		try {
			wokenUp = true;
			this.notifyAll();
		} catch(IllegalMonitorStateException e) {
		}
	}

	public void pause() {
//		Log.print("teSim::pause()") ;
		paused++;
		if(paused<=1) {
			theStats.pause();
			movingLeft=false;
			movingRight=false;
			movingDown=false;
			softDrop=false;
			theWell.setPaused(true);
			nextQueue.setPaused(true);
			touchHold();
			bluelava.update();
		}
	}

	public void resume() {
//		Log.print("teSim::resume()") ;
		paused--;
		if(paused<=0) {
			theStats.resume();
			movingLeft=false;
			movingRight=false;
			movingDown=false;
			softDrop=false;
			theWell.setPaused(false);
			nextQueue.setPaused(false);
			touchHold();
			paused=0;
			wakeUp();
		}
	}

	public boolean isHoldDirty() {
		return holdDirty;
	}

	public void touchHold() {
		holdDirty = true;
	}

	public void cleanHold() {
		holdDirty = false;
	}

	public boolean isPaused() {
		return paused>0;
	}
}
