package tetris;



import javax.microedition.lcdui.Graphics;

public class teStats {

	boolean dirty;

	boolean paused;

	int level;

	int goal;

	int score;

	int lines;

	int levmult;

	boolean lastWasTetris;

	int pgoal;		// ,pscore

	boolean leveledup;

	boolean np;

	long autodirty;

	long time;

	long base,elapsed;

	long lasttime;



	public teStats() {

		level = tetris.start_level-1;//0;

		goal = 0;

		score = 0;

		lines = 0;

		lastWasTetris = false;

		dirty = true;

		leveledup=false;

		np=false;

		autodirty=0;

		paused=false;

	}

	public boolean tickle() {

		if(paused) {

			return false;

		}

		// returns true if game is complete

		switch(tetris.gametype) {

		case tetris.GAMETYPE_ULTRA:

			time=180-(((System.currentTimeMillis()-base)+elapsed)/1000);

			if(time!=lasttime) {

				lasttime=time;

				touch();

			}

			if(time<=0) {

				return true;

			}

			break;

		case tetris.GAMETYPE_40LINES:

			time=((System.currentTimeMillis()-base)+elapsed)/1000;

			if(time!=lasttime) {

				lasttime=time;

				touch();

			}

			if(goal<=0) {

				return true;

			}

			break;

		}

		return false;

	}



	void reinit() {

		

		base = System.currentTimeMillis();

		elapsed = 0;

	}



	public void pause() {

		

		if(paused) {

		

			return;

		}

		long now=System.currentTimeMillis();

		elapsed+=now-base;

		paused=true;

	}



	public void resume() {

		

		base=System.currentTimeMillis();

		paused=false;

	}



	public void paintStats(Graphics g, int px, int levelY, int goalY) {

		if(tetris.gametype==tetris.GAMETYPE_CLASSIC) {

			drawDigits(g,px,levelY,level,false);

		} else {

			drawDigits(g,px,levelY,(int)time,false);

		}

		drawDigits(g,px,goalY,(goal>0)?goal:0,false);

		if(pgoal<0) {

			drawDigits(g,px,goalY+7,pgoal,true);

		}

	}



	public void paintScore(Graphics g, int px, int scoreY) {

		drawDigits(g, px, scoreY, score,false);

//		if(pscore>0) {

//			drawDigits(g,px,scoreY+7,pscore,true);

//		}

	}



	public void nextPiece() {

		if(!np) {

			autodirty=System.currentTimeMillis()+3000;

			np=true;

		}

	}



	void drawDigits(Graphics g, int x, int y, int val, boolean sign) {

		String s;

		boolean first = false;

		int digs = 0;

		int div = 100000;

		int v,z;

		if(val==0) {

//			teBG.drawText(g,"0",x,y,teBG.CENTER);

			teBG.alpha5.draw(g,"0",x,y,blFont.CENTER);

			return;

		}

		if(sign) {

			if(val>=0) {

				s="+";

			} else {

				s="-";

			}

		} else {

			s="";

		}

		if(val<0) {

		    val=-val;

		}

		val%=1000000;	// protect against rollover

		for(z=0;z<6;z++) {

			v = val/div;

			if((v>0)||first) {

				s+=(char)(v+'0');

				first = true;

			}

			val-=v*div;

			div/=10;

		}

//		teBG.drawText(g,s,x,y,teBG.CENTER);

		teBG.alpha5.draw(g,s,x,y,blFont.CENTER);

	}



	public void clearedLines(int lines) {

		String snd="clear";

		this.lines+=lines;

   	// check if we are on a new piece, if so, then clear the pscore/pgoal

		if(np) {

			pgoal=0;

			np=false;

		}

		switch(lines) {

		case 0:

			return;

		case 1:

			goal-=1;

			pgoal-=1;

			scoredxlev(1);

			lastWasTetris = false;

			break;

		case 2:

			goal-=3;

			pgoal-=3;

			scoredxlev(3);

			lastWasTetris = false;

			break;

		case 3:

			goal-=5;

			pgoal-=5;

			scoredxlev(5);

			lastWasTetris = false;

			break;

		case 4:

			if(lastWasTetris) {

				goal-=12;

				pgoal-=12;

				scoredxlev(12);

				snd="tetrisx2";

			} else {

				goal-=8;

				pgoal-=8;

				scoredxlev(8);

				lastWasTetris = true;

				snd="tetris";

			}

			break;

		}

		if(snd!=null) {

			if(goal<=0) {

				snd="levelup";

			}

			blSound.play(snd,0);

		}

		touch();

	}



	public void scored(int points) {

		score+=points;

//		pscore+=points;

		if(score<0) {

			score = 0;

		}

		touch();

	}



	public void scoredxlev(int points) {

		int s=points*levmult;

		score+=s;

//		pscore+=s;

		touch();

	}



	public void checkLevelUp(teSim sim) {

		while(goal<=0) {

			if(tetris.gametype==tetris.GAMETYPE_40LINES) {

				return;

			}

			levelUp(sim);

		}

	}



	public void levelUp(teSim sim) {

		levmult = ((level*100)/14)+100;

		level++;

		if(tetris.gametype==tetris.GAMETYPE_40LINES) {

			goal=40;

		} else {

			goal+=level*5;

		}

		if(level>1) {

			leveledup=true;

		}

		sim.nextQueue.touch();

		sim.touchHold();

		sim.theWell.touch();

		touch();

	}



	public void processLevelUp(teSim sim) {

		if(leveledup) {

			leveledup=false;

			teRenderer.gen(level);

			sim.nextQueue.touch();

			sim.touchHold();

			sim.theWell.touch();

			touch();

		}

	}



	public boolean isDirty() {

		// check for autodirty

		if(autodirty>0) {

			if(System.currentTimeMillis()>=autodirty) {

				if(np) {

//					pscore=0;

					pgoal=0;

				}

				dirty=true;

				autodirty=0;

			}

		}

		return dirty;

	}



	public void touch() {

		dirty = true;

	}



	public void clean() {

		dirty = false;

	}



	public teGameStatPack pack() {

//		pause();

		if(tetris.gametype==tetris.GAMETYPE_40LINES) {

			lines=goal;

		}

		return new teGameStatPack(score, level, lines, elapsed);

	}

}