package tetris;



import javax.microedition.lcdui.Graphics;



abstract class teTetri {



	public static final int TETRI_MINOS = 4;

	public static final int TETRI_MARKS = 5;



	public teMinoLoc minos[];

	public int minosx[];

	public int minosy[];



	public byte minoType;



	public int maxFace;



	public byte ghost[];



	public byte markx[][];

	public byte marky[][];



	public class teMinoLoc {

		public int x, y;



		public void set(int x, int y) {

			this.x = x;

			this.y = y;

		}

	}



	teTetri() {

		minos = new teMinoLoc[TETRI_MINOS];

		minosx = new int[TETRI_MINOS];

		minosy = new int[TETRI_MINOS];

		ghost = new byte[TETRI_MINOS];

		markx = new byte[TETRI_MINOS][TETRI_MARKS];

		marky = new byte[TETRI_MINOS][TETRI_MARKS];

		for(int i=0;i<TETRI_MINOS;i++) {

			minos[i] = new teMinoLoc();

		}

	}



	protected void init() {

		for(int i=0;i<teTetri.TETRI_MINOS;i++) {

			minosx[i] = minos[i].x * teRenderer.MINO_SIZE;

			minosy[i] = minos[i].y * teRenderer.MINO_SIZE;

		}

		// precalc the ghosts

		boolean ghostcalc[][];

		ghostcalc = new boolean[7][7];

		// fill in the minos

		for(int i=0;i<teTetri.TETRI_MINOS;i++) {

			ghostcalc[minos[i].x+3][minos[i].y+3]=true;

		}

		// get the ghost values

		for(int i=0;i<teTetri.TETRI_MINOS;i++) {

			int x=minos[i].x+3;

			int y=minos[i].y+3;

			byte g=0;

			// check the block to the north

			if(ghostcalc[x][y-1]) {

				g|=0x88;	// 10001000

			}

			// check the block to the east

			if(ghostcalc[x+1][y]) {

				g|=0x44;	// 01000100

			}

			// check the block to the south

			if(ghostcalc[x][y+1]) {

				g|=0x22;	// 00100010

			}

			// check the block to the west

			if(ghostcalc[x-1][y]) {

				g|=0x11;	// 00010001

			}

			ghost[i]=g;

		}

	}



	public void paint(Graphics g, int mino, int x, int y, int facing) {

		int m;



		// adjust for 1-based mino number

		mino--;

		switch(facing) {

		case tePiece.PIECE_FACE_N:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawImage(teRenderer.minos[mino][getGhost(m,facing)], x+minosx[m], y+minosy[m], Graphics.LEFT|Graphics.TOP);

			}

			break;

		case tePiece.PIECE_FACE_E:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawImage(teRenderer.minos[mino][getGhost(m,facing)], x-minosy[m], y+minosx[m], Graphics.LEFT|Graphics.TOP);

			}

			break;

		case tePiece.PIECE_FACE_S:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawImage(teRenderer.minos[mino][getGhost(m,facing)], x-minosx[m], y-minosy[m], Graphics.LEFT|Graphics.TOP);

			}

			break;

		case tePiece.PIECE_FACE_W:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawImage(teRenderer.minos[mino][getGhost(m,facing)], x+minosy[m], y-minosx[m], Graphics.LEFT|Graphics.TOP);

			}

			break;

		}

	}

	

	public void paintGhost(Graphics g, int x, int y, int facing) {

		int m;



		switch(facing) {

		case tePiece.PIECE_FACE_N:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawImage(teRenderer.ghosts[getGhost(m,facing)],x+minosx[m],y+minosy[m],Graphics.LEFT|Graphics.TOP);

			}

			break;

		case tePiece.PIECE_FACE_E:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawImage(teRenderer.ghosts[getGhost(m,facing)],x-minosy[m],y+minosx[m],Graphics.LEFT|Graphics.TOP);

			}

			break;

		case tePiece.PIECE_FACE_S:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawImage(teRenderer.ghosts[getGhost(m,facing)],x-minosx[m],y-minosy[m],Graphics.LEFT|Graphics.TOP);

			}

			break;

		case tePiece.PIECE_FACE_W:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawImage(teRenderer.ghosts[getGhost(m,facing)],x+minosy[m],y-minosx[m],Graphics.LEFT|Graphics.TOP);

			}

			break;

		}

	}



	public void paintFrame(Graphics g, int x, int y, int facing) {

		int m;

		int sz = teRenderer.MINO_SIZE;



		g.setColor(0, 0, 0);

		switch(facing) {

		case tePiece.PIECE_FACE_N:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawRect(x+minosx[m]-1, y+minosy[m]-1, sz, sz);

			}

			break;

		case tePiece.PIECE_FACE_E:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawRect(x-minosy[m]-1, y+minosx[m]-1, sz, sz);

			}

			break;

		case tePiece.PIECE_FACE_S:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawRect(x-minosx[m]-1, y-minosy[m]-1, sz, sz);

			}

			break;

		case tePiece.PIECE_FACE_W:

			for(m=0;m<TETRI_MINOS;m++) {

				g.drawRect(x+minosy[m]-1, y-minosx[m]-1, sz, sz);

			}

			break;

		}

	}



	public boolean lock(teWell well, int x, int y, int facing) {

		int m,l;

		byte g;

		boolean lockout = true;



		switch(facing) {

		case tePiece.PIECE_FACE_N:

			for(m=0;m<TETRI_MINOS;m++) {

				l = y+minos[m].y;

				g=getGhost(m,facing);

				if(l>=0) {

					well.getLine(l).setBlock(x+minos[m].x, minoType, g);

					if(l>=teWell.WELL_SKYLINE) {

						lockout = false;

					}

				}

			}

			break;

		case tePiece.PIECE_FACE_E:

			for(m=0;m<TETRI_MINOS;m++) {

				l = y+minos[m].x;

				g=getGhost(m,facing);

				if(l>=0) {

					well.getLine(l).setBlock(x-minos[m].y, minoType, g);

					if(l>=teWell.WELL_SKYLINE) {

						lockout = false;

					}

				}

			}

			break;

		case tePiece.PIECE_FACE_S:

			for(m=0;m<TETRI_MINOS;m++) {

				l = y-minos[m].y;

				g=getGhost(m,facing);

				if(l>=0) {

					well.getLine(l).setBlock(x-minos[m].x, minoType, g);

					if(l>=teWell.WELL_SKYLINE) {

						lockout = false;

					}

				}

			}

			break;

		case tePiece.PIECE_FACE_W:

			for(m=0;m<TETRI_MINOS;m++) {

				l = y-minos[m].x;

				g=getGhost(m,facing);

				if(l>=0) {

					well.getLine(l).setBlock(x+minos[m].y, minoType, g);

					if(l>=teWell.WELL_SKYLINE) {

						lockout = false;

					}

				}

			}

			break;

		}

		well.touch();

		

		return lockout;

	}



	public int getMinoX(int index, int facing) {

		switch(facing) {

		case tePiece.PIECE_FACE_N:

			return minos[index].x;

		case tePiece.PIECE_FACE_E:

			return -minos[index].y;

		case tePiece.PIECE_FACE_S:

			return -minos[index].x;

		case tePiece.PIECE_FACE_W:

			return minos[index].y;

		}

		return 0;

	}

	

	public int getMinoY(int index, int facing) {

		switch(facing) {

		case tePiece.PIECE_FACE_N:

			return minos[index].y;

		case tePiece.PIECE_FACE_E:

			return minos[index].x;

		case tePiece.PIECE_FACE_S:

			return -minos[index].y;

		case tePiece.PIECE_FACE_W:

			return -minos[index].x;

		}

		return 0;

	}



	public int getMarkerX(int mark_num, int facing) {

		return markx[facing][mark_num];

	}



	public int getMarkerY(int mark_num, int facing) {

		return marky[facing][mark_num];

	}



	protected void setMarksType1() {

		// T,J,L,S,Z

		// north

		markx[0][0]=0;

		marky[0][0]=0;

		markx[0][1]=0;

		marky[0][1]=0;

		markx[0][2]=0;

		marky[0][2]=0;

		markx[0][3]=0;

		marky[0][3]=0;

		markx[0][4]=0;

		marky[0][4]=0;

		// east

		markx[1][0]=0;

		marky[1][0]=0;

		markx[1][1]=1;

		marky[1][1]=0;

		markx[1][2]=1;

		marky[1][2]=1;

		markx[1][3]=0;

		marky[1][3]=-2;

		markx[1][4]=1;

		marky[1][4]=-2;

		// south

		markx[2][0]=0;

		marky[2][0]=0;

		markx[2][1]=0;

		marky[2][1]=0;

		markx[2][2]=0;

		marky[2][2]=0;

		markx[2][3]=0;

		marky[2][3]=0;

		markx[2][4]=0;

		marky[2][4]=0;

		// west

		markx[3][0]=0;

		marky[3][0]=0;

		markx[3][1]=-1;

		marky[3][1]=0;

		markx[3][2]=-1;

		marky[3][2]=1;

		markx[3][3]=0;

		marky[3][3]=-2;

		markx[3][4]=-1;

		marky[3][4]=-2;

	}



	protected void setMarksType2() {

		// I

		// north

		markx[0][0]=0;

		marky[0][0]=0;

		markx[0][1]=-1;

		marky[0][1]=0;

		markx[0][2]=2;

		marky[0][2]=0;

		markx[0][3]=-1;

		marky[0][3]=0;

		markx[0][4]=2;

		marky[0][4]=0;

		// east

		markx[1][0]=-1;

		marky[1][0]=0;

		markx[1][1]=0;

		marky[1][1]=0;

		markx[1][2]=0;

		marky[1][2]=0;

		markx[1][3]=0;

		marky[1][3]=-1;

		markx[1][4]=0;

		marky[1][4]=2;

		// south

		markx[2][0]=-1;

		marky[2][0]=-1;

		markx[2][1]=1;

		marky[2][1]=-1;

		markx[2][2]=-2;

		marky[2][2]=-1;

		markx[2][3]=1;

		marky[2][3]=0;

		markx[2][4]=-2;

		marky[2][4]=0;

		// west

		markx[3][0]=0;

		marky[3][0]=-1;

		markx[3][1]=0;

		marky[3][1]=-1;

		markx[3][2]=0;

		marky[3][2]=-1;

		markx[3][3]=0;

		marky[3][3]=1;

		markx[3][4]=0;

		marky[3][4]=-2;

	}



	protected void setMarksType3() {

		// O

		// north

		markx[0][0]=0;

		marky[0][0]=0;

		markx[0][1]=0;

		marky[0][1]=0;

		markx[0][2]=0;

		marky[0][2]=0;

		markx[0][3]=0;

		marky[0][3]=0;

		markx[0][4]=0;

		marky[0][4]=0;

		// east

		markx[1][0]=0;

		marky[1][0]=0;

		markx[1][1]=0;

		marky[1][1]=0;

		markx[1][2]=0;

		marky[1][2]=0;

		markx[1][3]=0;

		marky[1][3]=0;

		markx[1][4]=0;

		marky[1][4]=0;

		// south

		markx[2][0]=0;

		marky[2][0]=0;

		markx[2][1]=0;

		marky[2][1]=0;

		markx[2][2]=0;

		marky[2][2]=0;

		markx[2][3]=0;

		marky[2][3]=0;

		markx[2][4]=0;

		marky[2][4]=0;

		// west

		markx[3][0]=0;

		marky[3][0]=0;

		markx[3][1]=0;

		marky[3][1]=0;

		markx[3][2]=0;

		marky[3][2]=0;

		markx[3][3]=0;

		marky[3][3]=0;

		markx[3][4]=0;

		marky[3][4]=0;

	}



	public byte getGhost(int mino, int facing) {

		return (byte)((ghost[mino]>>facing)&0x0f);

	}



	public abstract boolean isFree(teWell well, int x, int y, int facing);

	public abstract boolean canFall(teWell well, int x, int y, int facing);



	public abstract int centerX(int facing);

	public abstract int centerY(int facing);

}

