package tetris;



public class teTetriS extends teTetri {

    

	static int cx[] = {-1, -2, -1, 0};

	static int cy[] = {0, -1, -2, -1};

	

    teTetriS() {

        super();

        

        minos[0].set(0, 0);

        minos[1].set(0, -1);

        minos[2].set(-1, 0);

        minos[3].set(1, -1);

        

        minoType = 3;

        

        maxFace = tePiece.PIECE_FACE_W;



		setMarksType1();



		init();

    }



    public boolean isFree(teWell well, int x, int y, int facing) {

	switch(facing) {

	case tePiece.PIECE_FACE_N:

	    if(x<1) return false;

	    if(x>teWell.WELL_WMAX-1) return false;

	    if(y>teWell.WELL_HMAX) return false;

	    if(well.isMaskUsed(0x3<<x, y-1)) return false;

	    if(well.isMaskUsed(0x3<<(x-1), y)) return false;

	    break;

	case tePiece.PIECE_FACE_E:

	    if(x<0) return false;

	    if(x>teWell.WELL_WMAX-1) return false;

	    if(y>teWell.WELL_HMAX-1) return false;

	    if(well.isBlockUsed(x, y-1)) return false;

	    if(well.isMaskUsed(0x3<<x, y)) return false;

	    if(well.isBlockUsed(x+1, y+1)) return false;

	    break;

	case tePiece.PIECE_FACE_S:

	    if(x<1) return false;

	    if(x>teWell.WELL_WMAX-1) return false;

	    if(y>teWell.WELL_HMAX-1) return false;

	    if(well.isMaskUsed(0x3<<x, y)) return false;

	    if(well.isMaskUsed(0x3<<(x-1), y+1)) return false;

	    break;

	case tePiece.PIECE_FACE_W:

	    if(x<1) return false;

	    if(x>teWell.WELL_WMAX) return false;

	    if(y>teWell.WELL_HMAX-1) return false;

	    if(well.isBlockUsed(x-1, y-1)) return false;

	    if(well.isMaskUsed(0x3<<(x-1), y)) return false;

	    if(well.isBlockUsed(x, y+1)) return false;

	    break;

	}

	return true;

    }



    public boolean canFall(teWell well, int x, int y, int facing) {

	switch(facing) {

	case tePiece.PIECE_FACE_N:

	    if(y>=teWell.WELL_HMAX) return false;

	    if(well.isBlockUsed(x+1, y)) return false;

	    if(well.isMaskUsed(0x3<<(x-1), y+1)) return false;

	    break;

	case tePiece.PIECE_FACE_E:

	    if(y>=teWell.WELL_HMAX-1) return false;

	    if(well.isBlockUsed(x, y+1)) return false;

	    if(well.isBlockUsed(x+1, y+2)) return false;

	    break;

	case tePiece.PIECE_FACE_S:

	    if(y>=teWell.WELL_HMAX-1) return false;

	    if(well.isBlockUsed(x+1, y+1)) return false;

	    if(well.isMaskUsed(0x3<<(x-1), y+2)) return false;

	    break;

	case tePiece.PIECE_FACE_W:

	    if(y>=teWell.WELL_HMAX-1) return false;

	    if(well.isBlockUsed(x-1, y+1)) return false;

	    if(well.isBlockUsed(x, y+2)) return false;

	    break;

	}

	return true;

    }



	public int centerX(int facing) {

		return cx[facing]*teRenderer.MINO_SIZE/2;

	}

	

	public int centerY(int facing) {

		return cy[facing]*teRenderer.MINO_SIZE/2;

	}

}

