package tetris;

import javax.microedition.lcdui.Graphics;
import java.util.TimerTask;
import java.util.Timer;

public class tetris extends blDest {

	teSim sim;
	teRenderer render;
	static boolean loaded;

	public static final int GAMETYPE_CLASSIC = 0;
	public static final int GAMETYPE_ULTRA = 1;
	public static final int GAMETYPE_40LINES = 2;

	static byte gametype;

	static int topScore;
	static int topLevel;
	static int topEfficiency;
	static int topRating;
	static int topLines;
	static int topScoreCD;
	static int topLevelCD;
	static int topLinesCD;
	static int topScore40;
	static int topTime40;

	static boolean ghost;
	static byte start_level;
	static Timer repeater;
	static int bufferclear;
    static boolean priorityLeft;

	class autorepeattask extends TimerTask {

		public void run() {
            boolean left = sim.movingRight ? (sim.movingLeft && priorityLeft) : sim.movingLeft;
            boolean right = sim.movingLeft ? (sim.movingRight && !priorityLeft) : sim.movingRight;
			if(left) {
				sim.moveLeft();
				return;
			}
			if(right) {
				sim.moveRight();
				return;
			}
			if(sim.movingDown) {
				sim.moveDown();
				return;
			}
			repeater.cancel();
			repeater=null;
		}
	}

	public void create(Object obj) {
		owns_bg=true;
		loaded=false;
		bufferclear = 2;
	}

	public void destroy() {
		loaded=false;
		if(repeater!=null) {
			repeater.cancel();
			repeater=null;
		}
		if(sim!=null) {
			sim.destroy();
			sim=null;
		}
		if(render!=null) {
			render.destroy();
			render=null;
		}
	}

	public void activating() {
		if(sim==null) {
			bluelava.updateLoading();
			try {
				//blSound.init();
				bluelava.updateLoading();
				blSound.load("resource:go.mid","audio/midi",1,0,"gamestart");
				bluelava.updateLoading();
				blSound.load("resource:over.mid","audio/midi",1,0,"gameover");
				bluelava.updateLoading();
				blSound.load("resource:clr.mid","audio/midi",1,0,"clear");
				bluelava.updateLoading();
				blSound.load("resource:t.mid","audio/midi",1,0,"tetris");
				bluelava.updateLoading();
				blSound.load("resource:tx2.mid","audio/midi",1,0,"tetrisx2");
				bluelava.updateLoading();
				blSound.load("resource:lvl.mid","audio/midi",1,0,"levelup");
				bluelava.updateLoading();
				blSound.load("resource:lck.mid","audio/midi",1,0,"lock");
				bluelava.updateLoading();
			} catch(Exception e) {
			}
//			teSound.init();
			sim = new teSim();
			render = new teRenderer();
			render.init(bluelava.getWidth(), bluelava.getHeight());

		} else {
			sim.resume();
		}
	}

	public void activated() {
		if(!sim.isAlive()) {
			sim.start();
			bluelava.enableHeart();
			loaded=true;
		}
	}

	public void deactivating() {
		if(sim!=null&&loaded) {
			sim.pause();
		}
	}

	public void pause() {
		if(loaded && !bluelava.is_loading) {
			bluelava.push("paused",null);
		}

		if(bluelava.is_loading)
			teSim.pushPauseAfterLoading=true ;
	}

/*
	public void resume() {
	}*/

	public void paint(Graphics g, boolean force) {
		if(sim!=null) {
			render.paint(g,sim);

//			Log.print("tetris::paint():paused: " + sim.paused) ;

				if(sim.paused == 0) {
					teBG.alpha8.draw(g, localString.texts[localString.PAUSE], 2, bluelava.getHeight() - 12, blFont.LEFT);
				}

		}


	}

	public boolean keyPressed(int key) {

		if(bluelava.is_loading)
			return false;


		if((bufferclear > 0) || !sim.pausable)
			return true;
		switch(key) {
		case KEY_LEFTSOFT:
			pause();
			break;
		case KEY_4:
		case KEY_LEFT:
            sim.moveLeft();
			sim.movingLeft=true;
            priorityLeft = true;
			autorepeat();
			break;
		case KEY_6:
		case KEY_RIGHT:
            sim.moveRight();
            sim.movingRight=true;
            priorityLeft = false;
            autorepeat();
			break;
		case KEY_3:
		case KEY_5:
		case KEY_7:
		case KEY_POUND:
		case KEY_FIRE:
			sim.rotateCW();
			break;
		case KEY_1:
		case KEY_9:
		case KEY_STAR:
			sim.rotateCCW();
			break;
		case KEY_0:
			sim.hold();
			break;
		case KEY_2:
		case KEY_UP:
			sim.hardDrop();
			break;
		case KEY_8:
		case KEY_DOWN:
			sim.moveDown();
            sim.movingDown=true;
			autorepeat();
			break;
		}
		return true;
	}

	public boolean keyReleased(int key) {

		switch(key) {
		case KEY_8:
		case KEY_DOWN:
			sim.movingDown=false;
			break;
		case KEY_4:
		case KEY_LEFT:
			sim.movingLeft=false;
			break;
		case KEY_6:
		case KEY_RIGHT:
			sim.movingRight=false;
			break;
		}


		//not sure if this is necessary
		if (!sim.pausable) {
			return true;
		}
/*
		sim.softDropOff();
		sim.movingLeft = false;
		sim.movingRight = false;
*/
		return true;
	}

	public boolean heartbeat() {
		bufferclear--;
		if(bufferclear == 0) {
			bluelava.disableHeart();
		}
		return true;
	}

	void autorepeat() {
		if(repeater!=null) {
			repeater.cancel();
			repeater=null;
		}
		repeater = new Timer();
		repeater.schedule(new autorepeattask(),200,50);
	}
}
