package com.bejeweled2_j2me;

import javax.microedition.lcdui.*;
import javax.microedition.rms.*;
import java.io.*;
import java.util.Vector;


class GameModeScreen extends BaseScreen implements CommandListener
{
    
    private static final int NUM_MODES = 3;
    private DialogCanvas gameModeForm;

    
    public Displayable getDisplayable()
    {
        return gameModeForm;
    }

    public void init() throws IOException
    {
        int difficulty = ((GameBoard)
            gameEngine.getScreenInstance(GameEngine.SCREEN_GAME)).getDifficulty();
        
        String[] labelStrings = { StringTable.NORMAL, StringTable.ADVANCED, StringTable.EXPERT };
        
        boolean defaultValues[] = new boolean[labelStrings.length];
        for(byte index = 0; index < labelStrings.length; ++index) {
            defaultValues[index] = (index == difficulty);
        }

        // Layout interface
        gameModeForm = new DialogCanvas(this, DialogCanvas.CHECKLIST, StringTable.GAME_MODE );
        gameModeForm.setList(labelStrings, defaultValues);
        gameModeForm.setDialogListener( this );
    }

   

    /**
     * Handles all soft key commands for this screen. Primarily the
     * Save command, which saves settings to persistent storage then
     * returns to the main menu.
     *
     * @param   cmd     command being handled.
     * @param   dis     displayable containing command.
     */
    public void commandAction( Command cmd, Displayable dis )
    {
        if (cmd.getCommandType() == Command.BACK) 
        {
            gameEngine.transition( GameEngine.SCREEN_MAIN );
        }
    }

    /**
     * Handle dialog item toggling with appropriate event response.
     *
     * @param type of event, should be ON or OFF from DialogCanvas
     * @param index of item toggled
     */
    public void dialogEvent(byte type, int index) {
        if(type == DialogCanvas.ON) 
        {
            if (gameEngine.isDemo()) {
                for (int i = 0; i < NUM_MODES; i++) {
                    gameModeForm.setCheckState(i, i == 0);
                }
                
                showUnavilableScreen();
            }
            else {
                for (int i = 0; i < NUM_MODES; i++) {
                    gameModeForm.setCheckState(i, i == index);
                }
                GameBoard gameBoard = (GameBoard)
                    gameEngine.getScreenInstance(GameEngine.SCREEN_GAME);
                gameBoard.setDifficulty(index);
            }
        }
        else if(type == DialogCanvas.OFF) 
        {
            // Ignore the turn-off
            gameModeForm.setCheckState(index, true);
        }
           
    }
    
    
    private void showUnavilableScreen() {
        DialogListener listener = new DialogListener() {
            public void dialogDismissed( byte result ) {
                if (result == Dialog.CMD_OK) {
                    Build.showBuyURIAndExit(gameEngine);
                }
                else if (result == Dialog.CMD_CANCEL) {
                    gameEngine.restart( GameEngine.SCREEN_GAME_MODE );
                }
            }
        };
        
        String message = StringTable.VODAFONE_UNAVAIL;
        if (Build.VODAFONE) {
            message += "|" + StringTable.VODAFONE_GET_GAME + "|" +
                StringTable.VODAFONE_DOWNLOAD;
        }
        
        dlg.show(listener, Dialog.DLG_VODA_GET_BACK, "BEJEWELED", message);        
    }
   
}
