package shell;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Graphics;
import shell.core.App;
import shell.core.Scene;
import shell.core.Visual;
import shell.core.Device;
import shell.core.ImageFont;

public class GameSelectScene extends Scene implements Layout {
    
    private static final int TOOLBAR_ANIM_DURATION = 500;
    
    private Visual[] menuItems;
    private Visual scrollThumb;
    private Visual scrollRail;
    private int menuStartY;
    
    private MenuItem[] itemInfo;
    
    private int numAltItemsPerPage;
    
    private int currentMenuItem;
    
    public void load() {
        setBackground(App.createImage("background.png"));
        
        numAltItemsPerPage = App.getIntProperty("alt.items.per.page", ALT_ITEMS_PER_PAGE);
        
        // Toolbar background
        Image toolbarBackground = App.createImage("header.png");
        int toolbarAnimY = -40;
        Visual toolbar = new Visual(toolbarBackground, 0, toolbarAnimY);
        toolbar.moveTo(0, 0, 0, TOOLBAR_ANIM_DURATION, Visual.EASE_OUT);
        add(toolbar);
        
        //
        itemInfo = MenuItem.getAll();
        menuItems = new Visual[itemInfo.length];
        int numAlternateItems = itemInfo.length - Device.GAMES.length;
        
        // Menu items and links
        ImageFont menuFont = new ImageFont("menu-font");
        ImageFont menuSelectFont = new ImageFont("menu-select-font");
        ImageFont menuSubtitleFont = new ImageFont("menu-subtitle-font");
        ImageFont menuSubtitleSelectFont = new ImageFont("menu-subtitle-select-font");
        menuStartY = ALT_ITEMS_BOTTOM - ALT_ITEM_DY * 
            Math.min(numAlternateItems, numAltItemsPerPage);
        int x = ALT_ITEM_X;
        int y = menuStartY;
        for (int i = Device.GAMES.length; i < itemInfo.length; i++) {
            Visual button = itemInfo[i].createButton(menuFont, menuSelectFont,
                menuSubtitleFont, menuSubtitleSelectFont,
                ALT_ITEM_WIDTH, ALT_ITEM_HEIGHT);
            //button.setLocation(x, y);
            button.move(x-Device.WIDTH, y, x, y, 0, 500, Visual.EASE_IN_OUT);
            button.setVisible((i - Device.GAMES.length) < numAltItemsPerPage);
            add(button);
            y += ALT_ITEM_DY;
            menuItems[i] = button;
        }
        
        // Scroll bar
        if (numAlternateItems > numAltItemsPerPage) {
            x = ALT_ITEM_X + ALT_ITEM_WIDTH;
            y = menuStartY;
            
            scrollThumb = new Visual("scroll-thumb.png", x, y);
            scrollThumb.setAnchor(Graphics.TOP | Graphics.RIGHT);
            scrollThumb.move(x-Device.WIDTH, y, x, y, 0, 500, Visual.EASE_IN_OUT);
            
            int height = ALT_ITEM_DY * numAltItemsPerPage + 1;
            Image image = Image.createImage(scrollThumb.getWidth(), height);
            Graphics g = image.getGraphics();
            g.setColor(0x000000);
            g.fillRect(0, 0, scrollThumb.getWidth(), height);
            
            scrollRail = new Visual(image, x, y);
            scrollRail.setAnchor(Graphics.TOP | Graphics.RIGHT);
            scrollRail.move(x-Device.WIDTH, y, x, y, 0, 500, Visual.EASE_IN_OUT);
            
            add(scrollRail);
            add(scrollThumb);
        }
        
        // Game banners
        // Place the game banners vertically equidistant between the toolbar
        // and the menu items
        if (Device.GAMES.length > 0) {
            int vspace = menuStartY - toolbar.getHeight();
            x = Device.WIDTH / 2;
            y = toolbar.getHeight();
            for (int i = 0; i < Device.GAMES.length; i++) {
                Visual banner = new Visual("banner" + i + ".png", 2, 1, 0, 0);
                y += (vspace - Device.GAMES.length * banner.getHeight()) / (Device.GAMES.length + 1);
                //banner.setLocation(x, y);
                banner.move(Device.WIDTH, y, x, y, 0, 500, Visual.EASE_IN_OUT);
                banner.setAnchor(Graphics.HCENTER | Graphics.TOP);
                add(banner);
                y += banner.getHeight();
                menuItems[i] = banner;
            }
        }
        
        // Softkeys
        ImageFont normalFont = new ImageFont("softkey-font");
        ImageFont selectFont = new ImageFont("softkey-select-font");
        setSoftKey1(ImageFont.createButton(Local.SELECT, normalFont, selectFont));
        setSoftKey2(ImageFont.createButton(Local.EXIT, normalFont, selectFont));
        
        // User selection
        setMenuItem(0);
    }
    
    
    public void unload() {
        super.unload();
        scrollThumb = null;
        scrollRail = null;
        menuItems = null;
    }
    
    
    
    private void setMenuItem(int menuItem) {
        menuItems[currentMenuItem].setFrame(0);
        this.currentMenuItem = menuItem;
        menuItems[currentMenuItem].setFrame(1);
        
        // Scrolling
        int numAlternateItems = itemInfo.length - Device.GAMES.length;
        if (currentMenuItem >= Device.GAMES.length && numAlternateItems > numAltItemsPerPage) {
            int numItems = menuItems.length - Device.GAMES.length;
            int numPages = (numItems + numAltItemsPerPage - 1) / numAltItemsPerPage;
            int page = (currentMenuItem - Device.GAMES.length) / numAltItemsPerPage;
            int firstItem = Math.min(numItems - numAltItemsPerPage, page * numAltItemsPerPage);
            int y = menuStartY;
            for (int i = 0; i < numItems; i++) {
                Visual item = menuItems[i + Device.GAMES.length];
                if (i >= firstItem && i < firstItem + numAltItemsPerPage) {
                    item.setVisible(true);
                    item.setY(y);
                    y += ALT_ITEM_DY;
                }
                else {
                    item.setVisible(false);
                }
            }
            
            // Scroll bar
            int hspace = scrollRail.getHeight() - scrollThumb.getHeight();
            scrollThumb.setY(menuStartY + hspace * page / (numPages-1));
        }
    }
    
    
    public void update(int elapsedTime) {
        
        if (App.isPressed(App.VK_UP) || App.isPressed(App.VK_2)) {
            setMenuItem((currentMenuItem + menuItems.length - 1) % menuItems.length);    
        }
        else if (App.isPressed(App.VK_DOWN) || App.isPressed(App.VK_8)) {
            setMenuItem((currentMenuItem + 1) % menuItems.length);
        }
        else if (App.isPressed(App.VK_OK) || App.isPressed(App.VK_5) || App.isPressed(App.VK_SOFT1)) {
            setSoftKey1Highlight(true);
            go();
        }
        else if (App.isPressed(App.VK_SOFT2)) {
            setSoftKey2Highlight(true);
            App.exit();
        }
    }
    
    
    private void go() {
        
        if (itemInfo[currentMenuItem].type == MenuItem.TYPE_LINK) {
            App.launchBrowser(itemInfo[currentMenuItem].link);
        }
        else if (itemInfo[currentMenuItem].type == MenuItem.TYPE_SCENE) {
            App.pushScene(new HelpScene());
        }
        else {
            BuyScene buyScene = new BuyScene(getBackgroundImage(), itemInfo, currentMenuItem);
            if (currentMenuItem < Device.GAMES.length) {
                buyScene.setMode(BuyScene.MODE_PRE_DEMO);
            }
            App.setScene(buyScene);
        }
        
            
            /*
            if (actualTool == 0) {
                BuyScene buyScene = new BuyScene(null, itemInfo, currentMenuItem);
                buyScene.setAllowScrolling(false);
                
                if (currentMenuItem == 0) {
                    tetris.localString.gameLang = Local.getLanguage();
                    shell.core.Main.setGame(new tetris.bluelava(), buyScene);
                }
                else if (currentMenuItem == 1) {
                    sims2.SimsCanvas.setLanguage(Local.getLanguage());
                    shell.core.Main.setGame(new sims2.SimsApp(), buyScene);
                }
                else {
                    com.bejeweled2_j2me.StringTable.setLocale(Local.getLanguage());
                    shell.core.Main.setGame(new com.bejeweled2_j2me.BejeweledMIDlet(), buyScene);
                    //App.setScene(new Splash("__placeholder.png", buyScene, Splash.NO_TIMEOUT, true));
                }
            }
            else if (actualTool == 1) {
                //
                App.launchBrowser(itemInfo[currentMenuItem].link);
            }
            else if (actualTool == 2) {
                
            }
            */
    }
}
