package sims2;



//package root;







/**

 * Enumeration class - will be removed upon obfuscation

 */

public final class WorldData

{

	/*

	 * Item Defines

	 */

	public static final int ITEM_FRIDGE 				= 7; // SimAttributes.NUM_ROOMS;

	public static final int ITEM_GAS_COOKER				= 8;

	public static final int ITEM_FIRE_EXTINGUISHER		= 9;

	public static final int ITEM_COFFEE_MACHINE			= 10;

	public static final int ITEM_TABLE 					= 11;

	public static final int ITEM_MICROWAVE				= 12;

	public static final int ITEM_SMOKE_ALARM			= 13;

	public static final int ITEM_CHAIR 					= 14;

	public static final int ITEM_MIRROR 				= 15;

	public static final int ITEM_BLACK_N_WHITE_TV		= 16;

	public static final int ITEM_BED	 				= 17;

	public static final int ITEM_ALARM_CLOCK			= 18;

	public static final int ITEM_TOILET 				= 19;

	public static final int ITEM_SINK					= 20;

	public static final int ITEM_SHOWER 				= 21;

	public static final int ITEM_BATH	 				= 22;

	public static final int ITEM_STEREO 				= 23;

	public static final int ITEM_SOFA_1 				= 24;

	public static final int ITEM_FLAT_SCREEN_TV			= 25;

	public static final int ITEM_BOOKCASE 				= 26;

	public static final int ITEM_GUITAR 				= 27;

	public static final int ITEM_EXERCISE_BIKE			= 28;

	public static final int ITEM_ARCADE_MACHINE			= 29;

	public static final int ITEM_CHESS_TABLE			= 30;

	public static final int ITEM_DANCE_FLOOR			= 31;

	public static final int ITEM_DECKS 					= 32;

	public static final int ITEM_JUICE_BAR				= 33;

	public static final int ITEM_SOFA_2					= 34;

	public static final int ITEM_HOT_TUB 				= 35;

	public static final int ITEM_BARBEQUE				= 36;

	public static final int ITEM_GARDEN_FURNITURE		= 37;

	public static final int ITEM_FRONT_DOOR				= 38;

	

	public static final int NUM_ITEMS					= (ITEM_FRONT_DOOR + 1 - SimAttributes.NUM_ROOMS);

	public static final int FIRST_ITEM					= ITEM_FRIDGE;

	public static final int LAST_ITEM					= ITEM_FRONT_DOOR;

	public static final int INVALID_ITEM_ID				= -1;

	

	public static final int GRAPHIC_PLANT				= 39;

	public static final int GRAPHIC_LAMP				= 40;

	public static final int GRAPHIC_MAIL_BOX			= 41;

	public static final int GRAPHIC_CHESS_TABLE			= 42;

	

	public static final int FIRST_GRAPHICAL_ITEM		= GRAPHIC_PLANT;

	public static final int LAST_GRAPHICAL_ITEM			= GRAPHIC_CHESS_TABLE;

	

	public static final int MAX_NUM_ITEMS_PER_ROOM		= 12;

	

	/*

	 * NPC Defines

	 */

	public static final short NPC_COMING_NONE			= 0;

	public static final short NPC_COMING_INVITE			= 1;

	public static final short NPC_COMING_PARTY			= 2;

	public static final short NPC_COMING_AUTO			= 3;

	public static final short NPC_PARTY_REJECT			= 4;

	

	public static final int NPC_LOC_KITCHEN_1			= 39;//(LAST_ITEM + 1);

	public static final int NPC_LOC_KITCHEN_2			= 40;

	public static final int NPC_LOC_BATHROOM			= 41;

	public static final int NPC_LOC_BEDROOM				= 42;

	public static final int NPC_LOC_LIVINGROOM_1		= 43;

	public static final int NPC_LOC_LIVINGROOM_2		= 44;

	public static final int NPC_LOC_RECROOM_1			= 45;

	public static final int NPC_LOC_RECROOM_2			= 46;

	public static final int NPC_LOC_PARTYROOM_1			= 47;

	public static final int NPC_LOC_PARTYROOM_2			= 48;

	public static final int NPC_LOC_PARTYROOM_3			= 49;

	public static final int NPC_LOC_PARTYROOM_4			= 50;

	public static final int NPC_LOC_PARTYROOM_5			= 51;

	public static final int NPC_LOC_PARTYROOM_6			= 52;

	public static final int NPC_LOC_GARDEN_1			= 53;

	public static final int NPC_LOC_GARDEN_2			= 54;

	public static final int NPC_LOC_DUMMY				= 55;

	

	public static final int NUM_NPC_LOCATIONS			= (NPC_LOC_GARDEN_2 - LAST_ITEM);

	public static final int INITIAL_NPC_LOC				= NPC_LOC_KITCHEN_1;

	public static final int FIRST_NPC_LOC				= NPC_LOC_KITCHEN_1;

	public static final int LAST_NPC_LOC				= NPC_LOC_GARDEN_2;

	public static final int NPC_LOC_INVALID				= 0;



	public static final int NPC_FRONT_DOOR_X_POS		= 18;

	public static final int NPC_FRONT_DOOR_Y_POS		= 7;

	public static final int NPC_FRONT_DOOR_FACING		= Facing.SW;

		

	/*

	 * Misc. defines

	 */

	

	// NPCs

	public static final int NPC_BEN						= 0;

	public static final int NPC_PENNY					= 1;

	public static final int NPC_JOHN					= 2;

	public static final int NPC_KITTY					= 3;

	public static final int NPC_LORNA					= 4;

	public static final int NPC_IAN						= 5;

	public static final int NUM_NPCS					= 6;

	public static final int NPC_INVALID					= -1;

	public static final int NPC_ID_START_OFFSET			= LAST_NPC_LOC + 2; //Make room for dummy

	public static final int NPC_ID_OFFSET_BEN			= NPC_ID_START_OFFSET + NPC_BEN;

	public static final int NPC_ID_OFFSET_PENNY			= NPC_ID_START_OFFSET + NPC_PENNY;

	public static final int NPC_ID_OFFSET_JOHN			= NPC_ID_START_OFFSET + NPC_JOHN;

	public static final int NPC_ID_OFFSET_KITTY			= NPC_ID_START_OFFSET + NPC_KITTY;

	public static final int NPC_ID_OFFSET_LORNA			= NPC_ID_START_OFFSET + NPC_LORNA;

	public static final int NPC_ID_OFFSET_IAN			= NPC_ID_START_OFFSET + NPC_IAN;

	public static final int NUM_NPCS_ALLOWED_IN_HOUSE	= 3;

	public static final int NUM_FRIENDS_FOR_LORNA		= 4;

	public static final int NUM_NPCS_NEEDED_FOR_IAN		= 2;

	

	public static final int GOTO_WORK					= -1;

	public static final int NOT_SELECTABLE_ITEM			= -1;

	public static final int NUM_STARTING_SIMOLEANS		= 700;

	

	/*

	 * Room number data defines

	 */

	public static final int ROOM_NUM_POSITIONS			= 0;

	public static final int ROOM_NUM_OBJECTS			= 1;

	public static final int ROOM_NUM_OBJECTS_SPRITES	= 2;

	public static final int ROOM_NUM_NPCS_IN_ROOM		= 3;

	public static final int ROOM_DEFAULT_X_POS			= 4;

	public static final int ROOM_DEFAULT_Y_POS			= 5;

	public static final int ROOM_DEFAULT_FACING			= 6;

	public static final int ROOM_COST					= 7;

	

	/*

	 * Room position data defines

	 */

	public static final int ROOM_POSITION_DATA_TYPE		= 0;

	public static final int ROOM_POSITION_CURSOR_X_POS	= 1;

	public static final int ROOM_POSITION_CURSOR_Y_POS	= 2;

	public static final int ROOM_POSITION_NPC_X_POS		= 3;

	public static final int ROOM_POSITION_NPC_Y_POS		= 4;

	

	/*

	 * NPC position data defines

	 */

	public static final int NPC_POSITION_X_POS			= 0;

	public static final int NPC_POSITION_Y_POS			= 1;

	public static final int NPC_POSITION_FACING			= 2;

	

	// Add additional lock flags that start with the (LAST_NPC_LOC + 2) value

	/** Unlock Flag Mask */

	public static final long INITIAL_LOCKED_FLAG_MASK	= //0;

		((long)1 << SimAttributes.ROOM_LIVINGROOM) |

		((long)1 << SimAttributes.ROOM_RECROOM) |

		((long)1 << SimAttributes.ROOM_PARTYROOM) |

		((long)1 << SimAttributes.ROOM_GARDEN) |

		((long)1 << ITEM_GAS_COOKER) |

		((long)1 << ITEM_COFFEE_MACHINE) |

		((long)1 << ITEM_ALARM_CLOCK) |

		((long)1 << ITEM_BATH) |

		((long)1 << ITEM_FLAT_SCREEN_TV) |

		((long)1 << ITEM_GUITAR) |

		((long)1 << ITEM_CHESS_TABLE) |

		((long)1 << ITEM_DECKS) |

		((long)1 << ITEM_JUICE_BAR) |

		((long)1 << ITEM_HOT_TUB) |

		((long)1 << NPC_ID_OFFSET_BEN) |

		((long)1 << NPC_ID_OFFSET_PENNY) |

		((long)1 << NPC_ID_OFFSET_JOHN) |

		((long)1 << NPC_ID_OFFSET_KITTY) |

		((long)1 << NPC_ID_OFFSET_LORNA) |

		((long)1 << NPC_ID_OFFSET_IAN);

	

	public static final long INITIAL_NPC_LOC_FLAG_MASK	= 

		((long)1 << NPC_LOC_KITCHEN_1) |

		((long)1 << NPC_LOC_KITCHEN_2) |

		((long)1 << NPC_LOC_BATHROOM) |

		((long)1 << NPC_LOC_BEDROOM) |

		((long)1 << NPC_LOC_LIVINGROOM_1) |

		((long)1 << NPC_LOC_LIVINGROOM_2) |

		((long)1 << NPC_LOC_RECROOM_1) |

		((long)1 << NPC_LOC_RECROOM_2) |

		((long)1 << NPC_LOC_PARTYROOM_1) |

		((long)1 << NPC_LOC_PARTYROOM_2) |

		((long)1 << NPC_LOC_PARTYROOM_3) |

		((long)1 << NPC_LOC_PARTYROOM_4) |

		((long)1 << NPC_LOC_PARTYROOM_5) |

		((long)1 << NPC_LOC_PARTYROOM_6) |

		((long)1 << NPC_LOC_GARDEN_1) |

		((long)1 << NPC_LOC_GARDEN_2);

	

	/** Value for the initial npc flag state - not really a mask */

	public static final byte INITIAL_NPC_FLAG_MASK	= 

		(byte) (

			(0)

//		|	(1 << NPC_BEN)

//		|	(1 << NPC_PENNY)

//		|	(1 << NPC_JOHN)

//		|	(1 << NPC_KITTY)

//		|	(1 << NPC_LORNA)

//		|	(1 << NPC_IAN)

		);

	

	/** Value for the initial npc flag state - not really a mask */

	public static final byte NPC_FLAG_MASK	= 

		(byte) ( (1 << NPC_BEN) | 

				 (1 << NPC_PENNY) | 

				 (1 << NPC_JOHN) |

				 (1 << NPC_KITTY) |

				 (1 << NPC_LORNA) |

				 (1 << NPC_IAN) );

	

	/*

	 * Action Defines

	 */

	public static final int ACTION_0					= 0;

	public static final int ACTION_1					= 1;

	public static final int ACTION_2					= 2;

	public static final int MAX_ACTIONS					= 3;

	

	public static final int ACTION_STATE_INIT			= 0;

	public static final int ACTION_STATE_MAIN			= 1;

//	public static final int ACTION_STATE_DO_ANIM		= 2;

//	public static final int ACTION_STATE_WAIT			= 3;

	public static final int ACTION_STATE_CANCEL			= 4;

	public static final int ACTION_STATE_PRE_INIT		= 5;

	public static final int ACTION_STATE_PREANIM		= 6;

	public static final int ACTION_STATE_POSTANIM		= 7;

	public static final int ACTION_STATE_MAIN_SETUP		= 8;

	public static final int ACTION_STATE_PREANIM_SETUP	= 9;

	public static final int ACTION_STATE_POSTANIM_SETUP	= 10;

	public static final int MAX_ACTION_STATES			= 11;

	

	public static final int ACTION_UPDATE_TIME			= 1000;

	public static final int ACTION_SHOWER_PAUSE_TIME	= 500;

	

	/*

	 * Item Table defines

	 */

	public static final int ITEM_DATA_STRING_ID			= 0;

	public static final int ITEM_DATA_NUM_ACTIONS		= 1;

	public static final int ITEM_DATA_NUM_NEEDS_0		= 2;

	public static final int ITEM_DATA_NUM_NEEDS_1		= 3;



	public static final int ITEM_ACTION_MAX_TIME		= 0;

	public static final int ITEM_ACTION_NEED_1			= 1;

	public static final int ITEM_ACTION_NEED_VAL_1		= 2;

	

	/*

	 * Time defines

	 */

	public static final int DAY_MONDAY					= 0;

	public static final int DAY_TUESDAY					= 1;

	public static final int DAY_WEDNESDAY				= 2;

	public static final int DAY_THURSDAY				= 3;

	public static final int DAY_FIRDAY					= 4;

	public static final int DAY_SATURDAY				= 5;

	public static final int DAY_SUNDAY					= 6;

	public static final int NUM_DAYS_PER_WEEK			= 7;



	public static final int NUM_HOUR_PER_DAY			= 24;

	public static final int NUM_MIN_PER_HOUR			= 60;

	public static final int NUM_MS_PER_MIN				= 1000;



	public static final int DEFAULT_DAY					= DAY_MONDAY;

	public static final int DEFAULT_HOUR				= 6;

	public static final int DEFAULT_MIN					= 0;

	

	public static final int NORMAL_TIME_PROGRESSION		= 1;			/** normal Sim time divisor */

	public static final int SLEEP_TIME_PROGRESSION		= 16;			/** sleep Sim time divisor */

	public static final int WORK_TIME_PROGRESSION		= 256;			/** work Sim time divisor */

	

	public static final int DOUBLE_CURSOR_DISPLAY_TIME_MS	= 1000;

	

	public static final int SIM_SCHEDULE_TIME_MS		= 200000;

	public static final int SIM_SCHEDULE_LIMIT			= 20000;

	

	/*

	 * Item defines

	 */

	/** Fire hazard rating (0-5) */

	public static final int GAS_COOKER_FIRE_RATING		= 3;

	/** Fire hazard rating (0-5) */

	public static final int MICROWAVE_FIRE_RATING		= 1;

	

	/*

	 * Item Cost defines

	 */

	public static final int OVEN_FOOD_COST				= -15;

	public static final int MICROWAVE_FOOD_COST			= -10;

	public static final int FRIDGE_FOOD_COST			= -5;

	public static final int JUICE_COST					= -2;

	public static final int COFFEE_COST					= -1;

	public static final int BBQ_COST					= -10;

	public static final int PARTY_COST_PP				= -10;

	

	/*

	 * Work Defines

	 */

	public static final int JOB_CHEF					= 0;

	public static final int JOB_HEAD_CHEF				= 1;

	public static final int JOB_TRAINER					= 2;

	public static final int JOB_DJ						= 3;

	public static final int JOB_GUITARIST				= 4;

	public static final int JOB_NONE					= -1;

	

	public static final int JOB_DATA_SALARY				= 0;

	public static final int JOB_DATA_START_HOUR			= 1;

	public static final int JOB_DATA_END_HOUR			= 2;

	public static final int JOB_DATA_NUM_FRIENDS		= 3;

	public static final int JOB_DATA_RECRUITING_NPC		= 4;

	public static final int JOB_DATA_SKILL_START		= 5;

	

	public static final int NPC_JOB_DATA_START_HOUR		= 0;

	public static final int NPC_JOB_DATA_END_HOUR		= 1;

	

	public static final int NPC_VISITING_TIME_NPC		= 0;

	public static final int NPC_VISITING_TIME_HOUR		= 1;

	

	public static final int JOB_SALARY_MULTIPLIER		= 10;

	

	/*

	 * Random Door defines

	 */	

	public static final int RANDOM_DOOR_GOOD_EVENT_PCT		= 20;

	public static final int RANDOM_DOOR_BAD_EVENT_PCT		= 15;



	public static final int RANDOM_DOOR_GOOD_EVENT_AMT		= 1000;

	public static final int RANDOM_DOOR_GOOD_EVENT_START	= 25;

	public static final int RANDOM_DOOR_BAD_EVENT_AMT		= 100;

	public static final int RANDOM_DOOR_BAD_EVENT_START		= 5;

	public static final int RANDOM_DOOR_REMOVE_MIN			= 30;

	

	public static final int RANDOM_DOOR_START_HOUR			= 8;

	public static final int RANDOM_DOOR_NUM_HOURS			= 13;



} // End of class WorldData

