package tetris;



import javax.microedition.lcdui.Graphics;

import javax.microedition.lcdui.Image;

import java.io.IOException;

import java.util.Hashtable;



public class blMenu {



	public static final int ITEMTYPE_NORMAL = 0;

	public static final int ITEMTYPE_RANGE = 1;

	public static final int ITEMTYPE_YESNO = 2;

	public static final int ITEMTYPE_ONOFF = 3;



	static final int MAX_ITEMS = 8;

	static final int MAX_HINTSIZE = 4;



	static Hashtable schemes;



	static class blScheme {



		int baseColor,hiliteColor,shadowColor;

		int bgColor,selColor;

		blFont titleFont,itemFont,hintFont;



		public blScheme(blFont title_font, blFont item_font, blFont hint_font, int color, int bg_color, int select_color) {

			titleFont=title_font;

			itemFont=item_font;

			hintFont=hint_font;

			bgColor=bg_color;

			selColor=select_color;

			baseColor=color;

			shadowColor=(color>>>1)&0x007f7f7f;

			int r=(((color>>>16)&0xff)+0xff)/2;

			int g=(((color>>>8)&0xff)+0xff)/2;

			int b=((color&0xff)+0xff)/2;

			hiliteColor=(r<<16)|(g<<8)|b;

		}

	}



	public static void addScheme(blFont title_font, blFont item_font, blFont hint_font, int color, int bg_color, int select_color, String scheme_id) {

		if(schemes==null) {

			schemes = new Hashtable();

		}

		schemes.put(scheme_id,new blScheme(title_font,item_font,hint_font,color,bg_color,select_color));

	}



	blScheme scheme;

	Image img;

	int mx,my,mw,mh;	// menu

	int sx,sy,sw;		// selection

	int center;

	int fy;       		// item font

	int ic;				// item count

	int hl,hy,hfy;		// hint

	int th;				// title

	int cw;				// max characters wide

	String tit;

	int selected;

	blMenuItem items[];



	private int itemToCompareWith = -1;

	private int currentItem = -2;



	int fh;



	public blMenu(String scheme_id, String title, int itemToCompareWith) {

		this(scheme_id, title);

		this.itemToCompareWith = itemToCompareWith;

	}

	public blMenu(String scheme_id, String title) {

		items = new blMenuItem[MAX_ITEMS];

		// grab the scheme

		scheme=(blScheme)schemes.get(scheme_id);

		if(scheme==null) {

			return;

		}

		ic=0;

		hl=0;

		cw=title.length();

		tit=title;

	}



	public void addItem(blMenuItem item) {

		// be sure we don't have too many items

		if(ic>=MAX_ITEMS) {

			return;

		}

		// add the item to our list

		items[ic++]=item;

		// check for any hint lines

		if(item.hint_lines>hl) {

			hl=item.hint_lines;

		}

		// check for the max width

		int l=item.txt.length();

		switch(item.type) {

		case ITEMTYPE_NORMAL:

			break;

		case ITEMTYPE_YESNO:

			l+=5;	// 2+"YES"

			break;

		case ITEMTYPE_ONOFF:

			l+=5;	// 2+"OFF"

			break;

		case ITEMTYPE_RANGE:

			l+=Integer.toString(item.max).length()+2;

			break;

		}

		if(l>cw) {

			cw=l;

		}

	}



	public void build() {

		// grab the item_font info

		fh=scheme.itemFont.getRealHeight();

		int fw=scheme.itemFont.getWidth();

		fy=fh+2;

		// grab the hint_font info

		if(scheme.hintFont!=null) {

			hfy=scheme.hintFont.getRealHeight()+1;

		}

		// calc some stuff

		sw=(cw*fw)+4;

		mw=sw+10;

		mx=(bluelava.getWidth()-mw)/2;

		sx=mx+5;

		center=bluelava.getWidth()/2;

		mh=(ic*fy)+7;

		// adjust for hints

		if(hl>0) {

			hy=(hl*hfy)+2;

			mh+=hy;

		} else {

			mh+=2;

			hy=2;

		}

		// calc the top of the menu and selections

		my=(bluelava.getHeight()-mh)/2;

		sy=my+4;

		// adjust for title

		if(tit!=null) {

			th=scheme.titleFont.getRealHeight();

			mh+=th+2;

			my-=th+2;

		} else {

			sy++;

			mh++;

		}

		img=Image.createImage(mw,mh);

		refresh();

	}



	public void refresh() {

		Graphics ig=img.getGraphics();

		// make the black outline

		ig.setColor(0,0,0);

		ig.drawRect(0,0,mw-1,mh-1);

		// fill with the bg color

		ig.setColor(scheme.bgColor);

		ig.fillRect(1,1,mw-2,mh-2);

		// frame

		int r=mw-2;

		int b=mh-2;

		int ah=mh-hy-2;

		int bt=(tit!=null)?th+4:3;

		ig.setColor(scheme.shadowColor);

		ig.drawLine(r,1,r,b);

		ig.drawLine(1,b,r,b);

		ig.drawLine(3,bt,r-3,bt);

		ig.drawLine(3,bt,3,ah);

		ig.setColor(scheme.hiliteColor);

		ig.drawLine(1,1,1,b);

		ig.drawLine(1,1,r,1);

		ig.drawLine(3,ah,r-2,ah);

		ig.drawLine(r-2,bt,r-2,ah);

		ig.setColor(scheme.baseColor);

		ig.drawRect(2,2,mw-5,mh-5);

		// title area

		if(tit!=null) {

			ig.fillRect(2,2,mw-4,th+2);

			scheme.titleFont.draw(ig,tit,mw/2,3,blFont.CENTER);

		}

		// hint area

		if(hl>0) {

			ig.fillRect(2,ah+1,mw-4,(hfy*hl)+1);

		}

	}



	public void draw(Graphics g) {

		// draw the background

		g.setClip(mx,my,mw,mh);

		g.drawImage(img,mx,my,Graphics.TOP|Graphics.LEFT);

		// draw the selection

		if(selected>=0) {

			g.setColor(scheme.selColor);

			g.fillRect(sx,sy+(fy*selected),sw,fy);

		}

		// draw the items

		int y=sy+1;

		String s;

		for(int i=0;i<ic;i++) {

			switch(items[i].type) {

			case ITEMTYPE_YESNO:

				s=items[i].txt;

				if(items[i].val==0) {

					//s+=": NO";

					s+=": " + localString.texts[localString.NO];



				} else {

					//s+=": YES";

					s+=": " + localString.texts[localString.YES];



				}

				break;

			case ITEMTYPE_ONOFF:

				s=items[i].txt;

				if(items[i].val==0) {

					if(localString.getLanguage().equals("en"))

						s+=": OFF";

					else

						s+=": " + localString.texts[localString.NO];

				} else {

					if(localString.getLanguage().equals("en"))

						s+=": ON";

					else

						s+=": " + localString.texts[localString.YES];

				}



				break;

			case ITEMTYPE_RANGE:

				s=items[i].txt;

				s+=": "+Integer.toString(items[i].val);

				break;

			default:

				s=items[i].txt;

				break;

			}

			scheme.itemFont.draw(g,s,center,y,blFont.CENTER);

			y+=fy;

		}

		// draw any hints

		int hli=items[selected].hint_lines;

		if(hli>0) {

			y+=2;

			for(int i=0;i<hli;i++) {

				scheme.hintFont.draw(g,items[selected].hint[i],center,y,blFont.CENTER);

				y+=hfy;

			}

		}

	}



	public boolean keyPressed(int key, int currentItem) {

		this.currentItem = currentItem;

		return keyPressed(key);

	}



	public boolean keyPressed(int key) {

		if(selected>=0) {

			switch(key) {

			case blDest.KEY_UP:

				if(selected>0) {

					selected--;

					return true;

				}

				break;

			case blDest.KEY_DOWN:

				if(selected<ic-1) {

					selected++;

					return true;

				}

				break;

			case blDest.KEY_LEFT:

				if(items[selected].type>ITEMTYPE_NORMAL) {

					int v=items[selected].val;

					int min=items[selected].min;

					if(v>min) {

						v--;

					} else {

						v=items[selected].max;

					}

					items[selected].val=v;

					if (currentItem == itemToCompareWith)



						return false;



					else



						return true;



				}

			case blDest.KEY_RIGHT:

				if(items[selected].type>ITEMTYPE_NORMAL) {

					int v=items[selected].val;

					int max=items[selected].max;

					if(v<max) {

						v++;

					} else {

						v=items[selected].min;

					}

					items[selected].val=v;

					if (currentItem == itemToCompareWith)



						return false;



					else



						return true;



				}

				break;

			case blDest.KEY_FIRE:

			case blDest.KEY_SELECT:

				if(items[selected].type>ITEMTYPE_RANGE) {

					int v=items[selected].val;

					int max=items[selected].max;

					if(v<max) {

						v++;

					} else {

						v=items[selected].min;

					}

					items[selected].val=v;



					if (currentItem == itemToCompareWith)

						return false;

					else

						return true;

				}

				break;

			}

		}

		return false;

	}



	public int getSelected() {

		return items[selected].key;

	}



	public int getItemValue(int item_key) {

		for(int i=0;i<ic;i++) {

			if(items[i].key==item_key) {

				return items[i].val;

			}

		}

		return -1;

	}



	public void select(int item_key) {

		if(item_key==-1) {

			selected=-1;

			return;

		}

		for(int i=0;i<ic;i++) {

			if(items[i].key==item_key) {

				selected=i;

			}

		}

	}

}

