/*
 * Decompiled with CFR 0.152.
 */
package DemoMoviFutbolin;

import DemoMoviFutbolin.GameCanvas;

public class Unit {
    int width;
    int height;
    int hwidth;
    int hheight;
    int diameter;
    int radius;
    int x;
    int y;
    int z;
    int fx;
    int fy;
    int fz;
    int vx;
    int vy;
    int vz;
    int timing;
    int state;
    int direction;
    int frame;
    boolean inGoal;
    boolean goal;
    int prex;
    int prey;
    int colPlayerDelay;
    boolean colX;
    boolean colY;
    int[] stack = new int[50];
    boolean triggers;
    private static short[] sintable;
    private static short[] costable;
    private static short[] tantable;
    int cola;
    int cola2;

    public Unit(int n) {
        this.diameter = n * 4;
        this.radius = this.diameter / 2;
        this.triggers = true;
    }

    public int lookAt(int n, int n2) {
        return this.calculateDirection(0, this.x, this.y, n, n2);
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.fx = this.x << 8;
        this.fy = this.y << 8;
    }

    public int calculateDirection(int n, int n2, int n3, int n4, int n5) {
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 && n7 == 0) {
            return n;
        }
        int n8 = Unit.atan(n7, n6);
        int n9 = ((n8 + 16) / 32 + 2) % 8;
        return n9;
    }

    public void activate(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.z = 0;
        this.fx = n << 8;
        this.fy = n2 << 8;
        this.fz = 0;
        this.vx = 0;
        this.vy = 0;
        this.vz = 0;
        this.prex = this.fx;
        this.prey = this.fy;
        this.goal = false;
    }

    public int getAngle(int n, int n2) {
        int n3 = this.x - n;
        int n4 = this.y - n2;
        int n5 = Unit.atan(n4, n3);
        return n5;
    }

    public void kick(int n, int n2, int n3, int n4) {
        int n5 = n - this.x;
        int n6 = n2 - this.y;
        int n7 = Unit.atan(n6, n5);
        this.vx = (Unit.cos(n7) >> 2) * n3 >> 8;
        this.vy = (Unit.sin(n7) >> 2) * n3 >> 8;
        this.vz = n4;
        this.fz = 0;
    }

    public void kick(int n, int n2) {
        this.vx = (Unit.cos(n) >> 2) * n2 >> 8;
        this.vy = (Unit.sin(n) >> 2) * n2 >> 8;
        this.fz = 0;
    }

    public void update() {
        int n;
        ++this.timing;
        this.prex = this.fx;
        this.prey = this.fy;
        this.fx += this.vx;
        this.fy += this.vy;
        this.fz += this.vz;
        if (this.fx >= 143360 || this.fx < this.radius << 8) {
            if (!GameCanvas.tutorial && this.fz < 15360 && this.fy <= 228 + (this.radius >> 1) << 8 && this.fy >= 108 - (this.radius >> 1) << 8) {
                n = 0;
                boolean bl = false;
                if (this.fy <= 108 + this.radius << 8) {
                    n = 1;
                }
                if (this.fy >= 228 - this.radius << 8) {
                    bl = true;
                }
                int n2 = Math.abs(this.vy);
                if (n != 0) {
                    this.vy = Math.abs(this.vx);
                    this.vx = -(this.vx >> 1) + (this.x > 280 ? -n2 : n2);
                    if (this.triggers) {
                        GameCanvas.displaySentence(GameCanvas.gc.gameText[21][2], this.x >= 280 ? 0 : 1);
                    }
                }
                if (bl) {
                    this.vy = -Math.abs(this.vx);
                    this.vx = -(this.vx >> 1) + (this.x > 280 ? -n2 : n2);
                    if (this.triggers) {
                        GameCanvas.displaySentence("UYYYYY!", this.x >= 280 ? 0 : 1);
                    }
                }
                if ((this.fx >= 147200 || this.fx < -3840) && this.triggers) {
                    this.goal = true;
                    this.fx *= 2;
                    this.vx = 0;
                    this.vy = 0;
                    this.vz = 0;
                }
            } else {
                this.fx = this.fx >= 71680 ? 143360 : this.radius << 8;
                this.vx = -(this.vx * 160) >> 8;
                n = Math.abs(this.vx);
                this.vz += n;
            }
        }
        if (this.fy + (this.radius << 8) >= 86016 || this.fy < 0) {
            this.fy = this.fy > 168 ? 336 - this.radius << 8 : 0;
            this.vy = -(this.vy * 160) >> 8;
            n = Math.abs(this.vy);
            this.vz += n;
        }
        if (!GameCanvas.kickOffMode) {
            if (this.x > 308) {
                this.vx -= 80;
            } else if (this.x < 252) {
                this.vx += 80;
            } else if (Math.abs(this.vx) < 80) {
                this.vx = this.vx <= 0 || GameCanvas.tutorial ? (this.vx -= 120) : (this.vx += 120);
            }
            int n3 = n = this.fz > 0 ? 18 : 40;
            if (this.vx > 0) {
                this.vx -= n;
            }
            if (this.vx < 0) {
                this.vx += n;
            }
            if (this.vy > 0) {
                this.vy -= n;
            }
            if (this.vy < 0) {
                this.vy += n;
            }
            if (Math.abs(this.vx) < n && Math.abs(this.vy) < n) {
                this.vx = 0;
                this.vy = 0;
            }
        }
        if (this.vz > -10240) {
            this.vz -= 1280;
        }
        this.fz += this.vz;
        if (this.fz < 0) {
            this.fz = 0;
            this.vz = -(this.vz * 6) / 10;
            if (this.vz <= 2560) {
                this.vz = 0;
            }
        }
        if (this.triggers) {
            this.colX = false;
            this.colY = false;
        }
        if (this.fz < 15360) {
            this.colPlayer();
        }
        this.x = this.fx >> 8;
        this.y = this.fy >> 8;
        this.z = this.fz >> 8;
    }

    boolean colPlayer() {
        if (!this.triggers) {
            return false;
        }
        if (this.colPlayerDelay > 0) {
            --this.colPlayerDelay;
            return false;
        }
        int n = this.fx + this.vx;
        int n2 = this.fy + this.vy;
        for (int i = 0; i < 2; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (GameCanvas.kickDelay[i] > 0 || GameCanvas.isBarUp(i)) continue;
            this.colX = false;
            this.colY = false;
            if (this.fx >> 8 < GameCanvas.bestPlayerX[i] + this.radius && n >> 8 >= GameCanvas.bestPlayerX[i] - this.radius || this.fx >> 8 > GameCanvas.bestPlayerX[i] - this.radius && n >> 8 <= GameCanvas.bestPlayerX[i] + this.radius) {
                n6 = n2 + this.fy >> 9;
                n5 = GameCanvas.bestPlayerY[i] - n6;
                n4 = this.diameter;
                n3 = Math.abs(n5);
                if (n3 < n4) {
                    this.colX = true;
                }
            }
            if (this.fy >> 8 < GameCanvas.bestPlayerY[i] && n2 >> 8 >= GameCanvas.bestPlayerY[i] || this.fy >> 8 > GameCanvas.bestPlayerY[i] && n2 >> 8 <= GameCanvas.bestPlayerY[i]) {
                n6 = n + this.fx >> 9;
                n5 = GameCanvas.bestPlayerY[i] - n6;
                n4 = this.diameter;
                n3 = Math.abs(n5);
                if (n3 < n4) {
                    this.colY = true;
                }
            }
            if (!this.colX && !this.colY) continue;
            this.colPlayerDelay = 2;
            n6 = GameCanvas.bestPlayerX[i];
            n5 = GameCanvas.bestPlayerY[i];
            n4 = -1;
            if (this.vx < 0 && this.fx >> 8 > n6 + this.radius) {
                n4 = 2;
            }
            if (this.vx > 0 && this.fx >> 8 < n6 - this.radius) {
                n4 = 6;
            }
            if (this.vy < 0 && this.fy >> 8 > n5 + this.radius) {
                n4 = n4 == -1 ? 4 : ++n4;
            }
            if (this.vy > 0 && this.fy >> 8 < n5 - this.radius) {
                n4 = n4 == -1 ? 0 : --n4;
            }
            n3 = this.vy * 160 >> 8;
            int n7 = this.vx * 160 >> 8;
            switch (n4) {
                case -1: {
                    break;
                }
                case 0: {
                    this.vy = -n3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    int n8 = n7;
                    this.vx = -n3;
                    this.vy = -n8;
                    break;
                }
                case 2: {
                    this.vx = -n7;
                    break;
                }
                case 4: {
                    this.vy = -n7;
                    break;
                }
                case 6: {
                    this.vx = -n7;
                }
            }
            if (this.triggers) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public void pushState() {
        int n = 0;
        this.stack[n++] = this.x;
        this.stack[n++] = this.y;
        this.stack[n++] = this.z;
        this.stack[n++] = this.fx;
        this.stack[n++] = this.fy;
        this.stack[n++] = this.fz;
        this.stack[n++] = this.vx;
        this.stack[n++] = this.vy;
        this.stack[n++] = this.vz;
        this.stack[n++] = this.prex;
        this.stack[n++] = this.prey;
        this.stack[n++] = this.timing;
        this.triggers = false;
    }

    public void popState() {
        int n = 0;
        this.x = this.stack[n++];
        this.y = this.stack[n++];
        this.z = this.stack[n++];
        this.fx = this.stack[n++];
        this.fy = this.stack[n++];
        this.fz = this.stack[n++];
        this.vx = this.stack[n++];
        this.vy = this.stack[n++];
        this.vz = this.stack[n++];
        this.prex = this.stack[n++];
        this.prey = this.stack[n++];
        this.timing = this.stack[n++];
        this.triggers = true;
    }

    public int getDistance(int n, int n2) {
        int n3 = this.y - n2;
        int n4 = this.x - n;
        int n5 = Unit.atan(n3, n4);
        int n6 = Unit.sin(n5);
        if (n6 == 0) {
            return Math.abs(n4);
        }
        int n7 = (n3 << 10) / n6;
        return Math.abs(n7);
    }

    public void soundPlay(int n) {
        GameCanvas.soundPlayEx(n);
    }

    public static void initTables(GameCanvas gameCanvas) {
        byte[] byArray = new byte[384];
        byArray = gameCanvas.loadFile("/trig.bin");
        sintable = new short[64];
        costable = new short[64];
        tantable = new short[64];
        for (int i = 0; i < 64; ++i) {
            Unit.sintable[i] = (short)((byArray[i * 2] & 0xFF) << 8 | byArray[i * 2 + 1] & 0xFF);
            Unit.costable[i] = (short)((byArray[128 + i * 2] & 0xFF) << 8 | byArray[i * 2 + 1 + 128] & 0xFF);
            Unit.tantable[i] = (short)((byArray[i * 2 + 256] & 0xFF) << 8 | byArray[i * 2 + 1 + 256] & 0xFF);
        }
    }

    public static void disposeTables() {
        sintable = null;
        costable = null;
        tantable = null;
    }

    static int sin(int n) {
        while (n < 0) {
            n += 256;
        }
        short s = ((n %= 256) >> 6) % 2 == 0 ? sintable[n % 64] : sintable[63 - n % 64];
        if (n >= 128) {
            s = -s;
        }
        return s;
    }

    static int cos(int n) {
        while (n < 0) {
            n += 256;
        }
        short s = ((n %= 256) >> 6) % 2 == 0 ? costable[n % 64] : costable[63 - n % 64];
        if (n >> 6 == 1 || n >> 6 == 2) {
            s = -s;
        }
        return s;
    }

    static int atan(int n, int n2) {
        int n3 = 0;
        short s = n2 != 0 ? (n << 10) / n2 : (short)99999;
        if (s < 0) {
            s = -s;
        }
        while (tantable[n3] < s && n3 < 63) {
            ++n3;
        }
        if (n >= 0 && n2 >= 0) {
            return n3;
        }
        if (n >= 0 && n2 < 0) {
            return 128 - n3;
        }
        if (n < 0 && n2 < 0) {
            return 128 + n3;
        }
        return (256 - n3) % 256;
    }

    public void miniUpdate() {
        int n;
        ++this.timing;
        int n2 = this.x;
        int n3 = this.y;
        this.fx += this.vx;
        this.fy += this.vy;
        this.fz += this.vz;
        this.vx = this.vx * 70 / 100;
        boolean bl = this.ballCollision(1);
        if (this.fy > 28160 || bl) {
            if (this.fy > 28160) {
                this.fy = 28160;
                this.vy = -(this.vy * 5) / 10;
                if (this.vy >= -512) {
                    this.vy = 0;
                }
            } else {
                n = Math.abs(GameCanvas.balls[this.cola].fx - this.fx);
                if (Math.abs(this.y - GameCanvas.balls[this.cola].y) < 10 && this.timing < 50) {
                    if (this.fx < GameCanvas.balls[this.cola].fx) {
                        this.vx -= 2304 - n / 2;
                        GameCanvas.balls[this.cola].vx += 2304 - n / 2;
                    } else {
                        this.vx += 2304 - n / 2;
                        GameCanvas.balls[this.cola].vx -= 2304 - n / 2;
                    }
                }
                if (Math.abs(GameCanvas.balls[this.cola].y - this.y) > 10) {
                    this.fy = GameCanvas.balls[this.cola].y - 11 << 8;
                    if (GameCanvas.balls[this.cola].vy < 0) {
                        GameCanvas.balls[this.cola].vy = 0;
                    }
                    this.vy = -(this.vy * 6) / 10;
                    if (this.vy >= -512) {
                        this.vy = 0;
                    }
                }
            }
        }
        if (this.fx >= 30720) {
            this.fx = 30720;
            this.vx = -(this.vx * 50) / 100;
        }
        if (this.fx <= 5120) {
            this.fx = 5120;
            this.vx = -(this.vx * 50) / 100;
        }
        if (this.vy < 1706) {
            this.vy += 512;
        }
        this.fy += this.vy;
        this.y = this.fy >> 8;
        if (this.ballCollision(2)) {
            if (this.vy <= 2048 && GameCanvas.balls[this.cola].y > this.y && GameCanvas.balls[this.cola2].y > this.y) {
                this.vy = 0;
                this.fy = GameCanvas.balls[this.cola].y - 10 << 8;
                n = (GameCanvas.balls[this.cola].fx + GameCanvas.balls[this.cola2].fx) / 2;
                this.vx = Math.abs(n) > 7680 && this.timing < 50 ? (this.vx += (this.fx - n) / 15) : 0;
            } else {
                n = Math.abs(GameCanvas.balls[this.cola].fx - this.fx);
                int n4 = Math.abs(GameCanvas.balls[this.cola2].fx - this.fx);
                if (this.fx < GameCanvas.balls[this.cola].fx) {
                    this.vx -= 2304 - n / 2;
                    GameCanvas.balls[this.cola].vx += 2304 - n / 2;
                } else {
                    this.vx += 2304 - n / 2;
                    GameCanvas.balls[this.cola].vx -= 2304 - n / 2;
                }
                if (this.fx < GameCanvas.balls[this.cola2].fx) {
                    this.vx -= 2304 - n4 / 2;
                    GameCanvas.balls[this.cola2].vx += 2304 - n4 / 2;
                } else {
                    this.vx += 2304 - n4 / 2;
                    GameCanvas.balls[this.cola2].vx -= 2304 - n4 / 2;
                }
            }
        }
        this.fy -= this.vy;
        this.x = this.fx >> 8;
        this.y = this.fy >> 8;
        this.z = this.fz >> 8;
        if (this.vy > 1536) {
            ++this.frame;
            this.frame %= 3;
        }
    }

    public boolean ballCollision(int n) {
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < GameCanvas.ballsOut; ++i) {
            if (GameCanvas.balls[i] == this || Math.abs(this.x - GameCanvas.balls[i].x) >= 20 || Math.abs(this.y - GameCanvas.balls[i].y) >= 10) continue;
            if (n2 == 0) {
                this.cola = i;
            } else {
                this.cola2 = i;
            }
            if (++n2 != n) continue;
            return true;
        }
        return false;
    }
}

