/*
 * Decompiled with CFR 0.152.
 */
package com.loboltd.javamap.map;

import com.loboltd.javamap.location.Point;
import com.loboltd.javamap.map.MapCanvas;
import com.loboltd.javamap.map.MapLV1Canvas;
import com.loboltd.javamap.map.MapLV2.MapLV2Canvas;
import com.loboltd.javamap.util.Configuration;
import com.loboltd.javamap.util.ConfigurationMA;
import com.loboltd.javamap.util.CoordinateTool;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import net.kbox.ActionController;
import net.kbox.common.MsgResource;
import net.kbox.component.KCommand;

public class MapCanvasFactory {
    protected Hashtable defaultCmd = new Hashtable();
    MsgResource msgRes = MsgResource.getInstance();

    public MapCanvas createNestedLV1MapCanvas(String area, Configuration config) {
        double width = config.getDouble("L1.MAP_W");
        double height = config.getDouble("L1.MAP_H");
        double top_left_ln = config.getDouble("L1.LT_LN");
        double top_left_lat = config.getDouble("L1.LT_LAT");
        double bottom_right_ln = config.getDouble("L1.RB_LN");
        double bottom_right_lat = config.getDouble("L1.RB_LAT");
        MapLV1Canvas mapL1 = new MapLV1Canvas("MAPL1");
        mapL1.setArea(area);
        mapL1.setLV(1);
        mapL1.setRate(width / CoordinateTool.getDX(top_left_ln, top_left_lat, bottom_right_ln, bottom_right_lat), height * 1.0 / CoordinateTool.getDY(top_left_ln, top_left_lat, bottom_right_ln, bottom_right_lat));
        mapL1.setFixLn(top_left_ln);
        mapL1.setFixLat(top_left_lat);
        mapL1.setCommandListener(ActionController.getInstance());
        return mapL1;
    }

    public MapCanvas createNestedLV1MapCanvas(String area, ConfigurationMA config) {
        double width = config.getDouble("L1.MAP_W");
        double height = config.getDouble("L1.MAP_H");
        double top_left_ln = config.getDouble("L1.LT_LN");
        double top_left_lat = config.getDouble("L1.LT_LAT");
        double bottom_right_ln = config.getDouble("L1.RB_LN");
        double bottom_right_lat = config.getDouble("L1.RB_LAT");
        MapLV1Canvas mapL1 = new MapLV1Canvas("MAPL1");
        mapL1.setArea(area);
        mapL1.setLV(1);
        mapL1.setRate(width / CoordinateTool.getDX(top_left_ln, top_left_lat, bottom_right_ln, bottom_right_lat), height * 1.0 / CoordinateTool.getDY(top_left_ln, top_left_lat, bottom_right_ln, bottom_right_lat));
        mapL1.setFixLn(top_left_ln);
        mapL1.setFixLat(top_left_lat);
        mapL1.setCommandListener(ActionController.getInstance());
        return mapL1;
    }

    public MapCanvas createNestedLV2MapCanvas(String area, int lv, Configuration config) {
        int blockx = config.getInt("L" + lv + ".BLOCKX");
        int blocky = config.getInt("L" + lv + ".BLOCKY");
        int block_width = config.getInt("L" + lv + ".BLOCK_W");
        int block_height = config.getInt("L" + lv + ".BLOCK_H");
        double tl_ln = config.getDouble("L" + lv + ".LT_LN");
        double tl_lat = config.getDouble("L" + lv + ".LT_LAT");
        double br_ln = config.getDouble("L" + lv + ".RB_LN");
        double br_lat = config.getDouble("L" + lv + ".RB_LAT");
        MapLV2Canvas mapL2 = new MapLV2Canvas("MAPL2");
        mapL2.setMaxBlockX(blockx);
        mapL2.setMaxBlockY(blocky);
        mapL2.setMapBlockWidth(block_width);
        mapL2.setMapBlockHeight(block_height);
        mapL2.setArea(area);
        mapL2.setLV(lv);
        mapL2.setRate((double)(block_width * blockx) / CoordinateTool.getDX(tl_ln, tl_lat, br_ln, br_lat), (double)(block_height * blocky * 1) / CoordinateTool.getDY(tl_ln, tl_lat, br_ln, br_lat));
        mapL2.setFixLn(tl_ln);
        mapL2.setFixLat(tl_lat);
        mapL2.setCommandListener(ActionController.getInstance());
        return mapL2;
    }

    public MapCanvas createNestedLV2MapCanvas(String area, int lv, ConfigurationMA config) {
        int blockx = config.getInt("L" + lv + ".BLOCKX");
        int blocky = config.getInt("L" + lv + ".BLOCKY");
        int block_width = config.getInt("L" + lv + ".BLOCK_W");
        int block_height = config.getInt("L" + lv + ".BLOCK_H");
        double tl_ln = config.getDouble("L" + lv + ".LT_LN");
        double tl_lat = config.getDouble("L" + lv + ".LT_LAT");
        double br_ln = config.getDouble("L" + lv + ".RB_LN");
        double br_lat = config.getDouble("L" + lv + ".RB_LAT");
        MapLV2Canvas mapL2 = new MapLV2Canvas("MAPL2");
        mapL2.setMaxBlockX(blockx);
        mapL2.setMaxBlockY(blocky);
        mapL2.setMapBlockWidth(block_width);
        mapL2.setMapBlockHeight(block_height);
        mapL2.setArea(area);
        mapL2.setLV(lv);
        mapL2.setRate((double)(block_width * blockx) / CoordinateTool.getDX(tl_ln, tl_lat, br_ln, br_lat), (double)(block_height * blocky * 1) / CoordinateTool.getDY(tl_ln, tl_lat, br_ln, br_lat));
        mapL2.setFixLn(tl_ln);
        mapL2.setFixLat(tl_lat);
        mapL2.setCommandListener(ActionController.getInstance());
        return mapL2;
    }

    protected void addCmd(MapCanvas mc, Vector cmds) {
        Enumeration enu = cmds.elements();
        while (enu.hasMoreElements()) {
            mc.addCommand((Command)enu.nextElement());
        }
    }

    public MapCanvas createMapCanvas(String area) {
        if (area == null) {
            throw new RuntimeException("The area is null!");
        }
        KCommand exit = new KCommand(this.msgRes.getMsg("EXIT"), 7, 10, "EXIT", null);
        KCommand origin = new KCommand("\u8fd4\u56de\u539f\u9ede", 8, 50, "ORIGIN", null);
        KCommand zoom = new KCommand(this.msgRes.getMsg("ZOOM"), 8, 0, "ZOOM", null);
        KCommand viclist = new KCommand("\u9644\u8fd1\u9910\u5ef3", 8, 30, "VICLIST", null);
        Hashtable<String, String> parametersOfSearchIndex = new Hashtable<String, String>();
        parametersOfSearchIndex.put("queryFactoryClass", "com.loboltd.javamap.query.QueryFactoryOfIndex");
        KCommand searchIndex = new KCommand("\u5730\u9ede\u641c\u5c0b", 8, 10, "CREATE_SEARCHFIELD", parametersOfSearchIndex);
        Hashtable<String, String> parametersOfSearchDetail = new Hashtable<String, String>();
        parametersOfSearchDetail.put("queryFactoryClass", "com.loboltd.javamap.query.QueryFactoryOfDetail");
        KCommand searchDetail = new KCommand(this.msgRes.getMsg("RSTSEARCH"), 8, 20, "CREATE_SEARCHFIELD", parametersOfSearchDetail);
        Hashtable<String, Boolean> parametersOfOpenBookMark = new Hashtable<String, Boolean>();
        parametersOfOpenBookMark.put("isReset", new Boolean(true));
        parametersOfOpenBookMark.put("isNext", new Boolean(true));
        KCommand openBookmark = new KCommand(this.msgRes.getMsg("MYFAVOR"), 8, 60, "OPENBOOKMARK", parametersOfOpenBookMark);
        Hashtable parametersOfMyLocations = new Hashtable();
        Vector<Point> myLocations = new Vector<Point>();
        Point p = new Point(114.168778, 22.297047);
        myLocations.addElement(p);
        parametersOfMyLocations.put("myLocations", myLocations);
        KCommand myLocation = new KCommand(this.msgRes.getMsg("MYLOCATION"), 8, 40, "MYLOCATION", parametersOfMyLocations);
        Hashtable<String, String> parametersOfSwitchArea = new Hashtable<String, String>();
        parametersOfSwitchArea.put("area", area);
        System.out.println("area:" + area);
        KCommand switchArea = new KCommand(this.msgRes.getMsg("SWITCHAREA"), 8, 70, "SWITCHAREA", parametersOfSwitchArea);
        this.defaultCmd.put(exit.getLabel(), exit);
        this.defaultCmd.put(zoom.getLabel(), zoom);
        this.defaultCmd.put(searchIndex.getLabel(), searchIndex);
        this.defaultCmd.put(searchDetail.getLabel(), searchDetail);
        this.defaultCmd.put(openBookmark.getLabel(), openBookmark);
        this.defaultCmd.put(switchArea.getLabel(), switchArea);
        this.defaultCmd.put(myLocation.getLabel(), myLocation);
        this.defaultCmd.put(origin.getLabel(), origin);
        this.defaultCmd.put(viclist.getLabel(), viclist);
        Vector<KCommand> mapL1Cmd = new Vector<KCommand>();
        mapL1Cmd.addElement(exit);
        mapL1Cmd.addElement(zoom);
        mapL1Cmd.addElement(searchIndex);
        mapL1Cmd.addElement(searchDetail);
        mapL1Cmd.addElement(openBookmark);
        mapL1Cmd.addElement(switchArea);
        Vector<KCommand> mapL2Cmd = new Vector<KCommand>();
        mapL2Cmd.addElement(exit);
        mapL2Cmd.addElement(zoom);
        mapL2Cmd.addElement(searchIndex);
        mapL2Cmd.addElement(searchDetail);
        mapL2Cmd.addElement(openBookmark);
        mapL2Cmd.addElement(switchArea);
        mapL2Cmd.addElement(myLocation);
        mapL2Cmd.addElement(origin);
        mapL2Cmd.addElement(viclist);
        String configPath = "/CONFIG/" + area + "/MAP_CONFIG.db";
        Configuration config = Configuration.getInstance().config(configPath);
        MapCanvas mapL1 = this.createNestedLV1MapCanvas(area, config);
        this.addCmd(mapL1, mapL1Cmd);
        int lv = 2;
        MapCanvas mapPre = mapL1;
        while (config.getString("L" + lv + ".BLOCKX") != null) {
            MapCanvas mapL2 = this.createNestedLV2MapCanvas(area, lv, config);
            mapPre.setNextMapCanvas(mapL2);
            mapPre = mapL2;
            ++lv;
            this.addCmd(mapL2, mapL2Cmd);
        }
        mapPre.setNextMapCanvas(mapL1);
        config.clear();
        System.gc();
        return mapL1;
    }
}

