/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient;

import javax.microedition.io.ConnectionNotFoundException;
import se.tactel.tvclient.InteractivityController;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Config;
import se.tactel.tvclient.gui.interactivity.FullScreenInteractivityHandler;
import se.tactel.tvclient.gui.interactivity.SplitScreenInteractivityHandler;
import se.tactel.tvclient.gui.screen.exit.ExitWindow;
import se.tactel.tvclient.gui.screen.guide.GuideScreenController;
import se.tactel.tvclient.gui.screen.loading.SplashController;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;
import se.tactel.tvclient.gui.screen.option.OptionsMenuWindow;
import se.tactel.tvclient.gui.screen.tab.channels.ChannelsWindow;
import se.tactel.tvclient.gui.screen.tab.news.NewsWindow;
import se.tactel.tvclient.gui.screen.tab.store.StoreController;
import se.tactel.tvclient.gui.screen.tab.tv.TvScreenController;
import se.tactel.tvclient.gui.screen.tooltip.TooltipWindow;
import se.tactel.tvclient.gui.screen.wait.WaitWindow;
import se.tactel.tvclient.gui.statusbar.StatusBarController;
import se.tactel.tvclient.gui.userdialog.Command;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.notificationcenter.Notification;
import se.tactel.tvclient.notificationcenter.NotificationCenter;
import se.tactel.tvclient.notificationcenter.Observer;
import se.tactel.tvclient.player.TVPlayer;
import se.tactel.tvclient.resource.ResourceManager;
import se.tactel.tvclient.util.Log;

public class Controller
implements Observer {
    public static final String EXIT_REQUEST = "CanYouPleaseExit";
    private StatusBarController statusBarController = null;
    private InteractivityController interactivityController = null;
    private TvScreenController tvScreenController;
    private GuideScreenController guideScreenController;
    private StoreController storeController;
    private FullScreenInteractivityHandler fullScreenInteractivityHandler;
    private SplitScreenInteractivityHandler splitScreenInteractivityHandler;
    private Window statusBarWindow;
    private Window tvScreenWindow;
    private NewsWindow newsWindow;
    private ChannelsWindow channelsWindow;
    OptionsMenuWindow optionsMenuWindow;
    private static WaitWindow waitWindow;
    private static TooltipWindow tooltipWindow;
    RichMediaMIDlet midlet = null;
    SplashController splash = new SplashController();
    private boolean playerStartCommandFlag;

    public Controller(RichMediaMIDlet midlet) {
        this.midlet = midlet;
        this.splash.create();
    }

    public void startup(String initURL) {
        try {
            String initURLToUseWhenConnecting;
            this.splash.createSlideshow();
            this.interactivityController = new InteractivityController(this);
            ServiceRegistry.instance().getDataProvider().getInteractivityData().addObserver(this.interactivityController);
            NotificationCenter.defaultCenter().addObserver(this, EXIT_REQUEST, null);
            this.fullScreenInteractivityHandler = new FullScreenInteractivityHandler();
            this.splitScreenInteractivityHandler = new SplitScreenInteractivityHandler();
            Config config = ServiceRegistry.instance().getDataProvider().getConfig();
            this.splash.progress();
            if (initURL != null && !"".equals(initURL)) {
                config.setBaseUrl(initURL);
                initURLToUseWhenConnecting = config.getInitUrl() + "?" + "lang=" + ServiceRegistry.instance().getLocalConfiguration().getLanguage() + "&client_version=" + RichMediaMIDlet.version;
                int slideshowId = ServiceRegistry.instance().getLocalConfiguration().getCurrentSlideshowGroup().id;
                if (slideshowId != -1) {
                    initURLToUseWhenConnecting = initURLToUseWhenConnecting + "&slideshow_group_id=" + slideshowId;
                }
            } else {
                Log.log(0x40000000L, "Unable to determine INIT url to startup server!");
                return;
            }
            ServiceRegistry.instance().getComm().processUrl(initURLToUseWhenConnecting, 2);
            if (config.getContentInfoUrlWithLang() != null && ServiceRegistry.instance().getDataProvider().getFolderList().getAllFolders().size() == 0) {
                ServiceRegistry.instance().getComm().processUrl(config.getContentInfoUrlWithLang(), 2);
            }
            ServiceRegistry.instance().registerPlayer(new TVPlayer());
            this.tvScreenController = new TvScreenController(this);
            this.tvScreenWindow = this.tvScreenController.createWindow();
            this.tvScreenWindow.makeKeyWindow();
            this.tvScreenWindow.orderBack();
            this.statusBarController = new StatusBarController();
            this.statusBarWindow = this.statusBarController.createWindow();
            this.statusBarWindow.orderBack();
            this.splash.progress();
            ResourceManager.instance();
            this.guideScreenController = new GuideScreenController();
            String ninUrl = config.getNinURL();
            if (ninUrl != null) {
                String ninInitUrl = ninUrl + "?version=" + config.getNinVersion() + "&cmd=start";
                if (!config.getStartupChannelId().equals("-1")) {
                    ninInitUrl = ninInitUrl + "&menu=" + config.getNinMenu() + "&key=" + config.getStartupChannelId();
                }
                ServiceRegistry.instance().getComm().processUrl(ninInitUrl, 2, false);
                if (ServiceRegistry.instance().getDataProvider().getCurrentNiNError() != null) {
                    ServiceRegistry.instance().getComm().processUrl("res://error_internet_connect_exit.xml");
                }
            } else {
                Log.log(0x40000000L, "NIN URL not available, not doing NiN init call");
            }
            ServiceRegistry.instance().getDataProvider().getDataUpdateThread().start();
            this.splash.progress();
            ServiceRegistry.instance().getPlayer();
            Channel c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(config.getStartupChannelId());
            ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().requestContentSwitch(c);
            if (c != null) {
                Log.log(0x100000000L, "Starting up on: " + c);
            } else {
                Log.log(0x40000000L, "No content available to start up on.");
            }
            this.splash.progress();
            ServiceRegistry.instance().getPlayer().setInitialVolumeLevel(100);
            this.splash.progress();
            this.splash.clean();
            ServiceRegistry.instance().getWindowServer().setStartupFinished();
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        catch (OutOfMemoryError error) {
            System.gc();
            Log.log(0x40000000L, error.toString());
        }
        catch (Throwable t) {
            System.gc();
            Log.log(0x40000000L, t.toString());
        }
    }

    public void endApplication() {
        Log.log(0x200000010L, "Quiting...");
        this.midlet.endApplication();
    }

    public RichMediaMIDlet getMidlet() {
        return this.midlet;
    }

    public void doPlatformRequest(String url) {
        try {
            RichMediaMIDlet.instance().platformRequest(url);
        }
        catch (ConnectionNotFoundException e) {
            Log.log(0x80000000L, "Exception while trying to browse to url: " + url + " exc: " + e.toString());
        }
    }

    protected void processUserdialogCommand(Command dlgCommand) {
        Log.log(128L, "**********Processing command in controller: " + dlgCommand.getCommand());
        if (dlgCommand == null) {
            return;
        }
        String command = dlgCommand.getCommand();
        if (command != null && command.length() > 0) {
            String url;
            if (command.equals("mtv:closeApp")) {
                ExitWindow ew = new ExitWindow(false);
                ew.makeModal();
                ew.makeKeyAndOrderFront();
                ew.display();
            } else if (command.equals("mtv:browse")) {
                String url2 = dlgCommand.getAttribute("xlink:href");
                if (url2 != null && url2.length() > 0) {
                    this.doPlatformRequest(url2);
                }
            } else if (command.equals("mtv:go")) {
                String url3 = dlgCommand.getAttribute("xlink:href");
                if (url3 != null) {
                    if (url3.endsWith(".htm") || url3.endsWith(".html") || url3.endsWith(".wml") || url3.endsWith(".xhtml")) {
                        this.doPlatformRequest(url3);
                    } else {
                        ServiceRegistry.instance().getComm().processUrl(url3);
                    }
                }
            } else if (command.equals("mtv:download") && (url = dlgCommand.getAttribute("xlink:href")) != null && url.length() > 0) {
                try {
                    this.midlet.platformRequest(url);
                }
                catch (ConnectionNotFoundException e) {
                    Log.exception(this, e);
                }
            }
        }
    }

    public void notifiedWithNotification(Notification notification) {
        if (EXIT_REQUEST == notification.name()) {
            this.endApplication();
        }
    }

    public NewsWindow getNewsWindow() {
        if (this.newsWindow == null) {
            this.newsWindow = new NewsWindow(this);
        }
        return this.newsWindow;
    }

    public ChannelsWindow getChannelsWindow() {
        if (this.channelsWindow == null) {
            this.channelsWindow = new ChannelsWindow(this);
        }
        return this.channelsWindow;
    }

    public Window getTvScreenWindow() {
        if (this.tvScreenWindow == null) {
            this.tvScreenWindow = this.tvScreenController.createWindow();
        }
        return this.tvScreenWindow;
    }

    public OptionsMenuWindow getOptionsMenuWindow(OptionsMenuItem[] menuItems) {
        if (this.optionsMenuWindow == null) {
            this.optionsMenuWindow = new OptionsMenuWindow(menuItems);
        } else {
            this.optionsMenuWindow.updateItems(menuItems);
        }
        if (this.channelsWindow != null && this.channelsWindow.isKeyWindow()) {
            this.channelsWindow.deactivateTickersForCurrentlySelectedItem();
        }
        return this.optionsMenuWindow;
    }

    public void closeOptionMenuWindow() {
        if (this.optionsMenuWindow != null) {
            this.optionsMenuWindow.close();
        }
    }

    public static WaitWindow getWaitWindow() {
        if (waitWindow == null) {
            waitWindow = new WaitWindow();
        }
        return waitWindow;
    }

    public static void popUpWaitWindowAndLoadUrl(String url) {
        new WaitWindow(url).makeKeyAndOrderFront();
    }

    public static TooltipWindow getTooltipWindow(int id) {
        if (tooltipWindow == null) {
            tooltipWindow = new TooltipWindow();
        }
        tooltipWindow.setText(id);
        return tooltipWindow;
    }

    public InteractivityController getInteractivityController() {
        return this.interactivityController;
    }

    public Window getStatusBarWindow() {
        return this.statusBarWindow;
    }

    public GuideScreenController getGuideScreenController() {
        return this.guideScreenController;
    }

    public StoreController getStoreController() {
        if (this.storeController == null) {
            this.storeController = new StoreController(this);
        }
        return this.storeController;
    }

    public TvScreenController getTvScreenController() {
        return this.tvScreenController;
    }

    public FullScreenInteractivityHandler getFullScreenInteractivityHandler() {
        return this.fullScreenInteractivityHandler;
    }

    public SplitScreenInteractivityHandler getSplitScreenInteractivityHandler() {
        return this.splitScreenInteractivityHandler;
    }

    public StatusBarController getStatusBarController() {
        return this.statusBarController;
    }

    public void setPlayerStartCommandFlag(boolean b) {
        this.playerStartCommandFlag = b;
    }

    public boolean getPlayerStartCommandFlag() {
        return this.playerStartCommandFlag;
    }
}

