/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient;

import java.util.Enumeration;
import java.util.Timer;
import java.util.Vector;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.windowing.ApplicationCanvas;
import se.tactel.tvclient.gui.windowing.ApplicationDelegate;
import se.tactel.tvclient.util.Log;

public class TimeoutHandler
implements ApplicationDelegate,
Runnable {
    private static TimeoutHandler self;
    Timer timer;
    boolean run = true;
    Object lock;
    private boolean reset = false;
    private Vector timeouts = new Vector();

    private TimeoutHandler() {
        this.lock = new Object();
        new Thread(this).start();
    }

    public static TimeoutHandler createTimeoutHandler() {
        if (self == null) {
            self = new TimeoutHandler();
        }
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.reset = true;
            this.lock.notify();
        }
    }

    public void addInactivityTimeout(long interval, Action action) {
        this.timeouts.addElement(new InactivityTimeout(interval, action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            long totWaitTime = 0L;
            while (this.run) {
                Object object = this.lock;
                synchronized (object) {
                    long waitTime = this.timeToNextInactivityTimeout(totWaitTime);
                    this.lock.wait(waitTime);
                    if (this.reset) {
                        this.resetInactivityTimeouts();
                        totWaitTime = 0L;
                        this.reset = false;
                    } else {
                        totWaitTime += waitTime;
                    }
                }
                this.activateInactivityTimeouts(totWaitTime);
            }
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }

    private long timeToNextInactivityTimeout(long totInactiveTime) {
        long bestInterval = Long.MAX_VALUE;
        Enumeration e = this.timeouts.elements();
        while (e.hasMoreElements()) {
            InactivityTimeout timeout = (InactivityTimeout)e.nextElement();
            if (timeout.getInterval() <= totInactiveTime || timeout.getInterval() >= bestInterval) continue;
            bestInterval = timeout.getInterval();
        }
        return bestInterval - totInactiveTime;
    }

    private void resetInactivityTimeouts() {
        Enumeration e = this.timeouts.elements();
        while (e.hasMoreElements()) {
            InactivityTimeout timeout = (InactivityTimeout)e.nextElement();
            timeout.setDone(false);
        }
    }

    private void activateInactivityTimeouts(long totInactiveTime) {
        Enumeration e = this.timeouts.elements();
        while (e.hasMoreElements()) {
            InactivityTimeout timeout = (InactivityTimeout)e.nextElement();
            if (timeout.getInterval() > totInactiveTime || timeout.isDone()) continue;
            try {
                timeout.getAction().clicked(null);
            }
            catch (Exception exception) {
                Log.exception(this, exception);
            }
            timeout.setDone(true);
        }
    }

    public boolean eventForApplication(Event event, ApplicationCanvas canvas) {
        this.reset();
        return false;
    }

    public void hideNotify() {
    }

    public void showNotify() {
    }

    public void sizeChanged(Point point) {
    }

    private static class InactivityTimeout {
        private long interval = 0L;
        private Action action = null;
        private boolean done = false;

        public InactivityTimeout(long interval, Action action) {
            this.interval = interval;
            this.action = action;
        }

        public long getInterval() {
            return this.interval;
        }

        public Action getAction() {
            return this.action;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }
    }
}

