/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.data.Epg;
import se.tactel.tvclient.data.Folder;

public class Channel
implements Content {
    public static final String TOKEN_ACCESS = "access";
    private String id = "-1";
    private Folder parentFolder;
    private String name;
    private String iconUrl;
    private String informationUrl;
    private String description;
    private boolean subscribed = false;
    private boolean paymentAllowed = false;
    private boolean visible = false;
    private String adultUrl;
    private boolean userVisible = true;
    private int order = -1;
    private String menu = "";
    private String tokenType = "access";
    private String codecType = "";
    private boolean availableOnNin;
    private boolean availableOnAs;

    public Channel(String id) {
        this.id = id;
    }

    public Channel(Channel otherChannel) {
        this.id = otherChannel.id;
        this.parentFolder = otherChannel.parentFolder;
        this.name = otherChannel.name;
        this.iconUrl = otherChannel.iconUrl;
        this.informationUrl = otherChannel.informationUrl;
        this.description = otherChannel.description;
        this.subscribed = otherChannel.subscribed;
        this.paymentAllowed = otherChannel.paymentAllowed;
        this.visible = otherChannel.visible;
        this.adultUrl = otherChannel.adultUrl;
        this.order = otherChannel.order;
        this.userVisible = otherChannel.userVisible;
        this.menu = otherChannel.menu;
        this.tokenType = otherChannel.tokenType;
        this.codecType = otherChannel.codecType;
    }

    public String getId() {
        return this.id;
    }

    public String getEcdsId() {
        return this.getId();
    }

    public String getName() {
        return this.name != null ? this.name : this.id;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPaymentAllowed() {
        return this.paymentAllowed;
    }

    public void setPaymentAllowed(boolean subscribe) {
        this.paymentAllowed = subscribe;
    }

    public boolean isVisible() {
        return this.visible && this.iconUrl != null && this.availableOnNin && this.availableOnAs;
    }

    public boolean isVisibleAccordingToASAttribute() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setAdultUrl(String url) {
        this.adultUrl = url;
    }

    public String getAdultUrl() {
        return this.adultUrl;
    }

    public String getInformationUrl() {
        return this.informationUrl;
    }

    public void setInformationUrl(String informationurl) {
        this.informationUrl = informationurl;
    }

    public Folder getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(Folder f) {
        this.parentFolder = f;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getMenu() {
        return this.menu;
    }

    public void setMenu(String menu) {
        this.menu = menu;
    }

    public boolean isNotAvailable() {
        Epg.EpgProgram epgProgram = ServiceRegistry.instance().getDataProvider().getEpg().getCurrentProgramForChannelWithId(this.getId());
        if (epgProgram == null) {
            return false;
        }
        return "SIN EMISION".equals(epgProgram.programGenre);
    }

    public boolean isUserVisible() {
        return this.userVisible;
    }

    public void setUserVisible(boolean userVisible) {
        this.userVisible = userVisible;
        ServiceRegistry.instance().getDataProvider().getChannelConfiguration().setChannelVisible(this.id, userVisible);
    }

    public void setUserVisibleWithoutChangingOrder(boolean userVisible) {
        this.userVisible = userVisible;
    }

    public void setAvailableOnNin(boolean availableOnNin) {
        this.availableOnNin = availableOnNin;
    }

    public void setAvailableOnAs(boolean availableOnAs) {
        this.availableOnAs = availableOnAs;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String token) {
        this.tokenType = token;
    }

    public String getCodecType() {
        return this.codecType;
    }

    public void setCodecType(String codecType) {
        this.codecType = codecType;
    }

    public String toString() {
        String channelStr = "Channel id=\"" + this.id + "\" parent=\"" + (this.parentFolder == null ? "NONE" : this.parentFolder.getId()) + "\" name=\"" + this.name + "\" order=\"" + this.order + "\" user visbile=\"" + this.userVisible + "\" n/a=\"" + this.isNotAvailable() + "\" description=\"" + this.description + "\" icon url=\"" + this.iconUrl + "\" informationurl=\"" + this.informationUrl + "\" subscribed=\"" + this.subscribed + "\" pay allow=\"" + this.paymentAllowed + "\" visible=\"" + this.visible + "\" adult url=\"" + this.adultUrl + "\" token=\"" + this.tokenType + "\" codecType=\"" + this.codecType + "\"";
        return channelStr;
    }

    public Content clone() {
        return new Channel(this);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.iconUrl == null ? 0 : this.iconUrl.hashCode());
        result = 31 * result + (this.informationUrl == null ? 0 : this.informationUrl.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parentFolder == null ? 0 : this.parentFolder.hashCode());
        result = 31 * result + (this.paymentAllowed ? 1231 : 1237);
        result = 31 * result + (this.subscribed ? 1231 : 1237);
        result = 31 * result + (this.visible ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Channel other = (Channel)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.iconUrl == null ? other.iconUrl != null : !this.iconUrl.equals(other.iconUrl)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.informationUrl == null ? other.informationUrl != null : !this.informationUrl.equals(other.informationUrl)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parentFolder == null ? other.parentFolder != null : !this.parentFolder.equals(other.parentFolder)) {
            return false;
        }
        if (this.paymentAllowed != other.paymentAllowed) {
            return false;
        }
        if (this.subscribed != other.subscribed) {
            return false;
        }
        if (this.visible != other.visible) {
            return false;
        }
        if (this.visible != other.visible) {
            return false;
        }
        if (this.adultUrl == null ? other.adultUrl != null : !this.adultUrl.equals(other.adultUrl)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        if (this.userVisible != other.userVisible) {
            return false;
        }
        if (this.tokenType == null ? other.tokenType != null : !this.tokenType.equals(other.tokenType)) {
            return false;
        }
        return !(this.codecType == null ? other.codecType != null : !this.codecType.equals(other.codecType));
    }
}

