/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Folder;
import se.tactel.tvclient.data.FolderList;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.util.Utils;

public class ChannelList
extends ObservableData {
    private Hashtable channels = new Hashtable();

    public void updateChannel(Channel c) {
        this.channels.put(c.getId(), c);
    }

    public Channel getChannel(String id) {
        return (Channel)this.channels.get(id);
    }

    public Vector getSortedVisibleChannels() {
        Vector<Channel> result = new Vector<Channel>();
        Enumeration e = this.channels.elements();
        while (e.hasMoreElements()) {
            Channel channel = (Channel)e.nextElement();
            if (!channel.isVisible() || !channel.isUserVisible()) continue;
            result.addElement(channel);
        }
        Utils.bubbleSort(result, new Utils.ContentOrderComparator());
        return result;
    }

    public Vector getAllChannels() {
        Vector<Channel> result = new Vector<Channel>();
        Enumeration e = this.channels.elements();
        while (e.hasMoreElements()) {
            Channel channel = (Channel)e.nextElement();
            if (!channel.isVisible()) continue;
            result.addElement(channel);
        }
        Utils.bubbleSort(result, new Utils.ContentOrderComparator());
        return result;
    }

    public Vector getAll() {
        Vector<Channel> result = new Vector<Channel>();
        Enumeration e = this.channels.elements();
        while (e.hasMoreElements()) {
            Channel channel = (Channel)e.nextElement();
            result.addElement(channel);
        }
        Utils.bubbleSort(result, new Utils.ContentOrderComparator());
        return result;
    }

    public Vector getSubscribedSortedVisibleChannels() {
        Vector<Channel> result = new Vector<Channel>();
        Vector v = this.getSortedVisibleChannels();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Channel channel = (Channel)e.nextElement();
            if (!channel.isSubscribed()) continue;
            result.addElement(channel);
        }
        return result;
    }

    public void removeChannel(String id) {
        FolderList folderList = ServiceRegistry.instance().getDataProvider().getFolderList();
        Channel channel = this.getChannel(id);
        if (channel == null) {
            return;
        }
        Vector folders = folderList.getAllFolders();
        for (int i = 0; i < folders.size(); ++i) {
            Folder folder = (Folder)folders.elementAt(i);
            if (!folder.containsContent(channel.getId())) continue;
            folder.removeContent(channel);
        }
        this.channels.remove(id);
    }

    public boolean contains(String channelId) {
        return this.channels.containsKey(channelId);
    }

    public String toString() {
        return this.channels.toString();
    }
}

