/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import se.tactel.tvclient.Controller;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.gui.screen.tab.store.StoreWindow;
import se.tactel.tvclient.gui.screen.tab.store.availablein.PurchaseOptionsDatasource;
import se.tactel.tvclient.gui.screen.wait.WaitWindow;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class CurrentContent
extends ObservableData {
    private Content currentContent = null;
    private ObservableData currentContentObserverableData = new ObservableData(){};
    public static final int SWITCH_RESULT_CODE_NOTHING = 0;
    public static final int SWITCH_RESULT_CODE_NOT_AVAILABLE = 1;
    public static final int SWITCH_RESULT_CODE_PURCHACE_INDIVIDUALLY = 2;
    public static final int SWITCH_RESULT_CODE_PURCHASE_BUNDLE = 3;
    public static final int SWITCH_RESULT_CODE_ADULT_CHECK = 4;
    public static final int SWITCH_RESULT_CODE_DIFFERENT_CODEC_RESTART = 5;
    public static final int SWITCH_RESULT_CODE_CONTENT_SWITCHED = 6;
    public static final int SWITCH_RESULT_CODE_CONTENT_ALREADY_RUNNING = 7;
    private boolean channelListObserverInited = false;

    public void addContentSwitchingObserver(Observer observer) {
        this.currentContentObserverableData.addObserver(observer);
    }

    public Content getCurrentContent() {
        return this.currentContent;
    }

    public synchronized int requestContentSwitch(Content newCurrentContent) {
        if (!this.channelListObserverInited) {
            this.initContentObservers();
        }
        Log.log(0x200040000L, "Content switch request from: " + this.currentContent);
        Log.log(0x200040000L, "                      ...to: " + newCurrentContent);
        if (newCurrentContent == null) {
            Log.log(0x40040000L, "Content switch to 'null' content, aborting!");
            return 0;
        }
        if (((Channel)newCurrentContent).isNotAvailable()) {
            Log.log(0x200040000L, "Channel is not available.");
            ServiceRegistry.instance().getComm().processUrlASync("res://error_channel_not_available.xml");
            return 1;
        }
        if (!newCurrentContent.isSubscribed()) {
            PurchaseOptionsDatasource purchaseOptionsDatasource = new PurchaseOptionsDatasource();
            purchaseOptionsDatasource.useContent(newCurrentContent);
            if (purchaseOptionsDatasource.isOnlyPossibleToPurchaseIndividually()) {
                String url = ServiceRegistry.instance().getDataProvider().getConfig().getContentOfferingUrl(newCurrentContent);
                Log.log(0x4000000000L, "Initiating purchase for channel: " + url);
                ServiceRegistry.instance().getController().getTvScreenController().playerView.hideAndRepaint(false);
                Controller.popUpWaitWindowAndLoadUrl(url);
                Utils.sleep(300L);
                return 2;
            }
            StoreWindow w = RichMediaMIDlet.instance().tController.getStoreController().getAvailableInWindow((Channel)newCurrentContent);
            ServiceRegistry.instance().getController().getTvScreenController().playerView.hideAndRepaint(true);
            w.makeKeyAndOrderFront();
            return 3;
        }
        String adultUrl = ((Channel)newCurrentContent).getAdultUrl();
        if (adultUrl != null && adultUrl.length() > 0) {
            Log.log(0x200040000L, "Is adult channel with url: " + adultUrl);
            Controller.popUpWaitWindowAndLoadUrl(adultUrl);
            return 4;
        }
        if (!(this.currentContent == null || !ServiceRegistry.instance().getPlayer().isRunning() || ((Channel)newCurrentContent).getCodecType().equals(((Channel)this.currentContent).getCodecType()) && ((Channel)newCurrentContent).getTokenType().equals(((Channel)this.currentContent).getTokenType()))) {
            this.restartStreamDueToDifferentCodecOrTokenTypes(newCurrentContent);
            return 5;
        }
        if (this.currentContent != null && this.currentContent.getId() == newCurrentContent.getId() && ServiceRegistry.instance().getPlayer().isRunning()) {
            return 7;
        }
        if (!ServiceRegistry.instance().getPlayer().isRunning()) {
            this.restartStreamDueToStoppedPlayer(newCurrentContent);
        } else {
            this.performContentSwitch(newCurrentContent);
        }
        return 6;
    }

    public void restartStreamDueToDifferentCodecOrTokenTypes(Content newCurrentContent) {
        String url = ServiceRegistry.instance().getDataProvider().getConfig().getRestartStreamUrl();
        url = url + "?lang=" + ServiceRegistry.instance().getLocalization().getLanguageCode() + "&channel_id=" + newCurrentContent.getId() + "&event=channelSwitch" + "&codecType1=" + ((Channel)this.currentContent).getCodecType() + "&tokenType1=" + ((Channel)this.currentContent).getTokenType() + "&codecType2=" + ((Channel)newCurrentContent).getCodecType() + "&tokenType2=" + ((Channel)newCurrentContent).getTokenType();
        RichMediaMIDlet.instance().tController.getTvScreenController().startSpinning();
        ServiceRegistry.instance().getComm().processUrl(url);
    }

    public void restartStreamDueToStoppedPlayer(Content newCurrentContent) {
        String url = ServiceRegistry.instance().getDataProvider().getConfig().getRestartStreamUrl();
        url = url + "?lang=" + ServiceRegistry.instance().getLocalization().getLanguageCode() + "&channel_id=" + newCurrentContent.getId() + "&event=startStream";
        RichMediaMIDlet.instance().tController.getTvScreenController().startSpinning();
        ServiceRegistry.instance().getComm().processUrl(url);
    }

    public synchronized void performContentSwitch(Content newCurrentContent) {
        Log.log(0x200040000L, "Switching to " + newCurrentContent.toString());
        if (!ServiceRegistry.instance().getPlayer().isRunning()) {
            ServiceRegistry.instance().getPlayer().setPlayerNeedsRestart();
        }
        if (ServiceRegistry.instance().getPlayer().attemptToSwitchChannel((Channel)newCurrentContent)) {
            Log.log(0x200040000L, "Channel switch suceeded.");
            this.currentContent = newCurrentContent.clone();
            this.notifyObservers();
            this.currentContentObserverableData.notifyObservers();
        } else {
            Log.log(0x40040000L, "Channel switch failed for: " + newCurrentContent.toString());
        }
    }

    private void initContentObservers() {
        this.channelListObserverInited = true;
        Log.log(0x200040000L, "Observering the channel list to catch data changes in current content");
        ServiceRegistry.instance().getDataProvider().getChannelList().addObserver(new Observer(){

            public void update(ObservableData data) {
                Channel content;
                if (CurrentContent.this.currentContent != null && (content = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(CurrentContent.this.currentContent.getId())) != null && !content.equals(CurrentContent.this.currentContent)) {
                    if (!content.isSubscribed() && CurrentContent.this.currentContent.isSubscribed()) {
                        try {
                            ServiceRegistry.instance().getPlayer().stopPlayer();
                            ServiceRegistry.instance().getPlayer().setPlayerNeedsRestart();
                        }
                        catch (Exception e) {
                            Log.exception(this, e);
                        }
                        WaitWindow waitWindow = Controller.getWaitWindow();
                        waitWindow.makeKeyAndOrderFront();
                        ServiceRegistry.instance().getComm().processUrlASync("res://error_tmp_subscription_expiration.xml");
                    }
                    Log.log(0x200040000L, "Data in current content has changed from: " + CurrentContent.this.currentContent.toString() + "\n" + "                                                           to: " + content.toString());
                    CurrentContent.this.currentContent = content.clone();
                    CurrentContent.this.notifyObservers();
                }
            }
        });
    }
}

