/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import java.util.Vector;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Config;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class DataUpdateThread
extends Thread
implements Observer {
    protected void initialRun() {
        Log.log(0x200000010L, "DUT - Initial run");
        Config config = ServiceRegistry.instance().getDataProvider().getConfig();
        try {
            this.updateEpgAllChannels();
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        if (config.getSlideShowUrlWithLang() != null) {
            ServiceRegistry.instance().getComm().processUrl(config.getSlideShowUrlWithLang(), 0);
        }
        if (config.getInteractivityRequestUrl() != null) {
            String url = config.getInteractivityRequestUrl();
            ServiceRegistry.instance().getComm().processUrlASync(url);
            Log.log(0x200000080L, "Making startup HTTP interactivity call to: '" + url + "'");
        }
        if (config.getPromotionSvgUrl() != null && !"".equals(config.getPromotionSvgUrl())) {
            RichMediaMIDlet.instance().tController.getNewsWindow().setUserDialogToDisplay(config.getPromotionSvgUrl());
        }
        if (ServiceRegistry.instance().getDataProvider().getConfig().getContentInfoUpdateInterval() != null) {
            ServiceRegistry.instance().getDataProvider().getConfig().getContentInfoUpdateInterval().addObserver(this);
            Log.log(0x200000000L, "DUT - Content info update interval activated");
        }
    }

    private void initialRunDelayed() {
        ServiceRegistry.instance().getDataProvider().getSlideShow().process();
    }

    public void run() {
        try {
            Thread.sleep(1000L);
            this.initialRun();
            Thread.sleep(25000L);
            this.initialRunDelayed();
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }

    public void update(ObservableData data) {
        Log.log(0x200000010L, "DUT - Update due to - " + data);
        Config config = ServiceRegistry.instance().getDataProvider().getConfig();
        if (data instanceof Config.Interval && data == config.getContentInfoUpdateInterval()) {
            ServiceRegistry.instance().getComm().processUrl(config.getContentInfoUrlWithLang(), 0);
        } else {
            Log.log(0x40000010L, "DUT - Illegal state");
        }
    }

    private void updateEpgAllChannels() {
        Vector channels = ServiceRegistry.instance().getDataProvider().getChannelList().getSortedVisibleChannels();
        Vector<Channel> channelIds = new Vector<Channel>();
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = (Channel)channels.elementAt(i);
            if (this.hasEpgDataForChannel(channel.getId())) continue;
            channelIds.addElement(channel);
        }
        if (channelIds.size() > 0) {
            String[] ids = new String[channelIds.size()];
            for (int i = 0; i < channelIds.size(); ++i) {
                ids[i] = ((Channel)channelIds.elementAt(i)).getId();
            }
            long startTm = Utils.getTime().getTime();
            long stopTm = startTm + 1L;
            String url = ServiceRegistry.instance().getDataProvider().getConfig().getEpgUrl(ids, startTm, stopTm);
            Log.log(0x20000000L, "DUT - Update EPG for subscribed channels, URL: " + url);
            ServiceRegistry.instance().getComm().processUrlASync(url, 0);
        }
    }

    private boolean hasEpgDataForChannel(String channelId) {
        return ServiceRegistry.instance().getDataProvider().getEpg().getCurrentProgramForChannelWithId(channelId) != null && ServiceRegistry.instance().getDataProvider().getEpg().getNextProgramForChannelWithId(channelId) != null;
    }
}

