/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.ProgramComparator;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class Epg
extends ObservableData {
    Hashtable channels = new Hashtable();
    ProgramComparator comparator = new ProgramComparator();
    private static Timer t;
    private static Hashtable notifyTimes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EpgDay getEpgDataFull(String channel, Date day) {
        Calendar c = Utils.getDate(day);
        Integer dow = new Integer(c.get(7));
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            EpgDay ed;
            EpgChannel ec;
            boolean request = false;
            if (this.channels.containsKey(channel)) {
                ec = (EpgChannel)this.channels.get(channel);
                if (ec.days.containsKey(dow)) {
                    ed = (EpgDay)ec.days.get(dow);
                } else {
                    ed = new EpgDay(dow);
                    ec.days.put(dow, ed);
                    request = true;
                }
            } else {
                ec = new EpgChannel(channel);
                ed = new EpgDay(dow);
                ec.days.put(dow, ed);
                this.channels.put(channel, ec);
                request = true;
            }
            if (request || !ed.isRequested()) {
                ed.setRequested(true);
                String url = ServiceRegistry.instance().getDataProvider().getConfig().getEpgUrl(channel, Math.max(Utils.currentTimeMillis(), Utils.getMillisAtBeginningOfDay(day)), Utils.getMillisAtEndOfDay(day));
                ServiceRegistry.instance().getComm().processUrlASync(url);
            }
            return ed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEpgDataEmpty(String channel, Date day) {
        Calendar c = Utils.getDate(day);
        Integer dow = new Integer(c.get(7));
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            if (this.channels.containsKey(channel)) {
                EpgDay ed;
                Vector programs;
                EpgChannel ec = (EpgChannel)this.channels.get(channel);
                if (ec.days.containsKey(dow) && (programs = (ed = (EpgDay)ec.days.get(dow)).getPrograms()) != null && programs.size() > 0) {
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EpgDay getDayAsIs(String channel, Date day) {
        Calendar c = Utils.getDate(day);
        Integer dow = new Integer(c.get(7));
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            if (this.channels.containsKey(channel)) {
                EpgChannel ec = (EpgChannel)this.channels.get(channel);
                if (ec.days.containsKey(dow)) {
                    return (EpgDay)ec.days.get(dow);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDownloadDaySync(String channel, Date day) {
        Calendar c = Utils.getDate(day);
        Integer dow = new Integer(c.get(7));
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            EpgDay ed;
            EpgChannel ec;
            if (this.channels.containsKey(channel)) {
                ec = (EpgChannel)this.channels.get(channel);
                if (ec.days.containsKey(dow)) {
                    ed = (EpgDay)ec.days.get(dow);
                } else {
                    ed = new EpgDay(dow);
                    ec.days.put(dow, ed);
                }
            } else {
                ec = new EpgChannel(channel);
                ed = new EpgDay(dow);
                ec.days.put(dow, ed);
                this.channels.put(channel, ec);
            }
            ed.setRequested(true);
        }
        String url = ServiceRegistry.instance().getDataProvider().getConfig().getEpgUrl(channel, Math.max(Utils.currentTimeMillis(), Utils.getMillisAtBeginningOfDay(day)), Utils.getMillisAtEndOfDay(day));
        boolean downloadOk = ServiceRegistry.instance().getComm().processUrl(url);
        Hashtable hashtable2 = this.channels;
        synchronized (hashtable2) {
            EpgDay ed;
            if (downloadOk && (ed = this.getDayAsIs(channel, day)) != null) {
                ed.setForcedDownloaded(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EpgProgram getCurrentProgramForChannelWithId(String chId) {
        Calendar c = Utils.getDate();
        Integer dow = new Integer(c.get(7));
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            if (this.channels.containsKey(chId)) {
                EpgChannel ec = (EpgChannel)this.channels.get(chId);
                if (ec.days.containsKey(dow)) {
                    EpgDay d = (EpgDay)ec.days.get(dow);
                    return d.getCurrentProgram();
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EpgProgram getNextProgramForChannelWithId(String chId) {
        Calendar c = Utils.getDate();
        Integer dow = new Integer(c.get(7));
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            if (this.channels.containsKey(chId)) {
                EpgChannel ec = (EpgChannel)this.channels.get(chId);
                if (ec.days.containsKey(dow)) {
                    EpgDay d = (EpgDay)ec.days.get(dow);
                    return d.getNextProgram();
                }
            }
            return null;
        }
    }

    private void removeNotifyTime(long time) {
        if (notifyTimes != null) {
            Long key = new Long(time);
            notifyTimes.remove(key);
        }
    }

    private boolean existsNotifyTime(long time) {
        if (notifyTimes != null) {
            Long key = new Long(time);
            return notifyTimes.containsKey(key);
        }
        return false;
    }

    private void addNotifyTime(long time) {
        if (notifyTimes != null) {
            Long key = new Long(time);
            notifyTimes.put(key, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEpgData(String channelId, String programName, String programDescription, String programGenre, String startTime, String stopTime) {
        try {
            EpgProgram ep = new EpgProgram(programName, programDescription, programGenre, Long.parseLong(startTime), Long.parseLong(stopTime));
            if ("SIN EMISION".equals(ep.programGenre)) {
                long start = ep.startTime.getTime();
                long stop = ep.endTime.getTime();
                if (Utils.currentTimeMillis() <= stop) {
                    if (Utils.currentTimeMillis() <= start && !this.existsNotifyTime(start)) {
                        this.scheduleNotifyTimerTask(start);
                    }
                    if (!this.existsNotifyTime(stop)) {
                        this.scheduleNotifyTimerTask(stop);
                    }
                }
            }
            Hashtable hashtable = this.channels;
            synchronized (hashtable) {
                return this.addEpgProgramToChannel(channelId, ep);
            }
        }
        catch (Exception e) {
            Log.exception(this, e);
            return false;
        }
    }

    private void scheduleNotifyTimerTask(long time) {
        try {
            if (notifyTimes == null) {
                notifyTimes = new Hashtable();
            }
            if (t == null) {
                t = new Timer();
            }
            if (!this.existsNotifyTime(time)) {
                t.schedule(new TimerTask(){

                    public void run() {
                        Log.log(0x220000000L, "Timer task running, time: " + new Date(Utils.currentTimeMillis()) + " sceduled at: " + new Date(this.scheduledExecutionTime()));
                        ServiceRegistry.instance().getDataProvider().getChannelList().notifyObservers();
                        ServiceRegistry.instance().getDataProvider().getEpg().notifyObservers();
                        Epg.this.removeNotifyTime(this.scheduledExecutionTime());
                    }
                }, time - Utils.currentTimeMillis());
                Log.log(0x220000000L, "Timer task set to occur " + new Date(time) + " delay = " + (time - Utils.currentTimeMillis()));
                this.addNotifyTime(time);
            }
        }
        catch (IllegalArgumentException e) {
            Log.exception(this, e);
            Log.log(0x220000000L, "Timer task schedule time was in the past.");
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }

    protected boolean addEpgProgramToChannel(String id, EpgProgram ep) {
        if (!this.channels.containsKey(id)) {
            this.channels.put(id, new EpgChannel(id));
        }
        return this.addEpgProgramToDay((EpgChannel)this.channels.get(id), ep);
    }

    protected boolean addEpgProgramToDay(EpgChannel ec, EpgProgram ep) {
        Calendar cal = Utils.getDate(ep.startTime);
        Integer dayOfWeek = new Integer(cal.get(7));
        if (!ec.days.containsKey(dayOfWeek)) {
            EpgDay ed = new EpgDay(dayOfWeek);
            ec.days.put(dayOfWeek, ed);
        }
        return this.addEpgProgramToProgramList((EpgDay)ec.days.get(dayOfWeek), ep);
    }

    protected boolean addEpgProgramToProgramList(EpgDay ed, EpgProgram ep) {
        boolean contains = false;
        for (int i = 0; i < ed.programs.size(); ++i) {
            EpgProgram cp = (EpgProgram)ed.programs.elementAt(i);
            if (cp.startTime.getTime() != ep.startTime.getTime()) continue;
            contains = true;
            Log.log(0x220000000L, "Epg item not added. Already exists in list.");
            break;
        }
        if (!contains) {
            ed.addProgram(ep);
            Utils.bubbleSort(ed.programs, this.comparator);
            Log.log(0x220000000L, "New epg item added to cache: " + ep.programName + " (" + ep.startTime.getTime() + "-" + ep.endTime.getTime() + ")");
            return true;
        }
        return false;
    }

    public static class EpgProgram {
        public Date startTime;
        public Date endTime;
        public String programName;
        public String programDescription;
        public String programGenre;

        public EpgProgram(String name, String description, String genre, long start, long end) {
            this.programName = name;
            this.programDescription = description;
            this.programGenre = genre;
            this.startTime = new Date(start);
            this.endTime = new Date(end);
        }

        public String getTextForUI() {
            String endMinute;
            String endHour;
            String startMinute;
            String s = "";
            Calendar calstart = Utils.getDate(this.startTime);
            Calendar calend = Utils.getDate(this.endTime);
            String startHour = Integer.toString(calstart.get(11));
            if (startHour.length() < 2) {
                startHour = "0" + startHour;
            }
            if ((startMinute = Integer.toString(calstart.get(12))).length() < 2) {
                startMinute = "0" + startMinute;
            }
            if ((endHour = Integer.toString(calend.get(11))).length() < 2) {
                endHour = "0" + endHour;
            }
            if ((endMinute = Integer.toString(calend.get(12))).length() < 2) {
                endMinute = "0" + endMinute;
            }
            s = s + startHour + ":" + startMinute + "-" + endHour + ":" + endMinute + "  " + this.programName;
            return s;
        }

        public String toString() {
            return new String("EPG info: " + this.programName + "\n" + this.startTime.toString() + "-" + this.endTime.toString() + "\n" + this.programDescription);
        }
    }

    public static class EpgDay {
        public Integer dayOfWeek = null;
        private Vector programs = null;
        private boolean requested;
        private boolean forcedDownloaded = false;

        public EpgDay(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            this.programs = new Vector();
        }

        public void addProgram(EpgProgram ep) {
            this.programs.addElement(ep);
        }

        public Vector getPrograms() {
            return this.programs;
        }

        public EpgProgram getCurrentProgram() {
            Enumeration enu = this.programs.elements();
            EpgProgram obj = null;
            long now = Utils.currentTimeMillis();
            while (enu.hasMoreElements()) {
                obj = (EpgProgram)enu.nextElement();
                if (now <= obj.startTime.getTime() || now >= obj.endTime.getTime()) continue;
                return obj;
            }
            return null;
        }

        public EpgProgram getNextProgram() {
            Enumeration enu = this.programs.elements();
            EpgProgram obj = null;
            long now = Utils.currentTimeMillis();
            while (enu.hasMoreElements()) {
                obj = (EpgProgram)enu.nextElement();
                if (now <= obj.startTime.getTime() || now >= obj.endTime.getTime() || !enu.hasMoreElements()) continue;
                return (EpgProgram)enu.nextElement();
            }
            return null;
        }

        public void setRequested(boolean b) {
            this.requested = b;
        }

        public boolean isRequested() {
            return this.requested;
        }

        public void setForcedDownloaded(boolean b) {
            this.forcedDownloaded = b;
        }

        public boolean isForcedDownloaded() {
            return this.forcedDownloaded;
        }
    }

    public static class EpgChannel {
        Hashtable days = null;
        String id = null;

        public EpgChannel(String id) {
            this.id = id;
            this.days = new Hashtable();
        }
    }
}

