/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class Folder
implements Content {
    private String id = "-1";
    private Folder parentFolder = null;
    private String name;
    private String url;
    private String iconUrl;
    private String description;
    private String informationUrl;
    private boolean subscribed = true;
    private boolean paymentAllowed = false;
    private boolean visible = true;
    private String extraInfo;
    private String streamInformationUrl;
    private int order = 0;
    private Hashtable childrenMap = new Hashtable();
    private Vector cachedSortedListOfChildren = null;

    public Folder(String id, Folder parentFolder) {
        this.id = id;
        this.parentFolder = parentFolder;
    }

    public Folder(String id) {
        this.id = id;
    }

    private Folder(Folder otherFolder) {
        this.id = otherFolder.id;
        this.parentFolder = otherFolder.parentFolder;
        this.name = otherFolder.name;
        this.url = otherFolder.url;
        this.iconUrl = otherFolder.iconUrl;
        this.description = otherFolder.description;
        this.informationUrl = otherFolder.informationUrl;
        this.subscribed = otherFolder.subscribed;
        this.paymentAllowed = otherFolder.paymentAllowed;
        this.visible = otherFolder.visible;
        this.extraInfo = otherFolder.extraInfo;
        this.streamInformationUrl = otherFolder.streamInformationUrl;
        this.order = otherFolder.order;
        this.childrenMap = otherFolder.childrenMap;
    }

    public String getId() {
        return this.id;
    }

    public String getEcdsId() {
        return this.getId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIconUrl(String iconurl) {
        this.iconUrl = iconurl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public synchronized void setChildren(Vector c) {
        for (int i = 0; i < c.size(); ++i) {
            Content content = (Content)c.elementAt(i);
            this.childrenMap.put(content.getId(), content);
        }
        this.cachedSortedListOfChildren = null;
    }

    public synchronized void removeContent(Content c) {
        if (c == null) {
            return;
        }
        if (this.childrenMap.containsKey(c.getId())) {
            this.childrenMap.remove(c.getId());
            this.cachedSortedListOfChildren = null;
        } else {
            Log.log(0x100000000L, "Trying to remove not available" + c.toString() + " from " + this.toString());
        }
    }

    public synchronized void removeAllChildren() {
        this.childrenMap = new Hashtable();
        this.cachedSortedListOfChildren = null;
    }

    public synchronized boolean updateChild(Content c) {
        Content existent = (Content)this.childrenMap.get(c.getId());
        if (!c.equals(existent)) {
            this.childrenMap.put(c.getId(), c);
            this.cachedSortedListOfChildren = null;
            return true;
        }
        return false;
    }

    public synchronized Enumeration getChildren() {
        if (this.cachedSortedListOfChildren == null) {
            this.cachedSortedListOfChildren = new Vector();
            Enumeration e = this.childrenMap.elements();
            while (e.hasMoreElements()) {
                this.cachedSortedListOfChildren.addElement((Content)e.nextElement());
            }
            Utils.bubbleSort(this.cachedSortedListOfChildren, new Utils.ContentOrderComparator());
        }
        return this.cachedSortedListOfChildren.elements();
    }

    public synchronized Content getContent(String id) {
        Enumeration e = this.childrenMap.elements();
        while (e.hasMoreElements()) {
            Content contentInSubFolder;
            Content c = (Content)e.nextElement();
            if (c.getId().equals(id)) {
                return c;
            }
            if (!(c instanceof Folder) || (contentInSubFolder = ((Folder)c).getContent(id)) == null) continue;
            return contentInSubFolder;
        }
        return null;
    }

    public synchronized boolean containsContent(String contentId) {
        return this.getContent(contentId) != null;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    public boolean isPaymentAllowed() {
        return this.paymentAllowed;
    }

    public void setPaymentAllowed(boolean subscribe) {
        this.paymentAllowed = subscribe;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInformationUrl() {
        return this.informationUrl;
    }

    public void setInformationUrl(String url) {
        this.informationUrl = url;
    }

    public String getStreamInformationUrl() {
        return this.streamInformationUrl;
    }

    public void setStreamInformationUrl(String streamInformationURL) {
        this.streamInformationUrl = streamInformationURL;
    }

    public String toString() {
        String folderStr = "Folder id=\"" + this.id + "\" parent=\"" + (this.parentFolder == null ? "NONE" : this.parentFolder.getId()) + "\" name=\"" + this.name + "\" order=\"" + this.order + "\" description=\"" + this.description + "\" url=\"" + this.url + "\" icon url=\"" + this.iconUrl + "\" order=\"" + this.order + "\" information url=\"" + this.informationUrl + "\" pay allow=\"" + this.paymentAllowed + "\" subscribed=\"" + this.subscribed + "\" visible=\"" + this.visible + "\" extra info=\"" + this.extraInfo + "\" streaminformation url=\"" + this.streamInformationUrl + "\" number of children=\"" + this.childrenMap.size() + "\" children: \"" + this.getChildrenString() + "\"";
        return folderStr;
    }

    private String getChildrenString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.getChildren();
        while (e.hasMoreElements()) {
            Content c = (Content)e.nextElement();
            if (c instanceof Folder) {
                sb.append("[F]" + c.getId() + " ");
                continue;
            }
            if (c instanceof Channel) {
                sb.append("[C]" + c.getId() + " ");
                continue;
            }
            sb.append("? ");
        }
        return sb.toString();
    }

    public Content clone() {
        return new Folder(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Folder other = (Folder)obj;
        if (this.childrenMap == null ? other.childrenMap != null : !((Object)this.childrenMap).equals(other.childrenMap)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.iconUrl == null ? other.iconUrl != null : !this.iconUrl.equals(other.iconUrl)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.informationUrl == null ? other.informationUrl != null : !this.informationUrl.equals(other.informationUrl)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parentFolder == null ? other.parentFolder != null : !this.parentFolder.equals(other.parentFolder)) {
            return false;
        }
        if (this.paymentAllowed != other.paymentAllowed) {
            return false;
        }
        if (this.subscribed != other.subscribed) {
            return false;
        }
        if (this.streamInformationUrl == null ? other.streamInformationUrl != null : !this.streamInformationUrl.equals(other.streamInformationUrl)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        if (this.visible != other.visible) {
            return false;
        }
        if (this.extraInfo != other.extraInfo) {
            return false;
        }
        return this.order == other.order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getMenu() {
        return "";
    }

    public void setMenu(String menu) {
    }
}

