/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Slideshow;
import se.tactel.tvclient.data.localization.Locale;
import se.tactel.tvclient.data.localization.Localization;
import se.tactel.tvclient.data.localization.LocalizationData;
import se.tactel.tvclient.data.persistence.Persister;
import se.tactel.tvclient.util.Log;

public class LocalConfiguration
extends ObservableData {
    private final Persister persister;
    private int language = 0;
    private LocalizationData localizationData = null;
    private Hashtable interactivityKeysTable = new Hashtable();
    private Slideshow.SlideshowGroup currentSlideshowGroup = new Slideshow.SlideshowGroup();
    private int tooltipTv = 0;
    private int tooltipFav = 0;

    public LocalConfiguration(Persister p, LocalizationData localizationData) {
        this.localizationData = localizationData;
        this.persister = p;
        Log.log(0x200010000L, "Creating local configuration");
        this.deserialize(this.persister.load());
        this.setLanguage(this.language);
    }

    public String getLanguage() {
        return this.localizationData.getLanguageCode();
    }

    public void setLanguage(int language) {
        if (language < Localization.getLocalizationVector().size()) {
            this.localizationData.setLocale((Locale)Localization.getLocalizationVector().elementAt(language));
        }
        this.language = language;
        this.persister.save(this.serialize());
        this.notifyObservers();
    }

    public Hashtable getInteractivityKeysTable() {
        return this.interactivityKeysTable;
    }

    public void addInteractivityKey(String name, String value) {
        if (name != null && value != null) {
            this.interactivityKeysTable.put(name, value);
            this.persister.save(this.serialize());
            this.notifyObservers();
        }
    }

    public void removeInteractivityKey(String name) {
        if (name != null && this.interactivityKeysTable.containsKey(name)) {
            this.interactivityKeysTable.remove(name);
            ServiceRegistry.instance().getComm().removeKey(name);
            this.persister.save(this.serialize());
        }
    }

    public Slideshow.SlideshowGroup getCurrentSlideshowGroup() {
        return this.currentSlideshowGroup;
    }

    public void setCurrentSlideshowGroup(Slideshow.SlideshowGroup slideshowGroup) {
        this.currentSlideshowGroup = slideshowGroup;
        this.persister.save(this.serialize());
        this.notifyObservers();
    }

    byte[] serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            Log.log(0x200010000L, "Persisting local configuration: " + this.toString());
            os.writeUTF(Integer.toString(this.language));
            if (this.currentSlideshowGroup != null) {
                Slideshow.Slide s;
                int i;
                os.writeInt(this.currentSlideshowGroup.id);
                os.writeInt(this.currentSlideshowGroup.cachedId);
                os.writeInt(this.currentSlideshowGroup.startupSlides.size());
                for (i = 0; i < this.currentSlideshowGroup.startupSlides.size(); ++i) {
                    s = (Slideshow.Slide)this.currentSlideshowGroup.startupSlides.elementAt(i);
                    os.writeInt(s.order);
                    os.writeUTF(s.url);
                    os.writeInt(s.duration);
                }
                os.writeInt(this.currentSlideshowGroup.exitSlides.size());
                for (i = 0; i < this.currentSlideshowGroup.exitSlides.size(); ++i) {
                    s = (Slideshow.Slide)this.currentSlideshowGroup.exitSlides.elementAt(i);
                    os.writeInt(s.order);
                    os.writeUTF(s.url);
                    os.writeInt(s.duration);
                }
            } else {
                os.writeInt(0);
            }
            Enumeration elements = this.interactivityKeysTable.keys();
            os.writeInt(this.interactivityKeysTable.size());
            while (elements.hasMoreElements()) {
                String name = (String)elements.nextElement();
                String value = (String)this.interactivityKeysTable.get(name);
                os.writeUTF(name);
                os.writeUTF(value);
            }
            os.writeInt(this.tooltipTv);
            os.writeInt(this.tooltipFav);
        }
        catch (IOException e) {
            Log.exception(this, e);
        }
        return baos.toByteArray();
    }

    void deserialize(byte[] serializedLocalConfiguration) {
        if (serializedLocalConfiguration == null) {
            Log.log(0x200010000L, "No previous local configuration persisted, starting up with default values: " + this.toString());
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(serializedLocalConfiguration));
        try {
            int i;
            String slanguage = is.readUTF();
            this.language = Integer.valueOf(slanguage);
            int slideShowId = is.readInt();
            if (slideShowId != 0) {
                Slideshow.Slide s;
                this.currentSlideshowGroup.startupSlides.removeAllElements();
                this.currentSlideshowGroup.id = slideShowId;
                this.currentSlideshowGroup.cachedId = is.readInt();
                int size = is.readInt();
                for (i = 0; i < size; ++i) {
                    s = new Slideshow.Slide();
                    s.order = is.readInt();
                    s.url = is.readUTF();
                    s.duration = is.readInt();
                    this.currentSlideshowGroup.startupSlides.addElement(s);
                }
                size = is.readInt();
                for (i = 0; i < size; ++i) {
                    s = new Slideshow.Slide();
                    s.order = is.readInt();
                    s.url = is.readUTF();
                    s.duration = is.readInt();
                    this.currentSlideshowGroup.exitSlides.addElement(s);
                }
            }
            int keyPairs = is.readInt();
            for (i = 0; i < keyPairs; ++i) {
                String name = is.readUTF();
                String value = is.readUTF();
                if (name == null || value == null) continue;
                this.interactivityKeysTable.put(name, value);
                ServiceRegistry.instance().getComm().addKey(name, value);
            }
            this.tooltipTv = is.readInt();
            this.tooltipFav = is.readInt();
        }
        catch (IOException e) {
            Log.exception(this, e);
        }
        Log.log(0x200010000L, "Deserialized local configuration: " + this.toString());
    }

    public int getTooltipTV() {
        return this.tooltipTv;
    }

    public int getTooltipFavorites() {
        return this.tooltipFav;
    }

    public void increaseTooltipTV() {
        ++this.tooltipTv;
        this.persister.save(this.serialize());
        this.notifyObservers();
    }

    public void increaseTooltipFavorites() {
        ++this.tooltipFav;
        this.persister.save(this.serialize());
        this.notifyObservers();
    }

    public String toString() {
        return "language =\"" + this.language + "\" " + " current slide show=\"" + this.currentSlideshowGroup.toString() + "\"";
    }
}

