/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data;

import java.util.Enumeration;
import java.util.Vector;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.util.Log;

public abstract class ObservableData {
    public Vector observers = new Vector();

    public void addObserver(Observer o) {
        this.observers.addElement(o);
        Log.log(0x200004000L, "Adding observer " + o.getClass().getName() + " for observable " + this.getClass().getName() + ", " + this.observers.size() + " currently observing " + "the observerable.");
    }

    public void deleteObserver(Observer o) {
        this.observers.removeElement(o);
    }

    protected void deleteObservers() {
        this.observers.removeAllElements();
    }

    public void notifyObservers() {
        new Thread(new Notifier(this.observers, this)).start();
    }

    public void notifyObserversSync() {
        Enumeration e = this.observers.elements();
        while (e.hasMoreElements()) {
            Observer observer = (Observer)e.nextElement();
            if (observer != null) {
                try {
                    observer.update(this);
                }
                catch (Exception exception) {
                    Log.exception(observer, exception);
                }
                catch (Error error) {
                    Log.log(0x40004000L, "Caught error during notify: " + error.toString());
                }
                continue;
            }
            Log.log(0x100004000L, "Attempting to update null observer!");
        }
    }

    static class Notifier
    implements Runnable {
        Vector observers;
        ObservableData data;

        public Notifier(Vector observers, ObservableData data) {
            this.observers = observers;
            this.data = data;
        }

        public void run() {
            Enumeration e = this.observers.elements();
            while (e.hasMoreElements()) {
                Observer observer = (Observer)e.nextElement();
                if (observer != null) {
                    try {
                        observer.update(this.data);
                    }
                    catch (Exception exception) {
                        Log.exception(observer, exception);
                    }
                    catch (Error error) {
                        Log.log(0x40004000L, "Caught error during notify: " + error.toString());
                    }
                    continue;
                }
                Log.log(0x100004000L, "Attempting to update null observer!");
            }
        }
    }
}

