/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.data.localization;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import se.tactel.tvclient.data.localization.Locale;
import se.tactel.tvclient.util.Log;

public class LocalizationData {
    private String version;
    private Locale locale;
    private Hashtable translatedwords;
    public static final int NONE = -1;
    public static final int SOFTKEY_OPTIONS = 1;
    public static final int SOFTKEY_CANCEL = 2;
    public static final int SOFTKEY_SELECT = 3;
    public static final int SOFTKEY_ACCEPT = 4;
    public static final int SOFTKEY_BACK = 5;
    public static final int SOFTKEY_YES = 6;
    public static final int SOFTKEY_NO = 7;
    public static final int OPTIONS_HELP = 100;
    public static final int OPTIONS_QUIT = 101;
    public static final int OPTIONS_WATCH = 102;
    public static final int OPTIONS_GOTO_WAP = 103;
    public static final int OPTIONS_GUIDE = 104;
    public static final int OPTIONS_OPEN = 105;
    public static final int OPTIONS_MOVE = 110;
    public static final int OPTIONS_HIDE = 111;
    public static final int OPTIONS_SHOW_ALL = 112;
    public static final int OPTIONS_VOLUME = 120;
    public static final int OPTIONS_FULLSCREEN = 121;
    public static final int OPTIONS_WATCH_NOW = 130;
    public static final int OPTIONS_DETAILS = 131;
    public static final int OPTIONS_BACK = 132;
    public static final int OPTIONS_GOTO_SHOP_START = 140;
    public static final int TOOLTIP_TV = 200;
    public static final int TV_LOADING = 202;
    public static final int TV_RESTART_ROTATE = 205;
    public static final int GUIDE_NAME = 250;
    public static final int GUIDE_TODAY = 251;
    public static final int GUIDE_TOMORROW = 252;
    public static final int STORE_BUY = 301;
    public static final int STORE_AVAILABLE = 302;
    public static final int STORE_START_TEXT = 303;
    public static final int STORE_ACCESS_INDIVIDUAL_TITLE = 304;
    public static final int STORE_ACCESS_INDIVIDUAL_DESCRIPTION = 305;
    public static final int TOOLTIP_CHANNELS = 350;
    public static final int EXIT_POPUP_TITLE = 400;
    public static final int EXIT_POPUP_TEXT = 401;
    public static final int ABOUT_TITLE = 410;
    public static final int ABOUT_TEXT = 411;
    public static final int ERROR_CONNECTION_TITLE = 420;
    public static final int ERROR_CONNECTION_PROBLEM = 421;
    public static final int ERROR_CONNECTION_SOLUTION = 423;
    public static final int ERROR_STREAM_START_TITLE = 430;
    public static final int ERROR_STREAM_START_PROBLEM = 431;
    public static final int ERROR_STREAM_START_SOLUTION = 432;
    public static final int ERROR_CHANNEL_SWITCH_TITLE = 440;
    public static final int ERROR_CHANNEL_SWITCH_TEXT = 441;
    public static final int ERROR_DOWNLOADING_SVG_TITLE = 450;
    public static final int ERROR_DOWNLOADING_SVG_TEXT = 451;
    public static final int ERROR_STREAM_FAILURE_TITLE = 460;
    public static final int ERROR_STREAM_FAILURE_TEXT = 461;
    public static final int ERROR_SUBSCRIPTION_TITLE = 470;
    public static final int ERROR_SUBSCRIPTION_TEXT = 471;
    public static final int ERROR_ACCESS_END_TITLE = 480;
    public static final int ERROR_ACCESS_END_TEXT = 481;
    public static final int ERROR_NOT_AVAILABLE_TITLE = 490;
    public static final int ERROR_NOT_AVAILABLE_TEXT = 491;
    public static final int DEFAULT_SVG_HEADER_TITLE = 600;
    public static final int OPTIONS_MUTE = 3003;
    public static final int OPTIONS_UNMUTE = 3004;
    public static final int OPTIONS_ADD_FAVOURITE = 3005;
    public static final int OPTIONS_ABOUT = 3006;
    public static final int SHOP_NO_NAME = 3019;
    public static final int SHOP_NO_DESC = 3020;
    public static final int GUIDE_NO_INFORMATION = 3026;
    public static final int SVG_SWITCH_CHANNEL_ERROR = 3027;
    public static final int SVG_CONNECT_ERROR = 3028;
    public static final int SVG_START_PLAYER_ERROR = 3029;
    public static final int SVG_OK = 3030;
    public static final int SVG_INFO_RESTART_TV = 3031;
    public static final int SVG_OPTIONS_EXIT = 3032;
    public static final int SVG_YES = 3033;
    public static final int SVG_NO = 3034;
    public static final int FAVOURITES_NOT_SUBSCRIBED_DETAILED_TEXT = 3035;
    public static final int CONTINUE = 3038;

    public Locale getCurrentLocale() {
        return this.locale;
    }

    public String getLanguageCode() {
        return this.locale.getLanguageCode();
    }

    public String getXmlVersion() {
        return this.version;
    }

    public String getString(int keyword) {
        String translation = (String)this.translatedwords.get(new Integer(keyword).toString());
        if (translation == null) {
            Log.log(0x100008000L, "When trying to find the translation for keyword " + keyword + " null was found");
            return "";
        }
        return translation;
    }

    public void setLocale(Locale local) {
        this.locale = local;
        this.loadXMLFile();
    }

    private void loadXMLFile() {
        if (this.locale != null) {
            Log.log(0x200008000L, "Using locale file: " + this.locale.getLanguageFile());
            this.translatedwords = new Hashtable();
            try {
                InputStream is = this.getClass().getResourceAsStream(this.getCurrentLocale().getLanguageFile());
                this.parseXMLdata(is);
            }
            catch (Exception e) {
                Log.log(0x100008000L, "Could not read xml file: " + this.getCurrentLocale().getLanguageFile());
            }
            System.gc();
        }
    }

    private void parseXMLdata(InputStream stream) throws IOException {
        try {
            XmlPullParserFactory xppf = XmlPullParserFactory.newInstance();
            XmlPullParser parser = xppf.newPullParser();
            parser.setInput(stream, null);
            try {
                this.traverse(parser);
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
            return;
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
            return;
        }
    }

    private void traverse(XmlPullParser parser) throws Exception {
        boolean leave = false;
        String currKeyword = null;
        String currTranslation = null;
        block6: do {
            int eventType = parser.next();
            String name = parser.getName();
            switch (eventType) {
                case 2: {
                    if ("string".equals(name)) {
                        currKeyword = parser.getAttributeValue(null, "enum");
                        currTranslation = parser.getAttributeValue(null, "translation");
                        if (currKeyword == null || currTranslation == null) continue block6;
                        this.translatedwords.put(currKeyword, currTranslation);
                        break;
                    }
                    if (!"tvclient_translate".equals(name)) break;
                    this.version = parser.getAttributeValue(null, "version");
                    break;
                }
                case 3: {
                    break;
                }
                case 1: {
                    leave = true;
                    break;
                }
                case 4: {
                    break;
                }
            }
        } while (!leave);
    }
}

