/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.channellist;

import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.gui.common.ImageView;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;

public class ChannelIconView
extends View {
    public ImageView channelIconImageView;
    private View shopDecorationView;
    private View favoriteDecorationView;
    private View notAvailableDecorationView;
    private Channel channelToDisplay;

    public ChannelIconView() {
        this.setFrame(new Rect(Skin.CHANNEL_ICON_FRAME));
        this.setOpaque(false);
        this.channelIconImageView = new ImageView(new Rect(Skin.CHANNEL_ICON_ICON_FRAME), Images.getIconUnknown()){

            public void drawInRect(TactelGraphics g, Rect rect) {
                super.drawInRect(g, rect);
                if (ChannelIconView.this.channelToDisplay != null && (!ChannelIconView.this.channelToDisplay.isSubscribed() || ChannelIconView.this.channelToDisplay.isNotAvailable()) && this.image != null) {
                    Rect oldClipRect = g.getClipRect();
                    int w = this.image.getWidth();
                    int h = this.image.getHeight();
                    Rect iconRect = new Rect(this.frame.x + (this.frame.width - w) / 2, this.frame.y + (this.frame.width - w) / 2, w, h);
                    iconRect = iconRect.rectByIntersectingRect(rect);
                    g.setClipRect(iconRect);
                    g.drawImageAtPoint(Images.getBlackTransparent(), new Point(0, 0));
                    g.setClipRect(oldClipRect);
                }
            }
        };
        this.channelIconImageView.setOpaque(false);
        this.favoriteDecorationView = new View();
        this.favoriteDecorationView.setFrame(new Rect(Skin.CHANNEL_ICON_FAVOURITE_FRAME));
        this.shopDecorationView = new View();
        this.shopDecorationView.setFrame(new Rect(Skin.CHANNEL_ICON_SHOP_FRAME));
        this.shopDecorationView.setBackgroundImage(Images.getIconShop());
        this.shopDecorationView.setOpaque(false);
        this.notAvailableDecorationView = new View();
        this.notAvailableDecorationView.setFrame(new Rect(Skin.CHANNEL_ICON_NA_FRAME));
        this.notAvailableDecorationView.setBackgroundImage(Images.getIconNA());
        this.notAvailableDecorationView.setOpaque(false);
        this.addSubview(this.channelIconImageView);
        this.addSubview(this.favoriteDecorationView);
        this.addSubview(this.shopDecorationView);
        this.addSubview(this.notAvailableDecorationView);
    }

    public void updateChannelToDisplay(Channel channel) {
        this.channelToDisplay = channel;
        if (this.channelToDisplay != null && this.channelToDisplay.getIconUrl() != null && !"".equals(this.channelToDisplay.getIconUrl())) {
            this.channelIconImageView.loadImageNoScale(Images.getIconLoading(), this.channelToDisplay.getIconUrl());
        } else {
            this.channelIconImageView.setImageNoScale(Images.getIconUnknown());
        }
        this.shopDecorationView.setDrawsBackground(!this.channelToDisplay.isSubscribed() && !this.channelToDisplay.isNotAvailable());
        this.notAvailableDecorationView.setDrawsBackground(this.channelToDisplay.isNotAvailable());
        this.updateChannelFavouriteNumber(this.channelToDisplay.getOrder());
        this.setNeedsDisplay();
    }

    public void updateChannelFavouriteNumber(int favourite) {
        if (0 < favourite && favourite < 10) {
            this.favoriteDecorationView.setDrawsBackground(true);
            this.favoriteDecorationView.setBackgroundImage(Images.getDecorationFavorite(favourite));
        } else {
            this.favoriteDecorationView.setDrawsBackground(false);
        }
    }
}

