/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.channellist;

import java.util.Vector;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.gui.channellist.ChannelListItemView;
import se.tactel.tvclient.gui.common.CustomScrollableListView;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.util.Assert;

public class ChannelListView
extends CustomScrollableListView {
    private ChannelFocusObserver channelFocusObserver;
    private boolean inMoveMode = false;

    public void setChannelFocusObserver(ChannelFocusObserver channelFocusObserver) {
        this.channelFocusObserver = channelFocusObserver;
    }

    public ChannelListView() {
        this.setDrawDisabledScrollbar(true);
    }

    public void flushItems() {
        this.subviews = new Vector();
        this.currentView = null;
    }

    public void updateChannelsInList() {
        Vector channelListItems = this.subviews();
        for (int i = 0; i < channelListItems.size(); ++i) {
            ChannelListItemView channelListItemView = (ChannelListItemView)channelListItems.elementAt(i);
            channelListItemView.setContentToDisplay(channelListItemView.channel);
        }
    }

    public void updateChannelOrderInList() {
        Vector channelListItems = this.subviews();
        int order = 1;
        for (int i = 0; i < channelListItems.size(); ++i) {
            ChannelListItemView channelListItemView = (ChannelListItemView)channelListItems.elementAt(i);
            channelListItemView.setOrder(order++);
        }
    }

    public boolean event(Event event) {
        if (!(this.subviews() != null && this.subviews().size() != 0 || event.type() != 1 || event.keyCode() != -1 && event.keyCode() != -2)) {
            return true;
        }
        if (event.type() == 1) {
            if (event.keyCode() == -2 && this.inMoveMode) {
                this.moveCurrentItemDown();
                this.updateChannelOrderInList();
                return true;
            }
            if (event.keyCode() == -1 && this.inMoveMode) {
                this.moveCurrentItemUp();
                this.updateChannelOrderInList();
                return true;
            }
        }
        View v = this.currentView;
        boolean b = super.event(event);
        if (v != this.currentView && this.channelFocusObserver != null) {
            this.channelFocusObserver.setFocusedChannel(((ChannelListItemView)this.currentView).channel);
        }
        return b;
    }

    public boolean isInMoveMode() {
        return this.inMoveMode;
    }

    public void setInMoveMode(boolean inMoveMode) {
        this.inMoveMode = inMoveMode;
    }

    public Channel getCurrentlySelectedChannel() {
        if (this.currentView != null) {
            return ((ChannelListItemView)this.currentView).channel;
        }
        return null;
    }

    public Channel getNextChannel() {
        int pos = this.subviews().indexOf(this.currentView);
        if (pos == this.subviews().size() - 1) {
            return ((ChannelListItemView)this.subviews.elementAt((int)0)).channel;
        }
        return ((ChannelListItemView)this.subviews.elementAt((int)(pos + 1))).channel;
    }

    public ChannelListItemView getCurrentlySelectedItem() {
        return (ChannelListItemView)this.currentView;
    }

    private void moveCurrentItemDown() {
        if (this.subviews.indexOf(this.currentView) != this.subviews.size() - 1) {
            int indexOfNextItem = this.subviews.indexOf(this.currentView) + 1;
            int indexOfCurrentItem = this.subviews.indexOf(this.currentView);
            View v = (View)this.subviews.elementAt(indexOfNextItem);
            this.subviews.setElementAt(this.currentView, indexOfNextItem);
            this.subviews.setElementAt(v, indexOfCurrentItem);
            this.swapPositionOfItems(this.currentView, v);
            this.setNeedsDisplay();
            this.scrollDownIfNeeded(v);
        }
    }

    private void moveCurrentItemUp() {
        if (this.subviews.indexOf(this.currentView) != 0) {
            int indexOfNextItem = this.subviews.indexOf(this.currentView) - 1;
            int indexOfCurrentItem = this.subviews.indexOf(this.currentView);
            View v = (View)this.subviews.elementAt(indexOfNextItem);
            this.subviews.setElementAt(this.currentView, indexOfNextItem);
            this.subviews.setElementAt(v, indexOfCurrentItem);
            this.swapPositionOfItems(this.currentView, v);
            this.setNeedsDisplay();
            this.scrollUpIfNeeded(v);
        }
    }

    void removeCurrentItem() {
        int indexOfNextCurrentItem = 0;
        if (this.subviews.indexOf(this.currentView) != this.subviews.size() - 1) {
            indexOfNextCurrentItem = this.subviews.indexOf(this.currentView) + 1;
        } else if (this.subviews.indexOf(this.currentView) < this.subviews.size()) {
            indexOfNextCurrentItem = this.subviews.indexOf(this.currentView) - 1;
        }
        View v = (View)this.subviews.elementAt(indexOfNextCurrentItem);
        System.out.println("Remove: " + ((ChannelListItemView)this.currentView).channel.toString());
        System.out.println("New cu: " + ((ChannelListItemView)v).channel.toString());
        this.currentView.setHighlight(false);
        View previousCurrentView = this.currentView;
        this.removeSubview(this.currentView);
        this.currentView = v;
        this.currentView.setHighlight(true);
        int d = 0;
        for (int i = 0; i < this.subviews.size(); ++i) {
            View v2 = (View)this.subviews.elementAt(i);
            v2.setFrame(new Rect(v.frame().setOrgin(new Point(0, d))));
            d += v2.frame().height;
            this.setAbsolutePosition(v2);
        }
        this.scrollVerticalBy(previousCurrentView.frame().height);
        this.updateVerticalScrollbar();
        this.setNeedsDisplay();
    }

    private void swapPositionOfItems(View v1, View v2) {
        Assert.isTrue(this == v1.parent() && v1.parent() == v2.parent(), "Cannot swap positions of views which are not items of the list.");
        Rect v1RelativeRect = this.getRectOfListItemRelativeListView(v1);
        Rect v2RelativeRect = this.getRectOfListItemRelativeListView(v2);
        v1.setFrame(v2RelativeRect);
        v2.setFrame(v1RelativeRect);
    }

    private Rect getRectOfListItemRelativeListView(View item) {
        Rect itemAbsoluteRect = item.frame();
        Rect itemRelativeRect = new Rect(itemAbsoluteRect.x - item.parent().frame().x, itemAbsoluteRect.y - item.parent().frame().y, itemAbsoluteRect.width, itemAbsoluteRect.height);
        return itemRelativeRect;
    }

    public void scrollToItem(View itemView) {
        Assert.isTrue(this == itemView.parent(), "Cannot scroll to item which is not subview of list");
        boolean itemViewBelowCurrentViewPort = itemView.frame().y + itemView.frame().height > this.frame.y + this.frame.height;
        boolean itemViewAboveCurrentViewPort = this.frame.y > itemView.frame().y;
        int amountToScroll = 0;
        if (itemViewBelowCurrentViewPort) {
            View lastItemInList = (View)this.subviews.elementAt(this.subviews.size() - 1);
            amountToScroll = itemView.frame().y - this.frame.y;
            int maximalScrollableAmount = lastItemInList.frame().y + lastItemInList.frame().height - (this.frame.y + this.frame.height);
            amountToScroll = Math.min(maximalScrollableAmount, amountToScroll);
        } else if (itemViewAboveCurrentViewPort) {
            amountToScroll = itemView.frame().y - this.frame.y;
        }
        this.scrollVerticalBy(amountToScroll);
        this.currentView.setHighlight(false);
        itemView.setHighlight(true);
        this.currentView = itemView;
        this.setNeedsDisplay();
    }

    public void scrollToChannel(Channel channel) {
        for (int i = 0; i < this.subviews.size(); ++i) {
            ChannelListItemView channelListItemView = (ChannelListItemView)this.subviews.elementAt(i);
            if (channelListItemView.channel != channel) continue;
            this.scrollToItem(channelListItemView);
            return;
        }
        Assert.notReached("Trying to scroll to channel which is not in list: " + channel);
    }

    public void scrollToChannelWithId(String id) {
        if (id != null) {
            for (int i = 0; i < this.subviews.size(); ++i) {
                ChannelListItemView channelListItemView = (ChannelListItemView)this.subviews.elementAt(i);
                if (!id.equals(channelListItemView.channel.getId())) continue;
                this.scrollToItem(channelListItemView);
                return;
            }
        }
        Assert.notReached("Trying to scroll to channel which is not in list: " + id);
    }

    public static interface ChannelFocusObserver {
        public void setFocusedChannel(Channel var1);
    }
}

