/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import se.tactel.tvclient.gui.common.ScrollableListView;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;

public class AlwaysScrollableListView
extends ScrollableListView {
    private boolean drawFrame = false;
    private int frameColor = -1;
    private int frameHighlightColor = -1;

    public AlwaysScrollableListView(boolean handleKeysWhenScrollingNotNeeded) {
        super(handleKeysWhenScrollingNotNeeded);
    }

    public boolean event(Event event) {
        if (this.highlight && (this.verticalScrollingNeeded || this.handleKeysWhenScrollingNotNeeded)) {
            if (event.type() == 1 && event.keyCode() == -2) {
                boolean res = false;
                int scroll = 10;
                if (this.subviews.size() > 0) {
                    scroll = ((View)this.subviews.elementAt((int)0)).frame().height;
                }
                if (this.yMaxForViewPort > this.frame.height) {
                    this.scrollVerticalBy(scroll);
                    res |= true;
                }
                if (res) {
                    this.setNeedsDisplay();
                }
                return res;
            }
            if (event.type() == 1 && event.keyCode() == -1) {
                boolean res = false;
                int scroll = -10;
                int yMin = this.frame.y;
                if (this.subviews.size() > 0) {
                    scroll = -((View)this.subviews.elementAt((int)0)).frame().height;
                    yMin = ((View)this.subviews.elementAt((int)0)).frame().y;
                }
                if (yMin < this.frame.y) {
                    this.scrollVerticalBy(scroll);
                    res |= true;
                }
                if (res) {
                    this.setNeedsDisplay();
                }
                return res;
            }
        }
        return super.event(event);
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        super.drawInRect(g, rect);
        if (this.isDrawFrame()) {
            g.setColor(this.isHighlighted() ? this.getFrameHighlightColor() : this.getFrameColor());
            g.drawRect(new Rect(this.frame.x, this.frame.y, this.frame.width - 1, this.frame.height - 1));
        }
    }

    public boolean isDrawFrame() {
        return this.drawFrame;
    }

    public void setDrawFrame(boolean drawFrame) {
        this.drawFrame = drawFrame;
    }

    public int getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(int frameColor) {
        this.frameColor = frameColor;
    }

    public int getFrameHighlightColor() {
        return this.frameHighlightColor;
    }

    public void setFrameHighlightColor(int frameHighlightColor) {
        this.frameHighlightColor = frameHighlightColor;
    }
}

