/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import java.util.Enumeration;
import java.util.Vector;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.TickerView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.util.Log;

public class AutoTickerView
extends TickerView {
    private static Action timeoutAction = null;
    private static Vector highlightedTickers = null;

    public AutoTickerView() {
        if (timeoutAction == null) {
            timeoutAction = new Action(){

                public void clicked(View sender) {
                    Log.log(0x100000L, "Key timeout, start scroll of highlighted tickers");
                    AutoTickerView.scrollHighlightedTickers();
                }
            };
            ServiceRegistry.instance().getTimeoutHandler().addInactivityTimeout(1000L, timeoutAction);
        }
        if (highlightedTickers == null) {
            highlightedTickers = new Vector();
        }
    }

    public void setHighlight(boolean flag) {
        super.setHighlight(flag);
        if (flag && this.isTextLongerThenView()) {
            AutoTickerView.addToHighlightVector(this);
        } else {
            AutoTickerView.removeFromHighlightVector(this);
            this.setEnabled(false);
        }
    }

    public void setText(String text) {
        super.setText(text);
        if (this.isHighlighted()) {
            this.setHighlight(false);
            this.setHighlight(true);
        } else {
            this.setHighlight(false);
        }
    }

    public void didLoseTop() {
        AutoTickerView.removeFromHighlightVector(this);
        this.setEnabled(false);
        super.didLoseTop();
    }

    public void setActive(boolean flag) {
        super.setActive(flag);
        if (!flag) {
            AutoTickerView.removeFromHighlightVector(this);
        }
    }

    private static synchronized void addToHighlightVector(AutoTickerView ticker) {
        if (!highlightedTickers.contains(ticker)) {
            highlightedTickers.addElement(ticker);
        }
    }

    private static synchronized void removeFromHighlightVector(AutoTickerView ticker) {
        if (highlightedTickers.contains(ticker)) {
            highlightedTickers.removeElement(ticker);
        }
    }

    private static synchronized void scrollHighlightedTickers() {
        Enumeration e = highlightedTickers.elements();
        while (e.hasMoreElements()) {
            AutoTickerView tick = (AutoTickerView)e.nextElement();
            tick.setEnabled(true, 2, false);
        }
        highlightedTickers.removeAllElements();
    }
}

