/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import se.tactel.tvclient.gui.common.ScrollableListView;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;

public class CustomScrollableListView
extends ScrollableListView {
    public CustomScrollableListView() {
        super(true);
        this.setScrollAHead(true);
        this.setWrapAround(true);
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        super.drawInRect(g, rect);
        View beforeCurrentView = null;
        if (this.subviews.indexOf(this.currentView) > 0) {
            beforeCurrentView = (View)this.subviews.elementAt(this.subviews.indexOf(this.currentView) - 1);
        }
        Rect clip = g.getClipRect();
        g.setClipRect(rect);
        for (int i = 0; i < this.subviews.size(); ++i) {
            View itemView = (View)this.subviews.elementAt(i);
            int yPos = itemView.frame().y + itemView.frame().height;
            if (this.frame.y >= yPos || yPos >= this.frame.y + this.frame.height || this.currentView.isHighlighted() && (itemView == this.currentView || itemView == beforeCurrentView)) continue;
            g.setStrokeStyle(1);
            g.setColor(-7894645);
            g.drawLine(itemView.frame().x, yPos, itemView.frame().x + itemView.frame().width, yPos);
            g.setStrokeStyle(0);
        }
        g.setClipRect(clip);
    }
}

