/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import javax.microedition.lcdui.Image;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.GraphicUtils;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.resource.Resource;
import se.tactel.tvclient.resource.ResourceImpl;
import se.tactel.tvclient.resource.ResourceManager;
import se.tactel.tvclient.util.Log;

public class ImageView
extends View {
    protected Image image = null;
    protected Image pendingImage = null;
    protected String activeImageEventLink = null;

    public ImageView(Rect aFrame, String imageURL, Image pendingImage, boolean isOpaque) {
        this.setFrame(aFrame);
        this.opaque = isOpaque;
        this.loadImage(pendingImage, imageURL);
    }

    public static ImageView createImageNoCache(Rect aFrame, String imageURL, Image pendingImage) {
        ImageView imageView = new ImageView();
        imageView.setFrame(aFrame);
        imageView.loadImageNoCache(pendingImage, imageURL);
        return imageView;
    }

    public ImageView(Rect aFrame, Resource imageResource) {
        this.setFrame(aFrame);
        if (imageResource != null) {
            this.setImage(imageResource);
        }
    }

    public ImageView(Rect aFrame, Image i) {
        this.setFrame(aFrame);
        this.image = i;
    }

    public ImageView() {
    }

    public void loadImage(Image pendingImage, final String imageURL) {
        this.pendingImage = pendingImage;
        if (this.pendingImage != null && (this.pendingImage.getHeight() != this.frame.height || this.pendingImage.getWidth() != this.frame.width)) {
            this.pendingImage = GraphicUtils.resizeImage(pendingImage, this.frame.width, this.frame.height);
        }
        if (imageURL != null) {
            try {
                new Thread(){

                    public void run() {
                        try {
                            Resource imageResource = ResourceManager.instance().getResource(imageURL);
                            if (imageResource != null) {
                                ImageView.this.setImage(imageResource);
                                ImageView.this.setNeedsDisplay();
                            }
                        }
                        catch (Exception e) {
                            Log.exception(this, e);
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        }
    }

    private void loadImageNoCache(Image pendingImage, final String imageURL) {
        this.pendingImage = pendingImage;
        if (this.pendingImage != null && (this.pendingImage.getHeight() != this.frame.height || this.pendingImage.getWidth() != this.frame.width)) {
            this.pendingImage = GraphicUtils.resizeImage(pendingImage, this.frame.width, this.frame.height);
        }
        if (imageURL != null) {
            try {
                new Thread(){

                    public void run() {
                        try {
                            byte[] downloadedImageData = ServiceRegistry.instance().getComm().getByteArray(imageURL);
                            ResourceImpl imageResource = new ResourceImpl(imageURL, downloadedImageData);
                            if (imageResource != null) {
                                ImageView.this.setImage(imageResource);
                                ImageView.this.setNeedsDisplay();
                            }
                        }
                        catch (Exception e) {
                            Log.exception(this, e);
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        }
    }

    public void loadImageNoScale(Image pendingImage, final String imageURL) {
        this.pendingImage = pendingImage;
        this.image = null;
        Resource preExistingImageResource = ResourceManager.instance().getResourceOnlyFromCache(imageURL);
        if (preExistingImageResource == null) {
            try {
                new Thread(){

                    public void run() {
                        try {
                            Resource imageResource;
                            if (imageURL != null && (imageResource = ResourceManager.instance().getResource(imageURL)) != null) {
                                ImageView.this.setImageNoScale(imageResource);
                                ImageView.this.setNeedsDisplay();
                            }
                        }
                        catch (Exception e) {
                            Log.exception(this, e);
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        } else {
            this.setImageNoScale(preExistingImageResource);
            this.setNeedsDisplay();
        }
    }

    public void setImage(Resource imageResource) {
        Image tmp = imageResource.getData();
        this.image = tmp.getHeight() != this.frame.height || tmp.getWidth() != this.frame.width ? GraphicUtils.resizeImage(tmp, this.frame.width, this.frame.height) : tmp;
    }

    private void setImageNoScale(Resource imageResource) {
        this.image = imageResource.getData();
    }

    public void scale(double sfX, double sfY) {
        super.scale(sfX, sfY);
        if (this.image == null) {
            return;
        }
        if (this.image.getHeight() != this.frame.height || this.image.getWidth() != this.frame.width) {
            this.image = GraphicUtils.resizeImage(this.image, this.frame.width, this.frame.height);
        }
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        try {
            if (this.image == null && this.pendingImage != null) {
                g.drawImageRectCenterdInRect(this.pendingImage, rect, this.frame);
            } else if (this.image != null) {
                g.drawImageRectCenterdInRect(this.image, rect, this.frame);
            } else {
                Log.log(0x100100000L, "Image view unable to paint it's image");
                g.setColor(this.backgroundColor);
                g.fillRect(this.frame);
            }
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        super.drawInRect(g, rect);
    }

    public String getActiveImageEventLink() {
        return this.activeImageEventLink;
    }

    public void setActiveImageEvent(String activeImageEvent) {
        this.activeImageEventLink = activeImageEvent;
    }

    public void setImage(Image anImage) {
        this.image = anImage;
        if (this.image.getHeight() != this.frame.height || this.image.getWidth() != this.frame.width) {
            this.image = GraphicUtils.resizeImage(this.image, this.frame.width, this.frame.height);
        }
    }

    public void setImageNoScale(Image anImage) {
        this.image = anImage;
    }

    public Image getImage() {
        return this.image;
    }
}

