/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.GraphicUtils;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;

public abstract class MultiTextView
extends View
implements Observer {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    protected int localizationId = -1;
    protected String text = null;
    protected Font font = Font.getFont((int)0, (int)0, (int)8);
    protected int textColor = -6645094;
    protected boolean verticalalignment = true;
    protected int alignment = 0;
    protected int inset = 5;

    public void setText(String text) {
        this.localizationId = -1;
        this.text = text;
    }

    public void setText(int localizationId) {
        this.localizationId = localizationId;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public void setInset(int inset) {
        this.inset = inset;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setVerticallyAlignment(boolean b) {
        this.verticalalignment = b;
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        Rect clip = g.getClipRect();
        super.drawInRect(g, rect);
        g.setClipRect(rect);
        g.setColor(this.textColor);
        g.setFont(this.font);
        if (this.localizationId != -1) {
            this.text = ServiceRegistry.instance().getLocalization().getString(this.localizationId);
        }
        if (this.text != null) {
            Vector rows = this.split(this.text);
            int center = 0;
            if (this.verticalalignment) {
                center = (this.frame.height - rows.size() * this.font.getHeight()) / 2;
            }
            block4: for (int i = 0; i < rows.size(); ++i) {
                String text = (String)rows.elementAt(i);
                switch (this.alignment) {
                    case 2: {
                        g.drawString(text, this.frame.x + this.frame.width - this.inset, this.frame.y + center + i * this.font.getHeight(), 24);
                        continue block4;
                    }
                    case 1: {
                        g.drawString(text, this.frame.x + this.frame.width / 2, this.frame.y + center + i * this.font.getHeight(), 17);
                        continue block4;
                    }
                    default: {
                        g.drawString(text, this.frame.x + this.inset, this.frame.y + center + i * this.font.getHeight(), 20);
                    }
                }
            }
        }
        g.setClipRect(clip);
    }

    private Vector split(String text) {
        String finalRow;
        Vector<String> rows = new Vector<String>();
        int begin = 0;
        StringBuffer row = new StringBuffer();
        String word = "";
        while (text.indexOf(32, begin) != -1) {
            word = text.substring(begin, text.indexOf(32, begin));
            if ("\\n".equals(word)) {
                finalRow = row.toString();
                row = null;
                rows.addElement(finalRow);
                row = new StringBuffer();
            } else if (this.font.stringWidth(row.toString()) + this.font.stringWidth(word) <= this.frame.width - this.inset - this.inset) {
                row.append(word);
                row.append(' ');
            } else {
                int s;
                finalRow = row.toString();
                row = null;
                if (this.frame.height < (rows.size() + 1) * this.font.getHeight() && (s = text.indexOf(32, begin)) != -1) {
                    finalRow = GraphicUtils.sizeStringToWidthForFontAndAddDots(finalRow, this.font.stringWidth(finalRow) - this.font.stringWidth("..."), this.font, true);
                }
                rows.addElement(finalRow);
                row = new StringBuffer(word);
                row.append(' ');
            }
            begin = text.indexOf(32, begin) + 1;
        }
        word = text.substring(begin);
        finalRow = row.toString();
        if (this.font.stringWidth(finalRow) + this.font.stringWidth(word) <= this.frame.width - this.inset - this.inset) {
            row.append(word);
            rows.addElement(row.toString());
        } else {
            rows.addElement(finalRow);
            rows.addElement(word);
        }
        return rows;
    }

    public void setAlignment(int align) {
        this.alignment = align;
    }

    public void update(ObservableData data) {
        this.text = this.getTextFromDataObject(data);
    }

    protected abstract String getTextFromDataObject(ObservableData var1);

    public void setDataToDisplay(ObservableData data) {
        data.addObserver(this);
        this.text = this.getTextFromDataObject(data);
    }

    public void sizeToFit() {
        if (this.text != null && (this.frame != null || this.parent != null)) {
            if (this.frame == null) {
                this.frame = new Rect(this.parent.frame());
            }
            if (this.parent != null) {
                this.frame.x = this.parent.frame().x;
                this.frame.y = this.parent.frame().y;
            }
            this.frame.height = Integer.MAX_VALUE;
            Vector v = this.split(this.text);
            this.frame.height = v.size() * this.font.getHeight();
        }
    }
}

