/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import se.tactel.tvclient.gui.common.core.ContainerView;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.list.ScrollbarView;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.position.Size;

public class ScrollableListView
extends ContainerView {
    ScrollbarView vScrollbar = null;
    public static final int SCROLLBAR_WIDTH = 10;
    protected int yMaxForViewPort = 0;
    protected boolean verticalScrollingNeeded = false;
    private int yMaxForSubviewsAtStart;
    protected View currentView = null;
    protected boolean handleKeysWhenScrollingNotNeeded;
    private boolean scrollAhead = false;
    private boolean wrapAround = false;
    boolean drawDisabledScrollBar = false;

    public ScrollableListView(boolean handleKeysWhenScrollingNotNeeded) {
        this.handleKeysWhenScrollingNotNeeded = handleKeysWhenScrollingNotNeeded;
    }

    protected void updateVerticalScrollbar() {
        if (this.subviews.size() > 0) {
            this.yMaxForViewPort = this.getChildMaxY();
            if (this.yMaxForViewPort > this.frame.height) {
                this.verticalScrollingNeeded = true;
                this.yMaxForSubviewsAtStart = this.yMaxForViewPort;
                this.updateScrollbarDimensions();
                this.vScrollbar.scrollToPosition(0);
            } else {
                this.verticalScrollingNeeded = false;
            }
        } else {
            this.verticalScrollingNeeded = false;
        }
    }

    public void removeAllElements() {
        this.subviews.removeAllElements();
        this.verticalScrollingNeeded = false;
    }

    protected void setAbsolutePosition(View view) {
        super.setAbsolutePosition(view);
        this.updateScrollbarDimensions();
    }

    public void setFrame(Rect frame) {
        super.setFrame(frame);
        this.updateVerticalScrollbar();
    }

    public void addSubview(View view) {
        view.setFrame(new Rect(view.frame().setOrgin(new Point(0, this.getChildMaxY()))));
        super.addSubview(view);
        if (this.currentView == null) {
            this.currentView = view;
            if (this.highlight) {
                this.currentView.setHighlight(true);
            }
        }
        this.updateVerticalScrollbar();
    }

    public void setScrollAHead(boolean b) {
        this.scrollAhead = b;
    }

    public void setWrapAround(boolean b) {
        this.wrapAround = b;
    }

    protected void setDrawDisabledScrollbar(boolean b) {
        this.drawDisabledScrollBar = b;
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        super.drawInRect(g, rect);
        if ((this.verticalScrollingNeeded || this.drawDisabledScrollBar) && this.vScrollbar != null) {
            this.vScrollbar.drawInRect(g, rect);
        }
    }

    public void setHighlight(boolean flag) {
        if (this.currentView != null) {
            this.currentView.setHighlight(flag);
        }
        this.highlight = flag;
    }

    private void wrapAroundToFirstItem() {
        this.currentView.setHighlight(false);
        this.currentView = (View)this.subviews.elementAt(0);
        this.currentView.setHighlight(true);
        int dy = this.currentView.frame().y - this.frame.y;
        this.scrollVerticalBy(dy);
    }

    private void wrapAroundToLastItem() {
        this.currentView.setHighlight(false);
        this.currentView = (View)this.subviews.elementAt(this.subviews.size() - 1);
        this.currentView.setHighlight(true);
        int dy = 0;
        if (this.frame.height < this.yMaxForViewPort) {
            dy = this.yMaxForViewPort - this.frame.height;
        }
        this.scrollVerticalBy(dy);
    }

    protected boolean scrollDownIfNeeded(View previousCurrentView) {
        if (this.currentView.frame().y + this.currentView.frame().height > this.frame.y + this.frame.height) {
            int pixelsToScroll = this.subviews.indexOf(this.currentView) == this.subviews.size() - 1 || !this.scrollAhead ? this.currentView.frame().y + this.currentView.frame().height - (this.frame.y + this.frame.height) : previousCurrentView.frame().height;
            this.scrollVerticalBy(pixelsToScroll);
            return true;
        }
        return false;
    }

    protected boolean scrollUpIfNeeded(View previousCurrentView) {
        if (this.currentView.frame().y < this.frame.y) {
            int pixelsToScroll = this.subviews.indexOf(this.currentView) == 0 || !this.scrollAhead ? this.currentView.frame().y - this.frame.y : -previousCurrentView.frame().height;
            this.scrollVerticalBy(pixelsToScroll);
            return true;
        }
        return false;
    }

    public boolean event(Event event) {
        if (this.highlight && (this.verticalScrollingNeeded || this.handleKeysWhenScrollingNotNeeded)) {
            if (event.type() == 1 && event.keyCode() == -2) {
                boolean res = false;
                View previousCurrentView = null;
                if (this.subviews.size() > 1 && this.currentView != this.subviews.elementAt(this.subviews.size() - 1)) {
                    previousCurrentView = this.currentView;
                    this.currentView.setHighlight(false);
                    this.currentView = (View)this.subviews.elementAt(this.subviews.indexOf(this.currentView) + 1);
                    this.currentView.setHighlight(true);
                    this.scrollDownIfNeeded(previousCurrentView);
                    res |= true;
                } else if (this.subviews.size() > 1 && this.wrapAround && this.subviews.indexOf(this.currentView) == this.subviews.size() - 1) {
                    this.wrapAroundToFirstItem();
                    this.setNeedsDisplay();
                    return true;
                }
                if (this.currentView.frame().y + this.currentView.frame().height > this.frame.y + this.frame.height) {
                    int pixelsToScroll;
                    if (this.subviews.indexOf(this.currentView) == this.subviews.size() - 1 || !this.scrollAhead) {
                        int frameSize = this.frame.y + this.frame.height;
                        int viewSize = this.currentView.frame().y + this.currentView.frame().height;
                        pixelsToScroll = viewSize > 2 * this.frame.height ? this.frame.height - 20 : viewSize - frameSize;
                    } else {
                        pixelsToScroll = previousCurrentView.frame().height;
                    }
                    this.scrollVerticalBy(pixelsToScroll);
                    res |= true;
                }
                if (res) {
                    this.setNeedsDisplay();
                }
                return res;
            }
            if (event.type() == 1 && event.keyCode() == -1) {
                boolean res = false;
                View previousCurrentView = null;
                if (this.subviews.size() > 1 && this.currentView != this.subviews.elementAt(0)) {
                    previousCurrentView = this.currentView;
                    this.currentView.setHighlight(false);
                    this.currentView = (View)this.subviews.elementAt(this.subviews.indexOf(this.currentView) - 1);
                    this.currentView.setHighlight(true);
                    this.scrollUpIfNeeded(previousCurrentView);
                    res |= true;
                } else if (this.subviews.size() > 1 && this.wrapAround && this.subviews.indexOf(this.currentView) == 0) {
                    this.wrapAroundToLastItem();
                    this.setNeedsDisplay();
                    return true;
                }
                if (this.currentView.frame().y < this.frame.y) {
                    int pixelsToScroll = this.subviews.indexOf(this.currentView) == 0 || !this.scrollAhead ? (Math.abs(this.currentView.frame().y - this.frame.y) > Math.abs(this.frame.height) ? -this.frame.height + 20 : this.currentView.frame().y - this.frame.y) : -previousCurrentView.frame().height;
                    this.scrollVerticalBy(pixelsToScroll);
                    res |= true;
                }
                if (res) {
                    this.setNeedsDisplay();
                }
                return res;
            }
        }
        return super.event(event);
    }

    private void updateScrollbarDimensions() {
        if (this.vScrollbar == null) {
            this.vScrollbar = new ScrollbarView();
        }
        Point o = new Point(this.frame.x + this.frame.width - 10 - 2, this.frame.y);
        Size s = new Size(10, this.frame.height);
        this.vScrollbar.setFrame(new Rect(o.x, o.y, s.width, s.height));
        if (this.verticalScrollingNeeded) {
            this.vScrollbar.setMarkerSize((int)((float)this.frame.height / (float)this.yMaxForSubviewsAtStart * (float)this.vScrollbar.frame().height));
        } else {
            this.vScrollbar.setMarkerSize(-1);
        }
    }

    protected void scrollVerticalBy(int dy) {
        this.yMaxForViewPort -= dy;
        if (this.vScrollbar != null) {
            this.vScrollbar.scrollToPosition((int)((float)(this.yMaxForSubviewsAtStart - this.yMaxForViewPort) / (float)this.yMaxForSubviewsAtStart * (float)this.vScrollbar.frame().height));
        }
        for (int i = 0; i < this.subviews.size(); ++i) {
            View v = (View)this.subviews.elementAt(i);
            v.getRelativeOrgin().y -= dy;
            this.setAbsolutePosition(v);
        }
    }

    private int getChildMaxY() {
        int maxY = 0;
        for (int a = 0; a < this.subviews.size(); ++a) {
            View v = (View)this.subviews.elementAt(a);
            if (v.frame().y + v.frame().height <= maxY) continue;
            maxY = v.getRelativeOrgin().y + v.frame().height;
        }
        return maxY;
    }

    public void updateScrollSize() {
        int d = 0;
        for (int i = 0; i < this.subviews.size(); ++i) {
            View v = (View)this.subviews.elementAt(i);
            v.setFrame(new Rect(v.frame().setOrgin(new Point(0, d))));
            d += v.frame().height;
            this.setAbsolutePosition(v);
        }
        this.yMaxForViewPort = 0;
        this.updateVerticalScrollbar();
    }
}

