/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import java.util.Enumeration;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.util.Log;

public class TickerView
extends TextView {
    public static final long WAIT_TIME = 200L;
    public static final int OFFSET_STEP = 5;
    private int offset = 0;
    private int prevOffset = 0;
    private int scrollsize = 0;
    private Image scrolltext = null;
    private int loopCnt = -1;
    private boolean onTop = true;
    private static TimerTask tt = null;
    private static Vector tickers = null;

    public TickerView() {
        this.opaque = false;
        this.enabled = false;
        this.setInset(0);
    }

    public void didLoseTop() {
        this.onTop = false;
    }

    public void didBecomeTop() {
        this.onTop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean flag) {
        super.setActive(flag);
        Vector vector = tickers;
        synchronized (vector) {
            if (flag) {
                if (!tickers.contains(this)) {
                    tickers.addElement(this);
                }
            } else if (tickers.contains(this)) {
                tickers.removeElement(this);
            }
        }
    }

    public void setEnabled(boolean flag) {
        this.setEnabled(flag, -1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean flag, int loopCnt, boolean startFromRight) {
        super.setEnabled(flag);
        this.loopCnt = loopCnt;
        if (startFromRight) {
            this.offset = -this.frame.width;
            this.prevOffset = 0;
        } else {
            this.offset = 0;
            this.prevOffset = -this.frame.width;
        }
        Vector vector = tickers;
        synchronized (vector) {
            if (flag) {
                if (!tickers.contains(this)) {
                    tickers.addElement(this);
                }
            } else if (tickers.contains(this)) {
                tickers.removeElement(this);
            }
        }
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        if (this.active && this.enabled) {
            if (this.drawsBackground) {
                g.setColor(this.backgroundColor);
                g.fillRect(this.frame);
                if (this.backgroundImage != null) {
                    g.drawImageRectCenterdInRect(this.backgroundImage, rect, this.frame);
                }
            }
            if (this.scrolltext != null) {
                if (this.offset >= 0) {
                    int width = Math.min(this.frame.width, this.scrolltext.getWidth() - this.offset);
                    if (width > this.scrolltext.getWidth()) {
                        width = this.scrolltext.getWidth();
                    }
                    g.graphics().drawRegion(this.scrolltext, this.offset, 0, width, this.scrolltext.getHeight(), 0, this.frame.x, this.frame.y, 20);
                } else {
                    int width = Math.min(this.frame.width + this.offset, this.scrolltext.getWidth() - this.offset);
                    if (width > this.scrolltext.getWidth()) {
                        width = this.scrolltext.getWidth();
                    }
                    g.graphics().drawRegion(this.scrolltext, 0, 0, width, this.scrolltext.getHeight(), 0, -this.offset + this.frame.x, this.frame.y, 20);
                }
            } else if (this.text != null) {
                if (this.prevOffset > 0 && this.offset <= 0 && this.loopCnt > 0) {
                    --this.loopCnt;
                    if (this.loopCnt == 0) {
                        this.setEnabled(false);
                    }
                }
                int center = (this.frame.height - this.font.getHeight()) / 2;
                Rect clip = g.getClipRect();
                g.setClipRect(this.frame);
                g.setColor(this.textcolor);
                g.setFont(this.font);
                g.drawString(this.text, -this.offset + this.frame.x, this.frame.y + center, 20);
                g.setClipRect(clip);
                this.prevOffset = this.offset;
            }
        } else {
            super.drawInRect(g, rect);
        }
    }

    static {
        if (tickers == null) {
            tickers = new Vector();
        }
        if (tt == null) {
            tt = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Vector vector = tickers;
                        synchronized (vector) {
                            Enumeration e = tickers.elements();
                            while (e.hasMoreElements()) {
                                TickerView tick = (TickerView)e.nextElement();
                                if (!tick.onTop || !tick.isEnabled() || !tick.isActive()) continue;
                                tick.offset = tick.offset + 5;
                                if (tick.text != null && tick.offset > tick.scrollsize + tick.font.stringWidth(tick.text)) {
                                    tick.offset = -((TickerView)tick).frame.width;
                                }
                                tick.setNeedsDisplay();
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.log(0x80000000L, "Exception while ticking text: " + e.getMessage());
                    }
                }
            };
            View.timer.scheduleAtFixedRate(tt, 0L, 200L);
        }
    }
}

