/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common.core;

import se.tactel.tvclient.gui.position.Point;

public class Event {
    public static final int UNKNOWN = 0;
    public static final int KEY_PRESSED = 1;
    public static final int KEY_LONG_PRESSED = 2;
    public static final int POINTER_DRAGGED = 3;
    public static final int POINTER_PRESSED = 4;
    public static final int POINTER_RELESE = 5;
    private int type;
    private int keyCode;
    private Point point;

    Event(int type, int key, Point point) {
        this.type = type;
        this.keyCode = key;
        this.point = point;
    }

    public static Event pointerDraggedEvent(Point point) {
        Event event = new Event(3, 0, point);
        return event;
    }

    public static Event pointerPressedEvent(Point point) {
        Event event = new Event(4, 0, point);
        return event;
    }

    public static Event pointerRelesedEvent(Point point) {
        Event event = new Event(5, 0, point);
        return event;
    }

    public int type() {
        return this.type;
    }

    public int keyCode() {
        return this.keyCode;
    }

    public Point point() {
        return this.point;
    }

    public void setKeyCode(int code) {
        this.keyCode = code;
    }

    public static Event keyEvent(int type, int keyValue) {
        Event event = new Event(type, keyValue, null);
        return event;
    }

    public String toString() {
        String typeString = "?";
        if (this.type == 1) {
            typeString = "KEY_PRESSED";
        } else if (this.type == 2) {
            typeString = "KEY_LONG_PRESSED";
        }
        return "Event, type=\"" + typeString + "\" code=\"" + this.keyCode + "\"";
    }
}

