/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common.core;

import java.util.Enumeration;
import java.util.Timer;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.Responder;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;

public class View
extends Responder {
    protected Rect frame = Rect.NULLRECT;
    protected Point relativeOrgin = new Point(Point.NULLPOINT);
    protected View parent = null;
    protected boolean opaque = true;
    protected boolean drawsBackground = false;
    protected int backgroundColor = -1;
    protected int highlightBackgroundColor = -1;
    protected boolean highlightBackgroundColorSpecified = false;
    protected Image backgroundImage = null;
    protected boolean active = true;
    protected boolean enabled = true;
    protected String id = null;
    public static final Timer timer = new Timer();
    protected Vector subviews = new Vector();
    protected Vector invalidSubviews = null;
    protected Action action = null;

    public void setFrame(Rect frame) {
        this.frame = frame;
        this.relativeOrgin.x = frame.x;
        this.relativeOrgin.y = frame.y;
        if (this.parent != null) {
            this.parent.setAbsolutePosition(this);
        }
        this.positionSubviews();
    }

    public Rect frame() {
        return this.frame;
    }

    public void setParent(View p) {
        this.parent = p;
    }

    public View parent() {
        return this.parent;
    }

    public Vector subviews() {
        return this.subviews;
    }

    public void removeAllSubviews() {
        this.subviews = new Vector();
    }

    public void setHighlight(boolean flag) {
        super.setHighlight(flag);
        for (int i = 0; i < this.subviews.size(); ++i) {
            ((View)this.subviews.elementAt(i)).setHighlight(flag);
        }
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action action() {
        return this.action;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setNeedsDisplay() {
        if (this.active && this.parent != null) {
            this.parent.addInvalidView(this);
        } else if (this.active && this.parent == null) {
            this.addInvalidView(this);
        }
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        Rect intersect = null;
        if (!rect.intersectsRect(this.frame) || rect.isNullRect()) {
            return;
        }
        if (this.frame != null && this.drawsBackground) {
            if (this.backgroundImage != null) {
                g.drawImageRectCenterdInRect(this.backgroundImage, rect, this.frame);
            } else {
                g.setColor(this.isHighlighted() ? this.highlightBackgroundColor() : this.backgroundColor());
                g.fillRect(rect);
            }
        }
        Enumeration enumerator = this.subviews.elements();
        while (enumerator.hasMoreElements()) {
            View v = (View)enumerator.nextElement();
            if (!v.active || !rect.intersectsRect(v.frame)) continue;
            intersect = rect.rectByIntersectingRect(v.frame);
            v.drawInRect(g, intersect);
            intersect = null;
        }
    }

    public boolean event(Event event) {
        int size = this.subviews.size();
        boolean res = false;
        switch (event.keyCode()) {
            default: 
        }
        for (int i = 0; i < size && !res; ++i) {
            View v = (View)this.subviews.elementAt(i);
            res = v.event(event);
        }
        if (!res && this.action != null && this.enabled && event.type() == 1 && event.keyCode() == -5 && this.active && this.highlight) {
            this.action.clicked(this);
            return true;
        }
        return res;
    }

    public void animate() {
    }

    public void sizeToFit() {
        if (this.frame != null && this.parent != null && this.frame.isNullRect() && this.parent != null) {
            this.frame.width = this.parent.frame.width;
            this.frame.height = this.parent.frame.height;
        }
        for (int i = 0; i < this.subviews.size(); ++i) {
            ((View)this.subviews.elementAt(i)).sizeToFit();
        }
    }

    public void setActive(boolean flag) {
        this.active = flag;
        if (this.action != null) {
            this.action.willChangeActiveState(this, flag);
        }
        for (int i = 0; i < this.subviews.size(); ++i) {
            ((View)this.subviews.elementAt(i)).setActive(flag);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setEnabled(boolean flag) {
        if (this.enabled != flag) {
            this.setNeedsDisplay();
        }
        this.enabled = flag;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public View opaqueAncestor() {
        View res = this;
        while (res.parent != null && res != res.parent && !res.isOpaque()) {
            res = res.parent;
        }
        return res;
    }

    public void setDrawsBackground(boolean drawsBackground) {
        this.drawsBackground = drawsBackground;
        this.opaque = !drawsBackground ? false : this.opaque;
    }

    public boolean drawsBackground() {
        return this.drawsBackground;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int backgroundColor() {
        return this.backgroundColor;
    }

    public void setHighlightBackgroundColor(int highlightBackgroundColor) {
        this.highlightBackgroundColorSpecified = true;
        this.highlightBackgroundColor = highlightBackgroundColor;
    }

    public int highlightBackgroundColor() {
        if (this.highlightBackgroundColorSpecified) {
            return this.highlightBackgroundColor;
        }
        return this.backgroundColor;
    }

    public void setBackgroundImage(Image img) {
        this.backgroundImage = img;
        if (this.backgroundImage != null) {
            this.opaque = false;
        }
    }

    public Point getRelativeOrgin() {
        return this.relativeOrgin;
    }

    public Rect getFrame() {
        return this.frame;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRelativeOrgin(Point relativeOrgin) {
        this.relativeOrgin = relativeOrgin;
    }

    public void addSubview(View view) {
        if (view != null && !this.subviews.contains(view)) {
            view.setParent(this);
            this.subviews.addElement(view);
            this.setAbsolutePosition(view);
            view.setActive(this.active);
        }
    }

    protected synchronized void addInvalidView(View v) {
        if (this.parent == null) {
            if (this.invalidSubviews == null) {
                this.invalidSubviews = new Vector();
            }
            if (!this.invalidSubviews.contains(v)) {
                this.invalidSubviews.insertElementAt(v, 0);
            }
        } else {
            this.parent.addInvalidView(v);
        }
    }

    public synchronized Vector getInvalidViews() {
        Vector old = this.invalidSubviews;
        this.invalidSubviews = null;
        return old;
    }

    protected void setAbsolutePosition(View view) {
        if (view.frame != null && this.frame != null) {
            view.frame.x = view.relativeOrgin.x + this.frame.x;
            view.frame.y = view.relativeOrgin.y + this.frame.y;
            if (view instanceof View) {
                view.positionSubviews();
            }
        }
    }

    protected void positionSubviews() {
        for (int i = 0; i < this.subviews.size(); ++i) {
            View v = (View)this.subviews.elementAt(i);
            this.setAbsolutePosition(v);
        }
    }

    public void removeSubview(View view) {
        if (this.subviews.contains(view)) {
            view.setActive(false);
            view.setParent(null);
            this.subviews.removeElement(view);
        }
    }

    public void removeFromParentView() {
        this.removeFromParentViewWithoutNeedingDisplay();
        this.setNeedsDisplay();
    }

    public void removeFromParentViewWithoutNeedingDisplay() {
        if (this.parent != null) {
            this.parent.removeSubview(this);
        }
    }

    public void didLoseTop() {
        Enumeration e = this.subviews.elements();
        while (e.hasMoreElements()) {
            ((View)e.nextElement()).didLoseTop();
        }
    }

    public void didBecomeTop() {
        Enumeration e = this.subviews.elements();
        while (e.hasMoreElements()) {
            ((View)e.nextElement()).didBecomeTop();
        }
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public void scale(double sfX, double sfY) {
        this.relativeOrgin.x = (int)((double)this.relativeOrgin.x * sfX);
        this.relativeOrgin.y = (int)((double)this.relativeOrgin.y * sfY);
        if (this.parent != null) {
            this.frame.x = this.parent.frame.x + this.relativeOrgin.x;
            this.frame.y = this.parent.frame.y + this.relativeOrgin.y;
        } else {
            this.frame.x = this.relativeOrgin.x;
            this.frame.y = this.relativeOrgin.y;
        }
        this.frame.width = (int)((double)this.frame.width * sfX);
        this.frame.height = (int)((double)this.frame.height * sfY);
        for (int i = 0; i < this.subviews.size(); ++i) {
            ((View)this.subviews.elementAt(i)).scale(sfX, sfY);
        }
    }
}

