/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.interactivity;

import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.ImageView;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.resource.ResourceImpl;
import se.tactel.tvclient.util.Log;

public class EventImageView
extends ImageView {
    public Thread downloaderThread;
    boolean imageIsAttemptingToLoad = true;
    private final String imageUrl;
    public Object loadingLock;

    public EventImageView(Rect frame, String imageUrl) {
        this.imageUrl = imageUrl;
        this.setFrame(frame);
        this.loadingLock = new Object();
        this.downloaderThread = new Thread(new NoCacheDownloaderThread(this, imageUrl));
        this.downloaderThread.start();
    }

    public boolean isImageAttemptingToLoad() {
        return this.imageIsAttemptingToLoad;
    }

    public boolean isImageLoaded() {
        return this.image != null;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public static class NoCacheDownloaderThread
    implements Runnable {
        private EventImageView view;
        private String imageURL;

        public NoCacheDownloaderThread(EventImageView view, String url) {
            this.view = view;
            this.imageURL = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] byArray = ServiceRegistry.instance().getComm().getByteArray(this.imageURL);
                ResourceImpl imageResource = new ResourceImpl(this.imageURL, byArray);
                if (imageResource != null) {
                    this.view.setImage(imageResource);
                }
            }
            catch (Exception exception) {
                Log.exception(this, exception);
            }
            finally {
                this.view.imageIsAttemptingToLoad = false;
                Object object = this.view.loadingLock;
                synchronized (object) {
                    this.view.loadingLock.notifyAll();
                }
            }
        }
    }
}

