/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.interactivity;

import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.data.interactivity.InteractivityEvent;
import se.tactel.tvclient.gui.interactivity.FullScreenSVGWindow;
import se.tactel.tvclient.gui.interactivity.SVGWindow;
import se.tactel.tvclient.gui.userdialog.UserDialogView;
import se.tactel.tvclient.util.Log;

public class FullScreenInteractivityHandler
implements Observer {
    private SVGWindow fullScreenInteractivitySVGWindow;

    public FullScreenInteractivityHandler() {
        ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().observerve(this);
    }

    public void update(ObservableData data) {
        InteractivityEvent event = ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().get();
        if (event != null && "form".equals(event.getType()) && "full".equals(event.getScreensize())) {
            SVGWindow oldWindow = this.fullScreenInteractivitySVGWindow;
            UserDialogView userDialogView = (UserDialogView)event.getEventViews().firstElement();
            if (userDialogView != null) {
                Log.log(128L, "Showing full screen interactivity window.");
                this.fullScreenInteractivitySVGWindow = new FullScreenSVGWindow(userDialogView);
                this.fullScreenInteractivitySVGWindow.makeKeyAndOrderFront();
                if (oldWindow != null) {
                    oldWindow.close();
                }
                RichMediaMIDlet.instance().tController.getInteractivityController().processUserDialogRootCommmands(userDialogView);
            }
        }
    }

    public boolean isDisplayingFullScreenInteractivity() {
        return this.fullScreenInteractivitySVGWindow != null;
    }

    public void closeWindow() {
        if (this.fullScreenInteractivitySVGWindow != null) {
            this.fullScreenInteractivitySVGWindow.close();
            this.fullScreenInteractivitySVGWindow = null;
        }
    }
}

