/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.interactivity;

import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.data.interactivity.CurrentInteractivityEvent;
import se.tactel.tvclient.data.interactivity.InteractivityEvent;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.interactivity.EventImageView;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.userdialog.Command;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.util.Log;

public class InteractivityView
extends View
implements Observer {
    private View interactivityBannerView;
    private View placeholderImageView;
    private View defaultButtonBarView;
    private View currentButtonBarView;
    private View viewDisplayed;
    private Window window;
    private boolean adsBlocked = false;
    private boolean isShowingAd = false;

    public InteractivityView(View buttonBar, Window w) {
        this.window = w;
        this.placeholderImageView = new View();
        this.placeholderImageView.setBackgroundImage(Images.getTvScreenPlaceholder());
        this.placeholderImageView.setDrawsBackground(true);
        if (buttonBar != null) {
            ((ButtonBar)buttonBar).setBackgroundImage(Images.getOptionsImage());
            ((ButtonBar)buttonBar).setLeftSoftKeyText("");
        }
        this.currentButtonBarView = this.defaultButtonBarView = buttonBar;
        this.interactivityBannerView = new View(){

            public void drawInRect(TactelGraphics g, Rect rect) {
                super.drawInRect(g, rect);
                g.setColor(-16777216);
            }
        };
        this.interactivityBannerView.setFrame(new Rect(Skin.INTERACTIVITY_VIEW_PROXY_VIEW));
        this.interactivityBannerView.setBackgroundColor(-16711936);
        this.interactivityBannerView.setDrawsBackground(true);
        this.interactivityBannerView.setOpaque(true);
        this.addSubview(this.interactivityBannerView);
        this.showPlaceHolder();
        this.update(ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().getObservable());
        ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().observerve(this);
    }

    public void didBecomeTop() {
        ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().startTimer();
    }

    public void didLoseTop() {
        ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().stopTimer();
    }

    public void setActive(boolean flag) {
    }

    private void showPlaceHolder() {
        this.interactivityBannerView.removeFromParentViewWithoutNeedingDisplay();
        this.viewDisplayed = null;
        this.placeholderImageView.setFrame(new Rect(Skin.INTERACTIVITY_VIEW_PLACEHOLDER));
        this.addSubview(this.placeholderImageView);
        this.switchButtonBar(this.defaultButtonBarView);
        this.isShowingAd = false;
        this.setNeedsDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showEventImage(EventImageView imageView) {
        long t = System.currentTimeMillis();
        while (imageView.isImageAttemptingToLoad()) {
            try {
                Object object = imageView.loadingLock;
                synchronized (object) {
                    imageView.loadingLock.wait();
                }
            }
            catch (InterruptedException e) {
                Log.exception(this, e);
            }
        }
        Log.log(4L, ">>> " + this + " window=" + this.window + " waited for image load " + (System.currentTimeMillis() - t));
        if (imageView.isImageLoaded()) {
            this.placeholderImageView.removeFromParentViewWithoutNeedingDisplay();
            this.switchButtonBar(null);
            this.interactivityBannerView.setFrame(new Rect(Skin.INTERACTIVITY_VIEW_PROXY_VIEW));
            this.addSubview(this.interactivityBannerView);
            imageView.setFrame(new Rect(Skin.INTERACTIVITY_VIEW_PROXY_VIEW));
            this.interactivityBannerView.removeAllSubviews();
            this.viewDisplayed = imageView;
            this.interactivityBannerView.addSubview(imageView);
            this.isShowingAd = true;
            this.setNeedsDisplay();
        } else {
            Log.log(0x40000080L, "Failed to display image in interactivity view from \"" + imageView.getImageUrl() + "\".");
            this.showPlaceHolder();
        }
    }

    public void setAdBlocked(boolean b) {
        this.adsBlocked = b;
        if (this.isShowingAd && this.adsBlocked) {
            ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().stopTimer();
            this.showPlaceHolder();
        } else if (!this.adsBlocked) {
            this.update(ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().getObservable());
        }
    }

    public void update(ObservableData data) {
        InteractivityEvent event = ((CurrentInteractivityEvent.ObserverableInteractivityEvent)data).getEvent();
        Log.log(4L, this + " " + this.window + ": updating in with: " + event);
        if (event != null && !this.adsBlocked) {
            if ("blank".equals(event.getType())) {
                this.showPlaceHolder();
                if (ServiceRegistry.instance().getWindowServer().getTopmostWindow() == this.window) {
                    ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().startTimer();
                }
            } else if ("split".equals(event.getScreensize()) && "image".equals(event.getType())) {
                EventImageView img = (EventImageView)event.getEventViews().firstElement();
                this.showEventImage(img);
                if (ServiceRegistry.instance().getWindowServer().getTopmostWindow() == this.window) {
                    ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().startTimer();
                }
            }
        } else if (event == null) {
            Log.log(4L, "No current event, show placeholder for time being.");
            this.showPlaceHolder();
        }
    }

    public boolean event(Event event) {
        if (event.type() == 1 && event.keyCode() == -7 && this.isShowingAd) {
            if (this.viewDisplayed instanceof EventImageView) {
                final String url = ((EventImageView)this.viewDisplayed).getActiveImageEventLink();
                Log.log(128L, "Going to jump page from banner ad: " + url);
                new Thread(){

                    public void run() {
                        try {
                            if (url != null && !url.startsWith("#")) {
                                RichMediaMIDlet.instance().tController.getInteractivityController().processUserdialogCommand(new Command("mtv:go", "xlink:href", url), null, false);
                            } else if (url != null && url.length() > 1) {
                                ServiceRegistry.instance().getDataProvider().getCurrentInteractivityEvent().activateBannerContextEvent(url.substring(1));
                            } else {
                                Log.log(0x40000080L, "Not supported syntax for going to jump page: " + url);
                            }
                        }
                        catch (Throwable t) {
                            Log.exception(this, t);
                        }
                    }
                }.start();
            }
            return true;
        }
        if (event.type() == 1 && event.keyCode() == -6 && this.isShowingAd) {
            ServiceRegistry.instance().getController().getTvScreenController().playerView.showTv(false);
            this.window.showOptionsMenuWindow();
            return true;
        }
        return super.event(event);
    }

    private void switchButtonBar(View buttonBar) {
        if (this.currentButtonBarView != null) {
            this.currentButtonBarView.removeFromParentViewWithoutNeedingDisplay();
            this.currentButtonBarView = null;
        }
        if (buttonBar != null) {
            this.currentButtonBarView = buttonBar;
            this.currentButtonBarView.setFrame(new Rect(Skin.INTERACTIVITY_VIEW_BUTTON_BAR));
            this.addSubview(this.currentButtonBarView);
        }
    }
}

