/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.list;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.list.DataSource;
import se.tactel.tvclient.gui.list.ListDelegate;
import se.tactel.tvclient.gui.list.ListItemView;
import se.tactel.tvclient.gui.list.ScrollbarView;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.util.Log;

public class ListView
extends View {
    private static final int SCROLLBAR_WIDTH = 10;
    int itemOffset = 2;
    int itemSpacing;
    Class listItemClass = null;
    DataSource iDataSource = null;
    boolean wrap = false;
    boolean alignTop = true;
    boolean drawLines;
    int listHeight;
    int currentHeight;
    ListDelegate iAction = null;
    private Boolean beenPainted = new Boolean(false);
    Vector listItems = null;
    ScrollbarView scrollbar = new ScrollbarView();
    int indexOfTopItem = 0;
    int selectedItemIndex = 0;

    public ListView() {
        this.addSubview(this.scrollbar);
        this.opaque = false;
        this.alignTop = true;
    }

    public void setItemSpacing(int space) {
        this.itemSpacing = space;
    }

    public void setFrame(Rect frame) {
        super.setFrame(frame);
        this.scrollbar.setFrame(new Rect(frame.width - 10, this.itemOffset > 0 ? 1 : 0, 10, frame.height - (this.itemOffset > 0 ? 1 : 0)));
        this.reloadData();
    }

    protected void positionSubviews() {
        super.positionSubviews();
        if (this.listItems != null) {
            this.positionItems();
        }
    }

    public void setListItemClass(Class c) {
        this.listItemClass = c;
        this.reloadData();
    }

    public void setDataSource(DataSource aDataSource) {
        this.iDataSource = aDataSource;
        this.clear();
        this.reloadData();
    }

    public int selectedRow() {
        return this.indexOfTopItem + this.selectedItemIndex;
    }

    public void setDrawLines(boolean flag) {
        this.drawLines = flag;
    }

    public void setItemOffset(int offset) {
        this.itemOffset = offset;
        if (this.frame != null && offset > 0) {
            --this.scrollbar.frame().height;
            --this.scrollbar.frame().y;
        }
        this.reloadData();
    }

    public void clear() {
        this.alignTop = true;
        if (this.listItems != null) {
            for (int i = 0; i < this.listItems.size(); ++i) {
                if (this.listItems.elementAt(i) instanceof View) {
                    View vw = (View)this.listItems.elementAt(i);
                    vw.setHighlight(false);
                }
                this.listItems.setElementAt(null, i);
            }
            this.listItems.removeAllElements();
        }
        this.selectedItemIndex = 0;
        this.indexOfTopItem = 0;
        this.scrollbar.scrollToPosition(0);
    }

    private void createItems() {
        this.clear();
        if (this.listItems == null) {
            this.listItems = new Vector();
        }
        int numberOfItems = this.iDataSource.numberOfRowsInListView(this);
        Rect itemFrame = new Rect(this.frame);
        itemFrame.x += this.itemOffset;
        itemFrame.y += this.itemOffset;
        for (int i = 0; i < numberOfItems; ++i) {
            try {
                ListItemView item = (ListItemView)this.listItemClass.newInstance();
                itemFrame.setSize(item.size());
                this.listItems.addElement(item);
                item.populateListViewFromDataSourceAtIndex(this, this.iDataSource, i);
                item.setFrame(new Rect(itemFrame));
                item.setParent(this);
                itemFrame.y += item.size().height + this.itemSpacing;
                if (itemFrame.y + 2 * this.itemOffset <= this.frame.y + this.frame.height) continue;
                break;
            }
            catch (InstantiationException e) {
                Log.exception(this, e);
                continue;
            }
            catch (IllegalAccessException e) {
                Log.exception(this, e);
            }
        }
    }

    public synchronized void reloadData() {
        if (this.listItemClass != null && this.iDataSource != null && this.frame != null) {
            boolean create = false;
            int listSize = this.iDataSource.numberOfRowsInListView(this);
            if (this.listItems == null || this.listItems.size() == 0 || listSize < this.listItems.size()) {
                create = true;
            } else {
                ListItemView item = (ListItemView)this.listItems.lastElement();
                if (item.frame().y + item.size().height + this.itemSpacing < this.frame.y + this.frame.height) {
                    create = true;
                }
            }
            if (create) {
                this.createItems();
            }
            int numberOfRows = this.listItems.size();
            int itemSize = 0;
            if (numberOfRows > 0) {
                itemSize = ((ListItemView)this.listItems.firstElement()).size().height;
            }
            this.listHeight = listSize * (this.itemSpacing + itemSize) + 2 * this.itemOffset - this.itemSpacing;
            if (this.listHeight > this.frame.height) {
                this.scrollbar.setMarkerSize((int)((float)this.scrollbar.frame().height * ((float)this.frame.height / (float)this.listHeight)));
            } else {
                this.scrollbar.setMarkerSize(-1);
            }
            this.positionItems();
            if (this.indexOfTopItem + this.listItems.size() > listSize) {
                this.selectLastRow();
            } else {
                this.updateList();
            }
        }
    }

    private void setAlignTop(boolean flag) {
        if (this.alignTop != flag) {
            this.alignTop = flag;
            this.positionItems();
        }
    }

    private void positionItems() {
        if (this.alignTop) {
            int yPos = this.itemOffset;
            for (int i = 0; i < this.listItems.size(); ++i) {
                ListItemView v = (ListItemView)this.listItems.elementAt(i);
                Rect itemFrame = v.frame();
                itemFrame.y = yPos;
                itemFrame.x = this.itemOffset;
                yPos += v.size().height + this.itemSpacing;
                v.setFrame(itemFrame);
            }
        } else {
            int yPos = this.frame.height;
            for (int i = this.listItems.size() - 1; i >= 0; --i) {
                ListItemView v = (ListItemView)this.listItems.elementAt(i);
                Rect itemFrame = v.frame();
                itemFrame.y = yPos -= this.itemSpacing + v.size().height;
                itemFrame.x = this.itemOffset;
                v.setFrame(itemFrame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawInRect(TactelGraphics g, Rect rect) {
        super.drawInRect(g, rect);
        Rect clip = g.getClipRect();
        g.setClipRect(rect);
        if (rect.intersectsRect(this.scrollbar.frame())) {
            this.scrollbar.drawInRect(g, this.scrollbar.frame());
        }
        if (this.itemOffset != 0) {
            g.setColor(-7894645);
            g.drawRect(this.frame);
            g.graphics().drawRect(this.frame.x + 1, this.frame.y + 1, this.frame.width - 2, this.frame.height - 2);
        }
        if (this.itemOffset != 0) {
            g.graphics().setClip(this.frame.x + 2, this.frame.y + 2, this.frame.width - 4, this.frame.height - 4);
        }
        if (this.listItems != null) {
            for (int i = 0; i < this.listItems.size(); ++i) {
                ListItemView v = (ListItemView)this.listItems.elementAt(i);
                if (v != null) {
                    Rect itemFrame = v.frame();
                    if (itemFrame.intersectsRect(rect)) {
                        v.drawInRect(g, rect.rectByIntersectingRect(itemFrame));
                    }
                    this.drawLine(g.graphics(), v, i);
                    continue;
                }
                Log.log(0x40100000L, "List item is NULL in drawInRect");
            }
            g.setClipRect(clip);
        }
        Boolean bl = this.beenPainted;
        synchronized (bl) {
            this.beenPainted = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotPainted() {
        Boolean bl = this.beenPainted;
        synchronized (bl) {
            this.beenPainted = Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beenPainted() {
        Boolean bl = this.beenPainted;
        synchronized (bl) {
            return this.beenPainted;
        }
    }

    private void drawLine(Graphics g, View v, int index) {
        if ((index != this.selectedItemIndex && index != this.selectedItemIndex - 1 || !this.highlight) && this.drawLines) {
            Rect itemFrame = v.frame();
            g.setStrokeStyle(1);
            g.setColor(-7894645);
            g.drawLine(itemFrame.x, itemFrame.y + itemFrame.height - 1, itemFrame.x + itemFrame.width, itemFrame.y + itemFrame.height - 1);
            g.setStrokeStyle(0);
        }
    }

    public void setDelegate(ListDelegate delegate) {
        this.iAction = delegate;
    }

    public boolean event(Event event) {
        if (this.active && this.enabled && this.highlight && event.type() == 1) {
            switch (event.keyCode()) {
                case -2: {
                    boolean res = this.gotoNextItem();
                    this.updateProgresbar();
                    this.setNeedsDisplay();
                    return res;
                }
                case -1: {
                    boolean res = this.gotoPreviousItem();
                    this.updateProgresbar();
                    this.setNeedsDisplay();
                    return res;
                }
                case -5: {
                    if (this.iAction == null) break;
                    this.iAction.listViewDidClickRowIndex(this, this.selectedRow());
                    return true;
                }
            }
        }
        return false;
    }

    public void setHighlight(boolean flag) {
        if (flag != this.highlight) {
            if (this.listItems != null && this.listItems.size() > 0) {
                ListItemView start = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
                start.setHighlight(flag);
            }
            this.highlight = flag;
            this.setNeedsDisplay();
        }
    }

    protected void updateProgresbar() {
        int markerPosition;
        if (this.listItems == null) {
            markerPosition = 0;
        } else {
            markerPosition = (int)((float)this.scrollbar.frame().height * ((float)this.indexOfTopItem / (float)this.iDataSource.numberOfRowsInListView(this)));
            if (this.listItems.size() > 0) {
                ListItemView item = (ListItemView)this.listItems.firstElement();
                int currentHight = this.indexOfTopItem * (this.itemSpacing + item.size().height) + this.itemOffset - this.itemSpacing;
                if (!this.alignTop) {
                    currentHight -= item.getRelativeOrgin().y;
                }
                markerPosition = (int)((float)this.scrollbar.frame().height * ((float)currentHight / (float)this.listHeight));
            }
        }
        this.scrollbar.scrollToPosition(markerPosition);
    }

    protected boolean gotoNextItem() {
        ListItemView next;
        ListItemView last;
        if (this.listItems.size() > 2 && this.selectedItemIndex >= this.listItems.size() - 1 && this.indexOfTopItem + this.selectedItemIndex != this.iDataSource.numberOfRowsInListView(this) - 1) {
            last = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
            this.selectedItemIndex = this.listItems.size() - 2;
            next = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
            last.setHighlight(false);
            next.setHighlight(true);
        }
        if (this.indexOfTopItem + this.selectedItemIndex == this.iDataSource.numberOfRowsInListView(this) - 2 && this.selectedItemIndex != this.listItems.size() - 1) {
            last = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
            ++this.selectedItemIndex;
            next = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
            last.setHighlight(false);
            next.setHighlight(true);
            if (this.indexOfTopItem != 0 || next.frame().y + next.frame().height >= this.frame.y + this.frame.height) {
                this.setAlignTop(false);
            }
            return true;
        }
        if (this.selectedItemIndex < this.listItems.size() - 2) {
            last = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
            ++this.selectedItemIndex;
            next = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
            last.setHighlight(false);
            next.setHighlight(true);
            return true;
        }
        if (this.indexOfTopItem + this.selectedItemIndex < this.iDataSource.numberOfRowsInListView(this) - 1) {
            int size = this.listItems.size();
            ++this.indexOfTopItem;
            this.setAlignTop(true);
            for (int i = 0; i < size; ++i) {
                ListItemView item = (ListItemView)this.listItems.elementAt(i);
                item.populateListViewFromDataSourceAtIndex(this, this.iDataSource, i + this.indexOfTopItem);
            }
            return true;
        }
        if (this.indexOfTopItem + this.selectedItemIndex == this.iDataSource.numberOfRowsInListView(this) - 1) {
            if (this.wrap) {
                int size = this.listItems.size();
                ListItemView last2 = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
                this.selectedItemIndex = 0;
                this.indexOfTopItem = 0;
                for (int i = 0; i < size; ++i) {
                    ListItemView item = (ListItemView)this.listItems.elementAt(i);
                    item.populateListViewFromDataSourceAtIndex(this, this.iDataSource, i + this.indexOfTopItem);
                }
                ListItemView next2 = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
                last2.setHighlight(false);
                next2.setHighlight(true);
                this.setAlignTop(true);
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean gotoPreviousItem() {
        if (this.indexOfTopItem == 0 && this.selectedItemIndex == 1 && this.listItems.size() > 0) {
            ListItemView last = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
            --this.selectedItemIndex;
            ListItemView next = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
            last.setHighlight(false);
            next.setHighlight(true);
            this.setAlignTop(true);
            return true;
        }
        if (this.selectedItemIndex > 1) {
            ListItemView last = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
            --this.selectedItemIndex;
            ListItemView next = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
            last.setHighlight(false);
            next.setHighlight(true);
            return true;
        }
        if (this.indexOfTopItem + this.selectedItemIndex > 1) {
            int size = this.listItems.size();
            --this.indexOfTopItem;
            this.setAlignTop(false);
            for (int i = 0; i < size; ++i) {
                ListItemView item = (ListItemView)this.listItems.elementAt(i);
                item.populateListViewFromDataSourceAtIndex(this, this.iDataSource, i + this.indexOfTopItem);
            }
            return true;
        }
        if (this.selectedItemIndex == 0 && this.listItems.size() > 0) {
            if (this.wrap) {
                int size = this.listItems.size();
                ListItemView last = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
                this.indexOfTopItem = this.iDataSource.numberOfRowsInListView(this) - size;
                this.selectedItemIndex = size - 1;
                for (int i = 0; i < size; ++i) {
                    ListItemView item = (ListItemView)this.listItems.elementAt(i);
                    item.populateListViewFromDataSourceAtIndex(this, this.iDataSource, i + this.indexOfTopItem);
                }
                ListItemView next = (ListItemView)this.listItems.elementAt(this.selectedItemIndex);
                last.setHighlight(false);
                next.setHighlight(true);
                if (this.indexOfTopItem != 0 || next.frame().y + next.frame().height >= this.frame.y + this.frame.height) {
                    this.setAlignTop(false);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void updateList() {
        if (this.listItems != null) {
            for (int i = 0; i < this.listItems.size(); ++i) {
                ListItemView li = (ListItemView)this.listItems.elementAt(i);
                li.populateListViewFromDataSourceAtIndex(this, this.iDataSource, i + this.indexOfTopItem);
                if (!this.highlight) continue;
                if (i == this.selectedItemIndex) {
                    li.setHighlight(true);
                    continue;
                }
                li.setHighlight(false);
            }
            this.updateProgresbar();
        }
    }

    public void setActive(boolean flag) {
        super.setActive(flag);
        this.scrollbar.setActive(flag);
        if (this.listItems != null && this.listItems.size() != 0) {
            for (int i = 0; i < this.listItems.size(); ++i) {
                ListItemView li = (ListItemView)this.listItems.elementAt(i);
                li.setActive(flag);
                if (flag) continue;
                li.setHighlight(false);
            }
            if (flag && this.highlight && this.listItems.size() > 0) {
                ((ListItemView)this.listItems.elementAt(this.selectedItemIndex)).setHighlight(true);
            }
        }
    }

    public void selectRowAtIndex(int i) {
        int size = this.iDataSource.numberOfRowsInListView(this);
        int numberOfRows = this.listItems.size();
        this.setAlignTop(true);
        if (i < numberOfRows - 1) {
            this.indexOfTopItem = 0;
            this.selectedItemIndex = i;
        } else if (i < size - numberOfRows) {
            this.indexOfTopItem = i - 1;
            this.selectedItemIndex = 1;
        } else {
            this.indexOfTopItem = size - numberOfRows;
            this.selectedItemIndex = i - this.indexOfTopItem;
            if (numberOfRows > 0) {
                ListItemView first = (ListItemView)this.listItems.firstElement();
                ListItemView last = (ListItemView)this.listItems.lastElement();
                if (first.getRelativeOrgin().y < 0 || last.frame().y + last.frame().height > this.frame.y + this.frame.height) {
                    this.setAlignTop(false);
                }
            }
        }
        this.updateList();
    }

    public void selectLastRow() {
        this.selectRowAtIndex(this.iDataSource.numberOfRowsInListView(this) - 1);
    }

    public void setWrap(boolean b) {
        this.wrap = b;
    }

    public void didLoseTop() {
        super.didLoseTop();
        Enumeration e = this.listItems.elements();
        while (e.hasMoreElements()) {
            View vw = (View)e.nextElement();
            vw.didLoseTop();
        }
    }
}

