/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.exit;

import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.SlideImageView;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.FadeView;
import se.tactel.tvclient.gui.common.SimpleMultiTextView;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.position.Size;
import se.tactel.tvclient.gui.windowing.NotPossibleToGoBackWindow;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.util.Log;

public class ExitWindow
extends Window
implements NotPossibleToGoBackWindow {
    public ExitWindow(boolean askForUserConfirmation) {
        Log.log(0x200000000L, "Creating exit window, askForUserConfirmation=" + askForUserConfirmation);
        if (askForUserConfirmation) {
            ButtonBar buttonBar = ButtonBar.createButtonBar();
            buttonBar.setLeftSoftKeyTextAndAction(4, new Action(){

                public void clicked(View sender) {
                    TimerTask exitTimerTask = new TimerTask(){

                        public void run() {
                            ExitWindow.this.exitClient();
                        }
                    };
                    Timer exitTimer = new Timer();
                    exitTimer.schedule(exitTimerTask, 3000L);
                    ExitWindow.this.setButtonBar(ButtonBar.createButtonBar());
                    View exitView = ExitWindow.this.getExitSlideView();
                    ExitWindow.this.setContentView(exitView);
                    ExitWindow.this.setButtonBar(null);
                    exitView.setNeedsDisplay();
                }
            });
            buttonBar.setRightSoftKeyTextAndAction(2, new Action(){

                public void clicked(View sender) {
                    ExitWindow.this.close();
                }
            });
            this.setButtonBar(buttonBar);
            this.setContentView(this.getExitConfirmationPopup());
        } else {
            View exitView = this.getExitSlideView();
            this.setContentView(exitView);
            this.exitClient();
        }
    }

    private View getExitConfirmationPopup() {
        View contentView = new View(){

            public void drawInRect(TactelGraphics g, Rect rect) {
                super.drawInRect(g, rect);
                g.setColor(-16777216);
                g.drawRect(new Rect(this.frame).setSize(new Size(this.frame.width - 2, this.frame.height - 2)).setOrgin(new Point(this.frame.x + 1, this.frame.y + 1)));
                g.drawRect(this.frame);
            }

            public boolean event(Event event) {
                if (event.type() == 1 && event.keyCode() == -11) {
                    ExitWindow.this.close();
                    return true;
                }
                return super.event(event);
            }
        };
        contentView.setDrawsBackground(true);
        contentView.setBackgroundColor(-1);
        Point popupViewOriginPoint = new Point((Skin.MAIN_FRAME.width - Skin.EXIT_CONFIRMATION_POPUP_SIZE.width) / 2, (Skin.MAIN_FRAME.height - Skin.EXIT_CONFIRMATION_POPUP_SIZE.height) / 2);
        contentView.setFrame(new Rect().setSize(Skin.EXIT_CONFIRMATION_POPUP_SIZE).setOrgin(popupViewOriginPoint));
        TextView titleTextView = new TextView();
        titleTextView.setAlignment(1);
        titleTextView.setTextColor(-16777216);
        titleTextView.setFont(Fonts.LARGER_BOLD);
        titleTextView.setText(400);
        titleTextView.setFrame(new Rect(Skin.EXIT_CONFIRMATION_POPUP_TITLE_RECT));
        contentView.addSubview(titleTextView);
        SimpleMultiTextView reallyQuitTextView = new SimpleMultiTextView();
        reallyQuitTextView.setVerticallyAlignment(true);
        reallyQuitTextView.setAlignment(1);
        reallyQuitTextView.setDrawsBackground(true);
        reallyQuitTextView.setBackgroundColor(-1);
        reallyQuitTextView.setTextColor(-16777216);
        reallyQuitTextView.setFont(Fonts.NORMAL_BOLD);
        reallyQuitTextView.setText(401);
        reallyQuitTextView.setFrame(new Rect(Skin.EXIT_CONFIRMATION_POPUP_TEXT_RECT));
        contentView.addSubview(reallyQuitTextView);
        FadeView backgroundView = new FadeView();
        backgroundView.setFrame(new Rect(Skin.MAIN_FRAME));
        backgroundView.addSubview(contentView);
        return backgroundView;
    }

    private View getExitSlideView() {
        SlideImageView slideImageView = new SlideImageView(null, false, new Rect(Skin.SCREEN_RECT), Images.getExitSlide());
        Vector slidesToDisplay = ServiceRegistry.instance().getLocalConfiguration().getCurrentSlideshowGroup().exitSlides;
        if (slidesToDisplay.size() != 0) {
            slideImageView.setSlides(slidesToDisplay);
            Log.log(0x4000000L, "Displaying exit slide group: " + slidesToDisplay.toString());
        }
        slideImageView.start();
        return slideImageView;
    }

    private void exitClient() {
        if (ServiceRegistry.instance().getPlayer().isRunning()) {
            ServiceRegistry.instance().getPlayer().stopPlayer();
        }
        Log.log(0x200000010L, "Creating exit window II");
        Thread stopSessionThread = new Thread(){

            public void run() {
                if (ServiceRegistry.instance().getDataProvider().getConfig().getStopSessionUrlWithLang() != null && !ServiceRegistry.instance().getComm().processUrl(ServiceRegistry.instance().getDataProvider().getConfig().getStopSessionUrlWithLang(), 0)) {
                    Log.log(0x100000010L, "Tried to access stopSession with no succes");
                }
                RichMediaMIDlet.instance().endApplication();
            }
        };
        stopSessionThread.start();
        TimerTask timeoutTask = new TimerTask(){

            public void run() {
                Log.log(0x100000010L, "Stop session call timeout - Closed application");
                RichMediaMIDlet.instance().endApplication();
            }
        };
        Timer exitTimer = new Timer();
        exitTimer.schedule(timeoutTask, 4000L);
    }
}

