/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.guide;

import java.util.Calendar;
import java.util.Date;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.data.Epg;
import se.tactel.tvclient.gui.RectView;
import se.tactel.tvclient.gui.channellist.ChannelIconView;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.ButtonView;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.TickerView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.interactivity.InteractivityView;
import se.tactel.tvclient.gui.list.ListDelegate;
import se.tactel.tvclient.gui.list.ListView;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.guide.EpgDatasource;
import se.tactel.tvclient.gui.screen.guide.GuideInformationController;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.gui.windowing.WindowDelegate;
import se.tactel.tvclient.notificationcenter.Notification;
import se.tactel.tvclient.notificationcenter.NotificationCenter;
import se.tactel.tvclient.notificationcenter.Observer;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class GuideEpgController
implements ListDelegate,
Observer,
WindowDelegate,
Runnable {
    private static GuideEpgController self;
    private Window epgWindow = null;
    private ChannelIconView channelImage;
    private TextView channeltext;
    private TickerView statustext;
    private ListView epglist;
    private View channelInfo;
    private TextView today;
    private View right;
    private View left;
    private long date;
    private int todayDayOfMonth;
    private boolean returnToWtc = false;
    private InteractivityView interactivityView;
    private OptionsMenuItem watchOptionsMenuItem;
    private OptionsMenuItem detailsOptionsMenuItem;
    private OptionsMenuItem goToWapOptionsMenuItem;
    private Date requestedDate = null;
    private Content content;
    private GuideInformationController information;
    private EpgDatasource epgdata = new EpgDatasource();
    String[] months = new String[]{" Ene", " Feb", " Mar", " Abr", " May", " Jun", " Jul", " Ago", " Sep", " Oct", " Nov", " Dic"};
    static /* synthetic */ Class class$se$tactel$tvclient$gui$screen$guide$EpgItem;

    private GuideEpgController() {
        this.information = new GuideInformationController();
        NotificationCenter.defaultCenter().addObserver(this, "epg", null);
    }

    public static GuideEpgController epgController() {
        if (self == null) {
            self = new GuideEpgController();
            self.createEpgWindow();
        }
        return self;
    }

    boolean epgWindowOnTop() {
        return ServiceRegistry.instance().getWindowServer().getTopmostWindow() == this.epgWindow;
    }

    private void createEpgWindow() {
        this.epgWindow = new Window();
        this.epgWindow.setDelegate(this);
        View view = new View();
        view.setFrame(new Rect(Skin.MAIN_FRAME));
        view.setBackgroundColor(-1972760);
        view.setDrawsBackground(true);
        this.channelInfo = new View();
        this.channelInfo.setFrame(new Rect(0, 54, 240, 47));
        this.channelInfo.setBackgroundColor(-1972760);
        this.channelInfo.setHighlightBackgroundColor(-6697759);
        this.channelInfo.setDrawsBackground(true);
        ButtonView shade = new ButtonView();
        shade.setFrame(new Rect(Skin.GUIDE_SHADE));
        shade.setDrawsBackground(true);
        shade.setBackgroundImage(Images.getShade());
        shade.setHighlightBackgroundImage(Images.getShadeHighlighted());
        shade.setAction(new Action(){

            public void clicked(View sender) {
                if (GuideEpgController.this.content != null && !((Channel)GuideEpgController.this.content).isNotAvailable() && GuideEpgController.this.content.isSubscribed() && (((Channel)GuideEpgController.this.content).getAdultUrl() == null || "".equals(((Channel)GuideEpgController.this.content).getAdultUrl()))) {
                    ServiceRegistry.instance().getController().getTvScreenWindow().makeKeyAndOrderFront();
                }
                int resultCode = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().requestContentSwitch(GuideEpgController.this.content);
                switch (resultCode) {
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        GuideEpgController.this.epgWindow.close();
                        break;
                    }
                }
            }
        });
        this.channelInfo.addSubview(shade);
        this.channelImage = new ChannelIconView();
        this.channelImage.setFrame(new Rect(Skin.GUIDE_EPG_CHANNEL_ICON_FRAME));
        this.channelInfo.addSubview(this.channelImage);
        this.channeltext = new TextView();
        this.channeltext.setText("no channel");
        this.channeltext.setFont(Fonts.NORMAL_BOLD);
        this.channeltext.setTextColor(-16777216);
        this.channeltext.setFrame(new Rect(Skin.GUIDE_EPG_CHANNEL_NAME_FRAME));
        this.channelInfo.addSubview(this.channeltext);
        this.statustext = new TickerView();
        this.statustext.setText("no information");
        this.statustext.setFont(Fonts.NORMAL);
        this.statustext.setTextColor(-16777216);
        this.statustext.setFrame(new Rect(Skin.GUIDE_EPG_CHANNEL_INFORMATION_FRAME));
        this.channelInfo.addSubview(this.statustext);
        view.addSubview(this.channelInfo);
        RectView guideTitleView = new RectView();
        guideTitleView.setFrame(new Rect(Skin.GUIDE_NAME_FRAME));
        guideTitleView.setBackgroundImage(Images.getDatebar());
        guideTitleView.setDrawsBackground(true);
        TextView title = new TextView();
        title.setFrame(new Rect(Skin.GUIDE_NAME_TEXT_FRAME));
        title.setAlignment(1);
        title.setFont(Fonts.LARGER_BOLD);
        title.setTextColor(-16777216);
        title.setText(250);
        guideTitleView.addSubview(title);
        view.addSubview(guideTitleView);
        RectView tabView = new RectView();
        tabView.setFrame(new Rect(Skin.GUIDE_EPG_DAY_TAB_FRAME));
        tabView.setBackgroundImage(Images.getDatebar());
        tabView.setDrawsBackground(true);
        this.today = new TextView();
        this.today.setFrame(new Rect(Skin.GUIDE_EPG_CURRENT_DAY_FRAME));
        this.today.setAlignment(1);
        this.today.setFont(Fonts.NORMAL_BOLD);
        this.today.setTextColor(-16777216);
        this.today.setText("idag");
        tabView.addSubview(this.today);
        this.right = new View();
        this.right.setFrame(new Rect(Skin.GUIDE_EPG_RIGHT_ARROW));
        this.right.setBackgroundImage(Images.getArrowRight());
        this.right.setDrawsBackground(true);
        tabView.addSubview(this.right);
        this.left = new View();
        this.left.setFrame(new Rect(Skin.GUIDE_EPG_LEFT_ARROW));
        this.left.setBackgroundImage(Images.getArrowLeft());
        this.left.setDrawsBackground(false);
        tabView.addSubview(this.left);
        view.addSubview(tabView);
        this.epglist = new ListView();
        this.epglist.setFrame(new Rect(Skin.GUIDE_EPG_LIST_FRAME));
        this.epglist.setListItemClass(class$se$tactel$tvclient$gui$screen$guide$EpgItem == null ? (class$se$tactel$tvclient$gui$screen$guide$EpgItem = GuideEpgController.class$("se.tactel.tvclient.gui.screen.guide.EpgItem")) : class$se$tactel$tvclient$gui$screen$guide$EpgItem);
        this.epglist.setItemSpacing(0);
        this.epglist.setBackgroundColor(-1972760);
        this.epglist.setDrawLines(true);
        this.epglist.setDrawsBackground(true);
        this.epglist.setDataSource(this.epgdata);
        this.epglist.setDelegate(this);
        this.epglist.setItemOffset(2);
        this.epglist.setHighlight(false);
        view.addSubview(this.epglist);
        this.epgWindow.setContentView(view);
        ButtonBar epgButtonBar = ButtonBar.createButtonBar();
        epgButtonBar.setLeftSoftKeyTextAndAction(1, new Action(){

            public void clicked(View sender) {
                GuideEpgController.this.showOptionMenu();
            }
        });
        this.interactivityView = new InteractivityView(epgButtonBar, this.epgWindow);
        this.interactivityView.setFrame(new Rect(Skin.INTERACTIVITY_VIEW));
        this.epgWindow.setButtonBar(this.interactivityView);
        OptionsMenuItem[] menuItems = this.createOptionsMenu();
        this.channelInfo.setNextResponder(this.epglist);
        this.epgWindow.setInitialFirstResponder(this.epglist);
        this.epgWindow.setOptionMenuItems(menuItems);
    }

    private OptionsMenuItem[] createOptionsMenu() {
        OptionsMenuItem[] menuItems = new OptionsMenuItem[6];
        menuItems[0] = OptionsMenuItem.createButtonMenuItem();
        menuItems[0].setText(130);
        menuItems[0].setAction(new Action(){

            public void clicked(View sender) {
                ServiceRegistry.instance().getController().closeOptionMenuWindow();
                GuideEpgController.this.watchNow();
            }
        });
        this.watchOptionsMenuItem = menuItems[0];
        menuItems[1] = OptionsMenuItem.createButtonMenuItem();
        menuItems[1].setText(131);
        menuItems[1].setAction(new Action(){

            public void clicked(View sender) {
                ServiceRegistry.instance().getController().closeOptionMenuWindow();
                Epg.EpgProgram p = GuideEpgController.this.epgdata.programAtIndex(GuideEpgController.this.epglist.selectedRow());
                GuideEpgController.this.information.showInformationForProgram(p);
                GuideEpgController.this.returnToWtc = false;
            }
        });
        this.detailsOptionsMenuItem = menuItems[1];
        menuItems[2] = OptionsMenuItem.createButtonMenuItem();
        menuItems[2].setText(132);
        menuItems[2].setAction(new Action(){

            public void clicked(View sender) {
                ServiceRegistry.instance().getController().closeOptionMenuWindow();
                GuideEpgController.this.back();
            }
        });
        menuItems[3] = OptionsMenuItem.createButtonMenuItem();
        menuItems[3].setText(103);
        menuItems[3].setAction(new Action(){

            public void clicked(View sender) {
                ServiceRegistry.instance().getController().closeOptionMenuWindow();
                if (GuideEpgController.this.content != null && GuideEpgController.this.content instanceof Channel) {
                    Channel channel = (Channel)GuideEpgController.this.content;
                    try {
                        RichMediaMIDlet.instance().platformRequest(channel.getInformationUrl());
                    }
                    catch (Exception e) {
                        Log.exception(this, e);
                    }
                }
            }
        });
        menuItems[3].setEnabled(false);
        this.goToWapOptionsMenuItem = menuItems[3];
        menuItems[4] = OptionsMenuItem.HELP_GUIDE_BUTTON;
        menuItems[5] = OptionsMenuItem.EXIT_BUTTON;
        return menuItems;
    }

    public void showEpgForChannel(Content content) {
        this.content = content;
        this.requestedDate = null;
        this.updateOptionMenu();
        this.channelImage.updateChannelToDisplay((Channel)content);
        this.channeltext.setText(content.getName());
        this.statustext.setText(content.getDescription());
        if (Fonts.NORMAL.stringWidth(content.getDescription()) > Skin.GUIDE_EPG_CHANNEL_INFORMATION_FRAME.width) {
            this.statustext.setEnabled(true);
        }
        this.left.setDrawsBackground(false);
        this.date = Utils.getTime().getTime();
        this.todayDayOfMonth = Utils.getDate().get(5);
        this.epglist.clear();
        this.epgdata.useEpgForChannelIdAtDate(content.getId(), new Date(this.date));
        this.setDate();
        this.updateArrows();
        this.channelInfo.setHighlight(false);
        this.epgWindow.setInitialFirstResponder(this.epglist);
        this.epgWindow.getOptionMenuItems()[1].setEnabled(true);
        this.epgWindow.makeKeyAndOrderFront();
    }

    public void showEpgForCurrentShowOnChannel(Content content) {
        this.showEpgForChannel(content);
        Epg.EpgProgram prog = this.epgdata.day.getCurrentProgram();
        if (prog != null) {
            this.information.showInformationForProgram(prog);
        } else {
            new Thread(this).start();
        }
    }

    private void setDate() {
        this.setDayFormatToTextView(this.date, this.today);
    }

    private void setDayFormatToTextView(long time, TextView view) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(time));
        int day = c.get(5);
        if (day == this.todayDayOfMonth) {
            view.setText(251);
            view.setNeedsDisplay();
        } else {
            view.setText(-1);
            view.setText(252);
            view.setNeedsDisplay();
        }
    }

    private void nextDayForward(boolean flag) {
        long tmpDate = this.date;
        if (flag) {
            if (this.showingToday() && this.epgdata.numberOfRowsInListView(this.epglist) > 0) {
                tmpDate = this.date + 86400000L;
            }
        } else if (!this.showingToday()) {
            tmpDate = this.date - 86400000L;
        }
        if (tmpDate != this.date) {
            if (this.epgdata.epgListExist(new Date(tmpDate))) {
                this.date = tmpDate;
                this.setDate();
                this.updateArrows();
                this.epgdata.useDate(new Date(this.date));
            } else if (this.requestedDate == null) {
                this.requestedDate = new Date(tmpDate);
                Epg.EpgDay tmpDay = this.epgdata.getDayAsIs(this.requestedDate);
                if (tmpDay != null && tmpDay.isForcedDownloaded()) {
                    this.requestedDate = null;
                    this.updateArrows();
                } else if (tmpDay == null || !tmpDay.isRequested() || !tmpDay.isForcedDownloaded()) {
                    new Thread(){

                        public void run() {
                            Date tmp = new Date(GuideEpgController.this.requestedDate.getTime());
                            GuideEpgController.this.epgdata.forceDownloadDaySync(GuideEpgController.this.requestedDate);
                            if (GuideEpgController.this.requestedDate != null && GuideEpgController.this.requestedDate.equals(tmp)) {
                                if (GuideEpgController.this.epgdata.epgListExist(GuideEpgController.this.requestedDate)) {
                                    GuideEpgController.this.date = GuideEpgController.this.requestedDate.getTime();
                                    GuideEpgController.this.setDate();
                                    GuideEpgController.this.updateArrows();
                                    GuideEpgController.this.epgdata.useDate(new Date(GuideEpgController.this.date));
                                } else {
                                    GuideEpgController.this.updateArrows();
                                }
                                GuideEpgController.this.requestedDate = null;
                            }
                        }
                    }.start();
                }
            }
        }
        this.epglist.reloadData();
        this.safeListDisplay();
    }

    private void updateArrows() {
        if (this.showingToday()) {
            Date tmpDate = new Date(this.date + 86400000L);
            if (this.epgdata.numberOfRowsInListView(this.epglist) == 0) {
                this.right.setDrawsBackground(false);
            } else if (this.epgdata.epgListExist(tmpDate)) {
                this.right.setDrawsBackground(true);
            } else if (this.epgdata.getDayAsIs(tmpDate) != null && this.epgdata.getDayAsIs(tmpDate).isForcedDownloaded()) {
                this.right.setDrawsBackground(false);
            } else {
                this.right.setDrawsBackground(true);
            }
            this.left.setDrawsBackground(false);
        } else {
            this.left.setDrawsBackground(this.epgdata.epgListExist(new Date(this.date - 86400000L)));
            this.right.setDrawsBackground(false);
        }
        this.left.setNeedsDisplay();
        this.right.setNeedsDisplay();
    }

    private boolean showingToday() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(this.date));
        int day = c.get(5);
        return day == this.todayDayOfMonth;
    }

    public void listViewDidClickRowIndex(ListView list, int rowIndex) {
        Epg.EpgProgram p = this.epgdata.programAtIndex(rowIndex);
        this.information.showInformationForProgram(p);
        this.returnToWtc = false;
    }

    public synchronized void notifiedWithNotification(Notification notification) {
        if (this.epglist == null) {
            return;
        }
        this.epglist.reloadData();
        try {
            if (this.showingToday()) {
                this.epglist.selectRowAtIndex(this.epgdata.indexOfCurrrentShow());
            }
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        if (this.content != null && this.channelImage != null) {
            this.content = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(this.content.getId());
            this.channelImage.updateChannelToDisplay((Channel)this.content);
        }
        this.updateOptionMenu();
        this.safeListDisplay();
    }

    private void updateOptionMenu() {
        if (this.watchOptionsMenuItem != null) {
            if (this.content != null && this.content instanceof Channel) {
                this.watchOptionsMenuItem.setEnabled(!((Channel)this.content).isNotAvailable());
            } else {
                this.watchOptionsMenuItem.setEnabled(false);
            }
        }
        if (this.detailsOptionsMenuItem != null) {
            if (this.epgWindow.firstResponder() == this.epglist) {
                this.detailsOptionsMenuItem.setEnabled(this.epgdata.numberOfRowsInListView(this.epglist) > 0);
            } else {
                this.detailsOptionsMenuItem.setEnabled(false);
            }
        }
        if (this.goToWapOptionsMenuItem != null) {
            this.goToWapOptionsMenuItem.setEnabled(this.content instanceof Channel && ((Channel)this.content).getInformationUrl() != null && !"".equals(((Channel)this.content).getInformationUrl()));
        }
    }

    public void back() {
        if (!this.showingToday()) {
            this.nextDayForward(false);
        } else {
            this.exit();
        }
    }

    public boolean eventForWindow(Event event, Window window) {
        if (event.type() == 1) {
            switch (event.keyCode()) {
                case -3: {
                    this.nextDayForward(false);
                    return true;
                }
                case -4: {
                    this.nextDayForward(true);
                    return true;
                }
                case -11: {
                    this.back();
                    return true;
                }
                case -2: {
                    this.detailsOptionsMenuItem.setEnabled(this.epgdata.numberOfRowsInListView(this.epglist) > 0);
                    break;
                }
                case -1: {
                    if (this.epgWindow.firstResponder() == this.epglist && this.epglist.selectedRow() > 0) {
                        this.detailsOptionsMenuItem.setEnabled(true);
                        break;
                    }
                    this.detailsOptionsMenuItem.setEnabled(false);
                    break;
                }
            }
        }
        return false;
    }

    public void windowDidBecomeTopWindow(Window window) {
        if (window == this.epgWindow) {
            this.interactivityView.didBecomeTop();
            if (this.returnToWtc) {
                this.epgWindow.selectKeyView(this.epglist);
            }
            this.returnToWtc = true;
        }
    }

    public void windowDidLoseTopWindow(Window window) {
        if (window == this.epgWindow) {
            this.interactivityView.didLoseTop();
        }
        this.epglist.didLoseTop();
        this.safeListDisplay();
    }

    public void showOptionMenu() {
        Epg.EpgProgram p = this.epgdata.programAtIndex(this.epglist.selectedRow());
        this.epgWindow.getOptionMenuItems()[1].setEnabled(this.epgWindow.firstResponder() == this.epglist && p != null && p.programName != null);
        this.epgWindow.showOptionsMenuWindow();
        this.returnToWtc = false;
    }

    public void exit() {
        this.epgWindow.goBack();
        this.epgWindow.orderOut();
    }

    public void watchNow() {
        if (this.content != null && !((Channel)this.content).isNotAvailable() && this.content.isSubscribed() && (((Channel)this.content).getAdultUrl() == null || "".equals(((Channel)this.content).getAdultUrl()))) {
            RichMediaMIDlet.instance().tController.getTvScreenWindow().makeKeyAndOrderFront();
        }
        int resultCode = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().requestContentSwitch(this.content);
        switch (resultCode) {
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                this.epgWindow.close();
                break;
            }
        }
    }

    public void run() {
        try {
            int timeoutCount = 20;
            while (this.epgdata.day.getCurrentProgram() == null && timeoutCount > 0) {
                --timeoutCount;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            if (this.epgdata.day.getCurrentProgram() != null) {
                this.showEpgForCurrentShowOnChannel(this.content);
            }
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }

    private void safeListDisplay() {
        if (!this.epgWindow.isVisible()) {
            return;
        }
        this.epglist.setNotPainted();
        this.epglist.setNeedsDisplay();
        this.updateArrows();
        int TIMEOUT_CNT = 15;
        for (int i = 0; !this.epglist.beenPainted() && i < 15; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Log.exception(this, e);
            }
        }
        if (!this.epglist.beenPainted()) {
            Log.log(0x60100000L, "EPG list did not repaint!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

