/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tab;

import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.interactivity.InteractivityView;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.Animator;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.gui.windowing.WindowDelegate;

public abstract class TabWindow
extends Window
implements WindowDelegate {
    private InteractivityView interactivityView;

    protected TabWindow() {
        this.setDelegate(this);
    }

    public final void setButtonBar(View view) {
        this.interactivityView = new InteractivityView(view, this);
        this.interactivityView.setFrame(new Rect(Skin.INTERACTIVITY_VIEW));
        super.setButtonBar(this.interactivityView);
    }

    protected final void blockAd(boolean b) {
        this.interactivityView.setAdBlocked(b);
    }

    protected abstract Window getTabToTheLeft();

    protected abstract Window getTabToTheRight();

    public boolean eventForWindow(Event event, Window window) {
        if (event.type() == 1) {
            if (event.keyCode() == -3) {
                Window newTab = this.getTabToTheLeft();
                if (newTab instanceof TabWindow) {
                    ((TabWindow)newTab).willBecomeTopWindow();
                }
                Animator.animateToLeft(this, newTab);
                newTab.buttonBar().setNeedsDisplay();
                this.close();
                return true;
            }
            if (event.keyCode() == -4) {
                Window newTab = this.getTabToTheRight();
                if (newTab instanceof TabWindow) {
                    ((TabWindow)newTab).willBecomeTopWindow();
                }
                Animator.animateToRight(this, newTab);
                newTab.buttonBar().setNeedsDisplay();
                this.close();
                return true;
            }
            if (event.keyCode() == -11) {
                this.goBack();
                if (ServiceRegistry.instance().getWindowServer().getTopmostWindow() != this) {
                    this.close();
                }
                return true;
            }
        }
        return false;
    }

    public void willBecomeTopWindow() {
    }

    public void windowDidBecomeTopWindow(Window window) {
        this.interactivityView.didBecomeTop();
    }

    public void windowDidLoseTopWindow(Window window) {
        this.interactivityView.didLoseTop();
    }
}

